#define ICONV_INTERNAL
#include "iconv.h"

static const iconv_ccs_convtable_7bit to_ucs_21 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3000, 0xFF0C, 0x3001, 0x3002, 0xFF0E, 0x30FB, 0xFF1B,
	0xFF1A, 0xFF1F, 0xFF01, 0xFE30, 0x2026, 0x2025, 0xFE50, 0xFE51,
	0xFE52, 0x00B7, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE31, 0x2014,
	0xFE32, 0x2013, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFF08, 0xFF09,
	0xFE35, 0xFE36, 0xFF5B, 0xFF5D, 0xFE37, 0xFE38, 0x3014, 0x3015,
	0xFE39, 0xFE3A, 0x3010, 0x3011, 0xFE3B, 0xFE3C, 0x300A, 0x300B,
	0xFE3D, 0xFE3E, 0x3008, 0x3009, 0xFE3F, 0xFE40, 0x300C, 0x300D,
	0xFE41, 0xFE42, 0x300E, 0x300F, 0xFE43, 0xFE44, 0xFE59, 0xFE5A,
	0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0x2018, 0x2019, 0x201C, 0x201D,
	0x301D, 0x301E, 0x2032, 0x2035, 0xFF03, 0xFF06, 0xFF0A, 0x203B,
	0x00A7, 0x3003, 0x25CB, 0x25CF, 0x25B3, 0x25B2, 0x25CE, 0x2606,
	0x2605, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25BD, 0x25BC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_22 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x32A3, 0x2105, 0x203E, 0xFFFE, 0xFF3F, 0xFFFE, 0xFE49,
	0xFE4A, 0xFE4D, 0xFE4E, 0xFE4B, 0xFE4C, 0xFE5F, 0xFE60, 0xFE61,
	0xFF0B, 0xFF0D, 0x00D7, 0x00F7, 0x00B1, 0x221A, 0xFF1C, 0xFF1E,
	0xFF1D, 0x2266, 0x2267, 0x2260, 0x221E, 0x2252, 0x2261, 0xFE62,
	0xFE63, 0xFE64, 0xFE66, 0xFE65, 0x223C, 0x2229, 0x222A, 0x22A5,
	0x2220, 0x221F, 0x22BF, 0x33D2, 0x33D1, 0x222B, 0x222E, 0x2235,
	0x2234, 0x2640, 0x2642, 0x2641, 0x2609, 0x2191, 0x2193, 0x2192,
	0x2190, 0x2196, 0x2197, 0x2199, 0x2198, 0x2016, 0xFF5C, 0xFF0F,
	0xFF3C, 0x2215, 0xFE68, 0xFF04, 0xFFE5, 0x3012, 0xFFE0, 0xFFE1,
	0xFF05, 0xFF20, 0x2103, 0x2109, 0xFE69, 0xFE6A, 0xFE6B, 0x33D5,
	0x339C, 0x339D, 0x339E, 0x33CE, 0x33A1, 0x338E, 0x338F, 0x33C4,
	0x00B0, 0x5159, 0x515B, 0x515E, 0x515D, 0x5161, 0x5163, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_23 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x55E7, 0x74E9, 0x7CCE, 0x2581, 0x2582, 0x2583, 0x2584,
	0x2585, 0x2586, 0x2587, 0x2588, 0x258F, 0x258E, 0x258D, 0x258C,
	0x258B, 0x258A, 0x2589, 0x253C, 0x2534, 0x252C, 0x2524, 0x251C,
	0x2594, 0x2500, 0x2502, 0x2595, 0x250C, 0x2510, 0x2514, 0x2518,
	0x256D, 0x256E, 0x2570, 0x256F, 0x2550, 0x255E, 0x256A, 0x2561,
	0x25E2, 0x25E3, 0x25E5, 0x25E4, 0x2571, 0x2572, 0x2573, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_24 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16,
	0xFF17, 0xFF18, 0xFF19, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164,
	0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x3021, 0x3022, 0x3023,
	0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0xFFFE, 0x5344,
	0xFFFE, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27,
	0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F,
	0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37,
	0xFF38, 0xFF39, 0xFF3A, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45,
	0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D,
	0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55,
	0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0x0391, 0x0392, 0x0393,
	0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_25 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1,
	0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03B1,
	0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9,
	0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1,
	0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x3105,
	0x3106, 0x3107, 0x3108, 0x3109, 0x310A, 0x310B, 0x310C, 0x310D,
	0x310E, 0x310F, 0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115,
	0x3116, 0x3117, 0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D,
	0x311E, 0x311F, 0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125,
	0x3126, 0x3127, 0x3128, 0x3129, 0x02D9, 0x02C9, 0x02CA, 0x02C7,
	0x02CB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_26 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466,
	0x2467, 0x2468, 0x2469, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478,
	0x2479, 0x247A, 0x247B, 0x247C, 0x247D, 0x2170, 0x2171, 0x2172,
	0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_42 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2400, 0x2401, 0x2402, 0x2403, 0x2404, 0x2405, 0x2406,
	0x2407, 0x2408, 0x2409, 0x240A, 0x240B, 0x240C, 0x240D, 0x240E,
	0x240F, 0x2410, 0x2411, 0x2412, 0x2413, 0x2414, 0x2415, 0x2416,
	0x2417, 0x2418, 0x2419, 0x241A, 0x241B, 0x241C, 0x241D, 0x241E,
	0x241F, 0x2421, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_44 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E00, 0x4E59, 0x4E01, 0x4E03, 0x4E43, 0x4E5D, 0x4E86,
	0x4E8C, 0x4EBA, 0x513F, 0x5165, 0x516B, 0x51E0, 0x5200, 0x5201,
	0x529B, 0x5315, 0x5341, 0x535C, 0x53C8, 0x4E09, 0x4E0B, 0x4E08,
	0x4E0A, 0x4E2B, 0x4E38, 0x51E1, 0x4E45, 0x4E48, 0x4E5F, 0x4E5E,
	0x4E8E, 0x4EA1, 0x5140, 0x5203, 0x52FA, 0x5343, 0x53C9, 0x53E3,
	0x571F, 0x58EB, 0x5915, 0x5927, 0x5973, 0x5B50, 0x5B51, 0x5B53,
	0x5BF8, 0x5C0F, 0x5C22, 0x5C38, 0x5C71, 0x5DDD, 0x5DE5, 0x5DF1,
	0x5DF2, 0x5DF3, 0x5DFE, 0x5E72, 0x5EFE, 0x5F0B, 0x5F13, 0x624D,
	0x4E11, 0x4E10, 0x4E0D, 0x4E2D, 0x4E30, 0x4E39, 0x4E4B, 0x5C39,
	0x4E88, 0x4E91, 0x4E95, 0x4E92, 0x4E94, 0x4EA2, 0x4EC1, 0x4EC0,
	0x4EC3, 0x4EC6, 0x4EC7, 0x4ECD, 0x4ECA, 0x4ECB, 0x4EC4, 0x5143,
	0x5141, 0x5167, 0x516D, 0x516E, 0x516C, 0x5197, 0x51F6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_45 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5206, 0x5207, 0x5208, 0x52FB, 0x52FE, 0x52FF, 0x5316,
	0x5339, 0x5348, 0x5347, 0x5345, 0x535E, 0x5384, 0x53CB, 0x53CA,
	0x53CD, 0x58EC, 0x5929, 0x592B, 0x592A, 0x592D, 0x5B54, 0x5C11,
	0x5C24, 0x5C3A, 0x5C6F, 0x5DF4, 0x5E7B, 0x5EFF, 0x5F14, 0x5F15,
	0x5FC3, 0x6208, 0x6236, 0x624B, 0x624E, 0x652F, 0x6587, 0x6597,
	0x65A4, 0x65B9, 0x65E5, 0x66F0, 0x6708, 0x6728, 0x6B20, 0x6B62,
	0x6B79, 0x6BCB, 0x6BD4, 0x6BDB, 0x6C0F, 0x6C34, 0x706B, 0x722A,
	0x7236, 0x723B, 0x7247, 0x7259, 0x725B, 0x72AC, 0x738B, 0x4E19,
	0x4E16, 0x4E15, 0x4E14, 0x4E18, 0x4E3B, 0x4E4D, 0x4E4F, 0x4E4E,
	0x4EE5, 0x4ED8, 0x4ED4, 0x4ED5, 0x4ED6, 0x4ED7, 0x4EE3, 0x4EE4,
	0x4ED9, 0x4EDE, 0x5145, 0x5144, 0x5189, 0x518A, 0x51AC, 0x51F9,
	0x51FA, 0x51F8, 0x520A, 0x52A0, 0x529F, 0x5305, 0x5306, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_46 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5317, 0x531D, 0x4EDF, 0x534A, 0x5349, 0x5361, 0x5360,
	0x536F, 0x536E, 0x53BB, 0x53EF, 0x53E4, 0x53F3, 0x53EC, 0x53EE,
	0x53E9, 0x53E8, 0x53FC, 0x53F8, 0x53F5, 0x53EB, 0x53E6, 0x53EA,
	0x53F2, 0x53F1, 0x53F0, 0x53E5, 0x53ED, 0x53FB, 0x56DB, 0x56DA,
	0x5916, 0x592E, 0x5931, 0x5974, 0x5976, 0x5B55, 0x5B83, 0x5C3C,
	0x5DE8, 0x5DE7, 0x5DE6, 0x5E02, 0x5E03, 0x5E73, 0x5E7C, 0x5F01,
	0x5F18, 0x5F17, 0x5FC5, 0x620A, 0x6253, 0x6254, 0x6252, 0x6251,
	0x65A5, 0x65E6, 0x672E, 0x672C, 0x672A, 0x672B, 0x672D, 0x6B63,
	0x6BCD, 0x6C11, 0x6C10, 0x6C38, 0x6C41, 0x6C40, 0x6C3E, 0x72AF,
	0x7384, 0x7389, 0x74DC, 0x74E6, 0x7518, 0x751F, 0x7528, 0x7529,
	0x7530, 0x7531, 0x7532, 0x7533, 0x758B, 0x767D, 0x76AE, 0x76BF,
	0x76EE, 0x77DB, 0x77E2, 0x77F3, 0x793A, 0x79BE, 0x7A74, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_47 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7ACB, 0x4E1E, 0x4E1F, 0x4E52, 0x4E53, 0x4E69, 0x4E99,
	0x4EA4, 0x4EA6, 0x4EA5, 0x4EFF, 0x4F09, 0x4F19, 0x4F0A, 0x4F15,
	0x4F0D, 0x4F10, 0x4F11, 0x4F0F, 0x4EF2, 0x4EF6, 0x4EFB, 0x4EF0,
	0x4EF3, 0x4EFD, 0x4F01, 0x4F0B, 0x5149, 0x5147, 0x5146, 0x5148,
	0x5168, 0x5171, 0x518D, 0x51B0, 0x5217, 0x5211, 0x5212, 0x520E,
	0x5216, 0x52A3, 0x5308, 0x5321, 0x5320, 0x5370, 0x5371, 0x5409,
	0x540F, 0x540C, 0x540A, 0x5410, 0x5401, 0x540B, 0x5404, 0x5411,
	0x540D, 0x5408, 0x5403, 0x540E, 0x5406, 0x5412, 0x56E0, 0x56DE,
	0x56DD, 0x5733, 0x5730, 0x5728, 0x572D, 0x572C, 0x572F, 0x5729,
	0x5919, 0x591A, 0x5937, 0x5938, 0x5984, 0x5978, 0x5983, 0x597D,
	0x5979, 0x5982, 0x5981, 0x5B57, 0x5B58, 0x5B87, 0x5B88, 0x5B85,
	0x5B89, 0x5BFA, 0x5C16, 0x5C79, 0x5DDE, 0x5E06, 0x5E76, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_48 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E74, 0x5F0F, 0x5F1B, 0x5FD9, 0x5FD6, 0x620E, 0x620C,
	0x620D, 0x6210, 0x6263, 0x625B, 0x6258, 0x6536, 0x65E9, 0x65E8,
	0x65EC, 0x65ED, 0x66F2, 0x66F3, 0x6709, 0x673D, 0x6734, 0x6731,
	0x6735, 0x6B21, 0x6B64, 0x6B7B, 0x6C16, 0x6C5D, 0x6C57, 0x6C59,
	0x6C5F, 0x6C60, 0x6C50, 0x6C55, 0x6C61, 0x6C5B, 0x6C4D, 0x6C4E,
	0x7070, 0x725F, 0x725D, 0x767E, 0x7AF9, 0x7C73, 0x7CF8, 0x7F36,
	0x7F8A, 0x7FBD, 0x8001, 0x8003, 0x800C, 0x8012, 0x8033, 0x807F,
	0x8089, 0x808B, 0x808C, 0x81E3, 0x81EA, 0x81F3, 0x81FC, 0x820C,
	0x821B, 0x821F, 0x826E, 0x8272, 0x827E, 0x866B, 0x8840, 0x884C,
	0x8863, 0x897F, 0x9621, 0x4E32, 0x4EA8, 0x4F4D, 0x4F4F, 0x4F47,
	0x4F57, 0x4F5E, 0x4F34, 0x4F5B, 0x4F55, 0x4F30, 0x4F50, 0x4F51,
	0x4F3D, 0x4F3A, 0x4F38, 0x4F43, 0x4F54, 0x4F3C, 0x4F46, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_49 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F63, 0x4F5C, 0x4F60, 0x4F2F, 0x4F4E, 0x4F36, 0x4F59,
	0x4F5D, 0x4F48, 0x4F5A, 0x514C, 0x514B, 0x514D, 0x5175, 0x51B6,
	0x51B7, 0x5225, 0x5224, 0x5229, 0x522A, 0x5228, 0x52AB, 0x52A9,
	0x52AA, 0x52AC, 0x5323, 0x5373, 0x5375, 0x541D, 0x542D, 0x541E,
	0x543E, 0x5426, 0x544E, 0x5427, 0x5446, 0x5443, 0x5433, 0x5448,
	0x5442, 0x541B, 0x5429, 0x544A, 0x5439, 0x543B, 0x5438, 0x542E,
	0x5435, 0x5436, 0x5420, 0x543C, 0x5440, 0x5431, 0x542B, 0x541F,
	0x542C, 0x56EA, 0x56F0, 0x56E4, 0x56EB, 0x574A, 0x5751, 0x5740,
	0x574D, 0x5747, 0x574E, 0x573E, 0x5750, 0x574F, 0x573B, 0x58EF,
	0x593E, 0x599D, 0x5992, 0x59A8, 0x599E, 0x59A3, 0x5999, 0x5996,
	0x598D, 0x59A4, 0x5993, 0x598A, 0x59A5, 0x5B5D, 0x5B5C, 0x5B5A,
	0x5B5B, 0x5B8C, 0x5B8B, 0x5B8F, 0x5C2C, 0x5C40, 0x5C41, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C3F, 0x5C3E, 0x5C90, 0x5C91, 0x5C94, 0x5C8C, 0x5DEB,
	0x5E0C, 0x5E8F, 0x5E87, 0x5E8A, 0x5EF7, 0x5F04, 0x5F1F, 0x5F64,
	0x5F62, 0x5F77, 0x5F79, 0x5FD8, 0x5FCC, 0x5FD7, 0x5FCD, 0x5FF1,
	0x5FEB, 0x5FF8, 0x5FEA, 0x6212, 0x6211, 0x6284, 0x6297, 0x6296,
	0x6280, 0x6276, 0x6289, 0x626D, 0x628A, 0x627C, 0x627E, 0x6279,
	0x6273, 0x6292, 0x626F, 0x6298, 0x626E, 0x6295, 0x6293, 0x6291,
	0x6286, 0x6539, 0x653B, 0x6538, 0x65F1, 0x66F4, 0x675F, 0x674E,
	0x674F, 0x6750, 0x6751, 0x675C, 0x6756, 0x675E, 0x6749, 0x6746,
	0x6760, 0x6753, 0x6757, 0x6B65, 0x6BCF, 0x6C42, 0x6C5E, 0x6C99,
	0x6C81, 0x6C88, 0x6C89, 0x6C85, 0x6C9B, 0x6C6A, 0x6C7A, 0x6C90,
	0x6C70, 0x6C8C, 0x6C68, 0x6C96, 0x6C92, 0x6C7D, 0x6C83, 0x6C72,
	0x6C7E, 0x6C74, 0x6C86, 0x6C76, 0x6C8D, 0x6C94, 0x6C98, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C82, 0x7076, 0x707C, 0x707D, 0x7078, 0x7262, 0x7261,
	0x7260, 0x72C4, 0x72C2, 0x7396, 0x752C, 0x752B, 0x7537, 0x7538,
	0x7682, 0x76EF, 0x77E3, 0x79C1, 0x79C0, 0x79BF, 0x7A76, 0x7CFB,
	0x7F55, 0x8096, 0x8093, 0x809D, 0x8098, 0x809B, 0x809A, 0x80B2,
	0x826F, 0x8292, 0x828B, 0x828D, 0x898B, 0x89D2, 0x8A00, 0x8C37,
	0x8C46, 0x8C55, 0x8C9D, 0x8D64, 0x8D70, 0x8DB3, 0x8EAB, 0x8ECA,
	0x8F9B, 0x8FB0, 0x8FC2, 0x8FC6, 0x8FC5, 0x8FC4, 0x5DE1, 0x9091,
	0x90A2, 0x90AA, 0x90A6, 0x90A3, 0x9149, 0x91C6, 0x91CC, 0x9632,
	0x962E, 0x9631, 0x962A, 0x962C, 0x4E26, 0x4E56, 0x4E73, 0x4E8B,
	0x4E9B, 0x4E9E, 0x4EAB, 0x4EAC, 0x4F6F, 0x4F9D, 0x4F8D, 0x4F73,
	0x4F7F, 0x4F6C, 0x4F9B, 0x4F8B, 0x4F86, 0x4F83, 0x4F70, 0x4F75,
	0x4F88, 0x4F69, 0x4F7B, 0x4F96, 0x4F7E, 0x4F8F, 0x4F91, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F7A, 0x5154, 0x5152, 0x5155, 0x5169, 0x5177, 0x5176,
	0x5178, 0x51BD, 0x51FD, 0x523B, 0x5238, 0x5237, 0x523A, 0x5230,
	0x522E, 0x5236, 0x5241, 0x52BE, 0x52BB, 0x5352, 0x5354, 0x5353,
	0x5351, 0x5366, 0x5377, 0x5378, 0x5379, 0x53D6, 0x53D4, 0x53D7,
	0x5473, 0x5475, 0x5496, 0x5478, 0x5495, 0x5480, 0x547B, 0x5477,
	0x5484, 0x5492, 0x5486, 0x547C, 0x5490, 0x5471, 0x5476, 0x548C,
	0x549A, 0x5462, 0x5468, 0x548B, 0x547D, 0x548E, 0x56FA, 0x5783,
	0x5777, 0x576A, 0x5769, 0x5761, 0x5766, 0x5764, 0x577C, 0x591C,
	0x5949, 0x5947, 0x5948, 0x5944, 0x5954, 0x59BE, 0x59BB, 0x59D4,
	0x59B9, 0x59AE, 0x59D1, 0x59C6, 0x59D0, 0x59CD, 0x59CB, 0x59D3,
	0x59CA, 0x59AF, 0x59B3, 0x59D2, 0x59C5, 0x5B5F, 0x5B64, 0x5B63,
	0x5B97, 0x5B9A, 0x5B98, 0x5B9C, 0x5B99, 0x5B9B, 0x5C1A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C48, 0x5C45, 0x5C46, 0x5CB7, 0x5CA1, 0x5CB8, 0x5CA9,
	0x5CAB, 0x5CB1, 0x5CB3, 0x5E18, 0x5E1A, 0x5E16, 0x5E15, 0x5E1B,
	0x5E11, 0x5E78, 0x5E9A, 0x5E97, 0x5E9C, 0x5E95, 0x5E96, 0x5EF6,
	0x5F26, 0x5F27, 0x5F29, 0x5F80, 0x5F81, 0x5F7F, 0x5F7C, 0x5FDD,
	0x5FE0, 0x5FFD, 0x5FF5, 0x5FFF, 0x600F, 0x6014, 0x602F, 0x6035,
	0x6016, 0x602A, 0x6015, 0x6021, 0x6027, 0x6029, 0x602B, 0x601B,
	0x6216, 0x6215, 0x623F, 0x623E, 0x6240, 0x627F, 0x62C9, 0x62CC,
	0x62C4, 0x62BF, 0x62C2, 0x62B9, 0x62D2, 0x62DB, 0x62AB, 0x62D3,
	0x62D4, 0x62CB, 0x62C8, 0x62A8, 0x62BD, 0x62BC, 0x62D0, 0x62D9,
	0x62C7, 0x62CD, 0x62B5, 0x62DA, 0x62B1, 0x62D8, 0x62D6, 0x62D7,
	0x62C6, 0x62AC, 0x62CE, 0x653E, 0x65A7, 0x65BC, 0x65FA, 0x6614,
	0x6613, 0x660C, 0x6606, 0x6602, 0x660E, 0x6600, 0x660F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6615, 0x660A, 0x6607, 0x670D, 0x670B, 0x676D, 0x678B,
	0x6795, 0x6771, 0x679C, 0x6773, 0x6777, 0x6787, 0x679D, 0x6797,
	0x676F, 0x6770, 0x677F, 0x6789, 0x677E, 0x6790, 0x6775, 0x679A,
	0x6793, 0x677C, 0x676A, 0x6772, 0x6B23, 0x6B66, 0x6B67, 0x6B7F,
	0x6C13, 0x6C1B, 0x6CE3, 0x6CE8, 0x6CF3, 0x6CB1, 0x6CCC, 0x6CE5,
	0x6CB3, 0x6CBD, 0x6CBE, 0x6CBC, 0x6CE2, 0x6CAB, 0x6CD5, 0x6CD3,
	0x6CB8, 0x6CC4, 0x6CB9, 0x6CC1, 0x6CAE, 0x6CD7, 0x6CC5, 0x6CF1,
	0x6CBF, 0x6CBB, 0x6CE1, 0x6CDB, 0x6CCA, 0x6CAC, 0x6CEF, 0x6CDC,
	0x6CD6, 0x6CE0, 0x7095, 0x708E, 0x7092, 0x708A, 0x7099, 0x722C,
	0x722D, 0x7238, 0x7248, 0x7267, 0x7269, 0x72C0, 0x72CE, 0x72D9,
	0x72D7, 0x72D0, 0x73A9, 0x73A8, 0x739F, 0x73AB, 0x73A5, 0x753D,
	0x759D, 0x7599, 0x759A, 0x7684, 0x76C2, 0x76F2, 0x76F4, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x77E5, 0x77FD, 0x793E, 0x7940, 0x7941, 0x79C9, 0x79C8,
	0x7A7A, 0x7A79, 0x7AFA, 0x7CFE, 0x7F54, 0x7F8C, 0x7F8B, 0x8005,
	0x80BA, 0x80A5, 0x80A2, 0x80B1, 0x80A1, 0x80AB, 0x80A9, 0x80B4,
	0x80AA, 0x80AF, 0x81E5, 0x81FE, 0x820D, 0x82B3, 0x829D, 0x8299,
	0x82AD, 0x82BD, 0x829F, 0x82B9, 0x82B1, 0x82AC, 0x82A5, 0x82AF,
	0x82B8, 0x82A3, 0x82B0, 0x82BE, 0x82B7, 0x864E, 0x8671, 0x521D,
	0x8868, 0x8ECB, 0x8FCE, 0x8FD4, 0x8FD1, 0x90B5, 0x90B8, 0x90B1,
	0x90B6, 0x91C7, 0x91D1, 0x9577, 0x9580, 0x961C, 0x9640, 0x963F,
	0x963B, 0x9644, 0x9642, 0x96B9, 0x96E8, 0x9752, 0x975E, 0x4E9F,
	0x4EAD, 0x4EAE, 0x4FE1, 0x4FB5, 0x4FAF, 0x4FBF, 0x4FE0, 0x4FD1,
	0x4FCF, 0x4FDD, 0x4FC3, 0x4FB6, 0x4FD8, 0x4FDF, 0x4FCA, 0x4FD7,
	0x4FAE, 0x4FD0, 0x4FC4, 0x4FC2, 0x4FDA, 0x4FCE, 0x4FDE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_50 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4FB7, 0x5157, 0x5192, 0x5191, 0x51A0, 0x524E, 0x5243,
	0x524A, 0x524D, 0x524C, 0x524B, 0x5247, 0x52C7, 0x52C9, 0x52C3,
	0x52C1, 0x530D, 0x5357, 0x537B, 0x539A, 0x53DB, 0x54AC, 0x54C0,
	0x54A8, 0x54CE, 0x54C9, 0x54B8, 0x54A6, 0x54B3, 0x54C7, 0x54C2,
	0x54BD, 0x54AA, 0x54C1, 0x54C4, 0x54C8, 0x54AF, 0x54AB, 0x54B1,
	0x54BB, 0x54A9, 0x54A7, 0x54BF, 0x56FF, 0x5782, 0x578B, 0x57A0,
	0x57A3, 0x57A2, 0x57CE, 0x57AE, 0x5793, 0x5955, 0x5951, 0x594F,
	0x594E, 0x5950, 0x59DC, 0x59D8, 0x59FF, 0x59E3, 0x59E8, 0x5A03,
	0x59E5, 0x59EA, 0x59DA, 0x59E6, 0x5A01, 0x59FB, 0x5B69, 0x5BA3,
	0x5BA6, 0x5BA4, 0x5BA2, 0x5BA5, 0x5C01, 0x5C4E, 0x5C4F, 0x5C4D,
	0x5C4B, 0x5CD9, 0x5CD2, 0x5DF7, 0x5E1D, 0x5E25, 0x5E1F, 0x5E7D,
	0x5EA0, 0x5EA6, 0x5EFA, 0x5F08, 0x5F2D, 0x5F65, 0x5F88, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_51 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F85, 0x5F8A, 0x5F8B, 0x5F87, 0x5F8C, 0x5F89, 0x6012,
	0x601D, 0x6020, 0x6025, 0x600E, 0x6028, 0x604D, 0x6070, 0x6068,
	0x6062, 0x6046, 0x6043, 0x606C, 0x606B, 0x606A, 0x6064, 0x6241,
	0x62DC, 0x6316, 0x6309, 0x62FC, 0x62ED, 0x6301, 0x62EE, 0x62FD,
	0x6307, 0x62F1, 0x62F7, 0x62EF, 0x62EC, 0x62FE, 0x62F4, 0x6311,
	0x6302, 0x653F, 0x6545, 0x65AB, 0x65BD, 0x65E2, 0x6625, 0x662D,
	0x6620, 0x6627, 0x662F, 0x661F, 0x6628, 0x6631, 0x6624, 0x66F7,
	0x67FF, 0x67D3, 0x67F1, 0x67D4, 0x67D0, 0x67EC, 0x67B6, 0x67AF,
	0x67F5, 0x67E9, 0x67EF, 0x67C4, 0x67D1, 0x67B4, 0x67DA, 0x67E5,
	0x67B8, 0x67CF, 0x67DE, 0x67F3, 0x67B0, 0x67D9, 0x67E2, 0x67DD,
	0x67D2, 0x6B6A, 0x6B83, 0x6B86, 0x6BB5, 0x6BD2, 0x6BD7, 0x6C1F,
	0x6CC9, 0x6D0B, 0x6D32, 0x6D2A, 0x6D41, 0x6D25, 0x6D0C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_52 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D31, 0x6D1E, 0x6D17, 0x6D3B, 0x6D3D, 0x6D3E, 0x6D36,
	0x6D1B, 0x6CF5, 0x6D39, 0x6D27, 0x6D38, 0x6D29, 0x6D2E, 0x6D35,
	0x6D0E, 0x6D2B, 0x70AB, 0x70BA, 0x70B3, 0x70AC, 0x70AF, 0x70AD,
	0x70B8, 0x70AE, 0x70A4, 0x7230, 0x7272, 0x726F, 0x7274, 0x72E9,
	0x72E0, 0x72E1, 0x73B7, 0x73CA, 0x73BB, 0x73B2, 0x73CD, 0x73C0,
	0x73B3, 0x751A, 0x752D, 0x754F, 0x754C, 0x754E, 0x754B, 0x75AB,
	0x75A4, 0x75A5, 0x75A2, 0x75A3, 0x7678, 0x7686, 0x7687, 0x7688,
	0x76C8, 0x76C6, 0x76C3, 0x76C5, 0x7701, 0x76F9, 0x76F8, 0x7709,
	0x770B, 0x76FE, 0x76FC, 0x7707, 0x77DC, 0x7802, 0x7814, 0x780C,
	0x780D, 0x7946, 0x7949, 0x7948, 0x7947, 0x79B9, 0x79BA, 0x79D1,
	0x79D2, 0x79CB, 0x7A7F, 0x7A81, 0x7AFF, 0x7AFD, 0x7C7D, 0x7D02,
	0x7D05, 0x7D00, 0x7D09, 0x7D07, 0x7D04, 0x7D06, 0x7F38, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_53 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7F8E, 0x7FBF, 0x8010, 0x800D, 0x8011, 0x8036, 0x80D6,
	0x80E5, 0x80DA, 0x80C3, 0x80C4, 0x80CC, 0x80E1, 0x80DB, 0x80CE,
	0x80DE, 0x80E4, 0x80DD, 0x81F4, 0x8222, 0x82E7, 0x8303, 0x8305,
	0x82E3, 0x82DB, 0x82E6, 0x8304, 0x82E5, 0x8302, 0x8309, 0x82D2,
	0x82D7, 0x82F1, 0x8301, 0x82DC, 0x82D4, 0x82D1, 0x82DE, 0x82D3,
	0x82DF, 0x82EF, 0x8306, 0x8650, 0x8679, 0x867B, 0x867A, 0x884D,
	0x886B, 0x8981, 0x89D4, 0x8A08, 0x8A02, 0x8A03, 0x8C9E, 0x8CA0,
	0x8D74, 0x8D73, 0x8DB4, 0x8ECD, 0x8ECC, 0x8FF0, 0x8FE6, 0x8FE2,
	0x8FEA, 0x8FE5, 0x8FED, 0x8FEB, 0x8FE4, 0x8FE8, 0x90CA, 0x90CE,
	0x90C1, 0x90C3, 0x914B, 0x914A, 0x91CD, 0x9582, 0x9650, 0x964B,
	0x964C, 0x964D, 0x9762, 0x9769, 0x97CB, 0x97ED, 0x97F3, 0x9801,
	0x98A8, 0x98DB, 0x98DF, 0x9996, 0x9999, 0x4E58, 0x4EB3, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_54 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x500C, 0x500D, 0x5023, 0x4FEF, 0x5026, 0x5025, 0x4FF8,
	0x5029, 0x5016, 0x5006, 0x503C, 0x501F, 0x501A, 0x5012, 0x5011,
	0x4FFA, 0x5000, 0x5014, 0x5028, 0x4FF1, 0x5021, 0x500B, 0x5019,
	0x5018, 0x4FF3, 0x4FEE, 0x502D, 0x502A, 0x4FFE, 0x502B, 0x5009,
	0x517C, 0x51A4, 0x51A5, 0x51A2, 0x51CD, 0x51CC, 0x51C6, 0x51CB,
	0x5256, 0x525C, 0x5254, 0x525B, 0x525D, 0x532A, 0x537F, 0x539F,
	0x539D, 0x53DF, 0x54E8, 0x5510, 0x5501, 0x5537, 0x54FC, 0x54E5,
	0x54F2, 0x5506, 0x54FA, 0x5514, 0x54E9, 0x54ED, 0x54E1, 0x5509,
	0x54EE, 0x54EA, 0x54E6, 0x5527, 0x5507, 0x54FD, 0x550F, 0x5703,
	0x5704, 0x57C2, 0x57D4, 0x57CB, 0x57C3, 0x5809, 0x590F, 0x5957,
	0x5958, 0x595A, 0x5A11, 0x5A18, 0x5A1C, 0x5A1F, 0x5A1B, 0x5A13,
	0x59EC, 0x5A20, 0x5A23, 0x5A29, 0x5A25, 0x5A0C, 0x5A09, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_55 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B6B, 0x5C58, 0x5BB0, 0x5BB3, 0x5BB6, 0x5BB4, 0x5BAE,
	0x5BB5, 0x5BB9, 0x5BB8, 0x5C04, 0x5C51, 0x5C55, 0x5C50, 0x5CED,
	0x5CFD, 0x5CFB, 0x5CEA, 0x5CE8, 0x5CF0, 0x5CF6, 0x5D01, 0x5CF4,
	0x5DEE, 0x5E2D, 0x5E2B, 0x5EAB, 0x5EAD, 0x5EA7, 0x5F31, 0x5F92,
	0x5F91, 0x5F90, 0x6059, 0x6063, 0x6065, 0x6050, 0x6055, 0x606D,
	0x6069, 0x606F, 0x6084, 0x609F, 0x609A, 0x608D, 0x6094, 0x608C,
	0x6085, 0x6096, 0x6247, 0x62F3, 0x6308, 0x62FF, 0x634E, 0x633E,
	0x632F, 0x6355, 0x6342, 0x6346, 0x634F, 0x6349, 0x633A, 0x6350,
	0x633D, 0x632A, 0x632B, 0x6328, 0x634D, 0x634C, 0x6548, 0x6549,
	0x6599, 0x65C1, 0x65C5, 0x6642, 0x6649, 0x664F, 0x6643, 0x6652,
	0x664C, 0x6645, 0x6641, 0x66F8, 0x6714, 0x6715, 0x6717, 0x6821,
	0x6838, 0x6848, 0x6846, 0x6853, 0x6839, 0x6842, 0x6854, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_56 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6829, 0x68B3, 0x6817, 0x684C, 0x6851, 0x683D, 0x67F4,
	0x6850, 0x6840, 0x683C, 0x6843, 0x682A, 0x6845, 0x6813, 0x6818,
	0x6841, 0x6B8A, 0x6B89, 0x6BB7, 0x6C23, 0x6C27, 0x6C28, 0x6C26,
	0x6C24, 0x6CF0, 0x6D6A, 0x6D95, 0x6D88, 0x6D87, 0x6D66, 0x6D78,
	0x6D77, 0x6D59, 0x6D93, 0x6D6C, 0x6D89, 0x6D6E, 0x6D5A, 0x6D74,
	0x6D69, 0x6D8C, 0x6D8A, 0x6D79, 0x6D85, 0x6D65, 0x6D94, 0x70CA,
	0x70D8, 0x70E4, 0x70D9, 0x70C8, 0x70CF, 0x7239, 0x7279, 0x72FC,
	0x72F9, 0x72FD, 0x72F8, 0x72F7, 0x7386, 0x73ED, 0x7409, 0x73EE,
	0x73E0, 0x73EA, 0x73DE, 0x7554, 0x755D, 0x755C, 0x755A, 0x7559,
	0x75BE, 0x75C5, 0x75C7, 0x75B2, 0x75B3, 0x75BD, 0x75BC, 0x75B9,
	0x75C2, 0x75B8, 0x768B, 0x76B0, 0x76CA, 0x76CD, 0x76CE, 0x7729,
	0x771F, 0x7720, 0x7728, 0x77E9, 0x7830, 0x7827, 0x7838, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_57 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x781D, 0x7834, 0x7837, 0x7825, 0x782D, 0x7820, 0x781F,
	0x7832, 0x7955, 0x7950, 0x7960, 0x795F, 0x7956, 0x795E, 0x795D,
	0x7957, 0x795A, 0x79E4, 0x79E3, 0x79E7, 0x79DF, 0x79E6, 0x79E9,
	0x79D8, 0x7A84, 0x7A88, 0x7AD9, 0x7B06, 0x7B11, 0x7C89, 0x7D21,
	0x7D17, 0x7D0B, 0x7D0A, 0x7D20, 0x7D22, 0x7D14, 0x7D10, 0x7D15,
	0x7D1A, 0x7D1C, 0x7D0D, 0x7D19, 0x7D1B, 0x7F3A, 0x7F5F, 0x7F94,
	0x7FC5, 0x7FC1, 0x8006, 0x8004, 0x8018, 0x8015, 0x8019, 0x8017,
	0x803D, 0x803F, 0x80F1, 0x8102, 0x80F0, 0x8105, 0x80ED, 0x80F4,
	0x8106, 0x80F8, 0x80F3, 0x8108, 0x80FD, 0x810A, 0x80FC, 0x80EF,
	0x81ED, 0x81EC, 0x8200, 0x8210, 0x822A, 0x822B, 0x8228, 0x822C,
	0x82BB, 0x832B, 0x8352, 0x8354, 0x834A, 0x8338, 0x8350, 0x8349,
	0x8335, 0x8334, 0x834F, 0x8332, 0x8339, 0x8336, 0x8317, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_58 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8340, 0x8331, 0x8328, 0x8343, 0x8654, 0x868A, 0x86AA,
	0x8693, 0x86A4, 0x86A9, 0x868C, 0x86A3, 0x869C, 0x8870, 0x8877,
	0x8881, 0x8882, 0x887D, 0x8879, 0x8A18, 0x8A10, 0x8A0E, 0x8A0C,
	0x8A15, 0x8A0A, 0x8A17, 0x8A13, 0x8A16, 0x8A0F, 0x8A11, 0x8C48,
	0x8C7A, 0x8C79, 0x8CA1, 0x8CA2, 0x8D77, 0x8EAC, 0x8ED2, 0x8ED4,
	0x8ECF, 0x8FB1, 0x9001, 0x9006, 0x8FF7, 0x9000, 0x8FFA, 0x8FF4,
	0x9003, 0x8FFD, 0x9005, 0x8FF8, 0x9095, 0x90E1, 0x90DD, 0x90E2,
	0x9152, 0x914D, 0x914C, 0x91D8, 0x91DD, 0x91D7, 0x91DC, 0x91D9,
	0x9583, 0x9662, 0x9663, 0x9661, 0x965B, 0x965D, 0x9664, 0x9658,
	0x965E, 0x96BB, 0x98E2, 0x99AC, 0x9AA8, 0x9AD8, 0x9B25, 0x9B32,
	0x9B3C, 0x4E7E, 0x507A, 0x507D, 0x505C, 0x5047, 0x5043, 0x504C,
	0x505A, 0x5049, 0x5065, 0x5076, 0x504E, 0x5055, 0x5075, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_59 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5074, 0x5077, 0x504F, 0x500F, 0x506F, 0x506D, 0x515C,
	0x5195, 0x51F0, 0x526A, 0x526F, 0x52D2, 0x52D9, 0x52D8, 0x52D5,
	0x5310, 0x530F, 0x5319, 0x533F, 0x5340, 0x533E, 0x53C3, 0x66FC,
	0x5546, 0x556A, 0x5566, 0x5544, 0x555E, 0x5561, 0x5543, 0x554A,
	0x5531, 0x5556, 0x554F, 0x5555, 0x552F, 0x5564, 0x5538, 0x552E,
	0x555C, 0x552C, 0x5563, 0x5533, 0x5541, 0x5557, 0x5708, 0x570B,
	0x5709, 0x57DF, 0x5805, 0x580A, 0x5806, 0x57E0, 0x57E4, 0x57FA,
	0x5802, 0x5835, 0x57F7, 0x57F9, 0x5920, 0x5962, 0x5A36, 0x5A41,
	0x5A49, 0x5A66, 0x5A6A, 0x5A40, 0x5A3C, 0x5A62, 0x5A5A, 0x5A46,
	0x5A4A, 0x5B70, 0x5BC7, 0x5BC5, 0x5BC4, 0x5BC2, 0x5BBF, 0x5BC6,
	0x5C09, 0x5C08, 0x5C07, 0x5C60, 0x5C5C, 0x5C5D, 0x5D07, 0x5D06,
	0x5D0E, 0x5D1B, 0x5D16, 0x5D22, 0x5D11, 0x5D29, 0x5D14, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D19, 0x5D24, 0x5D27, 0x5D17, 0x5DE2, 0x5E38, 0x5E36,
	0x5E33, 0x5E37, 0x5EB7, 0x5EB8, 0x5EB6, 0x5EB5, 0x5EBE, 0x5F35,
	0x5F37, 0x5F57, 0x5F6C, 0x5F69, 0x5F6B, 0x5F97, 0x5F99, 0x5F9E,
	0x5F98, 0x5FA1, 0x5FA0, 0x5F9C, 0x607F, 0x60A3, 0x6089, 0x60A0,
	0x60A8, 0x60CB, 0x60B4, 0x60E6, 0x60BD, 0x60C5, 0x60BB, 0x60B5,
	0x60DC, 0x60BC, 0x60D8, 0x60D5, 0x60C6, 0x60DF, 0x60B8, 0x60DA,
	0x60C7, 0x621A, 0x621B, 0x6248, 0x63A0, 0x63A7, 0x6372, 0x6396,
	0x63A2, 0x63A5, 0x6377, 0x6367, 0x6398, 0x63AA, 0x6371, 0x63A9,
	0x6389, 0x6383, 0x639B, 0x636B, 0x63A8, 0x6384, 0x6388, 0x6399,
	0x63A1, 0x63AC, 0x6392, 0x638F, 0x6380, 0x637B, 0x6369, 0x6368,
	0x637A, 0x655D, 0x6556, 0x6551, 0x6559, 0x6557, 0x555F, 0x654F,
	0x6558, 0x6555, 0x6554, 0x659C, 0x659B, 0x65AC, 0x65CF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x65CB, 0x65CC, 0x65CE, 0x665D, 0x665A, 0x6664, 0x6668,
	0x6666, 0x665E, 0x66F9, 0x52D7, 0x671B, 0x6881, 0x68AF, 0x68A2,
	0x6893, 0x68B5, 0x687F, 0x6876, 0x68B1, 0x68A7, 0x6897, 0x68B0,
	0x6883, 0x68C4, 0x68AD, 0x6886, 0x6885, 0x6894, 0x689D, 0x68A8,
	0x689F, 0x68A1, 0x6882, 0x6B32, 0x6BBA, 0x6BEB, 0x6BEC, 0x6C2B,
	0x6D8E, 0x6DBC, 0x6DF3, 0x6DD9, 0x6DB2, 0x6DE1, 0x6DCC, 0x6DE4,
	0x6DFB, 0x6DFA, 0x6E05, 0x6DC7, 0x6DCB, 0x6DAF, 0x6DD1, 0x6DAE,
	0x6DDE, 0x6DF9, 0x6DB8, 0x6DF7, 0x6DF5, 0x6DC5, 0x6DD2, 0x6E1A,
	0x6DB5, 0x6DDA, 0x6DEB, 0x6DD8, 0x6DEA, 0x6DF1, 0x6DEE, 0x6DE8,
	0x6DC6, 0x6DC4, 0x6DAA, 0x6DEC, 0x6DBF, 0x6DE6, 0x70F9, 0x7109,
	0x710A, 0x70FD, 0x70EF, 0x723D, 0x727D, 0x7281, 0x731C, 0x731B,
	0x7316, 0x7313, 0x7319, 0x7387, 0x7405, 0x740A, 0x7403, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7406, 0x73FE, 0x740D, 0x74E0, 0x74F6, 0x74F7, 0x751C,
	0x7522, 0x7565, 0x7566, 0x7562, 0x7570, 0x758F, 0x75D4, 0x75D5,
	0x75B5, 0x75CA, 0x75CD, 0x768E, 0x76D4, 0x76D2, 0x76DB, 0x7737,
	0x773E, 0x773C, 0x7736, 0x7738, 0x773A, 0x786B, 0x7843, 0x784E,
	0x7965, 0x7968, 0x796D, 0x79FB, 0x7A92, 0x7A95, 0x7B20, 0x7B28,
	0x7B1B, 0x7B2C, 0x7B26, 0x7B19, 0x7B1E, 0x7B2E, 0x7C92, 0x7C97,
	0x7C95, 0x7D46, 0x7D43, 0x7D71, 0x7D2E, 0x7D39, 0x7D3C, 0x7D40,
	0x7D30, 0x7D33, 0x7D44, 0x7D2F, 0x7D42, 0x7D32, 0x7D31, 0x7F3D,
	0x7F9E, 0x7F9A, 0x7FCC, 0x7FCE, 0x7FD2, 0x801C, 0x804A, 0x8046,
	0x812F, 0x8116, 0x8123, 0x812B, 0x8129, 0x8130, 0x8124, 0x8202,
	0x8235, 0x8237, 0x8236, 0x8239, 0x838E, 0x839E, 0x8398, 0x8378,
	0x83A2, 0x8396, 0x83BD, 0x83AB, 0x8392, 0x838A, 0x8393, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8389, 0x83A0, 0x8377, 0x837B, 0x837C, 0x8386, 0x83A7,
	0x8655, 0x5F6A, 0x86C7, 0x86C0, 0x86B6, 0x86C4, 0x86B5, 0x86C6,
	0x86CB, 0x86B1, 0x86AF, 0x86C9, 0x8853, 0x889E, 0x8888, 0x88AB,
	0x8892, 0x8896, 0x888D, 0x888B, 0x8993, 0x898F, 0x8A2A, 0x8A1D,
	0x8A23, 0x8A25, 0x8A31, 0x8A2D, 0x8A1F, 0x8A1B, 0x8A22, 0x8C49,
	0x8C5A, 0x8CA9, 0x8CAC, 0x8CAB, 0x8CA8, 0x8CAA, 0x8CA7, 0x8D67,
	0x8D66, 0x8DBE, 0x8DBA, 0x8EDB, 0x8EDF, 0x9019, 0x900D, 0x901A,
	0x9017, 0x9023, 0x901F, 0x901D, 0x9010, 0x9015, 0x901E, 0x9020,
	0x900F, 0x9022, 0x9016, 0x901B, 0x9014, 0x90E8, 0x90ED, 0x90FD,
	0x9157, 0x91CE, 0x91F5, 0x91E6, 0x91E3, 0x91E7, 0x91ED, 0x91E9,
	0x9589, 0x966A, 0x9675, 0x9673, 0x9678, 0x9670, 0x9674, 0x9676,
	0x9677, 0x966C, 0x96C0, 0x96EA, 0x96E9, 0x7AE0, 0x7ADF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9802, 0x9803, 0x9B5A, 0x9CE5, 0x9E75, 0x9E7F, 0x9EA5,
	0x9EBB, 0x50A2, 0x508D, 0x5085, 0x5099, 0x5091, 0x5080, 0x5096,
	0x5098, 0x509A, 0x6700, 0x51F1, 0x5272, 0x5274, 0x5275, 0x5269,
	0x52DE, 0x52DD, 0x52DB, 0x535A, 0x53A5, 0x557B, 0x5580, 0x55A7,
	0x557C, 0x558A, 0x559D, 0x5598, 0x5582, 0x559C, 0x55AA, 0x5594,
	0x5587, 0x558B, 0x5583, 0x55B3, 0x55AE, 0x559F, 0x553E, 0x55B2,
	0x559A, 0x55BB, 0x55AC, 0x55B1, 0x557E, 0x5589, 0x55AB, 0x5599,
	0x570D, 0x582F, 0x582A, 0x5834, 0x5824, 0x5830, 0x5831, 0x5821,
	0x581D, 0x5820, 0x58F9, 0x58FA, 0x5960, 0x5A77, 0x5A9A, 0x5A7F,
	0x5A92, 0x5A9B, 0x5AA7, 0x5B73, 0x5B71, 0x5BD2, 0x5BCC, 0x5BD3,
	0x5BD0, 0x5C0A, 0x5C0B, 0x5C31, 0x5D4C, 0x5D50, 0x5D34, 0x5D47,
	0x5DFD, 0x5E45, 0x5E3D, 0x5E40, 0x5E43, 0x5E7E, 0x5ECA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5EC1, 0x5EC2, 0x5EC4, 0x5F3C, 0x5F6D, 0x5FA9, 0x5FAA,
	0x5FA8, 0x60D1, 0x60E1, 0x60B2, 0x60B6, 0x60E0, 0x611C, 0x6123,
	0x60FA, 0x6115, 0x60F0, 0x60FB, 0x60F4, 0x6168, 0x60F1, 0x610E,
	0x60F6, 0x6109, 0x6100, 0x6112, 0x621F, 0x6249, 0x63A3, 0x638C,
	0x63CF, 0x63C0, 0x63E9, 0x63C9, 0x63C6, 0x63CD, 0x63D2, 0x63E3,
	0x63D0, 0x63E1, 0x63D6, 0x63ED, 0x63EE, 0x6376, 0x63F4, 0x63EA,
	0x63DB, 0x6452, 0x63DA, 0x63F9, 0x655E, 0x6566, 0x6562, 0x6563,
	0x6591, 0x6590, 0x65AF, 0x666E, 0x6670, 0x6674, 0x6676, 0x666F,
	0x6691, 0x667A, 0x667E, 0x6677, 0x66FE, 0x66FF, 0x671F, 0x671D,
	0x68FA, 0x68D5, 0x68E0, 0x68D8, 0x68D7, 0x6905, 0x68DF, 0x68F5,
	0x68EE, 0x68E7, 0x68F9, 0x68D2, 0x68F2, 0x68E3, 0x68CB, 0x68CD,
	0x690D, 0x6912, 0x690E, 0x68C9, 0x68DA, 0x696E, 0x68FB, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B3E, 0x6B3A, 0x6B3D, 0x6B98, 0x6B96, 0x6BBC, 0x6BEF,
	0x6C2E, 0x6C2F, 0x6C2C, 0x6E2F, 0x6E38, 0x6E54, 0x6E21, 0x6E32,
	0x6E67, 0x6E4A, 0x6E20, 0x6E25, 0x6E23, 0x6E1B, 0x6E5B, 0x6E58,
	0x6E24, 0x6E56, 0x6E6E, 0x6E2D, 0x6E26, 0x6E6F, 0x6E34, 0x6E4D,
	0x6E3A, 0x6E2C, 0x6E43, 0x6E1D, 0x6E3E, 0x6ECB, 0x6E89, 0x6E19,
	0x6E4E, 0x6E63, 0x6E44, 0x6E72, 0x6E69, 0x6E5F, 0x7119, 0x711A,
	0x7126, 0x7130, 0x7121, 0x7136, 0x716E, 0x711C, 0x724C, 0x7284,
	0x7280, 0x7336, 0x7325, 0x7334, 0x7329, 0x743A, 0x742A, 0x7433,
	0x7422, 0x7425, 0x7435, 0x7436, 0x7434, 0x742F, 0x741B, 0x7426,
	0x7428, 0x7525, 0x7526, 0x756B, 0x756A, 0x75E2, 0x75DB, 0x75E3,
	0x75D9, 0x75D8, 0x75DE, 0x75E0, 0x767B, 0x767C, 0x7696, 0x7693,
	0x76B4, 0x76DC, 0x774F, 0x77ED, 0x785D, 0x786C, 0x786F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_61 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A0D, 0x7A08, 0x7A0B, 0x7A05, 0x7A00, 0x7A98, 0x7A97,
	0x7A96, 0x7AE5, 0x7AE3, 0x7B49, 0x7B56, 0x7B46, 0x7B50, 0x7B52,
	0x7B54, 0x7B4D, 0x7B4B, 0x7B4F, 0x7B51, 0x7C9F, 0x7CA5, 0x7D5E,
	0x7D50, 0x7D68, 0x7D55, 0x7D2B, 0x7D6E, 0x7D72, 0x7D61, 0x7D66,
	0x7D62, 0x7D70, 0x7D73, 0x5584, 0x7FD4, 0x7FD5, 0x800B, 0x8052,
	0x8085, 0x8155, 0x8154, 0x814B, 0x8151, 0x814E, 0x8139, 0x8146,
	0x813E, 0x814C, 0x8153, 0x8174, 0x8212, 0x821C, 0x83E9, 0x8403,
	0x83F8, 0x840D, 0x83E0, 0x83C5, 0x840B, 0x83C1, 0x83EF, 0x83F1,
	0x83F4, 0x8457, 0x840A, 0x83F0, 0x840C, 0x83CC, 0x83FD, 0x83F2,
	0x83CA, 0x8438, 0x840E, 0x8404, 0x83DC, 0x8407, 0x83D4, 0x83DF,
	0x865B, 0x86DF, 0x86D9, 0x86ED, 0x86D4, 0x86DB, 0x86E4, 0x86D0,
	0x86DE, 0x8857, 0x88C1, 0x88C2, 0x88B1, 0x8983, 0x8996, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_62 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A3B, 0x8A60, 0x8A55, 0x8A5E, 0x8A3C, 0x8A41, 0x8A54,
	0x8A5B, 0x8A50, 0x8A46, 0x8A34, 0x8A3A, 0x8A36, 0x8A56, 0x8C61,
	0x8C82, 0x8CAF, 0x8CBC, 0x8CB3, 0x8CBD, 0x8CC1, 0x8CBB, 0x8CC0,
	0x8CB4, 0x8CB7, 0x8CB6, 0x8CBF, 0x8CB8, 0x8D8A, 0x8D85, 0x8D81,
	0x8DCE, 0x8DDD, 0x8DCB, 0x8DDA, 0x8DD1, 0x8DCC, 0x8DDB, 0x8DC6,
	0x8EFB, 0x8EF8, 0x8EFC, 0x8F9C, 0x902E, 0x9035, 0x9031, 0x9038,
	0x9032, 0x9036, 0x9102, 0x90F5, 0x9109, 0x90FE, 0x9163, 0x9165,
	0x91CF, 0x9214, 0x9215, 0x9223, 0x9209, 0x921E, 0x920D, 0x9210,
	0x9207, 0x9211, 0x9594, 0x958F, 0x958B, 0x9591, 0x9593, 0x9592,
	0x958E, 0x968A, 0x968E, 0x968B, 0x967D, 0x9685, 0x9686, 0x968D,
	0x9672, 0x9684, 0x96C1, 0x96C5, 0x96C4, 0x96C6, 0x96C7, 0x96EF,
	0x96F2, 0x97CC, 0x9805, 0x9806, 0x9808, 0x98E7, 0x98EA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_63 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x98EF, 0x98E9, 0x98F2, 0x98ED, 0x99AE, 0x99AD, 0x9EC3,
	0x9ECD, 0x9ED1, 0x4E82, 0x50AD, 0x50B5, 0x50B2, 0x50B3, 0x50C5,
	0x50BE, 0x50AC, 0x50B7, 0x50BB, 0x50AF, 0x50C7, 0x527F, 0x5277,
	0x527D, 0x52DF, 0x52E6, 0x52E4, 0x52E2, 0x52E3, 0x532F, 0x55DF,
	0x55E8, 0x55D3, 0x55E6, 0x55CE, 0x55DC, 0x55C7, 0x55D1, 0x55E3,
	0x55E4, 0x55EF, 0x55DA, 0x55E1, 0x55C5, 0x55C6, 0x55E5, 0x55C9,
	0x5712, 0x5713, 0x585E, 0x5851, 0x5858, 0x5857, 0x585A, 0x5854,
	0x586B, 0x584C, 0x586D, 0x584A, 0x5862, 0x5852, 0x584B, 0x5967,
	0x5AC1, 0x5AC9, 0x5ACC, 0x5ABE, 0x5ABD, 0x5ABC, 0x5AB3, 0x5AC2,
	0x5AB2, 0x5D69, 0x5D6F, 0x5E4C, 0x5E79, 0x5EC9, 0x5EC8, 0x5F12,
	0x5F59, 0x5FAC, 0x5FAE, 0x611A, 0x610F, 0x6148, 0x611F, 0x60F3,
	0x611B, 0x60F9, 0x6101, 0x6108, 0x614E, 0x614C, 0x6144, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x614D, 0x613E, 0x6134, 0x6127, 0x610D, 0x6106, 0x6137,
	0x6221, 0x6222, 0x6413, 0x643E, 0x641E, 0x642A, 0x642D, 0x643D,
	0x642C, 0x640F, 0x641C, 0x6414, 0x640D, 0x6436, 0x6416, 0x6417,
	0x6406, 0x656C, 0x659F, 0x65B0, 0x6697, 0x6689, 0x6687, 0x6688,
	0x6696, 0x6684, 0x6698, 0x668D, 0x6703, 0x6994, 0x696D, 0x695A,
	0x6977, 0x6960, 0x6954, 0x6975, 0x6930, 0x6982, 0x694A, 0x6968,
	0x696B, 0x695E, 0x6953, 0x6979, 0x6986, 0x695D, 0x6963, 0x695B,
	0x6B47, 0x6B72, 0x6BC0, 0x6BBF, 0x6BD3, 0x6BFD, 0x6EA2, 0x6EAF,
	0x6ED3, 0x6EB6, 0x6EC2, 0x6E90, 0x6E9D, 0x6EC7, 0x6EC5, 0x6EA5,
	0x6E98, 0x6EBC, 0x6EBA, 0x6EAB, 0x6ED1, 0x6E96, 0x6E9C, 0x6EC4,
	0x6ED4, 0x6EAA, 0x6EA7, 0x6EB4, 0x714E, 0x7159, 0x7169, 0x7164,
	0x7149, 0x7167, 0x715C, 0x716C, 0x7166, 0x714C, 0x7165, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_65 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x715E, 0x7146, 0x7168, 0x7156, 0x723A, 0x7252, 0x7337,
	0x7345, 0x733F, 0x733E, 0x746F, 0x745A, 0x7455, 0x745F, 0x745E,
	0x7441, 0x743F, 0x7459, 0x745B, 0x745C, 0x7576, 0x7578, 0x7600,
	0x75F0, 0x7601, 0x75F2, 0x75F1, 0x75FA, 0x75FF, 0x75F4, 0x75F3,
	0x76DE, 0x76DF, 0x775B, 0x776B, 0x7766, 0x775E, 0x7763, 0x7779,
	0x776A, 0x776C, 0x775C, 0x7765, 0x7768, 0x7762, 0x77EE, 0x788E,
	0x78B0, 0x7897, 0x7898, 0x788C, 0x7889, 0x787C, 0x7891, 0x7893,
	0x787F, 0x797A, 0x797F, 0x7981, 0x842C, 0x79BD, 0x7A1C, 0x7A1A,
	0x7A20, 0x7A14, 0x7A1F, 0x7A1E, 0x7A9F, 0x7AA0, 0x7B77, 0x7BC0,
	0x7B60, 0x7B6E, 0x7B67, 0x7CB1, 0x7CB3, 0x7CB5, 0x7D93, 0x7D79,
	0x7D91, 0x7D81, 0x7D8F, 0x7D5B, 0x7F6E, 0x7F69, 0x7F6A, 0x7F72,
	0x7FA9, 0x7FA8, 0x7FA4, 0x8056, 0x8058, 0x8086, 0x8084, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_66 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8171, 0x8170, 0x8178, 0x8165, 0x816E, 0x8173, 0x816B,
	0x8179, 0x817A, 0x8166, 0x8205, 0x8247, 0x8482, 0x8477, 0x843D,
	0x8431, 0x8475, 0x8466, 0x846B, 0x8449, 0x846C, 0x845B, 0x843C,
	0x8435, 0x8461, 0x8463, 0x8469, 0x846D, 0x8446, 0x865E, 0x865C,
	0x865F, 0x86F9, 0x8713, 0x8708, 0x8707, 0x8700, 0x86FE, 0x86FB,
	0x8702, 0x8703, 0x8706, 0x870A, 0x8859, 0x88DF, 0x88D4, 0x88D9,
	0x88DC, 0x88D8, 0x88DD, 0x88E1, 0x88CA, 0x88D5, 0x88D2, 0x899C,
	0x89E3, 0x8A6B, 0x8A72, 0x8A73, 0x8A66, 0x8A69, 0x8A70, 0x8A87,
	0x8A7C, 0x8A63, 0x8AA0, 0x8A71, 0x8A85, 0x8A6D, 0x8A62, 0x8A6E,
	0x8A6C, 0x8A79, 0x8A7B, 0x8A3E, 0x8A68, 0x8C62, 0x8C8A, 0x8C89,
	0x8CCA, 0x8CC7, 0x8CC8, 0x8CC4, 0x8CB2, 0x8CC3, 0x8CC2, 0x8CC5,
	0x8DE1, 0x8DDF, 0x8DE8, 0x8DEF, 0x8DF3, 0x8DFA, 0x8DEA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_67 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8DE4, 0x8DE6, 0x8EB2, 0x8F03, 0x8F09, 0x8EFE, 0x8F0A,
	0x8F9F, 0x8FB2, 0x904B, 0x904A, 0x9053, 0x9042, 0x9054, 0x903C,
	0x9055, 0x9050, 0x9047, 0x904F, 0x904E, 0x904D, 0x9051, 0x903E,
	0x9041, 0x9112, 0x9117, 0x916C, 0x916A, 0x9169, 0x91C9, 0x9237,
	0x9257, 0x9238, 0x923D, 0x9240, 0x923E, 0x925B, 0x924B, 0x9264,
	0x9251, 0x9234, 0x9249, 0x924D, 0x9245, 0x9239, 0x923F, 0x925A,
	0x9598, 0x9698, 0x9694, 0x9695, 0x96CD, 0x96CB, 0x96C9, 0x96CA,
	0x96F7, 0x96FB, 0x96F9, 0x96F6, 0x9756, 0x9774, 0x9776, 0x9810,
	0x9811, 0x9813, 0x980A, 0x9812, 0x980C, 0x98FC, 0x98F4, 0x98FD,
	0x98FE, 0x99B3, 0x99B1, 0x99B4, 0x9AE1, 0x9CE9, 0x9E82, 0x9F0E,
	0x9F13, 0x9F20, 0x50E7, 0x50EE, 0x50E5, 0x50D6, 0x50ED, 0x50DA,
	0x50D5, 0x50CF, 0x50D1, 0x50F1, 0x50CE, 0x50E9, 0x5162, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_68 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x51F3, 0x5283, 0x5282, 0x5331, 0x53AD, 0x55FE, 0x5600,
	0x561B, 0x5617, 0x55FD, 0x5614, 0x5606, 0x5609, 0x560D, 0x560E,
	0x55F7, 0x5616, 0x561F, 0x5608, 0x5610, 0x55F6, 0x5718, 0x5716,
	0x5875, 0x587E, 0x5883, 0x5893, 0x588A, 0x5879, 0x5885, 0x587D,
	0x58FD, 0x5925, 0x5922, 0x5924, 0x596A, 0x5969, 0x5AE1, 0x5AE6,
	0x5AE9, 0x5AD7, 0x5AD6, 0x5AD8, 0x5AE3, 0x5B75, 0x5BDE, 0x5BE7,
	0x5BE1, 0x5BE5, 0x5BE6, 0x5BE8, 0x5BE2, 0x5BE4, 0x5BDF, 0x5C0D,
	0x5C62, 0x5D84, 0x5D87, 0x5E5B, 0x5E63, 0x5E55, 0x5E57, 0x5E54,
	0x5ED3, 0x5ED6, 0x5F0A, 0x5F46, 0x5F70, 0x5FB9, 0x6147, 0x613F,
	0x614B, 0x6177, 0x6162, 0x6163, 0x615F, 0x615A, 0x6158, 0x6175,
	0x622A, 0x6487, 0x6458, 0x6454, 0x64A4, 0x6478, 0x645F, 0x647A,
	0x6451, 0x6467, 0x6434, 0x646D, 0x647B, 0x6572, 0x65A1, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_69 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x65D7, 0x65D6, 0x66A2, 0x66A8, 0x669D, 0x699C, 0x69A8,
	0x6995, 0x69C1, 0x69AE, 0x69D3, 0x69CB, 0x699B, 0x69B7, 0x69BB,
	0x69AB, 0x69B4, 0x69D0, 0x69CD, 0x69AD, 0x69CC, 0x69A6, 0x69C3,
	0x69A3, 0x6B49, 0x6B4C, 0x6C33, 0x6F33, 0x6F14, 0x6EFE, 0x6F13,
	0x6EF4, 0x6F29, 0x6F3E, 0x6F20, 0x6F2C, 0x6F0F, 0x6F02, 0x6F22,
	0x6EFF, 0x6EEF, 0x6F06, 0x6F31, 0x6F38, 0x6F32, 0x6F23, 0x6F15,
	0x6F2B, 0x6F2F, 0x6F88, 0x6F2A, 0x6EEC, 0x6F01, 0x6EF2, 0x6ECC,
	0x6EF7, 0x7194, 0x7199, 0x717D, 0x718A, 0x7184, 0x7192, 0x723E,
	0x7292, 0x7296, 0x7344, 0x7350, 0x7464, 0x7463, 0x746A, 0x7470,
	0x746D, 0x7504, 0x7591, 0x7627, 0x760D, 0x760B, 0x7609, 0x7613,
	0x76E1, 0x76E3, 0x7784, 0x777D, 0x777F, 0x7761, 0x78C1, 0x789F,
	0x78A7, 0x78B3, 0x78A9, 0x78A3, 0x798E, 0x798F, 0x798D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A2E, 0x7A31, 0x7AAA, 0x7AA9, 0x7AED, 0x7AEF, 0x7BA1,
	0x7B95, 0x7B8B, 0x7B75, 0x7B97, 0x7B9D, 0x7B94, 0x7B8F, 0x7BB8,
	0x7B87, 0x7B84, 0x7CB9, 0x7CBD, 0x7CBE, 0x7DBB, 0x7DB0, 0x7D9C,
	0x7DBD, 0x7DBE, 0x7DA0, 0x7DCA, 0x7DB4, 0x7DB2, 0x7DB1, 0x7DBA,
	0x7DA2, 0x7DBF, 0x7DB5, 0x7DB8, 0x7DAD, 0x7DD2, 0x7DC7, 0x7DAC,
	0x7F70, 0x7FE0, 0x7FE1, 0x7FDF, 0x805E, 0x805A, 0x8087, 0x8150,
	0x8180, 0x818F, 0x8188, 0x818A, 0x817F, 0x8182, 0x81E7, 0x81FA,
	0x8207, 0x8214, 0x821E, 0x824B, 0x84C9, 0x84BF, 0x84C6, 0x84C4,
	0x8499, 0x849E, 0x84B2, 0x849C, 0x84CB, 0x84B8, 0x84C0, 0x84D3,
	0x8490, 0x84BC, 0x84D1, 0x84CA, 0x873F, 0x871C, 0x873B, 0x8722,
	0x8725, 0x8734, 0x8718, 0x8755, 0x8737, 0x8729, 0x88F3, 0x8902,
	0x88F4, 0x88F9, 0x88F8, 0x88FD, 0x88E8, 0x891A, 0x88EF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8AA6, 0x8A8C, 0x8A9E, 0x8AA3, 0x8A8D, 0x8AA1, 0x8A93,
	0x8AA4, 0x8AAA, 0x8AA5, 0x8AA8, 0x8A98, 0x8A91, 0x8A9A, 0x8AA7,
	0x8C6A, 0x8C8D, 0x8C8C, 0x8CD3, 0x8CD1, 0x8CD2, 0x8D6B, 0x8D99,
	0x8D95, 0x8DFC, 0x8F14, 0x8F12, 0x8F15, 0x8F13, 0x8FA3, 0x9060,
	0x9058, 0x905C, 0x9063, 0x9059, 0x905E, 0x9062, 0x905D, 0x905B,
	0x9119, 0x9118, 0x911E, 0x9175, 0x9178, 0x9177, 0x9174, 0x9278,
	0x92AC, 0x9280, 0x9285, 0x9298, 0x9296, 0x927B, 0x9293, 0x929C,
	0x92A8, 0x927C, 0x9291, 0x95A1, 0x95A8, 0x95A9, 0x95A3, 0x95A5,
	0x95A4, 0x9699, 0x969C, 0x969B, 0x96CC, 0x96D2, 0x9700, 0x977C,
	0x9785, 0x97F6, 0x9817, 0x9818, 0x98AF, 0x98B1, 0x9903, 0x9905,
	0x990C, 0x9909, 0x99C1, 0x9AAF, 0x9AB0, 0x9AE6, 0x9B41, 0x9B42,
	0x9CF4, 0x9CF6, 0x9CF3, 0x9EBC, 0x9F3B, 0x9F4A, 0x5104, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5100, 0x50FB, 0x50F5, 0x50F9, 0x5102, 0x5108, 0x5109,
	0x5105, 0x51DC, 0x5287, 0x5288, 0x5289, 0x528D, 0x528A, 0x52F0,
	0x53B2, 0x562E, 0x563B, 0x5639, 0x5632, 0x563F, 0x5634, 0x5629,
	0x5653, 0x564E, 0x5657, 0x5674, 0x5636, 0x562F, 0x5630, 0x5880,
	0x589F, 0x589E, 0x58B3, 0x589C, 0x58AE, 0x58A9, 0x58A6, 0x596D,
	0x5B09, 0x5AFB, 0x5B0B, 0x5AF5, 0x5B0C, 0x5B08, 0x5BEE, 0x5BEC,
	0x5BE9, 0x5BEB, 0x5C64, 0x5C65, 0x5D9D, 0x5D94, 0x5E62, 0x5E5F,
	0x5E61, 0x5EE2, 0x5EDA, 0x5EDF, 0x5EDD, 0x5EE3, 0x5EE0, 0x5F48,
	0x5F71, 0x5FB7, 0x5FB5, 0x6176, 0x6167, 0x616E, 0x615D, 0x6155,
	0x6182, 0x617C, 0x6170, 0x616B, 0x617E, 0x61A7, 0x6190, 0x61AB,
	0x618E, 0x61AC, 0x619A, 0x61A4, 0x6194, 0x61AE, 0x622E, 0x6469,
	0x646F, 0x6479, 0x649E, 0x64B2, 0x6488, 0x6490, 0x64B0, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x64A5, 0x6493, 0x6495, 0x64A9, 0x6492, 0x64AE, 0x64AD,
	0x64AB, 0x649A, 0x64AC, 0x6499, 0x64A2, 0x64B3, 0x6575, 0x6577,
	0x6578, 0x66AE, 0x66AB, 0x66B4, 0x66B1, 0x6A23, 0x6A1F, 0x69E8,
	0x6A01, 0x6A1E, 0x6A19, 0x69FD, 0x6A21, 0x6A13, 0x6A0A, 0x69F3,
	0x6A02, 0x6A05, 0x69ED, 0x6A11, 0x6B50, 0x6B4E, 0x6BA4, 0x6BC5,
	0x6BC6, 0x6F3F, 0x6F7C, 0x6F84, 0x6F51, 0x6F66, 0x6F54, 0x6F86,
	0x6F6D, 0x6F5B, 0x6F78, 0x6F6E, 0x6F8E, 0x6F7A, 0x6F70, 0x6F64,
	0x6F97, 0x6F58, 0x6ED5, 0x6F6F, 0x6F60, 0x6F5F, 0x719F, 0x71AC,
	0x71B1, 0x71A8, 0x7256, 0x729B, 0x734E, 0x7357, 0x7469, 0x748B,
	0x7483, 0x747E, 0x7480, 0x757F, 0x7620, 0x7629, 0x761F, 0x7624,
	0x7626, 0x7621, 0x7622, 0x769A, 0x76BA, 0x76E4, 0x778E, 0x7787,
	0x778C, 0x7791, 0x778B, 0x78CB, 0x78C5, 0x78BA, 0x78CA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x78BE, 0x78D5, 0x78BC, 0x78D0, 0x7A3F, 0x7A3C, 0x7A40,
	0x7A3D, 0x7A37, 0x7A3B, 0x7AAF, 0x7AAE, 0x7BAD, 0x7BB1, 0x7BC4,
	0x7BB4, 0x7BC6, 0x7BC7, 0x7BC1, 0x7BA0, 0x7BCC, 0x7CCA, 0x7DE0,
	0x7DF4, 0x7DEF, 0x7DFB, 0x7DD8, 0x7DEC, 0x7DDD, 0x7DE8, 0x7DE3,
	0x7DDA, 0x7DDE, 0x7DE9, 0x7D9E, 0x7DD9, 0x7DF2, 0x7DF9, 0x7F75,
	0x7F77, 0x7FAF, 0x7FE9, 0x8026, 0x819B, 0x819C, 0x819D, 0x81A0,
	0x819A, 0x8198, 0x8517, 0x853D, 0x851A, 0x84EE, 0x852C, 0x852D,
	0x8513, 0x8511, 0x8523, 0x8521, 0x8514, 0x84EC, 0x8525, 0x84FF,
	0x8506, 0x8782, 0x8774, 0x8776, 0x8760, 0x8766, 0x8778, 0x8768,
	0x8759, 0x8757, 0x874C, 0x8753, 0x885B, 0x885D, 0x8910, 0x8907,
	0x8912, 0x8913, 0x8915, 0x890A, 0x8ABC, 0x8AD2, 0x8AC7, 0x8AC4,
	0x8A95, 0x8ACB, 0x8AF8, 0x8AB2, 0x8AC9, 0x8AC2, 0x8ABF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8AB0, 0x8AD6, 0x8ACD, 0x8AB6, 0x8AB9, 0x8ADB, 0x8C4C,
	0x8C4E, 0x8C6C, 0x8CE0, 0x8CDE, 0x8CE6, 0x8CE4, 0x8CEC, 0x8CED,
	0x8CE2, 0x8CE3, 0x8CDC, 0x8CEA, 0x8CE1, 0x8D6D, 0x8D9F, 0x8DA3,
	0x8E2B, 0x8E10, 0x8E1D, 0x8E22, 0x8E0F, 0x8E29, 0x8E1F, 0x8E21,
	0x8E1E, 0x8EBA, 0x8F1D, 0x8F1B, 0x8F1F, 0x8F29, 0x8F26, 0x8F2A,
	0x8F1C, 0x8F1E, 0x8F25, 0x9069, 0x906E, 0x9068, 0x906D, 0x9077,
	0x9130, 0x912D, 0x9127, 0x9131, 0x9187, 0x9189, 0x918B, 0x9183,
	0x92C5, 0x92BB, 0x92B7, 0x92EA, 0x92E4, 0x92C1, 0x92B3, 0x92BC,
	0x92D2, 0x92C7, 0x92F0, 0x92B2, 0x95AD, 0x95B1, 0x9704, 0x9706,
	0x9707, 0x9709, 0x9760, 0x978D, 0x978B, 0x978F, 0x9821, 0x982B,
	0x981C, 0x98B3, 0x990A, 0x9913, 0x9912, 0x9918, 0x99DD, 0x99D0,
	0x99DF, 0x99DB, 0x99D1, 0x99D5, 0x99D2, 0x99D9, 0x9AB7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_70 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AEE, 0x9AEF, 0x9B27, 0x9B45, 0x9B44, 0x9B77, 0x9B6F,
	0x9D06, 0x9D09, 0x9D03, 0x9EA9, 0x9EBE, 0x9ECE, 0x58A8, 0x9F52,
	0x5112, 0x5118, 0x5114, 0x5110, 0x5115, 0x5180, 0x51AA, 0x51DD,
	0x5291, 0x5293, 0x52F3, 0x5659, 0x566B, 0x5679, 0x5669, 0x5664,
	0x5678, 0x566A, 0x5668, 0x5665, 0x5671, 0x566F, 0x566C, 0x5662,
	0x5676, 0x58C1, 0x58BE, 0x58C7, 0x58C5, 0x596E, 0x5B1D, 0x5B34,
	0x5B78, 0x5BF0, 0x5C0E, 0x5F4A, 0x61B2, 0x6191, 0x61A9, 0x618A,
	0x61CD, 0x61B6, 0x61BE, 0x61CA, 0x61C8, 0x6230, 0x64C5, 0x64C1,
	0x64CB, 0x64BB, 0x64BC, 0x64DA, 0x64C4, 0x64C7, 0x64C2, 0x64CD,
	0x64BF, 0x64D2, 0x64D4, 0x64BE, 0x6574, 0x66C6, 0x66C9, 0x66B9,
	0x66C4, 0x66C7, 0x66B8, 0x6A3D, 0x6A38, 0x6A3A, 0x6A59, 0x6A6B,
	0x6A58, 0x6A39, 0x6A44, 0x6A62, 0x6A61, 0x6A4B, 0x6A47, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_71 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A35, 0x6A5F, 0x6A48, 0x6B59, 0x6B77, 0x6C05, 0x6FC2,
	0x6FB1, 0x6FA1, 0x6FC3, 0x6FA4, 0x6FC1, 0x6FA7, 0x6FB3, 0x6FC0,
	0x6FB9, 0x6FB6, 0x6FA6, 0x6FA0, 0x6FB4, 0x71BE, 0x71C9, 0x71D0,
	0x71D2, 0x71C8, 0x71D5, 0x71B9, 0x71CE, 0x71D9, 0x71DC, 0x71C3,
	0x71C4, 0x7368, 0x749C, 0x74A3, 0x7498, 0x749F, 0x749E, 0x74E2,
	0x750C, 0x750D, 0x7634, 0x7638, 0x763A, 0x76E7, 0x76E5, 0x77A0,
	0x779E, 0x779F, 0x77A5, 0x78E8, 0x78DA, 0x78EC, 0x78E7, 0x79A6,
	0x7A4D, 0x7A4E, 0x7A46, 0x7A4C, 0x7A4B, 0x7ABA, 0x7BD9, 0x7C11,
	0x7BC9, 0x7BE4, 0x7BDB, 0x7BE1, 0x7BE9, 0x7BE6, 0x7CD5, 0x7CD6,
	0x7E0A, 0x7E11, 0x7E08, 0x7E1B, 0x7E23, 0x7E1E, 0x7E1D, 0x7E09,
	0x7E10, 0x7F79, 0x7FB2, 0x7FF0, 0x7FF1, 0x7FEE, 0x8028, 0x81B3,
	0x81A9, 0x81A8, 0x81FB, 0x8208, 0x8258, 0x8259, 0x854A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_72 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8559, 0x8548, 0x8568, 0x8569, 0x8543, 0x8549, 0x856D,
	0x856A, 0x855E, 0x8783, 0x879F, 0x879E, 0x87A2, 0x878D, 0x8861,
	0x892A, 0x8932, 0x8925, 0x892B, 0x8921, 0x89AA, 0x89A6, 0x8AE6,
	0x8AFA, 0x8AEB, 0x8AF1, 0x8B00, 0x8ADC, 0x8AE7, 0x8AEE, 0x8AFE,
	0x8B01, 0x8B02, 0x8AF7, 0x8AED, 0x8AF3, 0x8AF6, 0x8AFC, 0x8C6B,
	0x8C6D, 0x8C93, 0x8CF4, 0x8E44, 0x8E31, 0x8E34, 0x8E42, 0x8E39,
	0x8E35, 0x8F3B, 0x8F2F, 0x8F38, 0x8F33, 0x8FA8, 0x8FA6, 0x9075,
	0x9074, 0x9078, 0x9072, 0x907C, 0x907A, 0x9134, 0x9192, 0x9320,
	0x9336, 0x92F8, 0x9333, 0x932F, 0x9322, 0x92FC, 0x932B, 0x9304,
	0x931A, 0x9310, 0x9326, 0x9321, 0x9315, 0x932E, 0x9319, 0x95BB,
	0x96A7, 0x96A8, 0x96AA, 0x96D5, 0x970E, 0x9711, 0x9716, 0x970D,
	0x9713, 0x970F, 0x975B, 0x975C, 0x9766, 0x9798, 0x9830, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_73 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9838, 0x983B, 0x9837, 0x982D, 0x9839, 0x9824, 0x9910,
	0x9928, 0x991E, 0x991B, 0x9921, 0x991A, 0x99ED, 0x99E2, 0x99F1,
	0x9AB8, 0x9ABC, 0x9AFB, 0x9AED, 0x9B28, 0x9B91, 0x9D15, 0x9D23,
	0x9D26, 0x9D28, 0x9D12, 0x9D1B, 0x9ED8, 0x9ED4, 0x9F8D, 0x9F9C,
	0x512A, 0x511F, 0x5121, 0x5132, 0x52F5, 0x568E, 0x5680, 0x5690,
	0x5685, 0x5687, 0x568F, 0x58D5, 0x58D3, 0x58D1, 0x58CE, 0x5B30,
	0x5B2A, 0x5B24, 0x5B7A, 0x5C37, 0x5C68, 0x5DBC, 0x5DBA, 0x5DBD,
	0x5DB8, 0x5E6B, 0x5F4C, 0x5FBD, 0x61C9, 0x61C2, 0x61C7, 0x61E6,
	0x61CB, 0x6232, 0x6234, 0x64CE, 0x64CA, 0x64D8, 0x64E0, 0x64F0,
	0x64E6, 0x64EC, 0x64F1, 0x64E2, 0x64ED, 0x6582, 0x6583, 0x66D9,
	0x66D6, 0x6A80, 0x6A94, 0x6A84, 0x6AA2, 0x6A9C, 0x6ADB, 0x6AA3,
	0x6A7E, 0x6A97, 0x6A90, 0x6AA0, 0x6B5C, 0x6BAE, 0x6BDA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_74 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C08, 0x6FD8, 0x6FF1, 0x6FDF, 0x6FE0, 0x6FDB, 0x6FE4,
	0x6FEB, 0x6FEF, 0x6F80, 0x6FEC, 0x6FE1, 0x6FE9, 0x6FD5, 0x6FEE,
	0x6FF0, 0x71E7, 0x71DF, 0x71EE, 0x71E6, 0x71E5, 0x71ED, 0x71EC,
	0x71F4, 0x71E0, 0x7235, 0x7246, 0x7370, 0x7372, 0x74A9, 0x74B0,
	0x74A6, 0x74A8, 0x7646, 0x7642, 0x764C, 0x76EA, 0x77B3, 0x77AA,
	0x77B0, 0x77AC, 0x77A7, 0x77AD, 0x77EF, 0x78F7, 0x78FA, 0x78F4,
	0x78EF, 0x7901, 0x79A7, 0x79AA, 0x7A57, 0x7ABF, 0x7C07, 0x7C0D,
	0x7BFE, 0x7BF7, 0x7C0C, 0x7BE0, 0x7CE0, 0x7CDC, 0x7CDE, 0x7CE2,
	0x7CDF, 0x7CD9, 0x7CDD, 0x7E2E, 0x7E3E, 0x7E46, 0x7E37, 0x7E32,
	0x7E43, 0x7E2B, 0x7E3D, 0x7E31, 0x7E45, 0x7E41, 0x7E34, 0x7E39,
	0x7E48, 0x7E35, 0x7E3F, 0x7E2F, 0x7F44, 0x7FF3, 0x7FFC, 0x8071,
	0x8072, 0x8070, 0x806F, 0x8073, 0x81C6, 0x81C3, 0x81BA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_75 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x81C2, 0x81C0, 0x81BF, 0x81BD, 0x81C9, 0x81BE, 0x81E8,
	0x8209, 0x8271, 0x85AA, 0x8584, 0x857E, 0x859C, 0x8591, 0x8594,
	0x85AF, 0x859B, 0x8587, 0x85A8, 0x858A, 0x85A6, 0x8667, 0x87C0,
	0x87D1, 0x87B3, 0x87D2, 0x87C6, 0x87AB, 0x87BB, 0x87BA, 0x87C8,
	0x87CB, 0x893B, 0x8936, 0x8944, 0x8938, 0x893D, 0x89AC, 0x8B0E,
	0x8B17, 0x8B19, 0x8B1B, 0x8B0A, 0x8B20, 0x8B1D, 0x8B04, 0x8B10,
	0x8C41, 0x8C3F, 0x8C73, 0x8CFA, 0x8CFD, 0x8CFC, 0x8CF8, 0x8CFB,
	0x8DA8, 0x8E49, 0x8E4B, 0x8E48, 0x8E4A, 0x8F44, 0x8F3E, 0x8F42,
	0x8F45, 0x8F3F, 0x907F, 0x907D, 0x9084, 0x9081, 0x9082, 0x9080,
	0x9139, 0x91A3, 0x919E, 0x919C, 0x934D, 0x9382, 0x9328, 0x9375,
	0x934A, 0x9365, 0x934B, 0x9318, 0x937E, 0x936C, 0x935B, 0x9370,
	0x935A, 0x9354, 0x95CA, 0x95CB, 0x95CC, 0x95C8, 0x95C6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_76 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x96B1, 0x96B8, 0x96D6, 0x971C, 0x971E, 0x97A0, 0x97D3,
	0x9846, 0x98B6, 0x9935, 0x9A01, 0x99FF, 0x9BAE, 0x9BAB, 0x9BAA,
	0x9BAD, 0x9D3B, 0x9D3F, 0x9E8B, 0x9ECF, 0x9EDE, 0x9EDC, 0x9EDD,
	0x9EDB, 0x9F3E, 0x9F4B, 0x53E2, 0x5695, 0x56AE, 0x58D9, 0x58D8,
	0x5B38, 0x5F5E, 0x61E3, 0x6233, 0x64F4, 0x64F2, 0x64FE, 0x6506,
	0x64FA, 0x64FB, 0x64F7, 0x65B7, 0x66DC, 0x6726, 0x6AB3, 0x6AAC,
	0x6AC3, 0x6ABB, 0x6AB8, 0x6AC2, 0x6AAE, 0x6AAF, 0x6B5F, 0x6B78,
	0x6BAF, 0x7009, 0x700B, 0x6FFE, 0x7006, 0x6FFA, 0x7011, 0x700F,
	0x71FB, 0x71FC, 0x71FE, 0x71F8, 0x7377, 0x7375, 0x74A7, 0x74BF,
	0x7515, 0x7656, 0x7658, 0x7652, 0x77BD, 0x77BF, 0x77BB, 0x77BC,
	0x790E, 0x79AE, 0x7A61, 0x7A62, 0x7A60, 0x7AC4, 0x7AC5, 0x7C2B,
	0x7C27, 0x7C2A, 0x7C1E, 0x7C23, 0x7C21, 0x7CE7, 0x7E54, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_77 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7E55, 0x7E5E, 0x7E5A, 0x7E61, 0x7E52, 0x7E59, 0x7F48,
	0x7FF9, 0x7FFB, 0x8077, 0x8076, 0x81CD, 0x81CF, 0x820A, 0x85CF,
	0x85A9, 0x85CD, 0x85D0, 0x85C9, 0x85B0, 0x85BA, 0x85B9, 0x87EF,
	0x87EC, 0x87F2, 0x87E0, 0x8986, 0x89B2, 0x89F4, 0x8B28, 0x8B39,
	0x8B2C, 0x8B2B, 0x8C50, 0x8D05, 0x8E59, 0x8E63, 0x8E66, 0x8E64,
	0x8E5F, 0x8E55, 0x8EC0, 0x8F49, 0x8F4D, 0x9087, 0x9083, 0x9088,
	0x91AB, 0x91AC, 0x91D0, 0x9394, 0x938A, 0x9396, 0x93A2, 0x93B3,
	0x93AE, 0x93AC, 0x93B0, 0x9398, 0x939A, 0x9397, 0x95D4, 0x95D6,
	0x95D0, 0x95D5, 0x96E2, 0x96DC, 0x96D9, 0x96DB, 0x96DE, 0x9724,
	0x97A3, 0x97A6, 0x97AD, 0x97F9, 0x984D, 0x984F, 0x984C, 0x984E,
	0x9853, 0x98BA, 0x993E, 0x993F, 0x993D, 0x992E, 0x99A5, 0x9A0E,
	0x9AC1, 0x9B03, 0x9B06, 0x9B4F, 0x9B4E, 0x9B4D, 0x9BCA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_78 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BC9, 0x9BFD, 0x9BC8, 0x9BC0, 0x9D51, 0x9D5D, 0x9D60,
	0x9EE0, 0x9F15, 0x9F2C, 0x5133, 0x56A5, 0x56A8, 0x58DE, 0x58DF,
	0x58E2, 0x5BF5, 0x9F90, 0x5EEC, 0x61F2, 0x61F7, 0x61F6, 0x61F5,
	0x6500, 0x650F, 0x66E0, 0x66DD, 0x6AE5, 0x6ADD, 0x6ADA, 0x6AD3,
	0x701B, 0x701F, 0x7028, 0x701A, 0x701D, 0x7015, 0x7018, 0x7206,
	0x720D, 0x7258, 0x72A2, 0x7378, 0x737A, 0x74BD, 0x74CA, 0x74E3,
	0x7587, 0x7586, 0x765F, 0x7661, 0x77C7, 0x7919, 0x79B1, 0x7A6B,
	0x7A69, 0x7C3E, 0x7C3F, 0x7C38, 0x7C3D, 0x7C37, 0x7C40, 0x7E6B,
	0x7E6D, 0x7E79, 0x7E69, 0x7E6A, 0x7E73, 0x7F85, 0x7FB6, 0x7FB9,
	0x7FB8, 0x81D8, 0x85E9, 0x85DD, 0x85EA, 0x85D5, 0x85E4, 0x85E5,
	0x85F7, 0x87FB, 0x8805, 0x880D, 0x87F9, 0x87FE, 0x8960, 0x895F,
	0x8956, 0x895E, 0x8B41, 0x8B5C, 0x8B58, 0x8B49, 0x8B5A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_79 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8B4E, 0x8B4F, 0x8B46, 0x8B59, 0x8D08, 0x8D0A, 0x8E7C,
	0x8E72, 0x8E87, 0x8E76, 0x8E6C, 0x8E7A, 0x8E74, 0x8F54, 0x8F4E,
	0x8FAD, 0x908A, 0x908B, 0x91B1, 0x91AE, 0x93E1, 0x93D1, 0x93DF,
	0x93C3, 0x93C8, 0x93DC, 0x93DD, 0x93D6, 0x93E2, 0x93CD, 0x93D8,
	0x93E4, 0x93D7, 0x93E8, 0x95DC, 0x96B4, 0x96E3, 0x972A, 0x9727,
	0x9761, 0x97DC, 0x97FB, 0x985E, 0x9858, 0x985B, 0x98BC, 0x9945,
	0x9949, 0x9A16, 0x9A19, 0x9B0D, 0x9BE8, 0x9BE7, 0x9BD6, 0x9BDB,
	0x9D89, 0x9D61, 0x9D72, 0x9D6A, 0x9D6C, 0x9E92, 0x9E97, 0x9E93,
	0x9EB4, 0x52F8, 0x56B7, 0x56B6, 0x56B4, 0x56BC, 0x58E4, 0x5B40,
	0x5B43, 0x5B7D, 0x5BF6, 0x5DC9, 0x61F8, 0x61FA, 0x6518, 0x6514,
	0x6519, 0x66E6, 0x6727, 0x6AEC, 0x703E, 0x7030, 0x7032, 0x7210,
	0x737B, 0x74CF, 0x7662, 0x7665, 0x7926, 0x792A, 0x792C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_7A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x792B, 0x7AC7, 0x7AF6, 0x7C4C, 0x7C43, 0x7C4D, 0x7CEF,
	0x7CF0, 0x8FAE, 0x7E7D, 0x7E7C, 0x7E82, 0x7F4C, 0x8000, 0x81DA,
	0x8266, 0x85FB, 0x85F9, 0x8611, 0x85FA, 0x8606, 0x860B, 0x8607,
	0x860A, 0x8814, 0x8815, 0x8964, 0x89BA, 0x89F8, 0x8B70, 0x8B6C,
	0x8B66, 0x8B6F, 0x8B5F, 0x8B6B, 0x8D0F, 0x8D0D, 0x8E89, 0x8E81,
	0x8E85, 0x8E82, 0x91B4, 0x91CB, 0x9418, 0x9403, 0x93FD, 0x95E1,
	0x9730, 0x98C4, 0x9952, 0x9951, 0x99A8, 0x9A2B, 0x9A30, 0x9A37,
	0x9A35, 0x9C13, 0x9C0D, 0x9E79, 0x9EB5, 0x9EE8, 0x9F2F, 0x9F5F,
	0x9F63, 0x9F61, 0x5137, 0x5138, 0x56C1, 0x56C0, 0x56C2, 0x5914,
	0x5C6C, 0x5DCD, 0x61FC, 0x61FE, 0x651D, 0x651C, 0x6595, 0x66E9,
	0x6AFB, 0x6B04, 0x6AFA, 0x6BB2, 0x704C, 0x721B, 0x72A7, 0x74D6,
	0x74D4, 0x7669, 0x77D3, 0x7C50, 0x7E8F, 0x7E8C, 0x7FBC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_7B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8617, 0x862D, 0x861A, 0x8823, 0x8822, 0x8821, 0x881F,
	0x896A, 0x896C, 0x89BD, 0x8B74, 0x8B77, 0x8B7D, 0x8D13, 0x8E8A,
	0x8E8D, 0x8E8B, 0x8F5F, 0x8FAF, 0x91BA, 0x942E, 0x9433, 0x9435,
	0x943A, 0x9438, 0x9432, 0x942B, 0x95E2, 0x9738, 0x9739, 0x9732,
	0x97FF, 0x9867, 0x9865, 0x9957, 0x9A45, 0x9A43, 0x9A40, 0x9A3E,
	0x9ACF, 0x9B54, 0x9B51, 0x9C2D, 0x9C25, 0x9DAF, 0x9DB4, 0x9DC2,
	0x9DB8, 0x9E9D, 0x9EEF, 0x9F19, 0x9F5C, 0x9F66, 0x9F67, 0x513C,
	0x513B, 0x56C8, 0x56CA, 0x56C9, 0x5B7F, 0x5DD4, 0x5DD2, 0x5F4E,
	0x61FF, 0x6524, 0x6B0A, 0x6B61, 0x7051, 0x7058, 0x7380, 0x74E4,
	0x758A, 0x766E, 0x766C, 0x79B3, 0x7C60, 0x7C5F, 0x807E, 0x807D,
	0x81DF, 0x8972, 0x896F, 0x89FC, 0x8B80, 0x8D16, 0x8D17, 0x8E91,
	0x8E93, 0x8F61, 0x9148, 0x9444, 0x9451, 0x9452, 0x973D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_7C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x973E, 0x97C3, 0x97C1, 0x986B, 0x9955, 0x9A55, 0x9A4D,
	0x9AD2, 0x9B1A, 0x9C49, 0x9C31, 0x9C3E, 0x9C3B, 0x9DD3, 0x9DD7,
	0x9F34, 0x9F6C, 0x9F6A, 0x9F94, 0x56CC, 0x5DD6, 0x6200, 0x6523,
	0x652B, 0x652A, 0x66EC, 0x6B10, 0x74DA, 0x7ACA, 0x7C64, 0x7C63,
	0x7C65, 0x7E93, 0x7E96, 0x7E94, 0x81E2, 0x8638, 0x863F, 0x8831,
	0x8B8A, 0x9090, 0x908F, 0x9463, 0x9460, 0x9464, 0x9768, 0x986F,
	0x995C, 0x9A5A, 0x9A5B, 0x9A57, 0x9AD3, 0x9AD4, 0x9AD1, 0x9C54,
	0x9C57, 0x9C56, 0x9DE5, 0x9E9F, 0x9EF4, 0x56D1, 0x58E9, 0x652C,
	0x705E, 0x7671, 0x7672, 0x77D7, 0x7F50, 0x7F88, 0x8836, 0x8839,
	0x8862, 0x8B93, 0x8B92, 0x8B96, 0x8277, 0x8D1B, 0x91C0, 0x946A,
	0x9742, 0x9748, 0x9744, 0x97C6, 0x9870, 0x9A5F, 0x9B22, 0x9B58,
	0x9C5F, 0x9DF9, 0x9DFA, 0x9E7C, 0x9E7D, 0x9F07, 0x9F77, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_7D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9F72, 0x5EF3, 0x6B16, 0x7063, 0x7C6C, 0x7C6E, 0x883B,
	0x89C0, 0x8EA1, 0x91C1, 0x9472, 0x9470, 0x9871, 0x995E, 0x9AD6,
	0x9B23, 0x9ECC, 0x7064, 0x77DA, 0x8B9A, 0x9477, 0x97C9, 0x9A62,
	0x9A65, 0x7E9C, 0x8B9C, 0x8EAA, 0x91C5, 0x947D, 0x947E, 0x947C,
	0x9C77, 0x9C78, 0x9EF7, 0x8C54, 0x947F, 0x9E1A, 0x7228, 0x9A6A,
	0x9B31, 0x9E1B, 0x9E1E, 0x7C72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_14bit to_ucs = { {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, &to_ucs_21, &to_ucs_22, &to_ucs_23, &to_ucs_24, &to_ucs_25, &to_ucs_26, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, &to_ucs_42, NULL, &to_ucs_44, &to_ucs_45, &to_ucs_46, &to_ucs_47,
	&to_ucs_48, &to_ucs_49, &to_ucs_4A, &to_ucs_4B, &to_ucs_4C, &to_ucs_4D, &to_ucs_4E, &to_ucs_4F,
	&to_ucs_50, &to_ucs_51, &to_ucs_52, &to_ucs_53, &to_ucs_54, &to_ucs_55, &to_ucs_56, &to_ucs_57,
	&to_ucs_58, &to_ucs_59, &to_ucs_5A, &to_ucs_5B, &to_ucs_5C, &to_ucs_5D, &to_ucs_5E, &to_ucs_5F,
	&to_ucs_60, &to_ucs_61, &to_ucs_62, &to_ucs_63, &to_ucs_64, &to_ucs_65, &to_ucs_66, &to_ucs_67,
	&to_ucs_68, &to_ucs_69, &to_ucs_6A, &to_ucs_6B, &to_ucs_6C, &to_ucs_6D, &to_ucs_6E, &to_ucs_6F,
	&to_ucs_70, &to_ucs_71, &to_ucs_72, &to_ucs_73, &to_ucs_74, &to_ucs_75, &to_ucs_76, &to_ucs_77,
	&to_ucs_78, &to_ucs_79, &to_ucs_7A, &to_ucs_7B, &to_ucs_7C, &to_ucs_7D, NULL, NULL
} };

static const iconv_ccs_convtable_8bit from_ucs_00 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2170,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2278, 0x2234, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2131,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2232,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2233,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_02 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x256F,
	0xFFFE, 0x256D, 0x256E, 0x2570, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x256C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_03 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 0x247B,
	0x247C, 0x247D, 0x247E, 0x2521, 0x2522, 0x2523, 0x2524, 0x2525,
	0x2526, 0x2527, 0xFFFE, 0x2528, 0x2529, 0x252A, 0x252B, 0x252C,
	0x252D, 0x252E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x252F, 0x2530, 0x2531, 0x2532, 0x2533, 0x2534, 0x2535,
	0x2536, 0x2537, 0x2538, 0x2539, 0x253A, 0x253B, 0x253C, 0x253D,
	0x253E, 0x253F, 0xFFFE, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544,
	0x2545, 0x2546, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_20 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2139, 0x2137, 0xFFFE, 0x225D, 0xFFFE,
	0x2164, 0x2165, 0xFFFE, 0xFFFE, 0x2166, 0x2167, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x212D, 0x212C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x216A, 0xFFFE, 0xFFFE, 0x216B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x216F, 0xFFFE, 0xFFFE, 0x2223, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_21 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x226A, 0xFFFE, 0x2222, 0xFFFE, 0xFFFE,
	0xFFFE, 0x226B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x242B, 0x242C, 0x242D, 0x242E, 0x242F, 0x2430, 0x2431, 0x2432,
	0x2433, 0x2434, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2635, 0x2636, 0x2637, 0x2638, 0x2639, 0x263A, 0x263B, 0x263C,
	0x263D, 0x263E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2258, 0x2255, 0x2257, 0x2256, 0xFFFE, 0xFFFE, 0x2259, 0x225A,
	0x225C, 0x225B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_22 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2261, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2235, 0xFFFE, 0xFFFE, 0xFFFE, 0x223C, 0x2249,
	0x2248, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2245, 0x2246, 0x224D, 0xFFFE, 0xFFFE, 0x224E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2250, 0x224F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2244, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x223D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x223B, 0x223E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2239, 0x223A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2247, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x224A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_24 = { {
	0x4221, 0x4222, 0x4223, 0x4224, 0x4225, 0x4226, 0x4227, 0x4228,
	0x4229, 0x422A, 0x422B, 0x422C, 0x422D, 0x422E, 0x422F, 0x4230,
	0x4231, 0x4232, 0x4233, 0x4234, 0x4235, 0x4236, 0x4237, 0x4238,
	0x4239, 0x423A, 0x423B, 0x423C, 0x423D, 0x423E, 0x423F, 0x4240,
	0xFFFE, 0x4241, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2621, 0x2622, 0x2623, 0x2624, 0x2625, 0x2626, 0x2627, 0x2628,
	0x2629, 0x262A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x262B, 0x262C, 0x262D, 0x262E,
	0x262F, 0x2630, 0x2631, 0x2632, 0x2633, 0x2634, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_25 = { {
	0x2339, 0xFFFE, 0x233A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x233C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x233D, 0xFFFE, 0xFFFE, 0xFFFE, 0x233E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x233F, 0xFFFE, 0xFFFE, 0xFFFE, 0x2337, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2336, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2335, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2334, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2333, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2344, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2345, 0xFFFE,
	0xFFFE, 0x2347, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2346, 0xFFFE, 0xFFFE, 0x2340, 0x2341, 0x2343,
	0x2342, 0x234C, 0x234D, 0x234E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2324, 0x2325, 0x2326, 0x2327, 0x2328, 0x2329, 0x232A,
	0x232B, 0x2332, 0x2331, 0x2330, 0x232F, 0x232E, 0x232D, 0x232C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2338, 0x233B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x217C, 0x217B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2175, 0x2174, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x217E, 0x217D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x217A, 0x2179,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2172, 0xFFFE, 0xFFFE, 0x2176, 0x2173,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2348, 0x2349, 0x234B, 0x234A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_26 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2178, 0x2177, 0xFFFE,
	0xFFFE, 0x2254, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2251, 0x2253, 0x2252, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_30 = { {
	0x2121, 0x2123, 0x2124, 0x2171, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2152, 0x2153, 0x214E, 0x214F, 0x2156, 0x2157, 0x215A, 0x215B,
	0x214A, 0x214B, 0x2265, 0xFFFE, 0x2146, 0x2147, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2168, 0x2169, 0xFFFE,
	0xFFFE, 0x2435, 0x2436, 0x2437, 0x2438, 0x2439, 0x243A, 0x243B,
	0x243C, 0x243D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2126, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_31 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2547, 0x2548, 0x2549,
	0x254A, 0x254B, 0x254C, 0x254D, 0x254E, 0x254F, 0x2550, 0x2551,
	0x2552, 0x2553, 0x2554, 0x2555, 0x2556, 0x2557, 0x2558, 0x2559,
	0x255A, 0x255B, 0x255C, 0x255D, 0x255E, 0x255F, 0x2560, 0x2561,
	0x2562, 0x2563, 0x2564, 0x2565, 0x2566, 0x2567, 0x2568, 0x2569,
	0x256A, 0x256B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_32 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_33 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2275, 0x2276,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2270, 0x2271, 0x2272, 0xFFFE,
	0xFFFE, 0x2274, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2277, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2273, 0xFFFE,
	0xFFFE, 0x224C, 0x224B, 0xFFFE, 0xFFFE, 0x226F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_4E = { {
	0x4421, 0x4423, 0xFFFE, 0x4424, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4437, 0x4435, 0x4438, 0x4436, 0xFFFE, 0x4462, 0xFFFE, 0xFFFE,
	0x4461, 0x4460, 0xFFFE, 0xFFFE, 0x4562, 0x4561, 0x4560, 0xFFFE,
	0x4563, 0x455F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4722, 0x4723,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B64, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4439, 0xFFFE, 0x4463, 0xFFFE, 0xFFFE,
	0x4464, 0xFFFE, 0x486B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x443A, 0x4465, 0xFFFE, 0x4564, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4425, 0xFFFE, 0x443C, 0xFFFE, 0xFFFE,
	0x443D, 0xFFFE, 0xFFFE, 0x4466, 0xFFFE, 0x4565, 0x4567, 0x4566,
	0xFFFE, 0xFFFE, 0x4724, 0x4725, 0xFFFE, 0xFFFE, 0x4B65, 0xFFFE,
	0x537D, 0x4422, 0xFFFE, 0xFFFE, 0xFFFE, 0x4426, 0x443F, 0x443E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4726, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5871, 0xFFFE,
	0xFFFE, 0xFFFE, 0x632A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4427, 0xFFFE,
	0x4468, 0xFFFE, 0xFFFE, 0x4B67, 0x4428, 0xFFFE, 0x4440, 0xFFFE,
	0xFFFE, 0x4469, 0x446B, 0xFFFE, 0x446C, 0x446A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4727, 0xFFFE, 0x4B68, 0xFFFE, 0xFFFE, 0x4B69, 0x4F67,
	0xFFFE, 0x4441, 0x446D, 0xFFFE, 0x4728, 0x472A, 0x4729, 0xFFFE,
	0x486C, 0xFFFE, 0xFFFE, 0x4B6A, 0x4B6B, 0x4F68, 0x4F69, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x537E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4429, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x446F, 0x446E, 0xFFFE, 0x4470, 0x4476, 0xFFFE, 0x4471, 0x4472,
	0xFFFE, 0xFFFE, 0x4474, 0x4475, 0xFFFE, 0x4473, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x456A, 0x456B, 0x456C, 0x456D,
	0x4569, 0x4570, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4571, 0x4623,
	0xFFFE, 0xFFFE, 0xFFFE, 0x456E, 0x456F, 0x4568, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4737, 0xFFFE, 0x4734, 0x4738, 0xFFFE, 0xFFFE, 0x4735, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4736, 0xFFFE, 0x4739, 0xFFFE, 0x472B
} };

static const iconv_ccs_convtable_8bit from_ucs_4F = { {
	0xFFFE, 0x473A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x472C, 0x472E, 0x473B, 0xFFFE, 0x4730, 0xFFFE, 0x4733,
	0x4731, 0x4732, 0xFFFE, 0xFFFE, 0xFFFE, 0x472F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x472D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4924,
	0x4875, 0xFFFE, 0xFFFE, 0xFFFE, 0x4872, 0xFFFE, 0x4926, 0xFFFE,
	0x487A, 0xFFFE, 0x4879, 0xFFFE, 0x487D, 0x4878, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x487B, 0xFFFE, 0xFFFE, 0x487E, 0x486F,
	0x4929, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x486D, 0x4925, 0x486E,
	0x4876, 0x4877, 0xFFFE, 0xFFFE, 0x487C, 0x4874, 0xFFFE, 0x4870,
	0xFFFE, 0x4927, 0x492A, 0x4873, 0x4922, 0x4928, 0x4871, 0xFFFE,
	0x4923, 0xFFFE, 0xFFFE, 0x4921, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4B79, 0xFFFE, 0xFFFE, 0x4B71, 0xFFFE, 0xFFFE, 0x4B6C,
	0x4B76, 0xFFFE, 0xFFFE, 0x4B6F, 0xFFFE, 0x4B77, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C21, 0x4B7A, 0xFFFE, 0xFFFE, 0x4B7C, 0x4B70,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B75, 0xFFFE, 0xFFFE, 0x4B74, 0xFFFE,
	0x4B78, 0xFFFE, 0xFFFE, 0x4B73, 0xFFFE, 0x4B6E, 0xFFFE, 0x4B7D,
	0xFFFE, 0x4B7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B7B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B72, 0xFFFE, 0x4B6D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F78, 0x4F6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F6B, 0x4F73, 0x5021,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F6D,
	0xFFFE, 0xFFFE, 0x4F7B, 0x4F72, 0x4F7A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F76, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F7D, 0x4F70,
	0x4F79, 0x4F6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F77,
	0x4F74, 0xFFFE, 0x4F7C, 0xFFFE, 0xFFFE, 0x4F71, 0x4F7E, 0x4F75,
	0x4F6E, 0x4F6A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x543A, 0x5424,
	0xFFFE, 0x5434, 0xFFFE, 0x5439, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5427, 0xFFFE, 0x5430, 0xFFFE, 0xFFFE, 0xFFFE, 0x543D, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_50 = { {
	0x5431, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x542A, 0xFFFE,
	0xFFFE, 0x543F, 0xFFFE, 0x5436, 0x5421, 0x5422, 0xFFFE, 0x5924,
	0xFFFE, 0x542F, 0x542E, 0xFFFE, 0x5432, 0xFFFE, 0x5429, 0xFFFE,
	0x5438, 0x5437, 0x542D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x542C,
	0xFFFE, 0x5435, 0xFFFE, 0x5423, 0xFFFE, 0x5426, 0x5425, 0xFFFE,
	0x5433, 0x5428, 0x543C, 0x543E, 0xFFFE, 0x543B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x542B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5876, 0xFFFE, 0xFFFE, 0xFFFE, 0x5875,
	0xFFFE, 0x5879, 0xFFFE, 0xFFFE, 0x5877, 0xFFFE, 0x587C, 0x5923,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x587D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5878, 0xFFFE, 0x5874, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x587A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5926, 0xFFFE, 0x5925,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5921, 0x587E, 0x587B, 0x5922,
	0xFFFE, 0xFFFE, 0x5872, 0xFFFE, 0xFFFE, 0x5873, 0xFFFE, 0xFFFE,
	0x5E2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E2B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E2A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E2F, 0xFFFE,
	0x5E30, 0x5E2C, 0x5E31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E29, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6331, 0x632B, 0xFFFE, 0x6334,
	0xFFFE, 0xFFFE, 0x632D, 0x632E, 0xFFFE, 0x632C, 0xFFFE, 0x6332,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6333, 0xFFFE, 0xFFFE, 0x6330, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x632F, 0xFFFE, 0x6335,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x677C, 0x6779,
	0xFFFE, 0x677A, 0xFFFE, 0xFFFE, 0xFFFE, 0x6778, 0x6775, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6777, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6774, 0xFFFE, 0x6772,
	0xFFFE, 0x677D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6776, 0x6773, 0xFFFE,
	0xFFFE, 0x677B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C23, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C24, 0xFFFE, 0x6C22, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_51 = { {
	0x6C21, 0xFFFE, 0x6C25, 0xFFFE, 0x6B7E, 0x6C28, 0xFFFE, 0xFFFE,
	0x6C26, 0x6C27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7033, 0xFFFE, 0x7030, 0xFFFE, 0x7032, 0x7034, 0xFFFE, 0xFFFE,
	0x7031, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7341,
	0xFFFE, 0x7342, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7340, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7343, 0x782B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A62,
	0x7A63, 0xFFFE, 0xFFFE, 0x7B58, 0x7B57, 0xFFFE, 0xFFFE, 0x442A,
	0x4442, 0x4478, 0xFFFE, 0x4477, 0x4573, 0x4572, 0x473E, 0x473D,
	0x473F, 0x473C, 0xFFFE, 0x492C, 0x492B, 0x492D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C23, 0xFFFE, 0x4C22, 0x4C24, 0xFFFE, 0x5022,
	0xFFFE, 0x2279, 0xFFFE, 0x227A, 0x5927, 0x227C, 0x227B, 0xFFFE,
	0xFFFE, 0x227D, 0x677E, 0x227E, 0xFFFE, 0x442B, 0xFFFE, 0x4479,
	0x4740, 0x4C25, 0xFFFE, 0x442C, 0x447C, 0x447A, 0x447B, 0xFFFE,
	0xFFFE, 0x4741, 0xFFFE, 0xFFFE, 0xFFFE, 0x492E, 0x4C27, 0x4C26,
	0x4C28, 0xFFFE, 0xFFFE, 0xFFFE, 0x5440, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7035, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4574, 0x4575, 0xFFFE, 0xFFFE, 0x4742, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5024, 0x5023, 0xFFFE, 0xFFFE, 0x5928, 0xFFFE, 0x447D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5025, 0xFFFE, 0x5443, 0xFFFE, 0x5441, 0x5442, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7036, 0xFFFE, 0x4576, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x492F, 0x4930,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C29, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5446, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5447, 0x5445, 0x5444, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C29, 0x7037, 0xFFFE, 0xFFFE,
	0x442D, 0x443B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5929, 0x5E33, 0xFFFE, 0x6821, 0xFFFE, 0xFFFE, 0x447E, 0xFFFE,
	0x4579, 0x4577, 0x4578, 0xFFFE, 0xFFFE, 0x4C2A, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_52 = { {
	0x442E, 0x442F, 0xFFFE, 0x4443, 0xFFFE, 0xFFFE, 0x4521, 0x4522,
	0x4523, 0xFFFE, 0x457A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4747, 0xFFFE,
	0xFFFE, 0x4745, 0x4746, 0xFFFE, 0xFFFE, 0xFFFE, 0x4748, 0x4744,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F4F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4932, 0x4931, 0xFFFE, 0xFFFE,
	0x4935, 0x4933, 0x4934, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C30, 0xFFFE,
	0x4C2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C31, 0x4C2D,
	0x4C2C, 0xFFFE, 0x4C2E, 0x4C2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C32, 0xFFFE, 0x5027, 0xFFFE, 0xFFFE, 0xFFFE, 0x502C,
	0xFFFE, 0xFFFE, 0x5028, 0x502B, 0x502A, 0x5029, 0x5026, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x544A, 0xFFFE, 0x5448, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x544B, 0x5449, 0x544C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E37, 0x592A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x592B,
	0xFFFE, 0xFFFE, 0x5E34, 0xFFFE, 0x5E35, 0x5E36, 0xFFFE, 0x6337,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6338, 0xFFFE, 0x6336,
	0xFFFE, 0xFFFE, 0x6823, 0x6822, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C2A,
	0x6C2B, 0x6C2C, 0x6C2E, 0xFFFE, 0xFFFE, 0x6C2D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7038, 0xFFFE, 0x7039, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4430, 0xFFFE, 0xFFFE, 0xFFFE, 0x457C,
	0x457B, 0xFFFE, 0xFFFE, 0x4749, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4937, 0x4938, 0x4936, 0x4939, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C34, 0xFFFE, 0xFFFE, 0x4C33, 0xFFFE,
	0xFFFE, 0x5030, 0xFFFE, 0x502F, 0xFFFE, 0xFFFE, 0xFFFE, 0x502D,
	0xFFFE, 0x502E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x592C, 0xFFFE, 0xFFFE, 0x592F, 0xFFFE, 0x5B2B,
	0x592E, 0x592D, 0xFFFE, 0x5E3A, 0xFFFE, 0x5E39, 0x5E38, 0x6339,
	0xFFFE, 0xFFFE, 0x633C, 0x633D, 0x633B, 0xFFFE, 0x633A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C2F, 0xFFFE, 0xFFFE, 0x703A, 0xFFFE, 0x7344, 0xFFFE, 0xFFFE,
	0x7961, 0xFFFE, 0x4444, 0x4524, 0xFFFE, 0xFFFE, 0x4525, 0x4526
} };

static const iconv_ccs_convtable_8bit from_ucs_53 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x457D, 0x457E, 0xFFFE,
	0x474A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5031, 0xFFFE, 0x5931,
	0x5930, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4431, 0x4527, 0x4621,
	0xFFFE, 0x5932, 0xFFFE, 0xFFFE, 0xFFFE, 0x4622, 0xFFFE, 0xFFFE,
	0x474C, 0x474B, 0xFFFE, 0x493A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x544D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x633E,
	0xFFFE, 0x6824, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4528, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5935, 0x5933,
	0x5934, 0x4432, 0xFFFE, 0x4445, 0x243F, 0x452B, 0xFFFE, 0x452A,
	0x4529, 0x4625, 0x4624, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C38, 0x4C35, 0x4C37, 0x4C36, 0xFFFE, 0xFFFE, 0x5032,
	0xFFFE, 0xFFFE, 0x5E3B, 0xFFFE, 0x4433, 0xFFFE, 0x452C, 0xFFFE,
	0x4627, 0x4626, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C39, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4629, 0x4628,
	0x474D, 0x474E, 0xFFFE, 0x493B, 0xFFFE, 0x493C, 0xFFFE, 0x4C3A,
	0x4C3B, 0x4C3C, 0xFFFE, 0x5033, 0xFFFE, 0xFFFE, 0xFFFE, 0x544E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x452D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5034, 0xFFFE, 0xFFFE, 0x5450, 0xFFFE, 0x544F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E3C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6825, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x462A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5936, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4434, 0x4446, 0x452F, 0x452E, 0xFFFE, 0x4530, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C3E, 0xFFFE, 0x4C3D, 0x4C3F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5035, 0xFFFE, 0xFFFE, 0xFFFE, 0x5451,
	0xFFFE, 0xFFFE, 0x763B, 0x4447, 0x462C, 0x463B, 0x4636, 0xFFFE,
	0x4631, 0x4630, 0x4637, 0x4635, 0x462E, 0x463C, 0x462F, 0x462B,
	0x463A, 0x4639, 0x4638, 0x462D, 0xFFFE, 0x4634, 0xFFFE, 0xFFFE,
	0x4633, 0xFFFE, 0xFFFE, 0x463D, 0x4632, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_54 = { {
	0xFFFE, 0x4754, 0xFFFE, 0x475A, 0x4756, 0xFFFE, 0x475C, 0xFFFE,
	0x4759, 0x474F, 0x4752, 0x4755, 0x4751, 0x4758, 0x475B, 0x4750,
	0x4753, 0x4757, 0x475D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4949, 0xFFFE, 0x493D, 0x493F, 0x4957,
	0x4952, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4941, 0x4943,
	0xFFFE, 0x494A, 0xFFFE, 0x4956, 0x4958, 0x493E, 0x494F, 0xFFFE,
	0xFFFE, 0x4955, 0xFFFE, 0x4946, 0xFFFE, 0x4950, 0x4951, 0xFFFE,
	0x494E, 0x494C, 0xFFFE, 0x494D, 0x4953, 0xFFFE, 0x4940, 0xFFFE,
	0x4954, 0xFFFE, 0x4948, 0x4945, 0xFFFE, 0xFFFE, 0x4944, 0xFFFE,
	0x4947, 0xFFFE, 0x494B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4942, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C4D, 0xFFFE, 0x4C40, 0xFFFE, 0x4C41, 0x4C4E, 0x4C47,
	0x4C43, 0xFFFE, 0xFFFE, 0x4C46, 0x4C4B, 0x4C54, 0xFFFE, 0xFFFE,
	0x4C45, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C48, 0xFFFE, 0x4C4A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C53, 0x4C4F, 0xFFFE, 0x4C55, 0xFFFE,
	0x4C4C, 0xFFFE, 0x4C49, 0xFFFE, 0xFFFE, 0x4C44, 0x4C42, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x503C, 0x504A,
	0x5038, 0x5049, 0x5041, 0x5046, 0x5036, 0xFFFE, 0xFFFE, 0x5045,
	0xFFFE, 0x5047, 0xFFFE, 0x503D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x503B, 0xFFFE, 0xFFFE, 0x5048, 0xFFFE, 0x5040, 0xFFFE, 0x504B,
	0x5037, 0x5042, 0x503F, 0xFFFE, 0x5043, 0xFFFE, 0xFFFE, 0x503E,
	0x5044, 0x503A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5039, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x545E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5457, 0x5462, 0xFFFE,
	0x5452, 0x545C, 0x5461, 0xFFFE, 0xFFFE, 0x545D, 0x5460, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5458, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x545A, 0xFFFE, 0x5456, 0x5465, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_55 = { {
	0xFFFE, 0x5454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5459, 0x5464,
	0xFFFE, 0x545F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5466,
	0x5453, 0xFFFE, 0xFFFE, 0xFFFE, 0x545B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5463,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5949, 0xFFFE, 0x5947, 0x5944,
	0xFFFE, 0x5940, 0xFFFE, 0x594B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5455,
	0x5946, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E4E, 0xFFFE,
	0xFFFE, 0x594C, 0xFFFE, 0x593E, 0x593B, 0xFFFE, 0x5938, 0xFFFE,
	0xFFFE, 0xFFFE, 0x593F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5942,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5943, 0x5941, 0x594D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5948, 0xFFFE, 0x593C, 0x5A76,
	0xFFFE, 0x593D, 0xFFFE, 0x594A, 0x5945, 0xFFFE, 0x593A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5939, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5E3D, 0x5E40, 0xFFFE, 0x5E54, 0xFFFE,
	0x5E3E, 0xFFFE, 0x5E44, 0x5E4A, 0x6143, 0xFFFE, 0xFFFE, 0x5E48,
	0xFFFE, 0x5E55, 0x5E41, 0x5E49, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E47, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E43, 0x5E57, 0x5E50, 0xFFFE, 0x5E45, 0x5E42, 0xFFFE, 0x5E4D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E3F,
	0xFFFE, 0xFFFE, 0x5E46, 0x5E56, 0x5E52, 0xFFFE, 0x5E4C, 0xFFFE,
	0xFFFE, 0x5E53, 0x5E4F, 0x5E4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5E51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x634C, 0x634D, 0x6345,
	0xFFFE, 0x634F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6343, 0xFFFE,
	0xFFFE, 0x6346, 0xFFFE, 0x6341, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x634A, 0xFFFE, 0x6344, 0xFFFE, 0xFFFE, 0x633F,
	0xFFFE, 0x634B, 0xFFFE, 0x6347, 0x6348, 0x634E, 0x6342, 0x2321,
	0x6340, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6349,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6835, 0x6830,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x682A, 0x6826, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_56 = { {
	0x6827, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x682C, 0xFFFE,
	0x6833, 0x682D, 0xFFFE, 0xFFFE, 0xFFFE, 0x682E, 0x682F, 0xFFFE,
	0x6834, 0xFFFE, 0xFFFE, 0xFFFE, 0x682B, 0xFFFE, 0x6831, 0x6829,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6828, 0xFFFE, 0xFFFE, 0xFFFE, 0x6832,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C31, 0x6C3D,
	0x6C3E, 0xFFFE, 0x6C34, 0xFFFE, 0x6C36, 0xFFFE, 0x6C3C, 0xFFFE,
	0xFFFE, 0x6C33, 0xFFFE, 0x6C32, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C35,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C39, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6C38, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C3A,
	0xFFFE, 0x703B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7047, 0xFFFE, 0x703F, 0x7043, 0xFFFE, 0xFFFE,
	0x7042, 0x703E, 0x7041, 0x703C, 0x7046, 0xFFFE, 0xFFFE, 0x7045,
	0xFFFE, 0x7044, 0xFFFE, 0xFFFE, 0x6C3B, 0xFFFE, 0x7048, 0xFFFE,
	0x7040, 0x703D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7346, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7348, 0xFFFE, 0x7349,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7345, 0x734A,
	0x7347, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x763C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x782C, 0xFFFE, 0xFFFE,
	0x782D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x763D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7964, 0xFFFE, 0x7963, 0x7962,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7965, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A65, 0x7A64, 0x7A66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B59, 0x7B5B, 0x7B5A, 0xFFFE, 0x7C34, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x463F, 0x463E, 0xFFFE, 0x4760, 0x475F, 0xFFFE,
	0x475E, 0xFFFE, 0xFFFE, 0xFFFE, 0x495B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4959, 0x495C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x495A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x504C
} };

static const iconv_ccs_convtable_8bit from_ucs_57 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x5467, 0x5468, 0xFFFE, 0xFFFE, 0xFFFE,
	0x594E, 0x5950, 0xFFFE, 0x594F, 0xFFFE, 0x5E58, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6350, 0x6351, 0xFFFE, 0xFFFE, 0x6837, 0xFFFE,
	0x6836, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4448,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4763, 0x4767, 0xFFFE, 0xFFFE, 0x4765, 0x4764, 0xFFFE, 0x4766,
	0x4762, 0xFFFE, 0xFFFE, 0x4761, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4966, 0xFFFE, 0xFFFE, 0x4963, 0xFFFE,
	0x495F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4961,
	0xFFFE, 0xFFFE, 0x495D, 0xFFFE, 0xFFFE, 0x4960, 0x4962, 0x4965,
	0x4964, 0x495E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C5B, 0xFFFE, 0xFFFE, 0x4C5D, 0xFFFE, 0x4C5C, 0xFFFE,
	0xFFFE, 0x4C5A, 0x4C59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C58,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C5E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x504D, 0x4C57, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x504E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5054, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x504F, 0xFFFE, 0x5051, 0x5050, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5053, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5469, 0x546C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x546B, 0xFFFE, 0xFFFE, 0x5052, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x546A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5951,
	0x5955, 0xFFFE, 0xFFFE, 0xFFFE, 0x5956, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x595A,
	0xFFFE, 0x595B, 0x5957, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_58 = { {
	0xFFFE, 0xFFFE, 0x5958, 0xFFFE, 0xFFFE, 0x5952, 0x5954, 0xFFFE,
	0xFFFE, 0x546D, 0x5953, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E60, 0xFFFE, 0xFFFE,
	0x5E61, 0x5E5F, 0xFFFE, 0xFFFE, 0x5E5C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E59,
	0x5E5D, 0x5E5E, 0xFFFE, 0xFFFE, 0x5E5B, 0x5959, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x635B, 0x635E, 0x6359, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6353, 0x635D, 0xFFFE, 0x6357, 0xFFFE, 0xFFFE, 0x6355,
	0x6354, 0xFFFE, 0x6356, 0xFFFE, 0xFFFE, 0xFFFE, 0x6352, 0xFFFE,
	0xFFFE, 0xFFFE, 0x635C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6358, 0xFFFE, 0x635A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6838, 0xFFFE, 0xFFFE,
	0xFFFE, 0x683D, 0xFFFE, 0xFFFE, 0xFFFE, 0x683F, 0x6839, 0xFFFE,
	0x6C3F, 0xFFFE, 0xFFFE, 0x683A, 0xFFFE, 0x683E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x683C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x683B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C43, 0xFFFE, 0x6C41, 0x6C40,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C46, 0xFFFE,
	0x702E, 0x6C45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C44, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6C42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x704A, 0xFFFE,
	0xFFFE, 0x7049, 0xFFFE, 0xFFFE, 0xFFFE, 0x704C, 0xFFFE, 0x704B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x734E, 0xFFFE,
	0xFFFE, 0x734D, 0xFFFE, 0x734C, 0xFFFE, 0x734B, 0xFFFE, 0xFFFE,
	0x763F, 0x763E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x782E, 0x782F,
	0xFFFE, 0xFFFE, 0x7830, 0xFFFE, 0x7966, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C5E, 0xFFFE, 0x4449, 0x4531, 0xFFFE, 0xFFFE, 0x4967,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E62, 0x5E63, 0xFFFE, 0xFFFE, 0x6840, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_59 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x546E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A67, 0x444A, 0x4640, 0xFFFE,
	0xFFFE, 0x4768, 0x4769, 0xFFFE, 0x4C5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x595C, 0xFFFE, 0x6842, 0xFFFE, 0x6843, 0x6841, 0xFFFE, 0x444B,
	0xFFFE, 0x4532, 0x4534, 0x4533, 0xFFFE, 0x4535, 0x4641, 0xFFFE,
	0xFFFE, 0x4642, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x476A,
	0x476B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4968, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C63, 0xFFFE, 0xFFFE, 0x4C61,
	0x4C62, 0x4C60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5058, 0x5057,
	0x5059, 0x5056, 0xFFFE, 0xFFFE, 0x4C64, 0x5055, 0xFFFE, 0x546F,
	0x5470, 0xFFFE, 0x5471, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E64, 0xFFFE, 0x595D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x635F,
	0xFFFE, 0x6845, 0x6844, 0xFFFE, 0xFFFE, 0x6C47, 0x704D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x444C, 0x4643, 0xFFFE, 0x4644, 0xFFFE,
	0x476D, 0x4770, 0xFFFE, 0xFFFE, 0xFFFE, 0x476F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4772, 0x4771, 0x476E, 0x476C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4973, 0xFFFE, 0xFFFE, 0x4970, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x496A, 0x4972, 0xFFFE, 0xFFFE, 0x496F, 0xFFFE,
	0xFFFE, 0x496E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4969, 0x496C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x496D, 0x4971, 0x4974, 0xFFFE, 0xFFFE,
	0x496B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C69, 0x4C71,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C68, 0xFFFE, 0x4C66, 0xFFFE, 0xFFFE, 0x4C65, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C74, 0x4C6B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C70, 0x4C6E, 0xFFFE, 0x4C6D, 0xFFFE, 0xFFFE,
	0x4C6C, 0x4C6A, 0x4C73, 0x4C6F, 0x4C67, 0xFFFE, 0xFFFE, 0xFFFE,
	0x505B, 0xFFFE, 0x5062, 0xFFFE, 0x505A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x505D, 0xFFFE, 0x5060, 0x5063, 0xFFFE,
	0x505E, 0xFFFE, 0x5061, 0xFFFE, 0x5478, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5065, 0xFFFE, 0xFFFE, 0xFFFE, 0x505C
} };

static const iconv_ccs_convtable_8bit from_ucs_5A = { {
	0xFFFE, 0x5064, 0xFFFE, 0x505F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x547E, 0xFFFE, 0xFFFE, 0x547D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5472, 0xFFFE, 0x5477, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5473, 0xFFFE, 0xFFFE, 0x5476, 0x5474, 0xFFFE, 0xFFFE, 0x5475,
	0x5479, 0xFFFE, 0xFFFE, 0x547A, 0xFFFE, 0x547C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x547B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x595E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5964, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5963, 0x595F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5967, 0xFFFE,
	0xFFFE, 0x5960, 0x5968, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5966, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5965, 0xFFFE, 0xFFFE, 0xFFFE, 0x5961, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5962, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E65,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E67,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E66, 0x5E69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E6A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6368, 0x6366, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6365, 0x6364, 0x6363, 0xFFFE,
	0xFFFE, 0x6360, 0x6367, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6361, 0xFFFE, 0xFFFE, 0x6362, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x684A, 0x6849,
	0x684B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6846, 0xFFFE, 0x684C, 0xFFFE, 0xFFFE, 0x6847, 0xFFFE,
	0xFFFE, 0x6848, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C4B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6C49, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C4D, 0x6C48, 0xFFFE, 0x6C4A, 0x6C4C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x704E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7351, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7350, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x734F, 0xFFFE, 0xFFFE, 0xFFFE, 0x704F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7640, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7967, 0xFFFE, 0xFFFE, 0x7968, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x444D, 0x444E, 0xFFFE, 0x444F, 0x4536, 0x4645, 0xFFFE, 0x4773,
	0x4774, 0xFFFE, 0x4977, 0x4978, 0x4976, 0x4975, 0xFFFE, 0x4C75,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C77, 0x4C76, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5066, 0xFFFE, 0x5521, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5969, 0x5E6C, 0xFFFE, 0x5E6B, 0xFFFE, 0x684D, 0xFFFE, 0xFFFE,
	0x7050, 0xFFFE, 0x7352, 0xFFFE, 0xFFFE, 0x7969, 0xFFFE, 0x7B5C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4646, 0xFFFE, 0x4777, 0xFFFE, 0x4775,
	0x4776, 0x4778, 0xFFFE, 0x497A, 0x4979, 0xFFFE, 0xFFFE, 0x497B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C78,
	0x4C7A, 0x4C7C, 0x4C79, 0x4C7D, 0x4C7B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x506A, 0x5067, 0x5069, 0x506B, 0x5068, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5527, 0xFFFE,
	0x5523, 0xFFFE, 0xFFFE, 0x5524, 0x5526, 0x5528, 0x5525, 0xFFFE,
	0x552A, 0x5529, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x596E,
	0xFFFE, 0xFFFE, 0x596D, 0xFFFE, 0x596C, 0x596B, 0x596F, 0x596A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E6E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E70, 0xFFFE, 0x5E6D, 0x5E6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x684E, 0x6856,
	0xFFFE, 0x6850, 0x6854, 0xFFFE, 0x6855, 0x6851, 0x6852, 0x684F,
	0x6853, 0x6C50, 0xFFFE, 0x6C51, 0x6C4F, 0xFFFE, 0x6C4E, 0xFFFE,
	0x7051, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7831, 0x796A, 0xFFFE,
	0x4450, 0xFFFE, 0x4779, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5C = { {
	0xFFFE, 0x506C, 0xFFFE, 0xFFFE, 0x552B, 0xFFFE, 0xFFFE, 0x5972,
	0x5971, 0x5970, 0x5E71, 0x5E72, 0xFFFE, 0x6857, 0x7052, 0x4451,
	0xFFFE, 0x4537, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x477A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4452, 0xFFFE, 0x4538, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x497C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7353,
	0x4453, 0x4467, 0x4539, 0xFFFE, 0x4647, 0xFFFE, 0x4A22, 0x4A21,
	0x497D, 0x497E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D22, 0x4D23, 0xFFFE,
	0x4D21, 0xFFFE, 0xFFFE, 0x5070, 0xFFFE, 0x506F, 0x506D, 0x506E,
	0x552E, 0x552C, 0xFFFE, 0xFFFE, 0xFFFE, 0x552D, 0xFFFE, 0xFFFE,
	0x5522, 0xFFFE, 0xFFFE, 0xFFFE, 0x5974, 0x5975, 0xFFFE, 0xFFFE,
	0x5973, 0xFFFE, 0x6858, 0xFFFE, 0x6C52, 0x6C53, 0xFFFE, 0xFFFE,
	0x7354, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A68, 0xFFFE, 0xFFFE, 0x453A,
	0xFFFE, 0x4454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x477B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A26, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A23, 0x4A24, 0xFFFE, 0xFFFE, 0x4A25, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D27, 0xFFFE, 0x4D28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D29, 0xFFFE, 0x4D2A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D24,
	0x4D26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5072, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5071, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5533, 0xFFFE, 0x5532, 0xFFFE, 0xFFFE, 0x552F, 0xFFFE, 0xFFFE,
	0x5534, 0xFFFE, 0xFFFE, 0xFFFE, 0x5537, 0xFFFE, 0x5535, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5531, 0xFFFE, 0x5530, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5D = { {
	0xFFFE, 0x5536, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5977, 0x5976,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5978, 0xFFFE,
	0xFFFE, 0x597C, 0xFFFE, 0xFFFE, 0x597E, 0xFFFE, 0x597A, 0x5A24,
	0xFFFE, 0x5A21, 0xFFFE, 0x5979, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x597B, 0xFFFE, 0x5A22, 0xFFFE, 0xFFFE, 0x5A23,
	0xFFFE, 0x597D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E76, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E77,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E74, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6369, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x636A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6859, 0xFFFE, 0xFFFE, 0x685A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C55, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C54, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7358, 0xFFFE, 0x7356, 0xFFFE, 0x7355, 0x7357, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x796B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A69, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B5E, 0xFFFE, 0x7B5D, 0xFFFE, 0x7C35, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4455, 0x477C, 0xFFFE,
	0xFFFE, 0x4B56, 0x5A25, 0xFFFE, 0xFFFE, 0x4456, 0x464A, 0x4649,
	0x4648, 0xFFFE, 0xFFFE, 0x4A27, 0xFFFE, 0xFFFE, 0x5538, 0xFFFE,
	0xFFFE, 0x4457, 0x4458, 0x4459, 0x453B, 0xFFFE, 0xFFFE, 0x5073,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E78, 0x445A, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5E = { {
	0xFFFE, 0xFFFE, 0x464B, 0x464C, 0xFFFE, 0xFFFE, 0x477D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A28, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D30, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D2E, 0x4D2D, 0xFFFE,
	0x4D2B, 0xFFFE, 0x4D2C, 0x4D2F, 0xFFFE, 0x5074, 0xFFFE, 0x5076,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5075, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x553A, 0xFFFE, 0x5539, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A28, 0xFFFE, 0xFFFE, 0x5A27, 0x5A29,
	0x5A26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E7A, 0xFFFE, 0xFFFE,
	0x5E7B, 0xFFFE, 0xFFFE, 0x5E7C, 0xFFFE, 0x5E79, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x636B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x685F, 0x685D, 0xFFFE, 0x685E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x685B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C57,
	0xFFFE, 0x6C58, 0x6C56, 0x685C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7359, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x445B, 0x464D, 0x4821, 0xFFFE, 0x477E, 0xFFFE,
	0x4D31, 0x636C, 0xFFFE, 0x453C, 0x464E, 0x5077, 0x5E7D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A2A,
	0xFFFE, 0xFFFE, 0x4A2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A29,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D35, 0x4D36, 0x4D33,
	0xFFFE, 0xFFFE, 0x4D32, 0xFFFE, 0x4D34, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5078, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5079, 0x553D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x553B, 0xFFFE, 0x553C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2D, 0x5A2C, 0x5A2A,
	0x5A2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2E, 0xFFFE,
	0xFFFE, 0x5F21, 0x5F22, 0xFFFE, 0x5F23, 0xFFFE, 0xFFFE, 0xFFFE,
	0x636E, 0x636D, 0x5E7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6860, 0xFFFE, 0xFFFE, 0x6861, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C5A, 0xFFFE, 0xFFFE, 0x6C5C, 0xFFFE, 0x6C5B,
	0x6C5E, 0xFFFE, 0x6C59, 0x6C5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7833, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7D22, 0xFFFE, 0xFFFE, 0x4D37, 0x4A2C,
	0xFFFE, 0xFFFE, 0x507A, 0xFFFE, 0xFFFE, 0xFFFE, 0x445C, 0x453D
} };

static const iconv_ccs_convtable_8bit from_ucs_5F = { {
	0xFFFE, 0x464F, 0xFFFE, 0xFFFE, 0x4A2D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x507B, 0xFFFE, 0x6862, 0x445D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4822,
	0xFFFE, 0xFFFE, 0x636F, 0x445E, 0x453E, 0x453F, 0xFFFE, 0x4651,
	0x4650, 0xFFFE, 0xFFFE, 0x4823, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D38, 0x4D39,
	0xFFFE, 0x4D3A, 0xFFFE, 0xFFFE, 0xFFFE, 0x507C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x553E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2F, 0xFFFE, 0x5A30,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F24, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6863, 0xFFFE,
	0x6C5F, 0xFFFE, 0x7053, 0xFFFE, 0x735A, 0xFFFE, 0x7B5F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A31,
	0xFFFE, 0x6370, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7641, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A30, 0xFFFE, 0x4A2F, 0x507D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A33, 0x5D29, 0x5A34, 0x5A32, 0x5F25, 0xFFFE, 0xFFFE,
	0x6864, 0x6C60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A31,
	0xFFFE, 0x4A32, 0xFFFE, 0xFFFE, 0x4D3E, 0xFFFE, 0xFFFE, 0x4D3D,
	0x4D3B, 0x4D3C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5121, 0xFFFE, 0x5124,
	0x507E, 0x5126, 0x5122, 0x5123, 0x5125, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5541, 0x5540, 0x553F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A35,
	0x5A38, 0x5A36, 0xFFFE, 0xFFFE, 0x5A3B, 0xFFFE, 0x5A37, 0xFFFE,
	0x5A3A, 0x5A39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F28, 0x5F26, 0x5F27, 0xFFFE, 0x6371, 0xFFFE, 0x6372, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C62, 0xFFFE, 0x6C61,
	0xFFFE, 0x6865, 0xFFFE, 0xFFFE, 0xFFFE, 0x735B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4540, 0xFFFE, 0x4652, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A34, 0x4A36, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4825, 0x4A35,
	0x4A33, 0x4824, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D3F, 0xFFFE, 0xFFFE,
	0x4D40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A3A, 0x4A38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A37, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D42, 0xFFFE, 0xFFFE,
	0x4A39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D41, 0xFFFE, 0x4D43
} };

static const iconv_ccs_convtable_8bit from_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x512B, 0x4D44,
	0xFFFE, 0xFFFE, 0x5127, 0xFFFE, 0x4D45, 0x4D4A, 0x4D48, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D4F, 0xFFFE, 0x5128, 0xFFFE, 0xFFFE,
	0x5129, 0x4D4B, 0xFFFE, 0xFFFE, 0xFFFE, 0x512A, 0xFFFE, 0x4D4C,
	0x512C, 0x4D4D, 0x4D49, 0x4D4E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D46,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D47, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5132, 0xFFFE, 0xFFFE, 0x5131, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x512D, 0xFFFE, 0xFFFE,
	0x5545, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5546, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5542, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5130, 0x5543, 0x5136, 0x5544, 0xFFFE, 0xFFFE,
	0x512F, 0x5548, 0x5135, 0x5134, 0x5133, 0x5547, 0xFFFE, 0x5549,
	0x512E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A3C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x554A, 0x5550, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A3E, 0xFFFE, 0xFFFE, 0x554F, 0x554D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x554E, 0xFFFE, 0x5551, 0xFFFE,
	0xFFFE, 0xFFFE, 0x554C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x554B,
	0x5A3F, 0xFFFE, 0xFFFE, 0x5A3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F2B, 0xFFFE, 0x5A42, 0x5A47, 0x5F2C, 0xFFFE,
	0x5A4E, 0xFFFE, 0xFFFE, 0x5A46, 0x5A49, 0x5A44, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A45, 0x5A4C, 0x5A50,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F29, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A4B, 0xFFFE, 0xFFFE,
	0x5A4A, 0xFFFE, 0x5A4F, 0xFFFE, 0x5A48, 0xFFFE, 0xFFFE, 0x5A4D,
	0x5F2D, 0x5F2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A43, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F32, 0x5F36, 0xFFFE, 0x6377, 0x5F34, 0xFFFE, 0x5F38, 0xFFFE,
	0xFFFE, 0x6379, 0x5F30, 0x5F33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_61 = { {
	0x5F3A, 0x637A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6426, 0xFFFE,
	0x637B, 0x5F39, 0xFFFE, 0xFFFE, 0xFFFE, 0x6425, 0x5F37, 0x6374,
	0xFFFE, 0xFFFE, 0x5F3B, 0xFFFE, 0xFFFE, 0x5F31, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6373, 0x6378, 0x5F2E, 0xFFFE, 0xFFFE, 0x6376,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5F2F, 0xFFFE, 0xFFFE, 0xFFFE, 0x6424,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6423, 0xFFFE, 0xFFFE, 0x6427,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6422, 0x6867,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x637E, 0xFFFE, 0xFFFE, 0x6866,
	0x6375, 0xFFFE, 0xFFFE, 0x6868, 0x637D, 0x6421, 0x637C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C67, 0xFFFE, 0xFFFE,
	0x686E, 0xFFFE, 0x686D, 0xFFFE, 0xFFFE, 0x6C66, 0xFFFE, 0x686C,
	0xFFFE, 0xFFFE, 0x686A, 0x686B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C64,
	0x5F35, 0xFFFE, 0xFFFE, 0x6C6B, 0xFFFE, 0xFFFE, 0x6C65, 0xFFFE,
	0x6C6A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x686F, 0x6C63, 0x6869,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C69, 0xFFFE, 0x6C6C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7057, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C70, 0xFFFE,
	0x6C6E, 0x7055, 0xFFFE, 0xFFFE, 0x6C74, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C73, 0xFFFE, 0xFFFE, 0x6C6D,
	0xFFFE, 0x7056, 0xFFFE, 0x6C6F, 0x6C71, 0xFFFE, 0x6C75, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7054, 0xFFFE, 0xFFFE, 0xFFFE, 0x7059, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x705A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x735D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x735E,
	0x705C, 0x735C, 0x705B, 0x7360, 0xFFFE, 0x7058, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7642, 0xFFFE, 0xFFFE, 0x735F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7834, 0xFFFE, 0xFFFE, 0x7837, 0x7836, 0x7835,
	0x796C, 0xFFFE, 0x796D, 0xFFFE, 0x7A6A, 0xFFFE, 0x7A6B, 0x7B60
} };

static const iconv_ccs_convtable_8bit from_ucs_62 = { {
	0x7C36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4541, 0xFFFE, 0x4653, 0xFFFE, 0x4827, 0x4828, 0x4826, 0xFFFE,
	0x4829, 0x4A3C, 0x4A3B, 0xFFFE, 0xFFFE, 0x4D51, 0x4D50, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A51, 0x5A52, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F3C,
	0xFFFE, 0x6428, 0x6429, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6870, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C76, 0xFFFE,
	0x705D, 0xFFFE, 0x7361, 0x7643, 0x7362, 0xFFFE, 0x4542, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D53, 0x4D52,
	0x4D54, 0x5137, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5552,
	0x5A53, 0x5F3D, 0xFFFE, 0x4543, 0xFFFE, 0x445F, 0x4544, 0xFFFE,
	0xFFFE, 0x4657, 0x4656, 0x4654, 0x4655, 0xFFFE, 0xFFFE, 0xFFFE,
	0x482C, 0xFFFE, 0xFFFE, 0x482B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x482A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A43, 0x4A4C, 0x4A4A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A48, 0xFFFE, 0xFFFE, 0x4A41, 0xFFFE,
	0xFFFE, 0x4A47, 0xFFFE, 0xFFFE, 0x4A45, 0xFFFE, 0x4A46, 0x4D55,
	0x4A40, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A3D, 0xFFFE, 0x4A50, 0xFFFE,
	0xFFFE, 0x4A42, 0x4A44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A4F, 0x4A49, 0x4A4E, 0xFFFE, 0x4A4D, 0x4A3F, 0x4A3E,
	0x4A4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4D63, 0xFFFE, 0xFFFE, 0x4D5E, 0x4D71, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D6C, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D6A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D5B, 0xFFFE, 0xFFFE, 0x4D65, 0x4D64, 0xFFFE, 0x4D59,
	0xFFFE, 0xFFFE, 0x4D5A, 0xFFFE, 0x4D58, 0xFFFE, 0x4D70, 0x4D68,
	0x4D62, 0x4D56, 0xFFFE, 0x4D61, 0x4D57, 0x4D69, 0x4D72, 0xFFFE,
	0x4D66, 0xFFFE, 0x4D5C, 0x4D5F, 0x4D60, 0xFFFE, 0x4D6E, 0x4D6F,
	0x4D6D, 0x4D67, 0x4D6B, 0x4D5D, 0x5138, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5144, 0x513C, 0x513E, 0x5143,
	0xFFFE, 0x5141, 0xFFFE, 0x5553, 0x5146, 0xFFFE, 0xFFFE, 0x5142,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x513B, 0x513F, 0x5145, 0x5555
} };

static const iconv_ccs_convtable_8bit from_ucs_63 = { {
	0xFFFE, 0x513D, 0x5148, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5140,
	0x5554, 0x513A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5147, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5139, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5563, 0xFFFE, 0x5561, 0x5562, 0xFFFE, 0xFFFE, 0xFFFE, 0x5558,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x555E, 0xFFFE, 0xFFFE, 0x5560, 0x5557, 0xFFFE,
	0xFFFE, 0xFFFE, 0x555A, 0xFFFE, 0xFFFE, 0xFFFE, 0x555B, 0xFFFE,
	0xFFFE, 0x555D, 0xFFFE, 0xFFFE, 0x5565, 0x5564, 0x5556, 0x555C,
	0x555F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5559, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A5B,
	0x5A6F, 0x5A6E, 0xFFFE, 0x5A63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A5E, 0x5A56, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F4D, 0x5A5A,
	0xFFFE, 0xFFFE, 0x5A70, 0x5A6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A6C, 0xFFFE, 0xFFFE, 0x5A61, 0x5A65, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A66, 0x5A60, 0xFFFE, 0xFFFE, 0x5F3F, 0xFFFE, 0xFFFE, 0x5A6B,
	0xFFFE, 0xFFFE, 0x5A6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A57, 0xFFFE,
	0x5A5C, 0x5A67, 0xFFFE, 0x5A62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A54, 0x5A68, 0x5A58, 0x5F3E, 0xFFFE, 0x5A59, 0xFFFE, 0x5A55,
	0x5A64, 0x5A5F, 0x5A5D, 0xFFFE, 0x5A69, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F44, 0xFFFE,
	0xFFFE, 0x5F43, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F45, 0xFFFE, 0x5F40,
	0x5F48, 0xFFFE, 0x5F46, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F4A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F52, 0x5F50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F49, 0xFFFE, 0x5F47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F42, 0x5F4F, 0xFFFE, 0xFFFE, 0x5F4B, 0x5F4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6438, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6434, 0xFFFE, 0x6431,
	0xFFFE, 0xFFFE, 0xFFFE, 0x642A, 0x6433, 0xFFFE, 0x6436, 0x6437,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6432, 0xFFFE, 0x642C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x642D, 0xFFFE, 0x6430, 0x642E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x687A, 0xFFFE, 0x6435, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x642F, 0x642B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6878, 0x5F51, 0xFFFE, 0x6873, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6872, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6876,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6879,
	0xFFFE, 0x6C77, 0xFFFE, 0xFFFE, 0xFFFE, 0x687B, 0xFFFE, 0x6C78,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6875, 0x6C79, 0x6877, 0x687C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6871,
	0x6C7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C7D, 0xFFFE, 0x6D25, 0x6D22, 0xFFFE, 0x6D23, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D2B, 0x6D29, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C7A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D2C, 0xFFFE, 0x6874, 0x6D21, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D24, 0xFFFE, 0x6D28, 0x6D2A, 0x6D27, 0x6D26, 0xFFFE,
	0x6C7E, 0xFFFE, 0x6C7B, 0x6D2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7061, 0x7062, 0xFFFE, 0x706B, 0x7068,
	0xFFFE, 0x705F, 0x7066, 0xFFFE, 0x7064, 0x705E, 0xFFFE, 0x7065,
	0xFFFE, 0xFFFE, 0x7364, 0x7060, 0xFFFE, 0x7067, 0x7363, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7069, 0xFFFE, 0x706A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7365, 0xFFFE, 0x7063, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7366, 0xFFFE, 0x736B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7368, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7369, 0x736C, 0xFFFE, 0xFFFE,
	0x7367, 0x736A, 0x7645, 0xFFFE, 0x7644, 0xFFFE, 0xFFFE, 0x764A,
	0xFFFE, 0xFFFE, 0x7648, 0x7649, 0xFFFE, 0xFFFE, 0x7646, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_65 = { {
	0x7838, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7647, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7839,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x796F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x796E, 0x7970, 0xFFFE, 0xFFFE, 0x7A6D, 0x7A6C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C37, 0x7B61, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C39, 0x7C38, 0x7C5F, 0xFFFE, 0xFFFE, 0x4545,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x482D, 0xFFFE,
	0x4A53, 0x4A51, 0xFFFE, 0x4A52, 0xFFFE, 0xFFFE, 0x4D73, 0x5149,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x514A, 0xFFFE, 0xFFFE,
	0x5566, 0x5567, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A77,
	0xFFFE, 0x5A73, 0xFFFE, 0xFFFE, 0x5A7A, 0x5A79, 0x5A72, 0x5A75,
	0x5A78, 0x5A74, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A71, 0x5F54, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F56, 0x5F57, 0xFFFE, 0xFFFE, 0x5F55, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6439, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x687D, 0xFFFE, 0x706C, 0x6D2E, 0xFFFE, 0x6D2F,
	0x6D30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x736D, 0x736E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4546,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F59, 0x5F58, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A6E, 0xFFFE, 0x4547,
	0xFFFE, 0x5568, 0xFFFE, 0x5A7C, 0x5A7B, 0xFFFE, 0xFFFE, 0x643A,
	0xFFFE, 0x687E, 0xFFFE, 0xFFFE, 0x4548, 0x4658, 0xFFFE, 0x4D74,
	0xFFFE, 0xFFFE, 0xFFFE, 0x514B, 0x5A7D, 0xFFFE, 0xFFFE, 0x5F5A,
	0x643B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x764B,
	0xFFFE, 0x4549, 0xFFFE, 0xFFFE, 0x4D75, 0x514C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5569, 0xFFFE, 0xFFFE, 0xFFFE, 0x556A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B21, 0x5B22, 0xFFFE, 0x5B23, 0x5A7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6922, 0x6921,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x514D, 0xFFFE, 0xFFFE, 0x454A, 0x4659, 0xFFFE,
	0x482F, 0x482E, 0xFFFE, 0xFFFE, 0x4830, 0x4831, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_66 = { {
	0x4D7D, 0xFFFE, 0x4D7B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D7A, 0x4E23,
	0xFFFE, 0xFFFE, 0x4E22, 0xFFFE, 0x4D79, 0xFFFE, 0x4D7C, 0x4D7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D78, 0x4D77, 0x4E21, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5153,
	0x5150, 0xFFFE, 0xFFFE, 0xFFFE, 0x5156, 0x514E, 0xFFFE, 0x5151,
	0x5154, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x514F, 0xFFFE, 0x5152,
	0xFFFE, 0x5155, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5572, 0x556B, 0x556E, 0xFFFE, 0x5571, 0xFFFE, 0xFFFE,
	0xFFFE, 0x556C, 0xFFFE, 0xFFFE, 0x5570, 0xFFFE, 0xFFFE, 0x556D,
	0xFFFE, 0xFFFE, 0x556F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5B25, 0xFFFE, 0xFFFE, 0x5B24, 0x5B29, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B26, 0xFFFE, 0x5B28, 0xFFFE,
	0x5B27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F5B, 0x5F5F,
	0x5F5C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F5D, 0xFFFE, 0x5F5E, 0x5F63,
	0xFFFE, 0xFFFE, 0x5F61, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F62, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6441, 0xFFFE, 0xFFFE, 0x643E,
	0x643F, 0x643D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6443, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6440, 0x643C,
	0x6442, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6925, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6923, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6924, 0xFFFE, 0xFFFE, 0x6D32, 0xFFFE, 0xFFFE, 0x6D31, 0xFFFE,
	0xFFFE, 0x6D34, 0xFFFE, 0xFFFE, 0x6D33, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7072, 0x706F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7070, 0xFFFE, 0x706D, 0x7071,
	0xFFFE, 0x706E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7370, 0xFFFE,
	0xFFFE, 0x736F, 0xFFFE, 0xFFFE, 0x764C, 0x783B, 0xFFFE, 0xFFFE,
	0x783A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7971, 0xFFFE,
	0xFFFE, 0x7A6F, 0xFFFE, 0xFFFE, 0x7C3A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x454B, 0xFFFE, 0x4832, 0x4833, 0x4A55, 0xFFFE, 0xFFFE, 0x5157,
	0x5573, 0x5B2A, 0xFFFE, 0xFFFE, 0x5937, 0xFFFE, 0x5F64, 0x5F65
} };

static const iconv_ccs_convtable_8bit from_ucs_67 = { {
	0x5E32, 0xFFFE, 0xFFFE, 0x6444, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x454C, 0x4834, 0xFFFE, 0x4E25, 0xFFFE, 0x4E24, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5574, 0x5575, 0xFFFE, 0x5576,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B2C, 0xFFFE, 0x5F67, 0xFFFE, 0x5F66,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x764D, 0x7972,
	0x454D, 0xFFFE, 0x465C, 0x465D, 0x465B, 0x465E, 0x465A, 0xFFFE,
	0xFFFE, 0x4837, 0xFFFE, 0xFFFE, 0x4836, 0x4838, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4835, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A5F, 0xFFFE,
	0xFFFE, 0x4A5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A57, 0x4A58,
	0x4A59, 0x4A5A, 0xFFFE, 0x4A61, 0xFFFE, 0xFFFE, 0x4A5C, 0x4A62,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A5B, 0xFFFE, 0x4A5D, 0x4A56,
	0x4A60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E3A, 0xFFFE, 0xFFFE, 0x4E26, 0xFFFE, 0x4E30,
	0x4E31, 0x4E29, 0x4E3B, 0x4E2B, 0xFFFE, 0x4E36, 0xFFFE, 0x4E2C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E39, 0xFFFE, 0x4E34, 0x4E32,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E2D,
	0xFFFE, 0x4E33, 0xFFFE, 0x4E27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4E35, 0xFFFE, 0xFFFE, 0x4E38, 0xFFFE, 0x4E28, 0xFFFE, 0x4E2F,
	0xFFFE, 0xFFFE, 0x4E37, 0xFFFE, 0x4E2A, 0x4E2E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x515F,
	0x516C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5165, 0xFFFE, 0x515E, 0xFFFE,
	0x5168, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5163, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5169,
	0x515C, 0x5164, 0x5170, 0x5159, 0x515B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x516D, 0x5166, 0xFFFE, 0xFFFE, 0x516F, 0x516A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x516E, 0xFFFE, 0xFFFE, 0x5167, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5161, 0xFFFE, 0xFFFE, 0x515D, 0xFFFE, 0xFFFE, 0x5162,
	0xFFFE, 0x515A, 0xFFFE, 0x516B, 0x5627, 0x5160, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5158
} };

static const iconv_ccs_convtable_8bit from_ucs_68 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x562E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5623,
	0x562F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5577, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5621, 0x562C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5578, 0x557C, 0xFFFE, 0xFFFE, 0x562A, 0x5626, 0xFFFE, 0xFFFE,
	0x5629, 0x5630, 0x557D, 0x562B, 0xFFFE, 0x562D, 0x557A, 0xFFFE,
	0x5579, 0xFFFE, 0xFFFE, 0xFFFE, 0x5624, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5628, 0x5625, 0xFFFE, 0x557B, 0x557E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B33, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B32,
	0xFFFE, 0x5B2D, 0x5B42, 0x5B38, 0xFFFE, 0x5B3C, 0x5B3B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B30, 0x5B3D, 0xFFFE, 0xFFFE, 0x5B36,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B3E, 0xFFFE, 0x5B40,
	0xFFFE, 0x5B41, 0x5B2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B35,
	0x5B3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B3A, 0xFFFE, 0x5B2E,
	0x5B37, 0x5B34, 0xFFFE, 0x5622, 0xFFFE, 0x5B31, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B39, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F7B, 0xFFFE, 0x5F76, 0xFFFE, 0x5F77, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F73, 0xFFFE, 0xFFFE, 0x5F69, 0xFFFE, 0x5F6C,
	0x5F6B, 0xFFFE, 0x5F7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6E,
	0x5F6A, 0xFFFE, 0xFFFE, 0x5F75, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F71,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F70, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F74, 0xFFFE, 0xFFFE, 0x5F6F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F72, 0x5F68, 0x5F7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_69 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F78, 0x5F7A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x644C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x644E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6452, 0x644A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6447, 0x6457, 0xFFFE, 0x6455, 0x6451, 0xFFFE,
	0x6449, 0xFFFE, 0xFFFE, 0x6456, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x644F, 0xFFFE, 0xFFFE, 0x6450, 0xFFFE, 0x6446, 0x5F7D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x644B, 0xFFFE, 0x6448,
	0xFFFE, 0x6453, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x644D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6454, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6445, 0x6928, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x692D, 0x6926, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6938, 0xFFFE, 0xFFFE, 0x6936, 0xFFFE,
	0x6927, 0xFFFE, 0xFFFE, 0x6930, 0xFFFE, 0x6934, 0x692A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6931, 0xFFFE, 0xFFFE, 0x692E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x692F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6929, 0xFFFE, 0x6937, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x692C, 0x6935, 0x6933, 0xFFFE, 0xFFFE,
	0x6932, 0xFFFE, 0xFFFE, 0x692B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D42, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D3B, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6A = { {
	0xFFFE, 0x6D38, 0x6D40, 0xFFFE, 0xFFFE, 0x6D41, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D43, 0xFFFE, 0x6D3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D39, 0x6D36,
	0xFFFE, 0x6D3C, 0xFFFE, 0x6D35, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7121, 0xFFFE, 0xFFFE,
	0x7074, 0x7079, 0x7075, 0xFFFE, 0xFFFE, 0x7073, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x707A, 0xFFFE, 0xFFFE, 0x707E,
	0x7123, 0xFFFE, 0xFFFE, 0x707D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7078, 0x7076, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7122,
	0xFFFE, 0x707C, 0x707B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7077, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7378, 0xFFFE,
	0x7371, 0xFFFE, 0xFFFE, 0xFFFE, 0x7373, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x737A, 0xFFFE, 0xFFFE, 0xFFFE, 0x7372, 0xFFFE, 0xFFFE, 0x7379,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7375, 0xFFFE, 0xFFFE, 0xFFFE,
	0x737B, 0xFFFE, 0x7374, 0x7377, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x764F, 0xFFFE, 0x7654, 0x7655,
	0xFFFE, 0xFFFE, 0xFFFE, 0x764E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7652, 0xFFFE, 0xFFFE, 0x7651, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7653, 0x7650, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x783F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x783E, 0x7376, 0xFFFE, 0x783D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x783C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7973, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7A72, 0x7A70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A71, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D23, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x454E, 0x4839, 0xFFFE, 0x4E3C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5B43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6022, 0xFFFE, 0xFFFE, 0x6023, 0x6021, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6458,
	0xFFFE, 0x6939, 0xFFFE, 0xFFFE, 0x693A, 0xFFFE, 0x6D45, 0xFFFE,
	0x6D44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7124, 0xFFFE, 0xFFFE, 0x737C, 0xFFFE, 0xFFFE, 0x7656,
	0xFFFE, 0x7B63, 0x454F, 0x465F, 0x483A, 0x4A63, 0x4E3D, 0x4E3E,
	0xFFFE, 0xFFFE, 0x5171, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6459, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7125,
	0x7657, 0x4550, 0xFFFE, 0x483B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E3F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5172, 0xFFFE, 0xFFFE, 0x5173, 0xFFFE,
	0xFFFE, 0x5632, 0x5631, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6025, 0xFFFE,
	0x6024, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D46, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x737D, 0x7658,
	0xFFFE, 0xFFFE, 0x7A73, 0xFFFE, 0xFFFE, 0x5174, 0xFFFE, 0x5633,
	0xFFFE, 0xFFFE, 0x5B44, 0xFFFE, 0x6026, 0xFFFE, 0xFFFE, 0x645B,
	0x645A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D47, 0x6D48, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4551, 0xFFFE, 0x4660, 0xFFFE, 0x4A64,
	0xFFFE, 0xFFFE, 0x5175, 0x645C, 0x4552, 0xFFFE, 0xFFFE, 0x5176,
	0xFFFE, 0xFFFE, 0x737E, 0x4553, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B45, 0x5B46, 0xFFFE, 0xFFFE, 0x6027,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x645D, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7126, 0xFFFE, 0xFFFE,
	0x7421, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4554,
	0x4662, 0x4661, 0xFFFE, 0x4E40, 0xFFFE, 0xFFFE, 0x483C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E41, 0xFFFE, 0xFFFE, 0xFFFE, 0x5177,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5634, 0x5638, 0xFFFE, 0x5637, 0x5635,
	0x5636, 0xFFFE, 0xFFFE, 0x5B47, 0x602A, 0xFFFE, 0x6028, 0x6029,
	0xFFFE, 0xFFFE, 0xFFFE, 0x693B, 0x4555, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4663, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4666, 0xFFFE,
	0x4665, 0x4664, 0x4A65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4846, 0x4847, 0xFFFE,
	0x4842, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4843, 0xFFFE, 0x483E,
	0xFFFE, 0x483F, 0xFFFE, 0x4845, 0xFFFE, 0x483D, 0x4A66, 0x4840,
	0x4841, 0x4844, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A72, 0xFFFE, 0x4A6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A70, 0xFFFE, 0x4A77, 0xFFFE, 0x4A79, 0xFFFE, 0x4A7B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A6E, 0xFFFE, 0xFFFE, 0x4A75, 0x4A78, 0xFFFE,
	0xFFFE, 0x4A68, 0x4B21, 0x4A76, 0xFFFE, 0x4A6B, 0x4A7A, 0xFFFE,
	0x4A69, 0x4A6A, 0xFFFE, 0xFFFE, 0x4A71, 0x4A7C, 0xFFFE, 0xFFFE,
	0x4A6F, 0xFFFE, 0x4A74, 0xFFFE, 0x4A7D, 0xFFFE, 0x4A73, 0xFFFE,
	0x4A7E, 0x4A67, 0xFFFE, 0x4A6C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E4D, 0x4E5D, 0xFFFE, 0x4E54, 0xFFFE,
	0xFFFE, 0x4E45, 0xFFFE, 0x4E48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4E50, 0x4E52, 0xFFFE, 0x4E59, 0x4E4B, 0x4E49, 0x4E4A, 0x4E58,
	0xFFFE, 0x4E53, 0xFFFE, 0xFFFE, 0x4E51, 0x4E56, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5178, 0x4E5C, 0xFFFE, 0x4E46, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E4F, 0xFFFE, 0x4E4E, 0x4E60, 0x4E55,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E5B, 0x4E5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4E61, 0x4E5A, 0x4E4C, 0x4E42, 0xFFFE, 0x4E47, 0xFFFE, 0xFFFE,
	0x4E43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E5E,
	0x5639, 0x4E57, 0xFFFE, 0x4E44, 0xFFFE, 0x5229, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5179, 0x517E, 0xFFFE, 0x5230, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5223,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5228, 0xFFFE, 0xFFFE, 0x5222, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x517D, 0xFFFE, 0x522B,
	0xFFFE, 0x522D, 0x517B, 0x5231, 0xFFFE, 0xFFFE, 0x522E, 0xFFFE,
	0xFFFE, 0x5221, 0x517A, 0xFFFE, 0xFFFE, 0x522F, 0x5227, 0xFFFE,
	0x522C, 0x522A, 0xFFFE, 0x5224, 0xFFFE, 0x5225, 0x5226, 0xFFFE,
	0xFFFE, 0x517C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5641, 0x5646, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x564D, 0x563E, 0xFFFE,
	0xFFFE, 0x5648, 0x563A, 0xFFFE, 0x5643, 0xFFFE, 0x5645, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5647, 0xFFFE, 0xFFFE, 0x5640,
	0x563F, 0x564B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x564C, 0xFFFE, 0x563D,
	0x563C, 0x5644, 0x564A, 0xFFFE, 0x5649, 0xFFFE, 0x5B48, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5642, 0x564E, 0x563B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5B6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B57, 0x5B55,
	0xFFFE, 0xFFFE, 0x5B4C, 0xFFFE, 0xFFFE, 0x5B60, 0xFFFE, 0xFFFE,
	0x5B5A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B49, 0xFFFE, 0xFFFE, 0x5B6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B69, 0x5B5D, 0x5B68, 0x5B53,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B54, 0x5B4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B56, 0x5B5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B63, 0x5B4B, 0x5B61, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B58, 0xFFFE,
	0xFFFE, 0x5B4D, 0xFFFE, 0xFFFE, 0x5B4F, 0xFFFE, 0x5B6D, 0xFFFE,
	0x5B67, 0xFFFE, 0x5B64, 0x5B62, 0x5B6B, 0xFFFE, 0x5B66, 0xFFFE,
	0xFFFE, 0x5B65, 0xFFFE, 0x5B4A, 0xFFFE, 0x5B5C, 0xFFFE, 0x5B5B,
	0xFFFE, 0x5B59, 0x5B51, 0x5B50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B52, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6047, 0x5B5F, 0x6035, 0xFFFE, 0x6043, 0xFFFE, 0xFFFE,
	0x6032, 0x602E, 0xFFFE, 0x6034, 0x6038, 0x6033, 0x603C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6041, 0x603B, 0xFFFE, 0x602B,
	0xFFFE, 0xFFFE, 0x602F, 0xFFFE, 0x603E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x602C, 0xFFFE, 0x6040, 0xFFFE, 0xFFFE, 0xFFFE, 0x6044, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6042, 0x604A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6031, 0xFFFE, 0xFFFE, 0x603F, 0x6048, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x602D, 0xFFFE, 0x6039, 0xFFFE,
	0x6037, 0xFFFE, 0xFFFE, 0x6036, 0xFFFE, 0xFFFE, 0xFFFE, 0x604D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6049, 0xFFFE, 0xFFFE, 0xFFFE, 0x6030,
	0xFFFE, 0x604C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x603A, 0x603D,
	0xFFFE, 0xFFFE, 0x604B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6046, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6463, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x646D, 0xFFFE,
	0x6468, 0xFFFE, 0xFFFE, 0xFFFE, 0x646E, 0x6464, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x645E, 0xFFFE, 0xFFFE, 0x6467, 0xFFFE, 0x6472,
	0xFFFE, 0xFFFE, 0x6471, 0x646B, 0xFFFE, 0xFFFE, 0xFFFE, 0x645F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6473, 0xFFFE, 0x6461, 0xFFFE,
	0xFFFE, 0xFFFE, 0x646A, 0xFFFE, 0x6469, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6462, 0xFFFE, 0x646F, 0x6466, 0xFFFE, 0x6465,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6045, 0x6957, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x646C, 0xFFFE, 0x6460, 0x6470, 0x6D5A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6954, 0xFFFE, 0xFFFE, 0x6949,
	0xFFFE, 0xFFFE, 0x6956, 0xFFFE, 0x6940, 0xFFFE, 0xFFFE, 0x6958,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x693E, 0x6948
} };

static const iconv_ccs_convtable_8bit from_ucs_6F = { {
	0xFFFE, 0x6955, 0x6946, 0xFFFE, 0xFFFE, 0xFFFE, 0x694A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6945,
	0xFFFE, 0xFFFE, 0xFFFE, 0x693F, 0x693D, 0x694F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6943, 0xFFFE, 0x6947, 0x694E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6941, 0x6953, 0x6950, 0x6944, 0xFFFE, 0xFFFE, 0x6951,
	0xFFFE, 0x694B, 0x694D, 0x693C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x694C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6942, 0x6D49,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D4C, 0xFFFE, 0xFFFE, 0x6D4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D59, 0xFFFE, 0xFFFE, 0x6D51, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D5D,
	0x6D5C, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D57, 0xFFFE, 0x6D4D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D50, 0x6D53, 0x6D5B,
	0x6D56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D52, 0xFFFE, 0x6D55, 0xFFFE, 0x6D4A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x742A, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D4B, 0xFFFE, 0x6D4F, 0xFFFE,
	0x6952, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D54, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D58,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7133, 0x7129, 0xFFFE, 0xFFFE, 0x712B, 0xFFFE, 0x7132, 0x712D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7128, 0xFFFE, 0x712E, 0x7134, 0xFFFE, 0x7131, 0xFFFE,
	0xFFFE, 0x7130, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x712F, 0x712C, 0x7127, 0x712A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x742E, 0xFFFE, 0xFFFE,
	0x7422, 0xFFFE, 0xFFFE, 0x7426, 0xFFFE, 0xFFFE, 0xFFFE, 0x7424,
	0x7425, 0x742C, 0xFFFE, 0xFFFE, 0x7427, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x742D, 0xFFFE, 0x7428, 0x742B, 0xFFFE, 0x742F, 0x7429,
	0x7430, 0x7423, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x765D, 0xFFFE, 0xFFFE, 0xFFFE, 0x765B, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_70 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x765C, 0xFFFE,
	0xFFFE, 0x7659, 0xFFFE, 0x765A, 0xFFFE, 0xFFFE, 0xFFFE, 0x765F,
	0xFFFE, 0x765E, 0xFFFE, 0xFFFE, 0xFFFE, 0x7845, 0xFFFE, 0xFFFE,
	0x7846, 0xFFFE, 0x7843, 0x7840, 0xFFFE, 0x7844, 0xFFFE, 0x7841,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7842, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7975, 0xFFFE, 0x7976, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7974, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A74, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7B64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C60, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7D24, 0x7D32, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4556, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4848, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B22, 0xFFFE,
	0x4B25, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B23, 0x4B24, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E65, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E63, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E64, 0xFFFE, 0xFFFE, 0x4E62, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x523A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5232, 0x5235, 0x5237, 0x5239, 0x5236,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5234, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5238, 0xFFFE, 0x5233, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5653, 0xFFFE, 0x564F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5654,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5650, 0x5652, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5651, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B72,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B71, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_71 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B6F, 0x5B70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x604E, 0x604F, 0xFFFE, 0x6055, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6052, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6050, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6051, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6053, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6522, 0xFFFE,
	0xFFFE, 0x6478, 0xFFFE, 0xFFFE, 0x647D, 0xFFFE, 0x6474, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6524, 0xFFFE,
	0xFFFE, 0x6475, 0xFFFE, 0xFFFE, 0x647A, 0xFFFE, 0x6521, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6477, 0x647E, 0x647C, 0x6479,
	0x6523, 0x6476, 0xFFFE, 0xFFFE, 0x647B, 0xFFFE, 0x6054, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x695B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x695D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x695C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x695E, 0xFFFE, 0x6959, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x695A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D5E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D61, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x713B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7135, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x713F, 0x7140, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7139, 0x7136, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x713C, 0xFFFE,
	0x7137, 0xFFFE, 0x7138, 0xFFFE, 0xFFFE, 0x713A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x713D, 0xFFFE, 0xFFFE, 0x713E, 0xFFFE, 0xFFFE, 0x7432,
	0x7439, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7435, 0x7434, 0x7431,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7437, 0x7436, 0x7433, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7438, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7663, 0xFFFE, 0xFFFE, 0x7660, 0x7661, 0xFFFE, 0x7662, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_72 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7847, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7848, 0xFFFE, 0xFFFE,
	0x7977, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7D46, 0xFFFE, 0x4557, 0xFFFE, 0x4E67, 0x4E68, 0xFFFE, 0xFFFE,
	0x523B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x743A, 0x4558, 0xFFFE,
	0x4E69, 0x5655, 0x6525, 0x4559, 0xFFFE, 0x5B73, 0x695F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x743B, 0x455A,
	0x4E6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x6056, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6526, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D62, 0xFFFE,
	0x7849, 0x455B, 0xFFFE, 0x455C, 0xFFFE, 0x484A, 0xFFFE, 0x4849,
	0x4B28, 0x4B27, 0x4B26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E6B,
	0xFFFE, 0x4E6C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x523D,
	0xFFFE, 0xFFFE, 0x523C, 0xFFFE, 0x523E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5656, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B74, 0xFFFE, 0xFFFE,
	0x6058, 0x5B75, 0xFFFE, 0xFFFE, 0x6057, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6960, 0xFFFE, 0xFFFE, 0xFFFE, 0x6961, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x784A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A76,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x455D, 0xFFFE, 0xFFFE, 0x4667,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4E6D, 0xFFFE, 0x4B2A, 0xFFFE, 0x4B29, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E6E, 0xFFFE,
	0x4E71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E70,
	0xFFFE, 0x4E6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5240, 0x5241, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x523F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x565B,
	0x565A, 0x5658, 0xFFFE, 0xFFFE, 0x5657, 0x5659, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_73 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B79, 0xFFFE, 0xFFFE, 0x5B78, 0xFFFE,
	0xFFFE, 0x5B7A, 0xFFFE, 0x5B77, 0x5B76, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x605A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x605C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x605B, 0xFFFE, 0x6059, 0x6527,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x652A, 0x6529,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6962, 0x6528, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D64, 0xFFFE,
	0x6963, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D65,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7141, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x743C, 0xFFFE, 0x743D, 0xFFFE, 0xFFFE, 0x7665, 0xFFFE, 0x7664,
	0x784B, 0xFFFE, 0x784C, 0x7978, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B66, 0xFFFE, 0xFFFE, 0xFFFE, 0x4668, 0xFFFE, 0x565C, 0x5B7B,
	0xFFFE, 0x4669, 0xFFFE, 0x455E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B2B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E74,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E76, 0xFFFE, 0xFFFE,
	0x4E73, 0x4E72, 0xFFFE, 0x4E75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5245, 0x5248, 0xFFFE, 0xFFFE, 0xFFFE, 0x5242,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5244, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5247, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5243, 0xFFFE, 0xFFFE, 0x5246, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5662, 0xFFFE,
	0x5660, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5661, 0xFFFE, 0xFFFE, 0x565D, 0x565F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C22, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_74 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B7E, 0xFFFE, 0x5B7C, 0x5C21, 0xFFFE,
	0xFFFE, 0x565E, 0x5B7D, 0xFFFE, 0xFFFE, 0x5C23, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6066, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6060, 0xFFFE, 0xFFFE, 0x6061, 0x6067, 0xFFFE,
	0x6068, 0xFFFE, 0x605E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6065,
	0xFFFE, 0xFFFE, 0xFFFE, 0x605F, 0x6064, 0x6062, 0x6063, 0xFFFE,
	0xFFFE, 0xFFFE, 0x605D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6531,
	0xFFFE, 0x6530, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x652D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6532, 0x652C, 0x6533, 0x6534, 0xFFFE, 0x652F, 0x652E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6965, 0x6964, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D66, 0x6966, 0xFFFE, 0xFFFE, 0x6968, 0xFFFE, 0x652B,
	0x6967, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D69, 0xFFFE,
	0x6D6A, 0xFFFE, 0xFFFE, 0x6D68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7144, 0xFFFE, 0xFFFE, 0xFFFE, 0x7142, 0xFFFE, 0x7146, 0x7145,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7143, 0xFFFE, 0xFFFE, 0x7440, 0x7666,
	0x7441, 0x743E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x743F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x784D, 0xFFFE, 0x7667,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x784E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7979,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A78, 0xFFFE, 0x7A77, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C3C, 0xFFFE, 0x466A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C24, 0xFFFE, 0x7147, 0x784F, 0x7B67, 0xFFFE, 0x466B, 0xFFFE,
	0xFFFE, 0x2322, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C25, 0x5C26,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_75 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6969, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7148, 0x7149, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7668, 0xFFFE, 0xFFFE,
	0x466C, 0xFFFE, 0x5249, 0xFFFE, 0x5C27, 0xFFFE, 0xFFFE, 0x466D,
	0xFFFE, 0xFFFE, 0x5C28, 0xFFFE, 0xFFFE, 0x6069, 0x606A, 0xFFFE,
	0x466E, 0x466F, 0xFFFE, 0x4B2D, 0x4B2C, 0x524A, 0xFFFE, 0xFFFE,
	0x4670, 0x4671, 0x4672, 0x4673, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B2E,
	0x4B2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E77, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x524E, 0x524C, 0xFFFE, 0x524D, 0x524B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5663, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5667, 0x5666, 0xFFFE, 0x5665, 0x5664, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C2B, 0xFFFE, 0xFFFE, 0x5C29, 0x5C2A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x606C, 0x606B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6535, 0xFFFE,
	0x6536, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D6B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7851, 0x7850,
	0xFFFE, 0xFFFE, 0x7B68, 0x4674, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C2D,
	0xFFFE, 0x696A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E79, 0x4E7A, 0xFFFE, 0xFFFE, 0x4E78, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5252, 0x5253, 0x5250, 0x5251, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x524F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x566B, 0x566C, 0xFFFE, 0x5C30, 0xFFFE, 0xFFFE,
	0x5671, 0x566F, 0xFFFE, 0xFFFE, 0x566E, 0x566D, 0x5668, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5670, 0xFFFE, 0xFFFE, 0x5669, 0xFFFE, 0x566A,
	0xFFFE, 0xFFFE, 0x5C31, 0xFFFE, 0xFFFE, 0x5C32, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C2E, 0x5C2F, 0xFFFE, 0xFFFE,
	0x6071, 0x6070, 0xFFFE, 0x606E, 0xFFFE, 0xFFFE, 0x6072, 0xFFFE,
	0x6073, 0xFFFE, 0x606D, 0x606F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6538, 0x653B, 0x653A, 0x653F, 0x653E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x653C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x653D
} };

static const iconv_ccs_convtable_8bit from_ucs_76 = { {
	0x6537, 0x6539, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x696E, 0xFFFE, 0x696D, 0xFFFE, 0x696C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x696F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D6E,
	0x6D6C, 0x6D71, 0x6D72, 0xFFFE, 0x6D6F, 0xFFFE, 0x6D70, 0x696B,
	0xFFFE, 0x6D6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x714A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x714B, 0xFFFE, 0x714C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7443, 0xFFFE, 0xFFFE, 0xFFFE, 0x7442, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7444, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x766B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7669, 0xFFFE,
	0x766A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7852,
	0xFFFE, 0x7853, 0x797A, 0xFFFE, 0xFFFE, 0x797B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A79, 0xFFFE, 0xFFFE, 0x7B6A, 0xFFFE, 0x7B69, 0xFFFE,
	0xFFFE, 0x7C61, 0x7C62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5254, 0xFFFE, 0xFFFE, 0x6074, 0x6075, 0x4675, 0x484B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B30, 0xFFFE, 0x4E7B, 0xFFFE, 0x5255, 0x5256,
	0x5257, 0xFFFE, 0xFFFE, 0x5672, 0xFFFE, 0xFFFE, 0x5C33, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6077, 0xFFFE, 0xFFFE, 0x6076, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4676, 0xFFFE,
	0x5673, 0xFFFE, 0xFFFE, 0xFFFE, 0x6078, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4677,
	0xFFFE, 0xFFFE, 0x4E7C, 0x525A, 0xFFFE, 0x525B, 0x5259, 0xFFFE,
	0x5258, 0xFFFE, 0x5674, 0xFFFE, 0xFFFE, 0x5675, 0x5676, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C35, 0xFFFE, 0x5C34, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C36, 0x6079, 0xFFFE, 0x6540, 0x6541,
	0xFFFE, 0x6970, 0xFFFE, 0x6971, 0x6D75, 0x714E, 0xFFFE, 0x714D,
	0xFFFE, 0xFFFE, 0x7445, 0xFFFE, 0xFFFE, 0xFFFE, 0x4678, 0x4B31,
	0xFFFE, 0xFFFE, 0x4E7D, 0xFFFE, 0x4E7E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x525E, 0x525D, 0xFFFE, 0xFFFE, 0x5262, 0xFFFE, 0x5261, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_77 = { {
	0xFFFE, 0x525C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5263,
	0xFFFE, 0x525F, 0xFFFE, 0x5260, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5678,
	0x5679, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x567A, 0x5677, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C3A, 0x5C37,
	0x5C3B, 0xFFFE, 0x5C3C, 0xFFFE, 0x5C39, 0xFFFE, 0x5C38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x607A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6542, 0x654A, 0xFFFE, 0x6545, 0xFFFE,
	0xFFFE, 0x6975, 0x654D, 0x6546, 0xFFFE, 0x654B, 0x6544, 0xFFFE,
	0x654C, 0xFFFE, 0x6548, 0x6543, 0x6549, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6547, 0xFFFE, 0xFFFE, 0xFFFE, 0x6973, 0xFFFE, 0x6974,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6972, 0xFFFE, 0xFFFE, 0x6D77,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D7A, 0x6D78, 0xFFFE, 0x6D76, 0xFFFE,
	0xFFFE, 0x6D79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7150, 0x7151,
	0x714F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7152, 0xFFFE, 0x744A,
	0xFFFE, 0xFFFE, 0x7447, 0xFFFE, 0x7449, 0x744B, 0xFFFE, 0xFFFE,
	0x7448, 0xFFFE, 0xFFFE, 0x7446, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x766E, 0x766F, 0x766C, 0xFFFE, 0x766D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7854,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A7A, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C63,
	0xFFFE, 0xFFFE, 0x7D33, 0x4679, 0x5264, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x467A, 0x4B32, 0xFFFE, 0x4F21, 0xFFFE, 0xFFFE,
	0xFFFE, 0x567B, 0xFFFE, 0xFFFE, 0xFFFE, 0x607B, 0x654E, 0x744C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x467B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F22, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_78 = { {
	0xFFFE, 0xFFFE, 0x5265, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5267, 0x5268, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5266, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5721, 0xFFFE, 0x5727,
	0x5726, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5724, 0xFFFE, 0x567D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5725, 0xFFFE, 0xFFFE,
	0x567C, 0xFFFE, 0x5728, 0xFFFE, 0x5722, 0xFFFE, 0xFFFE, 0x5723,
	0x567E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C3F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x607C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C3D, 0x607D, 0xFFFE, 0xFFFE, 0x607E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6555, 0xFFFE, 0xFFFE, 0x6558,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6554, 0xFFFE, 0xFFFE, 0x6553, 0xFFFE, 0x654F, 0xFFFE,
	0xFFFE, 0x6556, 0xFFFE, 0x6557, 0xFFFE, 0xFFFE, 0xFFFE, 0x6551,
	0x6552, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6977,
	0xFFFE, 0xFFFE, 0xFFFE, 0x697B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6978,
	0xFFFE, 0x697A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6550, 0xFFFE, 0xFFFE, 0x6979, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D7D, 0xFFFE, 0x6E23, 0xFFFE, 0x6E21, 0xFFFE,
	0xFFFE, 0x6976, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D7C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D7E, 0x6D7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E22, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7154, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7156,
	0x7153, 0xFFFE, 0xFFFE, 0xFFFE, 0x7155, 0xFFFE, 0xFFFE, 0x7450,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x744F, 0xFFFE, 0xFFFE, 0x744D,
	0xFFFE, 0xFFFE, 0x744E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_79 = { {
	0xFFFE, 0x7451, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7670, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7855, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x797C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x797D, 0x7A21, 0x797E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x467C, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F23, 0xFFFE,
	0x4F24, 0x4F25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5269, 0x526C,
	0x526B, 0x526A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x572A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5729, 0x572D, 0x5730,
	0xFFFE, 0xFFFE, 0x5731, 0xFFFE, 0xFFFE, 0x572F, 0x572E, 0x572C,
	0x572B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C40, 0xFFFE, 0xFFFE,
	0x5C41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C42, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6559, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x655A,
	0xFFFE, 0x655B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x697E, 0x697C, 0x697D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7157, 0x7452,
	0xFFFE, 0xFFFE, 0x7453, 0xFFFE, 0xFFFE, 0xFFFE, 0x7671, 0xFFFE,
	0xFFFE, 0x7856, 0xFFFE, 0x7B6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x526D, 0x526E, 0xFFFE, 0xFFFE, 0x655D, 0x467D, 0x4B35,
	0x4B34, 0x4B33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F27, 0x4F26, 0xFFFE, 0x5271, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x526F, 0x5270, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5738, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5735,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5733, 0x5732, 0xFFFE, 0x5736, 0x5734,
	0xFFFE, 0x5737, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7A = { {
	0x6125, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6124, 0xFFFE, 0xFFFE,
	0x6122, 0xFFFE, 0xFFFE, 0x6123, 0xFFFE, 0x6121, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6561, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x655F, 0xFFFE, 0x655E, 0xFFFE, 0x6563, 0x6562,
	0x6560, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A21, 0xFFFE,
	0xFFFE, 0x6A22, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E29,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6E2A, 0x6E26, 0x6E28, 0xFFFE, 0x6E25,
	0x6E27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x715A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x715C, 0x715B, 0x7158, 0x7159, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7454,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7674, 0x7672, 0x7673, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7858, 0xFFFE, 0x7857, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x467E, 0xFFFE, 0x4B36, 0xFFFE,
	0xFFFE, 0x4F29, 0x4F28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5272,
	0xFFFE, 0x5273, 0xFFFE, 0xFFFE, 0x5739, 0xFFFE, 0xFFFE, 0xFFFE,
	0x573A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C44, 0xFFFE, 0xFFFE, 0x5C45, 0x6128, 0x6127,
	0x6126, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6564,
	0x6565, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A24, 0x6A23, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E2C, 0x6E2B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x715D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7455,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7675, 0x7676, 0xFFFE, 0x7A22,
	0xFFFE, 0xFFFE, 0x7C3D, 0x4721, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x573B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D7E,
	0x5D7D, 0xFFFE, 0xFFFE, 0x612A, 0xFFFE, 0x6129, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A25, 0xFFFE, 0x6A26,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A23, 0xFFFE,
	0xFFFE, 0x484C, 0x4F2A, 0xFFFE, 0xFFFE, 0x5275, 0xFFFE, 0x5274
} };

static const iconv_ccs_convtable_8bit from_ucs_7B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x573C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x573D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C4B, 0xFFFE, 0x5C48, 0xFFFE, 0xFFFE, 0x5C4C, 0xFFFE,
	0x5C46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C4A, 0xFFFE,
	0x5C47, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C49, 0xFFFE, 0x5C4D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x612D, 0xFFFE,
	0xFFFE, 0x612B, 0xFFFE, 0x6132, 0xFFFE, 0x6131, 0xFFFE, 0x6133,
	0x612E, 0x6134, 0x612F, 0xFFFE, 0x6130, 0xFFFE, 0x612C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6568, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x656A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6569, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A2A, 0xFFFE, 0x6566,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A31, 0xFFFE, 0xFFFE, 0x6A30,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6A29, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A2D, 0x6A28, 0xFFFE, 0x6A2B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A2C, 0xFFFE, 0xFFFE,
	0x6E34, 0x6A27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E2D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E2E, 0xFFFE, 0xFFFE, 0x6E30, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6567, 0x6E33, 0xFFFE, 0xFFFE, 0x6E2F, 0xFFFE, 0x6E31, 0x6E32,
	0xFFFE, 0x7160, 0xFFFE, 0xFFFE, 0x6E35, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x715E, 0xFFFE, 0x7162, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x745B, 0x7163, 0xFFFE, 0xFFFE, 0x7161, 0xFFFE, 0x7165, 0xFFFE,
	0xFFFE, 0x7164, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7459,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7458, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7456,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x745A, 0x7457, 0xFFFE, 0xFFFE,
	0xFFFE, 0x715F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x767A, 0xFFFE,
	0xFFFE, 0x767C, 0xFFFE, 0x767B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7678,
	0xFFFE, 0xFFFE, 0x7679, 0x7677, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x785D,
	0x785B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x785C, 0x7859, 0x785A,
	0x785E, 0xFFFE, 0xFFFE, 0x7A25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A24, 0x7A26, 0xFFFE, 0xFFFE,
	0x7A7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B6D,
	0x7B6C, 0xFFFE, 0xFFFE, 0x7C3F, 0x7C3E, 0x7C40, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D25, 0xFFFE, 0x7D26, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D4B, 0x484D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5276, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x573E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C4E, 0xFFFE, 0xFFFE, 0x5C50, 0xFFFE, 0x5C4F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6135,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6136, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x656B, 0xFFFE, 0x656C, 0xFFFE, 0x656D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A32, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A33, 0x6A34, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6E36, 0xFFFE, 0xFFFE, 0xFFFE, 0x2323, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7166, 0x7167, 0xFFFE,
	0xFFFE, 0x7461, 0xFFFE, 0xFFFE, 0x745D, 0x7462, 0x745E, 0x7460,
	0x745C, 0xFFFE, 0x745F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x767D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A27,
	0x7A28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x484E, 0xFFFE, 0xFFFE, 0x4B37, 0xFFFE, 0xFFFE, 0x4F2B, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7D = { {
	0x5279, 0xFFFE, 0x5277, 0xFFFE, 0x527C, 0x5278, 0x527D, 0x527B,
	0xFFFE, 0x527A, 0x5742, 0x5741, 0xFFFE, 0x574A, 0xFFFE, 0xFFFE,
	0x5746, 0xFFFE, 0xFFFE, 0xFFFE, 0x5745, 0x5747, 0xFFFE, 0x5740,
	0xFFFE, 0x574B, 0x5748, 0x574C, 0x5749, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5743, 0x573F, 0x5744, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x613B, 0xFFFE, 0xFFFE, 0x5C54, 0x5C5B,
	0x5C58, 0x5C5E, 0x5C5D, 0x5C59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C55, 0xFFFE, 0xFFFE, 0x5C56, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C57, 0xFFFE, 0x5C5C, 0x5C52, 0x5C5A, 0xFFFE, 0x5C51, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6138, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x613A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6573, 0xFFFE, 0xFFFE, 0x6137, 0xFFFE,
	0xFFFE, 0x613E, 0x6140, 0xFFFE, 0xFFFE, 0xFFFE, 0x613F, 0xFFFE,
	0x6139, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x613C, 0xFFFE,
	0x6141, 0x5C53, 0x613D, 0x6142, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x656F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6571, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6572,
	0xFFFE, 0x6570, 0xFFFE, 0x656E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A37, 0xFFFE, 0x6E43, 0xFFFE,
	0x6A3A, 0xFFFE, 0x6A40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A47, 0x6A44, 0xFFFE, 0xFFFE,
	0x6A36, 0x6A3E, 0x6A3D, 0xFFFE, 0x6A3C, 0x6A42, 0xFFFE, 0xFFFE,
	0x6A43, 0xFFFE, 0x6A3F, 0x6A35, 0xFFFE, 0x6A38, 0x6A39, 0x6A41,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A46,
	0xFFFE, 0xFFFE, 0x6A3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E3B, 0x6E44, 0x6E40, 0xFFFE, 0xFFFE, 0x6E3D, 0x6E41, 0xFFFE,
	0x6E37, 0xFFFE, 0xFFFE, 0x6E3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E3E, 0x6E42, 0xFFFE, 0xFFFE, 0x6E3C, 0xFFFE, 0xFFFE, 0x6E39,
	0xFFFE, 0xFFFE, 0x6E45, 0xFFFE, 0x6E38, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E46, 0xFFFE, 0x6E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x716A, 0x716F, 0x7168, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7170, 0x7169, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x716B, 0xFFFE, 0x716E, 0x716D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x716C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7469, 0xFFFE, 0xFFFE, 0x7463, 0x7473,
	0xFFFE, 0x746B, 0x7467, 0xFFFE, 0x746E, 0x7471, 0xFFFE, 0x7466,
	0xFFFE, 0x746F, 0xFFFE, 0xFFFE, 0xFFFE, 0x746A, 0x7464, 0x7472,
	0xFFFE, 0x746D, 0xFFFE, 0x7468, 0xFFFE, 0x746C, 0x7465, 0xFFFE,
	0x7470, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7725, 0xFFFE, 0x767E, 0x7721, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7726, 0x7723, 0xFFFE, 0xFFFE, 0xFFFE, 0x7722, 0xFFFE,
	0xFFFE, 0x7724, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7862, 0x7863, 0x785F, 0xFFFE, 0x7860, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7864, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7861, 0xFFFE, 0xFFFE, 0x7A2B, 0x7A2A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7A2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A7D, 0xFFFE, 0xFFFE, 0x7A7C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C41, 0x7C43, 0xFFFE, 0x7C42, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D39, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x484F, 0xFFFE,
	0x527E, 0xFFFE, 0x574D, 0xFFFE, 0xFFFE, 0x5C5F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7474, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7727, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A2D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C64, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F2C, 0x4B38, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x574E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6575, 0x6576, 0xFFFE, 0xFFFE, 0xFFFE, 0x6574, 0xFFFE,
	0x6A48, 0xFFFE, 0x6577, 0xFFFE, 0xFFFE, 0x6E47, 0xFFFE, 0x6E48,
	0xFFFE, 0x7171, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7865, 0xFFFE, 0xFFFE,
	0x7C65, 0xFFFE, 0x4850, 0x4F2E, 0x4F2D, 0xFFFE, 0x5321, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x574F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C61, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C60, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x657A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6579, 0x6578, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E49,
	0xFFFE, 0xFFFE, 0x7172, 0xFFFE, 0xFFFE, 0xFFFE, 0x7866, 0xFFFE,
	0x7868, 0x7867, 0xFFFE, 0xFFFE, 0x7A7E, 0x4851, 0xFFFE, 0x5322,
	0xFFFE, 0x5751, 0xFFFE, 0xFFFE, 0xFFFE, 0x5750, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C62, 0xFFFE, 0x5C63, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C64, 0xFFFE, 0x6144, 0x6145, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A4B,
	0x6A49, 0x6A4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7175, 0xFFFE,
	0x7173, 0x7174, 0xFFFE, 0x7475, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7728, 0xFFFE, 0x7729, 0x7476, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_80 = { {
	0x7A2E, 0x4852, 0xFFFE, 0x4853, 0x5753, 0x4F2F, 0x5752, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6146, 0x4854, 0x5324, 0xFFFE, 0xFFFE,
	0x5323, 0x5325, 0x4855, 0xFFFE, 0xFFFE, 0x5755, 0xFFFE, 0x5757,
	0x5754, 0x5756, 0xFFFE, 0xFFFE, 0x5C65, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E4B, 0xFFFE,
	0x7176, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4856, 0xFFFE, 0xFFFE, 0x5326, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5758, 0xFFFE, 0x5759,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C67, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6147, 0xFFFE, 0xFFFE, 0xFFFE, 0x657B, 0xFFFE,
	0x657C, 0xFFFE, 0x6A4D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x747A,
	0x7479, 0x7477, 0x7478, 0x747B, 0xFFFE, 0xFFFE, 0x772B, 0x772A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B6F, 0x7B6E, 0x4857,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x657E, 0x6148, 0x657D, 0x6A4E,
	0xFFFE, 0x4858, 0xFFFE, 0x4859, 0x485A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B3A, 0xFFFE, 0xFFFE, 0x4B39, 0xFFFE,
	0x4B3C, 0xFFFE, 0x4B3E, 0x4B3D, 0xFFFE, 0x4B3B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F34, 0x4F32, 0xFFFE, 0xFFFE, 0x4F31, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F36, 0x4F38, 0x4F35, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F39,
	0xFFFE, 0x4F33, 0x4B3F, 0xFFFE, 0x4F37, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x532A, 0x532B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x532C, 0xFFFE, 0x532F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5327, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5329, 0x532E, 0xFFFE, 0x5332, 0x5330, 0xFFFE,
	0xFFFE, 0x532D, 0xFFFE, 0xFFFE, 0x5331, 0x5328, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x575E, 0xFFFE, 0x5767,
	0x575C, 0x575A, 0xFFFE, 0x5762, 0x575F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5761, 0xFFFE, 0xFFFE, 0xFFFE, 0x5766, 0x5764, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_81 = { {
	0xFFFE, 0xFFFE, 0x575B, 0xFFFE, 0xFFFE, 0x575D, 0x5760, 0xFFFE,
	0x5763, 0xFFFE, 0x5765, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C69, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C6A, 0x5C6E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C6C, 0xFFFE, 0x5C6B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C68,
	0x5C6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x614E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6150, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x614F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x614B, 0x6151, 0xFFFE, 0x614D, 0xFFFE,
	0x6A4F, 0x614C, 0xFFFE, 0x6152, 0x614A, 0x6149, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6624, 0x662A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6627, 0xFFFE, 0xFFFE, 0x6625, 0xFFFE,
	0x6622, 0x6621, 0xFFFE, 0x6626, 0x6153, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6623, 0x6628, 0x6629, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A54,
	0x6A50, 0xFFFE, 0x6A55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A52, 0xFFFE, 0x6A53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A51,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E51, 0xFFFE, 0x6E50, 0x6E4C, 0x6E4D, 0x6E4E, 0xFFFE, 0xFFFE,
	0x6E4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7179, 0x7178, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7177, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x747E, 0xFFFE, 0xFFFE, 0x7524, 0x7526, 0x7523,
	0x7522, 0xFFFE, 0x7521, 0x747D, 0xFFFE, 0xFFFE, 0x747C, 0xFFFE,
	0xFFFE, 0x7525, 0xFFFE, 0xFFFE, 0xFFFE, 0x772C, 0xFFFE, 0x772D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7869, 0xFFFE, 0x7A2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B70,
	0xFFFE, 0xFFFE, 0x7C44, 0x485B, 0xFFFE, 0x4F3A, 0xFFFE, 0x6A56,
	0x7527, 0xFFFE, 0x485C, 0xFFFE, 0x5769, 0x5768, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x485D, 0x5333, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A57, 0x717A, 0x485E, 0xFFFE, 0x4F3B, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_82 = { {
	0x576A, 0xFFFE, 0x5C6F, 0xFFFE, 0xFFFE, 0x662B, 0xFFFE, 0x6A58,
	0x717B, 0x7528, 0x772E, 0xFFFE, 0x485F, 0x4F3C, 0xFFFE, 0xFFFE,
	0x576B, 0xFFFE, 0x6154, 0xFFFE, 0x6A59, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4860, 0x6155, 0xFFFE, 0x6A5A, 0x4861,
	0xFFFE, 0xFFFE, 0x5334, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x576E, 0xFFFE, 0x576C, 0x576D, 0x576F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C70, 0x5C72, 0x5C71,
	0xFFFE, 0x5C73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x662C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6A5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x717C, 0x717D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A30, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4862, 0x4B40,
	0xFFFE, 0x7529, 0x4863, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4864, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B42, 0xFFFE, 0x4B43, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F3F, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F3E, 0xFFFE, 0x4F42,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F49, 0xFFFE, 0x4F46, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F45, 0x4F40, 0xFFFE, 0x4F47,
	0x4F4A, 0x4F44, 0xFFFE, 0x4F3D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F4C,
	0x4F48, 0x4F43, 0xFFFE, 0x5770, 0xFFFE, 0x4F41, 0x4F4B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5345, 0x533F, 0x5347, 0x5344, 0xFFFE, 0xFFFE, 0x5340,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5339, 0x5343, 0xFFFE, 0x5346, 0x5348,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5338, 0xFFFE, 0x533C, 0x533A, 0x5335,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5349,
	0xFFFE, 0x5341, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_83 = { {
	0xFFFE, 0x5342, 0x533D, 0x5336, 0x533B, 0x5337, 0x534A, 0xFFFE,
	0xFFFE, 0x533E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x577E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5823, 0xFFFE, 0xFFFE, 0x5771, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5822, 0x577B, 0xFFFE, 0x5779, 0x5778, 0x577D, 0xFFFE,
	0x5775, 0x577C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5821, 0xFFFE, 0xFFFE, 0x5824, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5777, 0x5774, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x577A,
	0x5776, 0xFFFE, 0x5772, 0xFFFE, 0x5773, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D23,
	0x5C77, 0xFFFE, 0xFFFE, 0x5D24, 0x5D25, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D26, 0xFFFE,
	0xFFFE, 0x5D21, 0x5C7D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C74, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C7C, 0x5C7E, 0xFFFE, 0xFFFE, 0x5C79, 0xFFFE,
	0x5C76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C75, 0xFFFE,
	0x5D22, 0xFFFE, 0x5C78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D27,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C7A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x615D, 0xFFFE, 0xFFFE, 0xFFFE, 0x615B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6168, 0xFFFE, 0x6165, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x616E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x616C, 0xFFFE, 0xFFFE, 0x616F,
	0x615A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6156, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x615E,
	0x6163, 0x615F, 0x6167, 0xFFFE, 0x6160, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6158, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6166, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_84 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x6157, 0x616B, 0xFFFE, 0xFFFE, 0x616D,
	0xFFFE, 0xFFFE, 0x6162, 0x615C, 0x6164, 0x6159, 0x616A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x655C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6630, 0xFFFE, 0xFFFE, 0xFFFE, 0x6638, 0xFFFE, 0xFFFE,
	0x6169, 0xFFFE, 0xFFFE, 0xFFFE, 0x6637, 0x662F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x663D, 0xFFFE,
	0xFFFE, 0x6634, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6161,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6636, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6639, 0xFFFE, 0x663A, 0xFFFE, 0xFFFE, 0x6632, 0xFFFE,
	0xFFFE, 0x663B, 0xFFFE, 0x6633, 0x6635, 0x663C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6631, 0xFFFE, 0x662E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x662D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A60, 0xFFFE, 0xFFFE, 0x6A63, 0xFFFE, 0x6A61, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A65, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A69, 0xFFFE, 0xFFFE, 0x6A5D,
	0x6A66, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A5F, 0xFFFE, 0x6A5E, 0xFFFE,
	0xFFFE, 0x6A5C, 0x6A6B, 0x6A64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A6A, 0xFFFE, 0x6A67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E5D, 0xFFFE, 0x6E55, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E5F
} };

static const iconv_ccs_convtable_8bit from_ucs_85 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E60, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E59, 0xFFFE, 0x6E58, 0x6E5C, 0xFFFE, 0xFFFE, 0x6E52,
	0xFFFE, 0xFFFE, 0x6E54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E5B, 0xFFFE, 0x6E5A, 0xFFFE, 0x6E5E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E56, 0x6E57, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E53, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7225, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7222, 0x7226, 0x717E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7229, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7223, 0x7224, 0x7228, 0xFFFE, 0xFFFE, 0x7227, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x752C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x752B, 0xFFFE, 0xFFFE, 0x7532,
	0xFFFE, 0xFFFE, 0x7534, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x752E, 0xFFFE, 0xFFFE, 0x752F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7531, 0x752D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7535, 0xFFFE,
	0x7533, 0x7730, 0x752A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7530,
	0x7734, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7736, 0x7735, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7733, 0xFFFE, 0xFFFE, 0xFFFE, 0x7731, 0xFFFE, 0x772F,
	0x7732, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x786D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x786B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x786E, 0x786F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x786A, 0x786C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7870,
	0xFFFE, 0x7A32, 0x7A34, 0x7A31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_86 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A35, 0x7A37,
	0xFFFE, 0xFFFE, 0x7A38, 0x7A36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B21,
	0xFFFE, 0xFFFE, 0x7B23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B22, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C46,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F4D, 0xFFFE,
	0x534B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5825, 0x5D28, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6170, 0x663F, 0xFFFE, 0x663E, 0x6640,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7536,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4865, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x534C, 0x534E, 0x534D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5826, 0xFFFE, 0x582B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5828, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x582D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x582C, 0x5829, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x582A, 0x5827, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D32,
	0xFFFE, 0x5D31, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D2E, 0x5D2C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D2B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D2D, 0xFFFE, 0x5D2F, 0x5D2A,
	0xFFFE, 0x5D33, 0xFFFE, 0x5D30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6177, 0xFFFE, 0xFFFE, 0xFFFE, 0x6174, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6172, 0xFFFE, 0x6175, 0xFFFE, 0xFFFE, 0x6178, 0x6171,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6176, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6173, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6641, 0xFFFE, 0x6647, 0xFFFE, 0xFFFE, 0x6646, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_87 = { {
	0x6645, 0xFFFE, 0x6648, 0x6649, 0xFFFE, 0xFFFE, 0x664A, 0x6644,
	0x6643, 0xFFFE, 0x664B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6642, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A72, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A6D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A6F, 0xFFFE, 0xFFFE, 0x6A70, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A71, 0xFFFE, 0xFFFE, 0x6A74,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6A6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E6A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6E6B, 0xFFFE, 0x6A73, 0xFFFE, 0x6E69,
	0xFFFE, 0x6E68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E65, 0xFFFE,
	0x6E67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E62, 0xFFFE, 0x6E63, 0xFFFE,
	0x6E66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6E61, 0x722A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x722E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x722C, 0x722B,
	0xFFFE, 0xFFFE, 0x722D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x753C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7539, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x753E, 0x753D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7537, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x753B, 0xFFFE,
	0x753F, 0xFFFE, 0xFFFE, 0x7540, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7538, 0x753A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x773A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7738, 0xFFFE, 0xFFFE, 0x7737,
	0xFFFE, 0xFFFE, 0x7739, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7874, 0xFFFE, 0x7871, 0xFFFE, 0xFFFE, 0x7875, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_88 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7872, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7873, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A39, 0x7A3A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B27,
	0xFFFE, 0x7B26, 0x7B25, 0x7B24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C66, 0xFFFE,
	0xFFFE, 0x7C67, 0xFFFE, 0x7D27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4866, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4867, 0x534F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D34, 0xFFFE, 0xFFFE, 0xFFFE, 0x6179,
	0xFFFE, 0x664C, 0xFFFE, 0x6E6C, 0xFFFE, 0x6E6D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x722F, 0x7C68, 0x4868, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F50, 0xFFFE, 0xFFFE, 0x5350, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x582E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x582F,
	0xFFFE, 0x5833, 0xFFFE, 0xFFFE, 0xFFFE, 0x5832, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5830, 0x5831, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D36, 0xFFFE, 0xFFFE, 0x5D3B, 0xFFFE, 0x5D3A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D38, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D39, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D35, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x617C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x617A, 0x617B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6654, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6656, 0xFFFE, 0x664E, 0x6655, 0xFFFE, 0xFFFE,
	0x6651, 0x664F, 0xFFFE, 0xFFFE, 0x6650, 0x6652, 0xFFFE, 0x664D,
	0xFFFE, 0x6653, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6A76, 0x6A78, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A7A, 0x6A79, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A7B, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_89 = { {
	0xFFFE, 0xFFFE, 0x6A77, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E6F,
	0xFFFE, 0xFFFE, 0x6E73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6E6E, 0xFFFE, 0x6E70, 0x6E71, 0xFFFE, 0x6E72, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7234, 0xFFFE, 0xFFFE, 0xFFFE, 0x7232, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7230, 0x7233, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7231, 0xFFFE, 0xFFFE, 0xFFFE, 0x7542, 0xFFFE,
	0x7544, 0xFFFE, 0xFFFE, 0x7541, 0xFFFE, 0x7545, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7543, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7878, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7879, 0x7877,
	0x7876, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A3B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B28, 0xFFFE, 0x7B29, 0xFFFE, 0xFFFE, 0x7B72,
	0xFFFE, 0xFFFE, 0x7B71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4869,
	0xFFFE, 0x5351, 0xFFFE, 0x617D, 0xFFFE, 0xFFFE, 0x773B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B44, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D3D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D3C, 0xFFFE, 0xFFFE, 0x617E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6657, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7236, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7235, 0xFFFE, 0x7546, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x773C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7A3C, 0xFFFE, 0xFFFE, 0x7B2A, 0xFFFE, 0xFFFE,
	0x7D28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B45, 0xFFFE, 0x5352, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6658, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x773D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A3D, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B73, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8A = { {
	0x4B46, 0xFFFE, 0x5354, 0x5355, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5353, 0xFFFE, 0x5839, 0xFFFE, 0x5837, 0xFFFE, 0x5836, 0x583D,
	0x5835, 0x583E, 0xFFFE, 0x583B, 0xFFFE, 0x5838, 0x583C, 0x583A,
	0x5834, 0xFFFE, 0xFFFE, 0x5D45, 0xFFFE, 0x5D3F, 0xFFFE, 0x5D44,
	0xFFFE, 0xFFFE, 0x5D46, 0x5D40, 0xFFFE, 0x5D41, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D3E, 0xFFFE, 0xFFFE, 0x5D43, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D42, 0xFFFE, 0xFFFE, 0x622B, 0xFFFE, 0x622D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x622C, 0x6221, 0x6225, 0xFFFE, 0x666B, 0xFFFE,
	0xFFFE, 0x6226, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x622A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6229, 0xFFFE, 0xFFFE, 0xFFFE, 0x6227, 0x6223, 0x622E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6228, 0xFFFE, 0xFFFE, 0x6224, 0xFFFE,
	0x6222, 0xFFFE, 0x6666, 0x6661, 0xFFFE, 0xFFFE, 0x665C, 0xFFFE,
	0x666C, 0x665D, 0xFFFE, 0x6659, 0x6668, 0x6665, 0x6667, 0xFFFE,
	0x665E, 0x6663, 0x665A, 0x665B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6669, 0xFFFE, 0x666A, 0x6660, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6664, 0xFFFE, 0x665F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B22, 0x6B25, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B2D, 0xFFFE, 0x6B27, 0xFFFE, 0x6E78, 0xFFFE, 0xFFFE,
	0x6B2C, 0xFFFE, 0x6B2E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B23, 0xFFFE,
	0x6662, 0x6B26, 0xFFFE, 0x6B24, 0x6B28, 0x6B2A, 0x6B21, 0x6B2F,
	0x6B2B, 0xFFFE, 0x6B29, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F21, 0xFFFE, 0x6E7B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F24, 0xFFFE,
	0xFFFE, 0x6F25, 0xFFFE, 0xFFFE, 0x6E74, 0xFFFE, 0xFFFE, 0x6E7E,
	0xFFFE, 0xFFFE, 0x6E7D, 0xFFFE, 0x6E77, 0xFFFE, 0xFFFE, 0x6E76,
	0xFFFE, 0x6E7C, 0xFFFE, 0x6E79, 0xFFFE, 0x6F23, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6E75, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F22, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F26, 0x723C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7237, 0x723D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7239, 0xFFFE, 0x7243, 0x723E, 0xFFFE,
	0xFFFE, 0x723A, 0xFFFE, 0x7244, 0xFFFE, 0xFFFE, 0x7245, 0x7242,
	0x6E7A, 0xFFFE, 0x7238, 0xFFFE, 0x7246, 0xFFFE, 0x723F, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8B = { {
	0x723B, 0x7240, 0x7241, 0xFFFE, 0x754E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x754B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7547, 0xFFFE,
	0x754F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7548,
	0xFFFE, 0x7549, 0xFFFE, 0x754A, 0xFFFE, 0x754D, 0xFFFE, 0xFFFE,
	0x754C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x773E, 0xFFFE, 0xFFFE, 0x7741, 0x7740, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x773F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x787A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7923, 0xFFFE,
	0xFFFE, 0x787D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7921, 0x7922,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x787C, 0x7924, 0x787E, 0xFFFE, 0x787B, 0xFFFE, 0xFFFE, 0x7A42,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A40, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A43, 0x7A3F, 0xFFFE, 0xFFFE, 0x7A41,
	0x7A3E, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B2B, 0xFFFE, 0xFFFE, 0x7B2C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B2D, 0xFFFE, 0xFFFE,
	0x7B74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C6A, 0x7C69, 0xFFFE, 0xFFFE, 0x7C6B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D34, 0xFFFE, 0x7D3A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B47,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7551,
	0xFFFE, 0x7550, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B48, 0xFFFE,
	0x583F, 0x5D47, 0xFFFE, 0xFFFE, 0x6F27, 0xFFFE, 0x6F28, 0xFFFE,
	0x7742, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D43, 0x4B49, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x622F, 0x666D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6B30, 0x7247, 0x6F29, 0x7248, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7552, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5841, 0x5840, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6230, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x666F, 0x666E, 0xFFFE, 0x6B32, 0x6B31, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7249, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B4A, 0x5356, 0xFFFE,
	0x5357, 0x5842, 0x5843, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D4E,
	0x5D4C, 0x5D49, 0x5D4D, 0x5D4B, 0x5D4A, 0xFFFE, 0xFFFE, 0x6231,
	0xFFFE, 0xFFFE, 0x6674, 0x6233, 0x6238, 0xFFFE, 0x623A, 0x6239,
	0x623C, 0xFFFE, 0xFFFE, 0x6236, 0x6232, 0x6234, 0xFFFE, 0x623B,
	0x6237, 0x6235, 0x6676, 0x6675, 0x6673, 0x6677, 0xFFFE, 0x6671,
	0x6672, 0xFFFE, 0x6670, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B34, 0x6B35, 0x6B33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F32, 0xFFFE, 0x6F2B, 0xFFFE,
	0x6F2A, 0x6F34, 0x6F30, 0x6F31, 0x6F2D, 0xFFFE, 0x6F2C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F33, 0xFFFE, 0x6F2E, 0x6F2F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x724A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7556, 0xFFFE, 0x7553, 0x7557, 0x7555, 0x7554, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7743, 0xFFFE, 0xFFFE,
	0x7925, 0xFFFE, 0x7926, 0xFFFE, 0xFFFE, 0x7A45, 0xFFFE, 0x7A44,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7B2E, 0xFFFE, 0xFFFE, 0x7B75, 0x7B76,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B4B, 0xFFFE, 0x5D50, 0x5D4F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B36, 0xFFFE, 0x6F35, 0xFFFE, 0xFFFE,
	0x4B4C, 0xFFFE, 0xFFFE, 0x5359, 0x5358, 0xFFFE, 0xFFFE, 0x5844,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x623F, 0xFFFE, 0xFFFE, 0xFFFE, 0x623E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x623D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B38, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F36,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7558, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B4D, 0x535A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D52, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D51, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6247, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6242, 0x6245, 0xFFFE, 0x6240, 0xFFFE,
	0xFFFE, 0x6244, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6243, 0x6246, 0xFFFE, 0x6241, 0xFFFE, 0x6679,
	0xFFFE, 0x6678, 0xFFFE, 0xFFFE, 0x6721, 0xFFFE, 0x6722, 0xFFFE,
	0x667A, 0xFFFE, 0x667E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x667B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x667C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x667D, 0xFFFE, 0x6B39, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F3C,
	0x6F39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F3A, 0x6F40, 0x6F3E,
	0xFFFE, 0x6F3F, 0x6F3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F3D, 0xFFFE, 0x6F38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x724C, 0xFFFE, 0xFFFE, 0x724D, 0x7250, 0xFFFE, 0xFFFE,
	0xFFFE, 0x724F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x724E, 0xFFFE, 0x724B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x755B, 0x7559, 0x755C, 0x755A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7749, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7744, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7748,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7745, 0x7747, 0xFFFE, 0x7746, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x792B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7928, 0xFFFE, 0x792D, 0xFFFE, 0x792A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x792C, 0xFFFE, 0x7927, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A47, 0x7A49, 0xFFFE, 0xFFFE, 0x7A48, 0xFFFE, 0x7929,
	0xFFFE, 0x7A46, 0x7B2F, 0x7B31, 0xFFFE, 0x7B30, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7B77, 0xFFFE, 0x7B78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7D29, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D3B, 0x4B4E, 0x5845, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6723, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x774A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B4F, 0x4F51, 0x535C, 0x535B, 0xFFFE, 0x5848,
	0xFFFE, 0xFFFE, 0x5846, 0xFFFE, 0x5847, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D53, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D54,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6249, 0xFFFE, 0xFFFE, 0x6248, 0x624A, 0xFFFE, 0x6726, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x6724, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6725, 0x6727, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6B3B, 0x6B3D, 0x6B3A, 0x6B3C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F43, 0x6F48, 0x6F42, 0x6F49, 0x6F44,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F4A, 0x6F46, 0xFFFE,
	0xFFFE, 0x6F45, 0x6F47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7252,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7254, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7253, 0xFFFE, 0xFFFE, 0x7251, 0xFFFE, 0xFFFE, 0x755E, 0x7561,
	0xFFFE, 0xFFFE, 0x755F, 0xFFFE, 0x755D, 0x7560, 0xFFFE, 0xFFFE,
	0xFFFE, 0x774B, 0xFFFE, 0xFFFE, 0xFFFE, 0x774C, 0x792F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x792E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B32,
	0xFFFE, 0x7B79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B50, 0x624B, 0xFFFE, 0xFFFE, 0x6728,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B3E, 0xFFFE, 0xFFFE, 0x7256, 0xFFFE,
	0x7255, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7930, 0x7A29, 0x7B33,
	0x4B51, 0x5849, 0x6729, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B52, 0xFFFE, 0x4B55, 0x4B54, 0x4B53, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F52, 0xFFFE,
	0xFFFE, 0x4F54, 0xFFFE, 0xFFFE, 0x4F53, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x535F, 0xFFFE, 0x5364, 0x5361, 0x535E, 0xFFFE,
	0x5365, 0xFFFE, 0x5360, 0x5363, 0xFFFE, 0x5362, 0xFFFE, 0xFFFE,
	0x535D, 0xFFFE, 0xFFFE, 0xFFFE, 0x584F, 0xFFFE, 0xFFFE, 0x584C,
	0x5853, 0xFFFE, 0x584E, 0xFFFE, 0xFFFE, 0x5851, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_90 = { {
	0x584D, 0x584A, 0xFFFE, 0x5850, 0xFFFE, 0x5852, 0x584B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D56, 0xFFFE, 0x5D60,
	0x5D5C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D64, 0x5D5D, 0x5D62, 0x5D58,
	0xFFFE, 0x5D55, 0x5D57, 0x5D63, 0xFFFE, 0x5D5B, 0x5D5E, 0x5D5A,
	0x5D5F, 0xFFFE, 0x5D61, 0x5D59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x624C, 0xFFFE,
	0xFFFE, 0x624E, 0x6250, 0xFFFE, 0xFFFE, 0x624D, 0x6251, 0xFFFE,
	0x624F, 0xFFFE, 0xFFFE, 0xFFFE, 0x672F, 0xFFFE, 0x6737, 0xFFFE,
	0xFFFE, 0x6738, 0x672D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6732,
	0xFFFE, 0xFFFE, 0x672B, 0x672A, 0xFFFE, 0x6735, 0x6734, 0x6733,
	0x6731, 0x6736, 0xFFFE, 0x672C, 0x672E, 0x6730, 0xFFFE, 0xFFFE,
	0x6B40, 0x6B43, 0xFFFE, 0x6B47, 0x6B41, 0x6B46, 0x6B44, 0xFFFE,
	0x6B3F, 0xFFFE, 0x6B45, 0x6B42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F4D, 0x6F4B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F4E, 0x6F4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x725A, 0xFFFE, 0x7258, 0x7257, 0xFFFE, 0x6F4F,
	0x7259, 0xFFFE, 0x725C, 0xFFFE, 0x725B, 0x7563, 0xFFFE, 0x7562,
	0x7567, 0x7565, 0x7566, 0x774E, 0x7564, 0xFFFE, 0xFFFE, 0x774D,
	0x774F, 0xFFFE, 0x7931, 0x7932, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C4A,
	0x7C49, 0x4B57, 0xFFFE, 0xFFFE, 0xFFFE, 0x5854, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B58, 0x4B5B, 0xFFFE, 0xFFFE, 0x4B5A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F57, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F55, 0x4F58, 0xFFFE,
	0x4F56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5368, 0xFFFE, 0x5369, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5366, 0xFFFE, 0xFFFE, 0xFFFE, 0x5367, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5856, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5855, 0x5857, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D66, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6253, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D67, 0x6255, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_91 = { {
	0xFFFE, 0xFFFE, 0x6252, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6254, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6739, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x673A,
	0x6B49, 0x6B48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B4A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F52,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F51, 0xFFFE, 0xFFFE,
	0x6F50, 0x6F53, 0xFFFE, 0xFFFE, 0x725D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7568, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B7A, 0x4B5C, 0x536B, 0x536A, 0x585A, 0x5859, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5858, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D68,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6256, 0xFFFE, 0x6257, 0xFFFE, 0xFFFE,
	0xFFFE, 0x673D, 0x673C, 0xFFFE, 0x673B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B4E, 0x6B4B, 0xFFFE, 0x6B4D,
	0x6B4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F57, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F54,
	0xFFFE, 0x6F55, 0xFFFE, 0x6F56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x725E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x756B, 0xFFFE, 0x756A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7569, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7750, 0x7751, 0xFFFE, 0x7934, 0xFFFE,
	0xFFFE, 0x7933, 0xFFFE, 0xFFFE, 0x7A4A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B34, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C6E, 0x7D2A, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D3C, 0x4B5D, 0x4F59,
	0xFFFE, 0x673E, 0xFFFE, 0x7A4B, 0x4B5E, 0x536C, 0x5D69, 0x6258,
	0x7752, 0x4F5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x585D,
	0x585B, 0x585F, 0xFFFE, 0xFFFE, 0x585E, 0x585C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D6C, 0xFFFE, 0xFFFE, 0x5D6B, 0x5D6D,
	0xFFFE, 0x5D6F, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D6E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D6A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_92 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6260,
	0xFFFE, 0x625C, 0xFFFE, 0xFFFE, 0xFFFE, 0x625E, 0xFFFE, 0xFFFE,
	0x625F, 0x6261, 0xFFFE, 0xFFFE, 0x6259, 0x625A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x625D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x625B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6749, 0xFFFE, 0xFFFE, 0x673F,
	0x6741, 0x674D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6742, 0x6744, 0x674E,
	0x6743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x674C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x674A, 0xFFFE, 0x6746, 0xFFFE, 0x674B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6748, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6740,
	0xFFFE, 0xFFFE, 0x674F, 0x6745, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6747, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B4F, 0xFFFE, 0xFFFE, 0x6B55, 0x6B59, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B52, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B5A, 0xFFFE, 0x6B56, 0xFFFE, 0xFFFE, 0x6B54, 0xFFFE,
	0x6B53, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B57, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B58, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B50, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F63, 0x6F5E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F5A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F59, 0x6F5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F58, 0xFFFE, 0x6F61,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F5C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7261, 0xFFFE, 0xFFFE, 0xFFFE, 0x7265, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_93 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7267, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7269, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x726C, 0xFFFE, 0xFFFE,
	0x7573, 0x726E, 0x7268, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x725F, 0x726B, 0x7264, 0xFFFE, 0xFFFE, 0xFFFE, 0x726A, 0xFFFE,
	0x756E, 0xFFFE, 0xFFFE, 0x7266, 0xFFFE, 0xFFFE, 0x726D, 0x7263,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7262, 0xFFFE, 0xFFFE, 0x7260, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7570, 0x7572, 0xFFFE, 0x756C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7579, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7578, 0x7576, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7571, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7575, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7577, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x756F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7574, 0xFFFE,
	0xFFFE, 0xFFFE, 0x756D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7754, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7753, 0xFFFE, 0x7755, 0x775D,
	0x775B, 0xFFFE, 0x775C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7756, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7759, 0xFFFE, 0x7758, 0xFFFE,
	0x775A, 0xFFFE, 0xFFFE, 0x7757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7938, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7939, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x793E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7936, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x793C, 0x7941,
	0x793F, 0xFFFE, 0xFFFE, 0xFFFE, 0x793A, 0x793B, 0xFFFE, 0x7937,
	0xFFFE, 0x7935, 0x793D, 0xFFFE, 0x7940, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7942, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A4E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_94 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7B3B, 0xFFFE, 0xFFFE, 0x7B35, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B3A, 0x7B36, 0xFFFE, 0x7B37, 0xFFFE, 0xFFFE,
	0x7B39, 0xFFFE, 0x7B38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B7B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7B7C, 0x7B7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C4C, 0xFFFE, 0xFFFE, 0x7C4B, 0x7C4D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7D2C, 0xFFFE, 0x7D2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D35,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D3F, 0x7D3D, 0x7D3E, 0x7D44,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_95 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F5B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F5C, 0xFFFE, 0x536D, 0x5860, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D70, 0xFFFE, 0x6264, 0xFFFE, 0xFFFE, 0x6268, 0x6263,
	0xFFFE, 0x6265, 0x6267, 0x6266, 0x6262, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6750, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B5B, 0xFFFE, 0x6B5E, 0x6B60, 0x6B5F, 0xFFFE, 0xFFFE,
	0x6B5C, 0x6B5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F64, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x726F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x757E, 0xFFFE,
	0x757D, 0xFFFE, 0x757A, 0x757B, 0x757C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7760, 0xFFFE, 0xFFFE, 0xFFFE, 0x775E, 0x7761, 0x775F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7943, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A4F, 0x7B3C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_96 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F5D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x486A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B62, 0xFFFE, 0x4B63, 0xFFFE, 0x4B60, 0xFFFE,
	0xFFFE, 0x4B61, 0x4B5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F60, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F5F,
	0x4F5E, 0xFFFE, 0x4F62, 0xFFFE, 0x4F61, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x536F, 0x5370, 0x5371, 0xFFFE, 0xFFFE,
	0x536E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5867, 0xFFFE, 0xFFFE, 0x5864, 0xFFFE, 0x5865, 0x5868, 0xFFFE,
	0xFFFE, 0x5863, 0x5861, 0x5862, 0x5866, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D71, 0xFFFE, 0x5D79, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D75, 0xFFFE, 0x6270, 0x5D73, 0x5D76, 0x5D72, 0x5D77, 0x5D78,
	0x5D74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x626C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6271, 0x626D, 0x626E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6269, 0x626B, 0xFFFE, 0x626F, 0x626A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6752, 0x6753, 0xFFFE, 0xFFFE,
	0x6751, 0x6B61, 0xFFFE, 0x6B63, 0x6B62, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7270,
	0x7271, 0xFFFE, 0x7272, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7621, 0xFFFE, 0xFFFE, 0x7944, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7622, 0x4F63, 0xFFFE, 0x5869, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D7A, 0x6272, 0xFFFE, 0xFFFE, 0x6274, 0x6273, 0x6275, 0x6276,
	0xFFFE, 0x6756, 0x6757, 0x6755, 0x6B64, 0x6754, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6B65, 0xFFFE, 0xFFFE, 0x7273, 0x7623, 0xFFFE,
	0xFFFE, 0x7764, 0xFFFE, 0x7765, 0x7763, 0xFFFE, 0x7766, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7762, 0x7945, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F64, 0x5D7C, 0x5D7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6277,
	0xFFFE, 0xFFFE, 0x6278, 0xFFFE, 0xFFFE, 0xFFFE, 0x675B, 0x6758,
	0xFFFE, 0x675A, 0xFFFE, 0x6759, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_97 = { {
	0x6B66, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F66, 0xFFFE, 0x6F67, 0x6F68,
	0xFFFE, 0x6F69, 0xFFFE, 0xFFFE, 0xFFFE, 0x7277, 0x7274, 0x7279,
	0xFFFE, 0x7275, 0xFFFE, 0x7278, 0xFFFE, 0xFFFE, 0x7276, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7624, 0xFFFE, 0x7625, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7767, 0xFFFE, 0xFFFE, 0x7947,
	0xFFFE, 0xFFFE, 0x7946, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A50, 0xFFFE, 0x7B3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B3D, 0x7B3E, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B7E, 0x7C21, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C70, 0xFFFE, 0x7C72, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F65, 0xFFFE, 0xFFFE, 0xFFFE, 0x675C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x727A, 0x727B, 0xFFFE, 0x4F66, 0xFFFE,
	0x6F6A, 0x7948, 0x5372, 0xFFFE, 0xFFFE, 0xFFFE, 0x727C, 0xFFFE,
	0x7C4E, 0x5373, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x675D, 0xFFFE, 0x675E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B67, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B68, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F6C, 0xFFFE, 0x6F6B, 0xFFFE, 0x6F6D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x727D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7626, 0xFFFE, 0xFFFE, 0x7768, 0xFFFE, 0xFFFE, 0x7769, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x776A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C23, 0xFFFE, 0x7C22, 0xFFFE, 0xFFFE, 0x7C73, 0xFFFE,
	0xFFFE, 0x7D36, 0xFFFE, 0x5374, 0x6279, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7627, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7949, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5375, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5376, 0xFFFE, 0xFFFE, 0x6B69, 0xFFFE,
	0xFFFE, 0x776B, 0xFFFE, 0x794A, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B40
} };

static const iconv_ccs_convtable_8bit from_ucs_98 = { {
	0xFFFE, 0x5377, 0x5E21, 0x5E22, 0xFFFE, 0x627A, 0x627B, 0xFFFE,
	0x627C, 0xFFFE, 0x6762, 0xFFFE, 0x6764, 0xFFFE, 0xFFFE, 0xFFFE,
	0x675F, 0x6760, 0x6763, 0x6761, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B6A,
	0x6B6B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F70, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F6E, 0xFFFE, 0xFFFE, 0x7326, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F6F, 0xFFFE, 0x7324, 0xFFFE, 0xFFFE,
	0x727E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7323,
	0x7321, 0x7325, 0xFFFE, 0x7322, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7628, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x776E, 0x776C, 0x776F, 0x776D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7770, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x794C, 0xFFFE, 0xFFFE, 0x794D, 0xFFFE, 0xFFFE, 0x794B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B42, 0xFFFE, 0x7B41,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C24, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C4F,
	0x7C74, 0x7D2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5378, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B6C,
	0xFFFE, 0x6B6D, 0xFFFE, 0x6F71, 0xFFFE, 0xFFFE, 0x7629, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7771, 0xFFFE, 0x794E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A51, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5379, 0xFFFE, 0xFFFE, 0xFFFE, 0x537A,
	0xFFFE, 0xFFFE, 0x586A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x627D,
	0xFFFE, 0x6322, 0x627E, 0xFFFE, 0xFFFE, 0x6324, 0xFFFE, 0x6321,
	0xFFFE, 0xFFFE, 0x6323, 0xFFFE, 0x6766, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6765, 0x6767, 0x6768, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_99 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B6E, 0xFFFE, 0x6B6F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B71, 0x6F72, 0xFFFE, 0x6B70, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7327, 0xFFFE, 0x6F74, 0x6F73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F75, 0xFFFE, 0x732C, 0x732A, 0xFFFE, 0xFFFE, 0x7329, 0xFFFE,
	0xFFFE, 0x732B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7328, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7775, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x762A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7774, 0x7772, 0x7773,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x794F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7950, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A53, 0x7A52, 0xFFFE, 0xFFFE, 0x7C25, 0xFFFE, 0x7B43,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C50, 0xFFFE, 0x7D2E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x537B, 0xFFFE,
	0xFFFE, 0x537C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7776, 0xFFFE, 0xFFFE,
	0x7A54, 0xFFFE, 0xFFFE, 0xFFFE, 0x586B, 0x6326, 0x6325, 0xFFFE,
	0xFFFE, 0x676A, 0xFFFE, 0x6769, 0x676B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F77, 0x6F7A, 0x6F7C, 0xFFFE, 0xFFFE, 0x6F7B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F7D, 0xFFFE, 0x6F79, 0xFFFE, 0x6F76, 0xFFFE, 0x6F78,
	0xFFFE, 0xFFFE, 0x732E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x732D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x732F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x762C
} };

static const iconv_ccs_convtable_8bit from_ucs_9A = { {
	0xFFFE, 0x762B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7777, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7951, 0xFFFE,
	0xFFFE, 0x7952, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A58, 0xFFFE, 0x7A57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B47, 0xFFFE,
	0x7B46, 0xFFFE, 0xFFFE, 0x7B45, 0xFFFE, 0x7B44, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C27, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C26, 0xFFFE, 0x7C53,
	0xFFFE, 0xFFFE, 0x7C51, 0x7C52, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C75,
	0xFFFE, 0xFFFE, 0x7D37, 0xFFFE, 0xFFFE, 0x7D38, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x586C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B73,
	0x6B74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F7E,
	0x7330, 0xFFFE, 0xFFFE, 0xFFFE, 0x7331, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7778, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B48,
	0xFFFE, 0x7C56, 0x7C28, 0x7C54, 0x7C55, 0xFFFE, 0x7D2F, 0xFFFE,
	0x586D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x676C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B75, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7333, 0x7021, 0x7022,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7332, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x7779, 0xFFFE, 0xFFFE, 0x777A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7953, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C29, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7C76, 0x7D30, 0xFFFE, 0x586E, 0xFFFE, 0x7023,
	0x7334, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7D48, 0x586F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5870, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B76, 0x6B77, 0xFFFE, 0x7025, 0x7024, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x777D, 0x777C, 0x777B,
	0xFFFE, 0x7B4A, 0xFFFE, 0xFFFE, 0x7B49, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7C77, 0xFFFE, 0x5E23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7027,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7026,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7335, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x762F, 0x762E, 0xFFFE, 0x7630, 0x762D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7824, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7823, 0x7821, 0x777E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7956, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7957, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7955,
	0x7954, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7822, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7A5A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7A59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B4C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B4B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C2D, 0xFFFE, 0xFFFE, 0x7C2C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C57, 0xFFFE, 0x7C59, 0x7C58,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C78,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D40,
	0x7D41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E24, 0xFFFE, 0xFFFE,
	0xFFFE, 0x676D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B7A, 0x6B78, 0xFFFE, 0x6B79, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x702A, 0xFFFE, 0xFFFE, 0x7028, 0xFFFE,
	0xFFFE, 0x7029, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x733A, 0xFFFE, 0xFFFE, 0x7336, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x733B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7337, 0xFFFE, 0xFFFE, 0x7338, 0xFFFE,
	0x7339, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7631, 0xFFFE, 0xFFFE, 0xFFFE, 0x7632,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7825, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7826, 0xFFFE, 0xFFFE,
	0x7827, 0x7959, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x795B, 0xFFFE, 0x795C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x795A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7958, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B4D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7B50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7B4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7C2E, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C2F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C5A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C79, 0x7C7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D45, 0x7D49, 0xFFFE, 0xFFFE, 0x7D4A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E25, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A5B, 0xFFFE, 0xFFFE, 0x7C7B, 0x7C7C, 0xFFFE, 0x5E26,
	0xFFFE, 0xFFFE, 0x676E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7633, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x795D, 0x795F, 0xFFFE, 0xFFFE, 0xFFFE, 0x795E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B51, 0xFFFE, 0x7C5B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E27, 0xFFFE, 0xFFFE,
	0xFFFE, 0x702B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7960, 0x7A5C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5E28, 0x6B7B, 0xFFFE, 0x702C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6327, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D31, 0x6328, 0x702D, 0x7634,
	0xFFFE, 0x6329, 0xFFFE, 0xFFFE, 0x733D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x733C, 0xFFFE, 0xFFFE, 0x7638, 0x7636, 0x7637, 0x7635, 0xFFFE,
	0x7828, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B52,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C5C, 0xFFFE, 0xFFFE, 0x7D42,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C7D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x676F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6770, 0xFFFE, 0x7829, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7B53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6771, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x782A, 0xFFFE, 0xFFFE, 0x7A5E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C30, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B7C, 0xFFFE, 0xFFFE, 0x7639, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6B7D, 0x763A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x702F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B54, 0xFFFE, 0xFFFE, 0x7A5F,
	0xFFFE, 0x7A61, 0xFFFE, 0x7A60, 0xFFFE, 0xFFFE, 0x7B55, 0x7B56,
	0xFFFE, 0xFFFE, 0x7C32, 0xFFFE, 0x7C31, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7D21, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x733E, 0xFFFE, 0xFFFE,
	0x7832, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C33, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x733F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_FE = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x212B, 0x2136, 0x2138, 0xFFFE, 0xFFFE, 0x2140, 0x2141, 0x2144,
	0x2145, 0x2148, 0x2149, 0x214C, 0x214D, 0x2150, 0x2151, 0x2154,
	0x2155, 0x2158, 0x2159, 0x215C, 0x215D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2227, 0x2228, 0x222B, 0x222C, 0x2229, 0x222A, 0xFFFE,
	0x212E, 0x212F, 0x2130, 0xFFFE, 0x2132, 0x2133, 0x2134, 0x2135,
	0xFFFE, 0x215E, 0x215F, 0x2160, 0x2161, 0x2162, 0x2163, 0x222D,
	0x222E, 0x222F, 0x223F, 0x2240, 0x2241, 0x2243, 0x2242, 0xFFFE,
	0x2262, 0x226C, 0x226D, 0x226E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_FF = { {
	0xFFFE, 0x212A, 0xFFFE, 0x216C, 0x2263, 0x2268, 0x216D, 0xFFFE,
	0x213E, 0x213F, 0x216E, 0x2230, 0x2122, 0x2231, 0x2125, 0x225F,
	0x2421, 0x2422, 0x2423, 0x2424, 0x2425, 0x2426, 0x2427, 0x2428,
	0x2429, 0x242A, 0x2128, 0x2127, 0x2236, 0x2238, 0x2237, 0x2129,
	0x2269, 0x2441, 0x2442, 0x2443, 0x2444, 0x2445, 0x2446, 0x2447,
	0x2448, 0x2449, 0x244A, 0x244B, 0x244C, 0x244D, 0x244E, 0x244F,
	0x2450, 0x2451, 0x2452, 0x2453, 0x2454, 0x2455, 0x2456, 0x2457,
	0x2458, 0x2459, 0x245A, 0xFFFE, 0x2260, 0xFFFE, 0xFFFE, 0x2225,
	0xFFFE, 0x245B, 0x245C, 0x245D, 0x245E, 0x245F, 0x2460, 0x2461,
	0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469,
	0x246A, 0x246B, 0x246C, 0x246D, 0x246E, 0x246F, 0x2470, 0x2471,
	0x2472, 0x2473, 0x2474, 0x2142, 0x225E, 0x2143, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2266, 0x2267, 0xFFFE, 0xFFFE, 0xFFFE, 0x2264, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_16bit from_ucs = { {
	&from_ucs_00, NULL, &from_ucs_02, &from_ucs_03, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&from_ucs_20, &from_ucs_21, &from_ucs_22, NULL, &from_ucs_24, &from_ucs_25, &from_ucs_26, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&from_ucs_30, &from_ucs_31, &from_ucs_32, &from_ucs_33, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, &from_ucs_4E, &from_ucs_4F,
	&from_ucs_50, &from_ucs_51, &from_ucs_52, &from_ucs_53, &from_ucs_54, &from_ucs_55, &from_ucs_56, &from_ucs_57,
	&from_ucs_58, &from_ucs_59, &from_ucs_5A, &from_ucs_5B, &from_ucs_5C, &from_ucs_5D, &from_ucs_5E, &from_ucs_5F,
	&from_ucs_60, &from_ucs_61, &from_ucs_62, &from_ucs_63, &from_ucs_64, &from_ucs_65, &from_ucs_66, &from_ucs_67,
	&from_ucs_68, &from_ucs_69, &from_ucs_6A, &from_ucs_6B, &from_ucs_6C, &from_ucs_6D, &from_ucs_6E, &from_ucs_6F,
	&from_ucs_70, &from_ucs_71, &from_ucs_72, &from_ucs_73, &from_ucs_74, &from_ucs_75, &from_ucs_76, &from_ucs_77,
	&from_ucs_78, &from_ucs_79, &from_ucs_7A, &from_ucs_7B, &from_ucs_7C, &from_ucs_7D, &from_ucs_7E, &from_ucs_7F,
	&from_ucs_80, &from_ucs_81, &from_ucs_82, &from_ucs_83, &from_ucs_84, &from_ucs_85, &from_ucs_86, &from_ucs_87,
	&from_ucs_88, &from_ucs_89, &from_ucs_8A, &from_ucs_8B, &from_ucs_8C, &from_ucs_8D, &from_ucs_8E, &from_ucs_8F,
	&from_ucs_90, &from_ucs_91, &from_ucs_92, &from_ucs_93, &from_ucs_94, &from_ucs_95, &from_ucs_96, &from_ucs_97,
	&from_ucs_98, &from_ucs_99, &from_ucs_9A, &from_ucs_9B, &from_ucs_9C, &from_ucs_9D, &from_ucs_9E, &from_ucs_9F,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, &from_ucs_FE, &from_ucs_FF
} };

#define NBITS 14

static ucs2_t convert_from_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_16bit((const iconv_ccs_convtable *)&from_ucs, ch);
}

static ucs2_t convert_to_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_14bit((const iconv_ccs_convtable *)&to_ucs, ch);
}

static const char * const names[] = {
	"cns11643-plane1", NULL
};

static const struct iconv_ccs_desc iconv_ccs_desc = {
	names, NBITS,
	(const iconv_ccs_convtable *)&from_ucs,
	(const iconv_ccs_convtable *)&to_ucs,
	convert_from_ucs, convert_to_ucs,
};

struct iconv_module_desc iconv_module = {
	ICMOD_UC_CCS,
	apr_iconv_mod_noevent,
	NULL,
	&iconv_ccs_desc
};
