/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.stats;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.TimerTask;
import org.apache.airavata.messaging.core.stats.StatCounter;

public class LatencyWriterTask
extends TimerTask {
    private File file;
    private FileOutputStream fos;
    private BufferedWriter bw;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void run() {
        try {
            System.out.println("########### Latency Write Task ############");
            StatCounter statCounter = StatCounter.getInstance();
            Map<String, Long> messageTimeStamp = statCounter.getMessageTimeStamp();
            this.fos = new FileOutputStream(this.file, false);
            this.bw = new BufferedWriter(new OutputStreamWriter(this.fos));
            for (String msgId : messageTimeStamp.keySet()) {
                this.bw.write(msgId + " :" + String.valueOf(messageTimeStamp.get(msgId)));
                this.bw.newLine();
            }
            this.bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

