/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.globus.common.ChainedIOException;
import org.globus.gsi.gssapi.ClosedGSSException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public abstract class GssInputStream
extends InputStream {
    protected InputStream in;
    protected GSSContext context;
    protected byte[] buff;
    protected int index;

    public GssInputStream(InputStream in, GSSContext context) {
        this.in = in;
        this.context = context;
        this.buff = new byte[0];
        this.index = 0;
    }

    protected byte[] unwrap(byte[] msg) throws IOException {
        try {
            return this.context.unwrap(msg, 0, msg.length, null);
        }
        catch (ClosedGSSException e) {
            throw new EOFException("Remote host terminated connection");
        }
        catch (GSSException e) {
            throw new ChainedIOException("unwrap failed", (Throwable)e);
        }
    }

    protected abstract void readMsg() throws IOException;

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int off, int len) throws IOException {
        if (!this.hasData()) {
            return -1;
        }
        int max = this.index + len > this.buff.length ? this.buff.length - this.index : len;
        System.arraycopy(this.buff, this.index, data, off, max);
        this.index += max;
        return max;
    }

    public int read() throws IOException {
        if (!this.hasData()) {
            return -1;
        }
        return this.buff[this.index++] & 0xFF;
    }

    protected boolean hasData() throws IOException {
        if (this.buff == null) {
            return false;
        }
        if (this.buff.length == this.index) {
            try {
                this.readMsg();
            }
            catch (EOFException e) {
                return false;
            }
        }
        if (this.buff == null) {
            return false;
        }
        return this.buff.length != this.index;
    }

    public void close() throws IOException {
        this.buff = null;
        this.in.close();
    }

    public int available() throws IOException {
        if (this.buff == null) {
            return -1;
        }
        int avail = this.buff.length - this.index;
        return avail == 0 ? this.in.available() : avail;
    }
}

