/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBSEmailParser
implements EmailParser {
    private static final Logger log = LoggerFactory.getLogger(PBSEmailParser.class);
    public static final String BEGUN_EXECUTION = "Begun execution";
    public static final String EXECUTION_TERMINATED = "Execution terminated";
    public static final String ABORTED_BY_PBS_SERVER = "Aborted by PBS Server";
    static final String REGEX = "[a-zA-Z ]*:[ ]*(?<jobId>[a-zA-Z0-9-_\\.]*)\\s+[a-zA-Z ]*:[ ]*(?<jobName>[a-zA-Z0-9-\\.]*)\\s[\\S|\\s]*(?<status>Begun execution|Execution terminated|Aborted by PBS Server)";
    private static final String REGEX_EXIT_STATUS = "Exit_status=(?<exitStatus>[\\d]+)";

    public JobStatusResult parseEmail(Message message) throws MessagingException, AiravataException {
        JobStatusResult jobStatusResult = new JobStatusResult();
        try {
            String content = (String)message.getContent();
            this.parseContent(content, jobStatusResult);
        }
        catch (Exception e) {
            throw new AiravataException("[EJM]: Error while reading content of the email message");
        }
        return jobStatusResult;
    }

    void parseContent(String content, JobStatusResult jobStatusResult) throws MessagingException, AiravataException {
        content = content.replaceAll("[^\\x00-\\x7F]", "");
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            jobStatusResult.setJobId(matcher.group("jobId"));
            jobStatusResult.setJobName(matcher.group("jobName"));
            String statusLine = matcher.group("status");
            jobStatusResult.setState(this.getJobState(statusLine, content));
        } else {
            log.error("[EJM]: No matched found for content => \n" + content);
        }
    }

    private JobState getJobState(String statusLine, String content) {
        switch (statusLine) {
            case "Begun execution": {
                return JobState.ACTIVE;
            }
            case "Execution terminated": {
                int exitStatus = this.getExitStatus(content);
                if (exitStatus == 0) {
                    return JobState.COMPLETE;
                }
                if (exitStatus == 271) {
                    return JobState.CANCELED;
                }
                return JobState.FAILED;
            }
            case "Aborted by PBS Server": {
                return JobState.FAILED;
            }
        }
        return JobState.UNKNOWN;
    }

    private int getExitStatus(String content) {
        String group;
        Pattern pattern = Pattern.compile(REGEX_EXIT_STATUS);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find() && (group = matcher.group("exitStatus")) != null && !group.trim().isEmpty()) {
            return Integer.valueOf(group.trim());
        }
        return -1;
    }
}

