/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import org.apache.airavata.common.utils.DBEventService;
import org.apache.airavata.model.dbevent.EntityType;

public class DBEventManagerConstants {
    private static final String QUEUE_SUFFIX = ".queue";
    public static final String DB_EVENT_EXCHANGE_NAME = "db.event.exchange";
    public static final String ROUTING_KEY_SEPARATOR = ".";

    public static String getQueueName(DBEventService dBEventService) {
        return dBEventService.toString() + QUEUE_SUFFIX;
    }

    public static String getRoutingKey(String serviceName) {
        if (serviceName.equals(DBEventService.DB_EVENT.toString())) {
            return serviceName;
        }
        return "#." + serviceName + ROUTING_KEY_SEPARATOR + "#";
    }

    public static String getQueueName(String dbEventService) {
        return DBEventManagerConstants.getQueueName(DBEventManagerConstants.getDBEventService(dbEventService));
    }

    public static String getDbEventServiceName(EntityType entityType) {
        for (DBEventService service : DBEventService.values()) {
            if (!service.name().equals(entityType.name())) continue;
            return service.toString();
        }
        return null;
    }

    private static DBEventService getDBEventService(String dbEventService) {
        for (DBEventService service : DBEventService.values()) {
            if (!service.toString().equals(dbEventService)) continue;
            return service;
        }
        return null;
    }
}

