/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.logging.kafka;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.google.gson.Gson;
import java.time.Instant;
import java.util.Arrays;
import java.util.Properties;
import org.apache.airavata.common.logging.Exception;
import org.apache.airavata.common.logging.LogEntry;
import org.apache.airavata.common.logging.ServerId;
import org.apache.airavata.common.utils.AwsMetadata;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaAppender.class);
    private final Producer<String, String> producer;
    private final String kafkaTopic;
    private ServerId serverId = null;

    public KafkaAppender(String kafkaHost, String kafkaTopicPrefix) {
        Properties props = new Properties();
        props.put("bootstrap.servers", kafkaHost);
        props.put("acks", "0");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)10000);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("producer.type", "async");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.kafkaTopic = this.createKafkaTopic(kafkaTopicPrefix);
        logger.info("Starting kafka producer: bootstrap-server:{}, topic : {}", (Object)kafkaHost, (Object)this.kafkaTopic);
        this.producer = new KafkaProducer(props);
        if (ServerSettings.isRunningOnAws()) {
            AwsMetadata awsMetadata = new AwsMetadata();
            this.serverId = new ServerId(awsMetadata.getId(), awsMetadata.getHostname(), "airavata-0.16-1431-ge3edeec77", ServerSettings.getServerRoles());
        } else {
            this.serverId = new ServerId(ServerSettings.getIp(), ServerSettings.getIp(), "airavata-0.16-1431-ge3edeec77", ServerSettings.getServerRoles());
        }
    }

    protected void append(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        if (!event.getLevel().equals(Level.ALL) && !event.getLevel().equals(Level.OFF)) {
            IThrowableProxy throwableProxy = event.getThrowableProxy();
            LogEntry entry = throwableProxy != null ? new LogEntry(this.serverId, event.getFormattedMessage(), Instant.ofEpochMilli(event.getTimeStamp()).toString(), event.getLevel().toString(), event.getLoggerName(), event.getMDCPropertyMap(), event.getThreadName() != null ? event.getThreadName() : null, new Exception(throwableProxy.getMessage(), this.toStringArray(throwableProxy.getStackTraceElementProxyArray()), throwableProxy.getClassName())) : new LogEntry(this.serverId, event.getFormattedMessage(), Instant.ofEpochMilli(event.getTimeStamp()).toString(), event.getLevel().toString(), event.getLoggerName(), event.getMDCPropertyMap(), event.getThreadName() != null ? event.getThreadName() : null);
            this.producer.send(new ProducerRecord(this.kafkaTopic, (Object)new Gson().toJson((Object)entry)));
        }
    }

    private String[] toStringArray(StackTraceElementProxy[] stackTraceElement) {
        return (String[])Arrays.stream(stackTraceElement).map(StackTraceElementProxy::getSTEAsString).toArray(String[]::new);
    }

    private String createKafkaTopic(String kafkaTopicPrefix) {
        String[] serverRoles = ServerSettings.getServerRoles();
        if (serverRoles.length >= 4) {
            return String.format("%s_all_logs", kafkaTopicPrefix);
        }
        return String.format("%s_%s_logs", kafkaTopicPrefix, ServerSettings.getServerRoles()[0]);
    }

    public void close() {
        this.producer.close();
    }
}

