/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class ThriftSession
implements Serializable {
    private static Log log = LogFactory.getLog(ThriftSession.class);
    private String sessionId;
    private long createdAt;
    private long lastAccessedAt;
    private String userName;
    private String password;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private static final Map<String, String> ALLOWED_METHODS = new HashMap<String, String>();
    private final Map<String, Boolean> restrictedItems = new HashMap<String, Boolean>();
    private static final String CARBON_CONTEXT_HOLDER = "carbonContextHolder";

    public ThriftSession() {
        this.restrictedItems.put(CARBON_CONTEXT_HOLDER, false);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getLastAccess() {
        return this.lastAccessedAt;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccessedAt = lastAccess;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThriftSession)) {
            return false;
        }
        ThriftSession that = (ThriftSession)o;
        return !(this.sessionId != null ? !this.sessionId.equals(that.sessionId) : that.sessionId != null);
    }

    public int hashCode() {
        return this.sessionId != null ? this.sessionId.hashCode() : 0;
    }

    public void setAttribute(String key, Object val) {
        this.checkRestrictedItem(key);
        this.attributeMap.put(key, val);
    }

    public Object getAttribute(String key) throws Exception {
        if (key.equals(CARBON_CONTEXT_HOLDER)) {
            String errorMsg = "Trying to retrieve a restricted item. Access Denied.";
            log.error((Object)errorMsg);
            throw new Exception(errorMsg);
        }
        return this.attributeMap.get(key);
    }

    public CarbonContext getSessionCarbonContextHolder() {
        CarbonBaseUtils.checkSecurity(ALLOWED_METHODS);
        return (PrivilegedCarbonContext)this.attributeMap.get(CARBON_CONTEXT_HOLDER);
    }

    private void checkRestrictedItem(String itemName) {
        if (this.restrictedItems.containsKey(itemName)) {
            Boolean isSet = this.restrictedItems.get(itemName);
            if (isSet.booleanValue()) {
                throw new SecurityException("Malicious code detected! Trying to override restricted item: " + itemName);
            }
            this.restrictedItems.put(itemName, true);
        }
    }

    static {
        ALLOWED_METHODS.put("org.wso2.carbon.identity.entitlement.thrift.ThriftEntitlementServiceImpl", "populateCurrentCarbonContextFromAuthSession");
    }
}

