/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.ManagementFactory;

public class MBeanRegistrar {
    private static Log log = LogFactory.getLog(MBeanRegistrar.class);
    private static List<ObjectName> mbeans = new ArrayList<ObjectName>();

    private MBeanRegistrar() {
    }

    public static void registerMBean(Object mbeanInstance, String objectName) throws Exception {
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        Set<ObjectName> set = mbs.queryNames(new ObjectName(objectName), null);
        if (!set.isEmpty()) {
            log.debug((Object)("MBean " + objectName + " already exists"));
            throw new Exception("MBean " + objectName + " already exists");
        }
        ObjectName name = new ObjectName(objectName);
        mbs.registerMBean(mbeanInstance, name);
        mbeans.add(name);
    }

    public static void registerMBean(Object mbeanInstance) {
        String serverPackage = ServerConfiguration.getInstance().getFirstProperty("Package");
        if (serverPackage == null) {
            serverPackage = "wso2";
        }
        try {
            String className = mbeanInstance.getClass().getName();
            if (className.indexOf(46) != -1) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            MBeanRegistrar.registerMBean(mbeanInstance, serverPackage + ":type=" + className);
        }
        catch (Exception e) {
            String msg = "Could not register " + mbeanInstance.getClass() + " MBean";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public static void unregisterAllMBeans() {
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        for (ObjectName name : mbeans) {
            try {
                mbs.unregisterMBean(name);
            }
            catch (Exception e) {
                log.error((Object)("Cannot unregister MBean " + name.getCanonicalName()));
            }
        }
    }
}

