/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class MIMEType2FileExtensionMap {
    public static final String mappingFileName = "org/wso2/carbon/core/util/mime-mappings.xml";
    private Map<String, String> extensionToMimeMap = new HashMap<String, String>();
    private static Log log = LogFactory.getLog(MIMEType2FileExtensionMap.class);

    public MIMEType2FileExtensionMap() {
        try {
            URL resource = this.getClass().getClassLoader().getResource(mappingFileName);
            if (resource == null) {
                String msg = "Unable to load all MIME Mappings";
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            InputStream in = resource.openStream();
            OMElement doc = new StAXOMBuilder(in).getDocumentElement();
            Iterator childIter = doc.getChildElements();
            while (childIter.hasNext()) {
                OMElement mappingEle = (OMElement)childIter.next();
                String ext = mappingEle.getFirstChildWithName(new QName("Extension")).getText();
                String mimeType = mappingEle.getFirstChildWithName(new QName("MimeType")).getText();
                this.extensionToMimeMap.put(ext, mimeType);
            }
        }
        catch (Exception e) {
            String msg = "Unable to load all MIME Mappings";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public String getMIMEType(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        if (index == -1 || index == filename.length() - 1) {
            return "application/octet-stream";
        }
        String extension = filename.substring(index + 1);
        String contentType = this.extensionToMimeMap.get(extension);
        return contentType != null ? contentType : "application/octet-stream";
    }

    public void init(BundleContext context) {
    }
}

