/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.NamespacedSAXConfigurationHandler;
import org.compass.core.util.config.SAXConfigurationHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlConfigurationHelperBuilder {
    private SAXConfigurationHandler m_handler;
    private XMLReader m_parser;

    public XmlConfigurationHelperBuilder() {
        this(false);
    }

    public XmlConfigurationHelperBuilder(boolean enableNamespaces) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            if (enableNamespaces) {
                saxParserFactory.setNamespaceAware(true);
            }
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.setParser(saxParser.getXMLReader());
        }
        catch (Exception se) {
            throw new Error("Unable to setup SAX parser" + se);
        }
    }

    public XmlConfigurationHelperBuilder(XMLReader parser) {
        this.setParser(parser);
    }

    private void setParser(XMLReader parser) {
        this.m_parser = parser;
        this.m_handler = this.getHandler();
        this.m_parser.setContentHandler(this.m_handler);
        this.m_parser.setErrorHandler(this.m_handler);
    }

    protected SAXConfigurationHandler getHandler() {
        try {
            if (this.m_parser.getFeature("http://xml.org/sax/features/namespaces")) {
                return new NamespacedSAXConfigurationHandler();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SAXConfigurationHandler();
    }

    public ConfigurationHelper buildFromFile(String filename) throws ConfigurationException {
        return this.buildFromFile(new File(filename));
    }

    public ConfigurationHelper buildFromFile(File file) throws ConfigurationException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Failed to find file [" + file.getAbsolutePath() + "]");
        }
        return this.build(inputStream, file.getAbsolutePath());
    }

    public ConfigurationHelper build(InputStream inputStream, String systemId) throws ConfigurationException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(systemId);
        return this.build(inputSource);
    }

    public ConfigurationHelper build(String uri) throws ConfigurationException {
        return this.build(new InputSource(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationHelper build(InputSource input) throws ConfigurationException {
        XmlConfigurationHelperBuilder xmlConfigurationHelperBuilder = this;
        synchronized (xmlConfigurationHelperBuilder) {
            this.m_handler.clear();
            try {
                this.m_parser.parse(input);
            }
            catch (SAXParseException e) {
                throw new ConfigurationException("Line [" + e.getLineNumber() + "] Column [" + e.getColumnNumber() + "] in XML document [" + input.getSystemId() + "] is invalid", e);
            }
            catch (SAXException e) {
                throw new ConfigurationException("XML document [" + input.getSystemId() + "] is invalid", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("IOException parsing XML document [" + input.getSystemId() + "]", e);
            }
            return this.m_handler.getConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntityResolver(EntityResolver resolver) {
        XmlConfigurationHelperBuilder xmlConfigurationHelperBuilder = this;
        synchronized (xmlConfigurationHelperBuilder) {
            this.m_parser.setEntityResolver(resolver);
        }
    }
}

