/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;
import org.apache.lucene.store.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.dialect.DialectResolver;
import org.apache.lucene.store.jdbc.index.FetchPerTransactionJdbcIndexInput;
import org.apache.lucene.store.jdbc.support.JdbcTable;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.engine.event.SearchEngineLifecycleEventListener;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.core.lucene.engine.store.jdbc.DataSourceProvider;
import org.compass.core.lucene.engine.store.jdbc.DriverManagerDataSourceProvider;
import org.compass.core.util.ClassUtils;

public class JdbcDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(JdbcDirectoryStore.class);
    public static final String PROTOCOL = "jdbc://";
    private JdbcDirectorySettings jdbcSettings;
    private DataSource dataSource;
    private DataSourceProvider dataSourceProvider;
    private Dialect dialect;
    private boolean managed;
    private boolean disableSchemaOperation;
    private Map<String, JdbcTable> cachedJdbcTables = new ConcurrentHashMap<String, JdbcTable>();

    public boolean supportsConcurrentOperations() {
        return false;
    }

    public void configure(CompassSettings settings) throws CompassException {
        String connection = settings.getSetting("compass.engine.connection");
        String url = connection.substring(PROTOCOL.length());
        this.dataSourceProvider = (DataSourceProvider)settings.getSettingAsInstance("compass.engine.store.jdbc.connection.provider.class", DriverManagerDataSourceProvider.class.getName());
        this.dataSourceProvider.configure(url, settings);
        this.dataSource = this.dataSourceProvider.getDataSource();
        String dialectClassName = settings.getSetting("compass.engine.store.jdbc.dialect", null);
        if (dialectClassName == null) {
            try {
                this.dialect = new DialectResolver().getDialect(this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new ConfigurationException("Failed to auto detect dialect", e);
            }
        }
        try {
            this.dialect = (Dialect)ClassUtils.forName(dialectClassName, settings.getClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to configure dialect [" + dialectClassName + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using dialect [" + this.dialect.getClass().getName() + "]"));
        }
        this.managed = settings.getSettingAsBoolean("compass.engine.store.jdbc.managed", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using managed [" + this.managed + "]"));
        }
        if (!this.managed) {
            this.dataSource = new TransactionAwareDataSourceProxy(this.dataSource);
        }
        this.disableSchemaOperation = settings.getSettingAsBoolean("compass.engine.store.jdbc.disableSchemaOperations", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using disable schema operations [" + this.disableSchemaOperation + "]"));
        }
        this.jdbcSettings = new JdbcDirectorySettings();
        this.jdbcSettings.setNameColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.name.name", this.jdbcSettings.getNameColumnName()));
        this.jdbcSettings.setValueColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.value.name", this.jdbcSettings.getValueColumnName()));
        this.jdbcSettings.setSizeColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.size.name", this.jdbcSettings.getSizeColumnName()));
        this.jdbcSettings.setLastModifiedColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.lastModified.name", this.jdbcSettings.getLastModifiedColumnName()));
        this.jdbcSettings.setDeletedColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.deleted.name", this.jdbcSettings.getDeletedColumnName()));
        this.jdbcSettings.setNameColumnLength(settings.getSettingAsInt("compass.engine.store.jdbc.ddl.name.length", this.jdbcSettings.getNameColumnLength()));
        this.jdbcSettings.setValueColumnLengthInK(settings.getSettingAsInt("compass.engine.store.jdbc.ddl.value.length", this.jdbcSettings.getValueColumnLengthInK()));
        this.jdbcSettings.setDeleteMarkDeletedDelta(settings.getSettingAsLong("compass.engine.store.jdbc.deleteMarkDeletedDelta", this.jdbcSettings.getDeleteMarkDeletedDelta()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using delete mark deleted older than [" + this.jdbcSettings.getDeleteMarkDeletedDelta() + "ms]"));
        }
        this.jdbcSettings.setQueryTimeout(settings.getSettingAsInt("compass.transaction.lockTimeout", this.jdbcSettings.getQueryTimeout()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using query timeout (transaction lock timeout) [" + this.jdbcSettings.getQueryTimeout() + "ms]"));
        }
        try {
            this.jdbcSettings.setLockClass(settings.getSettingAsClass("compass.engine.store.jdbc.lockType", this.jdbcSettings.getLockClass()));
        }
        catch (ClassNotFoundException e) {
            throw new CompassException("Failed to create jdbc lock class [" + settings.getSetting("compass.engine.store.jdbc.lockType") + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using lock strategy [" + this.jdbcSettings.getLockClass().getName() + "]"));
        }
        if (this.dialect.supportTransactionalScopedBlobs() && !"true".equalsIgnoreCase(settings.getSetting("compass.engine.store.jdbc.connection.autoCommit", "false"))) {
            this.jdbcSettings.getDefaultFileEntrySettings().setClassSetting("indexInput.type", FetchPerTransactionJdbcIndexInput.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using transactional blobs (dialect supports it)");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using non transactional blobs (dialect does not supports it)");
        }
        Map<String, CompassSettings> fileEntries = settings.getSettingGroups("compass.engine.store.jdbc.fe");
        for (String fileEntryName : fileEntries.keySet()) {
            JdbcFileEntrySettings jdbcFileEntrySettings;
            CompassSettings compassFeSettings = fileEntries.get(fileEntryName);
            if (log.isInfoEnabled()) {
                log.info((Object)("Configuring file entry [" + fileEntryName + "] with settings [" + compassFeSettings + "]"));
            }
            if ((jdbcFileEntrySettings = this.jdbcSettings.getFileEntrySettingsWithoutDefault(fileEntryName)) == null) {
                jdbcFileEntrySettings = new JdbcFileEntrySettings();
            }
            for (String feSetting : compassFeSettings.keySet()) {
                jdbcFileEntrySettings.setSetting(feSetting, compassFeSettings.getSetting(feSetting));
            }
            this.jdbcSettings.registerFileEntrySettings(fileEntryName, jdbcFileEntrySettings);
        }
    }

    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        String totalPath = subContext + "_" + subIndex;
        JdbcTable jdbcTable = this.cachedJdbcTables.get(totalPath);
        if (jdbcTable == null) {
            jdbcTable = new JdbcTable(this.jdbcSettings, this.dialect, totalPath);
            this.cachedJdbcTables.put(totalPath, jdbcTable);
        }
        JdbcDirectory dir = new JdbcDirectory(this.dataSource, jdbcTable);
        if (!this.disableSchemaOperation) {
            try {
                Boolean exists = this.indexExists(dir);
                if (exists == null) {
                    try {
                        exists = IndexReader.indexExists(dir);
                    }
                    catch (IOException e) {
                        exists = false;
                    }
                }
                if (!exists.booleanValue()) {
                    dir.create();
                }
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to create dir [" + totalPath + "]", e);
            }
        }
        return dir;
    }

    public Boolean indexExists(Directory dir) throws SearchEngineException {
        try {
            boolean tableExists;
            if (this.dialect.supportsTableExists() && !(tableExists = ((JdbcDirectory)dir).tableExists())) {
                return Boolean.FALSE;
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to check if index exists", (Throwable)e);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return null;
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        try {
            if (this.disableSchemaOperation) {
                ((JdbcDirectory)dir).deleteContent();
            } else {
                ((JdbcDirectory)dir).delete();
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete index [" + subIndex + "]", e);
        }
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        JdbcDirectory jdbcDirectory = (JdbcDirectory)dir;
        try {
            jdbcDirectory.deleteContent();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete content of [" + subIndex + "]", e);
        }
    }

    public void performScheduledTasks(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        try {
            ((JdbcDirectory)dir).deleteMarkDeleted();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete mark deleted with jdbc for [" + subIndex + "]", e);
        }
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            ((JdbcDirectory)dir).deleteContent();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete index content");
        }
        return new CopyFromHolder();
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
        if (this.managed) {
            eventManager.registerLifecycleListener(new ManagedEventListeners());
        } else {
            eventManager.registerLifecycleListener(new NoneManagedEventListeners());
        }
    }

    public void close() {
        this.dataSourceProvider.closeDataSource();
    }

    public boolean requiresAsyncTransactionalContext() {
        return true;
    }

    private class NoneManagedEventListeners
    implements SearchEngineLifecycleEventListener {
        private Connection connection;

        private NoneManagedEventListeners() {
        }

        public void beforeBeginTransaction() throws SearchEngineException {
            try {
                this.connection = DataSourceUtils.getConnection(JdbcDirectoryStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to open db connection", e);
            }
        }

        public void afterBeginTransaction() throws SearchEngineException {
        }

        public void afterPrepare() throws SearchEngineException {
        }

        public void afterCommit(boolean onePhase) throws SearchEngineException {
            try {
                DataSourceUtils.commitConnectionIfPossible(this.connection);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to commit database transcation", e);
            }
            finally {
                DataSourceUtils.releaseConnection(this.connection);
                this.connection = null;
            }
        }

        public void afterRollback() throws SearchEngineException {
            try {
                DataSourceUtils.rollbackConnectionIfPossible(this.connection);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to rollback database transcation", e);
            }
            finally {
                DataSourceUtils.releaseConnection(this.connection);
                this.connection = null;
            }
        }

        public void close() throws SearchEngineException {
        }
    }

    private class ManagedEventListeners
    implements SearchEngineLifecycleEventListener {
        private ManagedEventListeners() {
        }

        public void beforeBeginTransaction() throws SearchEngineException {
        }

        public void afterBeginTransaction() throws SearchEngineException {
        }

        public void afterPrepare() throws SearchEngineException {
        }

        public void afterCommit(boolean onePhase) throws SearchEngineException {
            Connection conn;
            try {
                conn = DataSourceUtils.getConnection(JdbcDirectoryStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to get connection", e);
            }
            FetchPerTransactionJdbcIndexInput.releaseBlobs(conn);
            DataSourceUtils.releaseConnection(conn);
        }

        public void afterRollback() throws SearchEngineException {
            Connection conn;
            try {
                conn = DataSourceUtils.getConnection(JdbcDirectoryStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to get connection", e);
            }
            FetchPerTransactionJdbcIndexInput.releaseBlobs(conn);
            DataSourceUtils.releaseConnection(conn);
        }

        public void close() throws SearchEngineException {
        }
    }
}

