/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.merge.scheduler;

import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.merge.scheduler.ConcurrentMergeSchedulerProvider;
import org.compass.core.lucene.engine.merge.scheduler.ExecutorMergeSchedulerProvider;
import org.compass.core.lucene.engine.merge.scheduler.MergeSchedulerProvider;
import org.compass.core.lucene.engine.merge.scheduler.SerialMergeSchedulerProvider;
import org.compass.core.util.ClassUtils;

public class MergeSchedulerFactory {
    public static MergeScheduler create(LuceneSearchEngineIndexManager indexManager, CompassSettings settings) throws SearchEngineException {
        MergeSchedulerProvider provider;
        if (!indexManager.supportsConcurrentOperations()) {
            return new SerialMergeScheduler();
        }
        String type = settings.getSetting("compass.engine.merge.scheduler.type", "executor");
        if (type.equals("executor")) {
            provider = new ExecutorMergeSchedulerProvider();
        } else if (type.equals("concurrent")) {
            provider = new ConcurrentMergeSchedulerProvider();
        } else if (type.equals("serial")) {
            provider = new SerialMergeSchedulerProvider();
        } else {
            try {
                provider = (MergeSchedulerProvider)ClassUtils.forName(type, settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to create merge scheduler provider [" + type + "]", e);
            }
        }
        return provider.create(indexManager, settings);
    }
}

