/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.metadata;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.binding.metadata.MetaDataReader;
import org.compass.core.util.ClassUtils;

public class MetaDataReaderFactory {
    private static final Log log = LogFactory.getLog(MetaDataReaderFactory.class);

    public static MetaDataReader getMetaDataReader(CompassSettings settings) throws CompassException {
        String defaultMetaDataReader = null;
        try {
            ClassUtils.forName("org.objectweb.asm.Type", settings.getClassLoader());
            defaultMetaDataReader = "org.compass.core.config.binding.metadata.AsmMetaDataReader";
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (defaultMetaDataReader == null) {
            try {
                ClassUtils.forName("javassist.bytecode.ClassFile", settings.getClassLoader());
                defaultMetaDataReader = "org.compass.core.config.binding.metadata.JavassistMetaDataReader";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default class meta data reader detected [" + defaultMetaDataReader + "]"));
        }
        return (MetaDataReader)settings.getSettingAsInstance("compass.scanner.reader", defaultMetaDataReader);
    }
}

