/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetItemResult
implements Serializable {
    private Map<String, List<Map<String, AttributeValue>>> responses;
    private Map<String, KeysAndAttributes> unprocessedKeys;
    private ListWithAutoConstructFlag<ConsumedCapacity> consumedCapacity;

    public Map<String, List<Map<String, AttributeValue>>> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.responses = responses;
    }

    public BatchGetItemResult withResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.setResponses(responses);
        return this;
    }

    public BatchGetItemResult addResponsesEntry(String key, List<Map<String, AttributeValue>> value) {
        if (null == this.responses) {
            this.responses = new HashMap<String, List<Map<String, AttributeValue>>>();
        }
        if (this.responses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.responses.put(key, value);
        return this;
    }

    public BatchGetItemResult clearResponsesEntries() {
        this.responses = null;
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public void setUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = unprocessedKeys;
    }

    public BatchGetItemResult withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.setUnprocessedKeys(unprocessedKeys);
        return this;
    }

    public BatchGetItemResult addUnprocessedKeysEntry(String key, KeysAndAttributes value) {
        if (null == this.unprocessedKeys) {
            this.unprocessedKeys = new HashMap<String, KeysAndAttributes>();
        }
        if (this.unprocessedKeys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unprocessedKeys.put(key, value);
        return this;
    }

    public BatchGetItemResult clearUnprocessedKeysEntries() {
        this.unprocessedKeys = null;
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
            return;
        }
        ListWithAutoConstructFlag consumedCapacityCopy = new ListWithAutoConstructFlag(consumedCapacity.size());
        consumedCapacityCopy.addAll(consumedCapacity);
        this.consumedCapacity = consumedCapacityCopy;
    }

    public BatchGetItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
        if (this.getConsumedCapacity() == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacity.length));
        }
        for (ConsumedCapacity value : consumedCapacity) {
            this.getConsumedCapacity().add(value);
        }
        return this;
    }

    public BatchGetItemResult withConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
        } else {
            ListWithAutoConstructFlag consumedCapacityCopy = new ListWithAutoConstructFlag(consumedCapacity.size());
            consumedCapacityCopy.addAll(consumedCapacity);
            this.consumedCapacity = consumedCapacityCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResponses() != null) {
            sb.append("Responses: " + this.getResponses() + ",");
        }
        if (this.getUnprocessedKeys() != null) {
            sb.append("UnprocessedKeys: " + this.getUnprocessedKeys() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResponses() == null ? 0 : this.getResponses().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedKeys() == null ? 0 : this.getUnprocessedKeys().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResult)) {
            return false;
        }
        BatchGetItemResult other = (BatchGetItemResult)obj;
        if (other.getResponses() == null ^ this.getResponses() == null) {
            return false;
        }
        if (other.getResponses() != null && !other.getResponses().equals(this.getResponses())) {
            return false;
        }
        if (other.getUnprocessedKeys() == null ^ this.getUnprocessedKeys() == null) {
            return false;
        }
        if (other.getUnprocessedKeys() != null && !other.getUnprocessedKeys().equals(this.getUnprocessedKeys())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || other.getConsumedCapacity().equals(this.getConsumedCapacity());
    }
}

