/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;

public class Request
extends SFTPPacket<Request> {
    private final PacketType type;
    private final long reqID;
    private final Promise<Response, SFTPException> responsePromise;

    public Request(PacketType type, long reqID) {
        super(type);
        this.type = type;
        this.reqID = reqID;
        this.responsePromise = new Promise("sftp / " + reqID, SFTPException.chainer);
        this.putUInt32(reqID);
    }

    public long getRequestID() {
        return this.reqID;
    }

    public PacketType getType() {
        return this.type;
    }

    public Promise<Response, SFTPException> getResponsePromise() {
        return this.responsePromise;
    }

    @Override
    public String toString() {
        return "Request{" + this.reqID + ";" + (Object)((Object)this.type) + "}";
    }
}

