/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration;

import edu.uiuc.ncsa.security.core.configuration.XProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NSProperties
extends XProperties {
    public static final String XMLNS_PREFIX = "xmlns";
    HashMap<String, String> nsToPrefix;
    HashMap<String, String> prefixToNS;

    public HashMap<String, String> getPrefixToNS() {
        if (this.prefixToNS == null) {
            this.prefixToNS = new HashMap();
        }
        return this.prefixToNS;
    }

    public void addNSPrefix(String ns, String prefix) {
        this.getNsToPrefix().put(ns, prefix);
        this.getPrefixToNS().put(prefix, ns);
    }

    public void removeNS(String ns) {
        String prefix = this.getNsToPrefix().get(ns);
        this.getNsToPrefix().remove(ns);
        if (prefix != null) {
            this.getPrefixToNS().remove(prefix);
        }
    }

    public Collection<String> getNamespaces() {
        return this.getNsToPrefix().keySet();
    }

    public Collection<String> getPrefixes() {
        return this.getPrefixToNS().keySet();
    }

    protected HashMap<String, String> getNsToPrefix() {
        if (this.nsToPrefix == null) {
            this.nsToPrefix = new HashMap();
        }
        return this.nsToPrefix;
    }

    public boolean getBoolean(String ns, String key) {
        return this.getBoolean(this.resolveKey(ns, key));
    }

    protected String resolveKey(String ns, String key) {
        String realNS = ns;
        if (this.getPrefixToNS().containsKey(ns)) {
            realNS = this.getPrefixToNS().get(ns);
        }
        return realNS + key;
    }

    protected String toPrefix(String key) {
        return this.replaceHeader(this.getNamespaces(), this.getNsToPrefix(), key, false);
    }

    String replaceHeader(Collection<String> headers, Map<String, String> lookup, String key, boolean removeDelimeter) {
        if (headers == null || headers.size() == 0) {
            return key;
        }
        String[] keyArrays = new String[headers.size()];
        keyArrays = headers.toArray(keyArrays);
        Arrays.sort(keyArrays, new StringLengthComparator());
        String resolvedKey = key;
        for (String x : keyArrays) {
            if (!key.startsWith(x)) continue;
            if (x.equals(key)) {
                return lookup.get(x);
            }
            return lookup.get(x) + (removeDelimeter ? "" : ":") + key.substring(x.length() + (removeDelimeter ? ":".length() : 0));
        }
        return resolvedKey;
    }

    protected String toNS(String key) {
        return this.replaceHeader(this.getPrefixes(), this.getPrefixToNS(), key, true);
    }

    public void setBoolean(String ns, String key, boolean value) {
        this.setBoolean(this.resolveKey(ns, key), value);
    }

    public int getInt(String ns, String key) {
        return this.getInt(this.resolveKey(ns, key));
    }

    public void setInt(String ns, String key, int value) {
        this.setInt(this.resolveKey(ns, key), value);
    }

    public long getLong(String ns, String key) {
        return this.getLong(this.resolveKey(ns, key));
    }

    public void setLong(String ns, String key, long value) {
        this.setLong(this.resolveKey(ns, key), value);
    }

    public File getFile(String ns, String key) {
        return this.getFile(this.resolveKey(ns, key));
    }

    public File getFile(String ns, String key, File parent) {
        return this.getFile(this.resolveKey(ns, key), parent);
    }

    public void setFile(String ns, String key, File f) {
        this.setFile(this.resolveKey(ns, key), f);
    }

    public String getString(String ns, String key) {
        return this.getString(this.resolveKey(ns, key));
    }

    public void setString(String ns, String key, String value) {
        this.setString(this.resolveKey(ns, key), value);
    }

    public Object getSerializable(String ns, String key) {
        return this.getSerializable(this.resolveKey(ns, key));
    }

    public void setSerializable(String ns, String key, Serializable object) {
        this.setSerializable(this.resolveKey(ns, key), object);
    }

    public void setSerializableList(String ns, String key, Object[] oList) {
        this.setSerializableList(this.resolveKey(ns, key), oList);
    }

    public Object[] getSerializableList(String ns, String key) {
        return this.getSerializableList(this.resolveKey(ns, key));
    }

    public byte[] getBytes(String ns, String key) {
        return this.getBytes(this.resolveKey(ns, key));
    }

    public void setBytes(String ns, String key, byte[] ba) {
        this.setBytes(this.resolveKey(ns, key), ba);
    }

    public void setDouble(String ns, String key, double value) {
        this.setDouble(this.resolveKey(ns, key), value);
    }

    public double getDouble(String ns, String key) {
        return this.getDouble(this.resolveKey(ns, key));
    }

    public Object setProperty(String ns, String key, String value) {
        return this.setProperty(this.resolveKey(ns, key), value);
    }

    public void setDate(String ns, String key, Date d) {
        this.setDate(this.resolveKey(ns, key), d);
    }

    public URI getURI(String ns, String key) {
        return this.getURI(this.resolveKey(ns, key));
    }

    public void setURI(String ns, String key, URI uri) {
        this.setURI(this.resolveKey(ns, key), uri);
    }

    public void setURI(String ns, String key, String uriString) {
        this.setURI(this.resolveKey(ns, key), uriString);
    }

    public URL getURL(String ns, String key) {
        return this.getURL(this.resolveKey(ns, key));
    }

    public void setURL(String ns, String key, URL url) {
        this.setURL(this.resolveKey(ns, key), url);
    }

    public void setURL(String ns, String key, String urlString) {
        this.setURL(this.resolveKey(ns, key), urlString);
    }

    public Date getDate(String ns, String key) {
        return this.getDate(this.resolveKey(ns, key));
    }

    public String[] getListByNS(String ns, String key, String separator) {
        return this.getList(this.resolveKey(ns, key), separator);
    }

    public String[] getListByNS(String ns, String key) {
        return this.getList(this.resolveKey(ns, key));
    }

    public void setList(String ns, String key, String list) {
        this.setList(this.resolveKey(ns, key), list);
    }

    public void setList(String ns, String key, String[] list) {
        this.setList(this.resolveKey(ns, key), list);
    }

    public void setList(String ns, String key, String[] list, String separator) {
        this.setList(this.resolveKey(ns, key), list, separator);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        String keyS;
        XProperties xp0 = new XProperties();
        XProperties xp1 = new XProperties();
        xp0.load(inStream);
        for (Object key : xp0.keySet()) {
            keyS = key.toString();
            if (keyS.startsWith("xmlns:")) {
                this.addNSPrefix(xp0.getString(keyS), keyS.substring("xmlns:".length()));
                continue;
            }
            xp1.put(keyS, xp0.getString(keyS));
        }
        for (Object key : xp1.keySet()) {
            keyS = this.toNS(key.toString());
            this.setString(keyS, xp1.getString(key.toString()));
        }
    }

    @Override
    public void store(OutputStream os, String header) {
        try {
            XProperties xp = new XProperties();
            for (String prefix : this.getPrefixToNS().keySet()) {
                xp.put("xmlns:" + prefix, this.getPrefixToNS().get(prefix));
            }
            XProperties xp2 = xp;
            for (Object key : this.keySet()) {
                xp2.put(this.toPrefix(key.toString()), this.getString(key.toString()));
            }
            xp2.store(os, header);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void list(PrintStream out) {
        XProperties xp = new XProperties();
        for (String prefix : this.getPrefixToNS().keySet()) {
            xp.put("xmlns:" + prefix, this.getPrefixToNS().get(prefix));
        }
        xp.list(out);
        XProperties xp2 = new XProperties();
        for (Object key : this.keySet()) {
            xp2.put(this.toPrefix(key.toString()), this.getString(key.toString()));
        }
        xp2.list(out);
    }

    public class StringLengthComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1.length() < o2.length()) {
                return -1;
            }
            if (o1.length() > o2.length()) {
                return 1;
            }
            return 0;
        }
    }
}

