/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization;

import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.synchronization.message.Message;
import org.wso2.carbon.registry.synchronization.message.MessageCode;

public class SynchronizationException
extends RegistryException {
    private Message message;
    private static final String DEFAULT_SYNCHRONIZATION_OPERATION_FAILED_MESSAGE = "Synchronization Operation Failed.";

    public SynchronizationException(MessageCode code, Throwable cause) {
        this(code, cause, null);
    }

    public SynchronizationException(MessageCode code, Throwable cause, String[] parameters) {
        super(DEFAULT_SYNCHRONIZATION_OPERATION_FAILED_MESSAGE, cause);
        this.message = new Message(code, parameters != null ? parameters : new String[]{});
    }

    public SynchronizationException(MessageCode code, String[] parameters) {
        this(code, null, parameters);
    }

    public SynchronizationException(MessageCode code) {
        super(DEFAULT_SYNCHRONIZATION_OPERATION_FAILED_MESSAGE);
        this.message = new Message(code, new String[0]);
    }

    public MessageCode getCode() {
        return this.message.getMessageCode();
    }

    public String[] getParameters() {
        return this.message.getParameters();
    }

    public String getMessage() {
        StringBuilder msg = new StringBuilder("message code: ").append((Object)this.message.getMessageCode());
        if (this.message.getParameters() != null) {
            msg.append(", parameters: {");
            for (int i = 0; i < this.message.getParameters().length; ++i) {
                if (i != 0) {
                    msg.append(", ");
                }
                msg.append(this.message.getParameters()[i]);
            }
        }
        return msg.toString();
    }
}

