/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.VersionRepository;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.SimulationFilter;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class RequestContext {
    private boolean processingComplete;
    private ResourcePath resourcePath;
    private String actualPath;
    private Resource resource;
    private String sourceURL;
    private String parentPath;
    private Collection parentCollection;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Registry registry;
    private Registry systemRegistry;
    private Repository repository;
    private VersionRepository versionRepository;
    private Aspect aspect;
    private String action;
    private String sourcePath;
    private String targetPath;
    private String targetSubPath;
    private String userName;
    private String tag;
    private String associationType;
    private int rating;
    private Comment comment;
    private String versionPath;
    private Map queryParameters;
    private String keywords;
    private Reader dumpingReader;
    private Writer dumpingWriter;
    private long bytesRead;
    private long bytesWritten;
    private boolean loggingActivity = true;
    private RegistryContext registryContext;
    private Resource oldResource;
    private List<Association> oldAssociationsOnSource;
    private List<Association> oldAssociationsOnTarget;
    private List<Tag> oldTags;
    private List<Comment> oldComments;
    private int oldRating;
    private float oldAverageRating;
    private Map<String, List<String[]>> handlerExecutionStatusMap;
    private static final String SUCCESSFUL = "Successful";
    private static final String FAILED = "Failed";
    private static ThreadLocal<Integer> handlerExecutionId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    private static Integer getHandlerExecutionId() {
        return handlerExecutionId.get();
    }

    private static void setHandlerExecutionId(Integer input) {
        handlerExecutionId.set(input);
    }

    public RequestContext(Registry registry, Repository repository, VersionRepository versionRepository) {
        this.registry = registry;
        this.repository = repository;
        this.versionRepository = versionRepository;
        this.handlerExecutionStatusMap = new HashMap<String, List<String[]>>();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Registry getSystemRegistry() throws RegistryException {
        if (this.systemRegistry == null) {
            this.systemRegistry = RegistryUtils.getSystemRegistry(this.registry);
        }
        return this.systemRegistry;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public VersionRepository getVersionRepository() {
        return this.versionRepository;
    }

    public boolean isProcessingComplete() {
        return this.processingComplete;
    }

    public void setProcessingComplete(boolean processingComplete) {
        this.processingComplete = processingComplete;
    }

    public ResourcePath getResourcePath() {
        if (this.resourcePath == null && this.resource != null) {
            this.resourcePath = new ResourcePath(this.resource.getPath());
        }
        return this.resourcePath;
    }

    public void setResourcePath(ResourcePath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public String getActualPath() {
        return this.actualPath;
    }

    public void setActualPath(String actualPath) {
        this.actualPath = actualPath;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Collection getParentCollection() {
        return this.parentCollection;
    }

    public void setParentCollection(Collection parentCollection) {
        this.parentCollection = parentCollection;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetSubPath() {
        return this.targetSubPath;
    }

    public void setTargetSubPath(String targetSubPath) {
        this.targetSubPath = targetSubPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public String getVersionPath() {
        return this.versionPath;
    }

    public void setVersionPath(String versionPath) {
        this.versionPath = versionPath;
    }

    public Map getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map queryParameters) {
        this.queryParameters = queryParameters;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public Reader getDumpingReader() {
        return this.dumpingReader;
    }

    public void setDumpingReader(Reader dumpingReader) {
        this.dumpingReader = dumpingReader;
    }

    public Writer getDumpingWriter() {
        return this.dumpingWriter;
    }

    public void setDumpingWriter(Writer dumpingWriter) {
        this.dumpingWriter = dumpingWriter;
    }

    public RegistryContext getRegistryContext() {
        return this.registryContext;
    }

    public void setRegistryContext(RegistryContext registryContext) {
        this.registryContext = registryContext;
    }

    public Resource getOldResource() {
        return this.oldResource;
    }

    public void setOldResource(Resource oldResource) {
        this.oldResource = oldResource;
    }

    public Association[] getOldAssociationsOnSource() {
        if (this.oldAssociationsOnSource == null) {
            return null;
        }
        return this.oldAssociationsOnSource.toArray(new Association[this.oldAssociationsOnSource.size()]);
    }

    public void setOldAssociationsOnSource(Association[] oldAssociationsOnSource) {
        if (oldAssociationsOnSource != null) {
            this.oldAssociationsOnSource = Arrays.asList(oldAssociationsOnSource);
        }
    }

    public Association[] getOldAssociationsOnTarget() {
        if (this.oldAssociationsOnTarget == null) {
            return null;
        }
        return this.oldAssociationsOnTarget.toArray(new Association[this.oldAssociationsOnTarget.size()]);
    }

    public void setOldAssociationsOnTarget(Association[] oldAssociationsOnTarget) {
        if (oldAssociationsOnTarget != null) {
            this.oldAssociationsOnTarget = Arrays.asList(oldAssociationsOnTarget);
        }
    }

    public Tag[] getOldTags() {
        if (this.oldTags == null) {
            return null;
        }
        return this.oldTags.toArray(new Tag[this.oldTags.size()]);
    }

    public void setOldTags(Tag[] oldTags) {
        if (oldTags != null) {
            this.oldTags = Arrays.asList(oldTags);
        }
    }

    public Comment[] getOldComments() {
        if (this.oldComments == null) {
            return null;
        }
        return this.oldComments.toArray(new Comment[this.oldComments.size()]);
    }

    public void setOldComments(Comment[] oldComments) {
        if (oldComments != null) {
            this.oldComments = Arrays.asList(oldComments);
        }
    }

    public int getOldRating() {
        return this.oldRating;
    }

    public void setOldRating(int oldRating) {
        this.oldRating = oldRating;
    }

    public float getOldAverageRating() {
        return this.oldAverageRating;
    }

    public void setOldAverageRating(float oldAverageRating) {
        this.oldAverageRating = oldAverageRating;
    }

    public synchronized String getHandlerExecutionIdString() {
        Integer executionId = RequestContext.getHandlerExecutionId() + 1;
        RequestContext.setHandlerExecutionId(executionId);
        return Integer.toString(executionId);
    }

    public void setExecutionStatus(Handler handler, boolean status) {
        if (handler == null) {
            return;
        }
        String handlerClass = handler.getClass().getName();
        List<String[]> statusList = this.handlerExecutionStatusMap.get(handlerClass);
        if (statusList == null) {
            statusList = new LinkedList<String[]>();
        }
        String[] statusArr = new String[]{status ? SUCCESSFUL : FAILED, this.getHandlerExecutionIdString()};
        statusList.add(statusArr);
        this.handlerExecutionStatusMap.put(handlerClass, statusList);
    }

    public void setExecutionStatus(Handler handler, Throwable exception) {
        if (handler == null) {
            return;
        }
        String handlerClass = handler.getClass().getName();
        List<String[]> statusList = this.handlerExecutionStatusMap.get(handlerClass);
        if (statusList == null) {
            statusList = new LinkedList<String[]>();
        }
        String[] statusArr = new String[]{exception.getMessage(), this.getHandlerExecutionIdString()};
        statusList.add(statusArr);
        this.handlerExecutionStatusMap.put(handlerClass, statusList);
    }

    public boolean isExecutionStatusSet(Handler handler) {
        return handler != null && this.handlerExecutionStatusMap.get(handler.getClass().getName()) != null;
    }

    public Map<String, List<String[]>> getHandlerExecutionStatusMap() {
        return this.handlerExecutionStatusMap;
    }

    public boolean isSimulation() {
        return SimulationFilter.isSimulation();
    }

    public boolean isLoggingActivity() {
        return this.loggingActivity;
    }

    public void setLoggingActivity(boolean loggingActivity) {
        this.loggingActivity = loggingActivity;
    }
}

