/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.ConcurrentModificationException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCPathCache;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCResourceDAO
implements ResourceDAO {
    private static final Log log = LogFactory.getLog(JDBCResourceDAO.class);
    private static final Object ADD_RESOURCE_LOCK = new Object();
    private static final Object ADD_CONTENT_LOCK = new Object();
    private static final Object ADD_PROPERTY_LOCK = new Object();
    private static final String SELECT_NAME_VALUE_PROP_P = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, ";

    @Override
    public ResourceIDImpl getResourceID(String path) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            JDBCPathCache pathCache = JDBCPathCache.getPathCache();
            int pathID = pathCache.getPathID(conn, path);
            boolean isCollection = true;
            if (pathID == -1) {
                isCollection = false;
            }
            String resourceName = null;
            if (!isCollection) {
                String parentPath = RegistryUtils.getParentPath(path);
                resourceName = RegistryUtils.getResourceName(path);
                pathID = pathCache.getPathID(conn, parentPath);
            }
            if (pathID != -1) {
                ResourceIDImpl resourceID = new ResourceIDImpl();
                resourceID.setCollection(isCollection);
                resourceID.setName(resourceName);
                resourceID.setPathID(pathID);
                resourceID.setPath(path);
                return resourceID;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get ID of the resource at path " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return null;
    }

    @Override
    public ResourceIDImpl getResourceID(String path, boolean isCollection) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            int pathID;
            String resourceName = null;
            if (isCollection) {
                pathID = JDBCPathCache.getPathCache().getPathID(conn, path);
            } else {
                String parentPath = path.equals("/") ? null : RegistryUtils.getParentPath(path);
                resourceName = RegistryUtils.getResourceName(path);
                pathID = JDBCPathCache.getPathCache().getPathID(conn, parentPath);
            }
            if (pathID != -1) {
                ResourceIDImpl resourceID = new ResourceIDImpl();
                resourceID.setCollection(isCollection);
                resourceID.setName(resourceName);
                resourceID.setPathID(pathID);
                resourceID.setPath(path);
                return resourceID;
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get ID of the resource at path " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return null;
    }

    @Override
    public boolean resourceExists(ResourceIDImpl resourceID) throws RegistryException {
        return this.getVersion(resourceID) != -1L;
    }

    @Override
    public boolean resourceExists(String path) throws RegistryException {
        ResourceIDImpl resourceID = this.getResourceID(path);
        if (resourceID == null) {
            return false;
        }
        if (this.resourceExists(resourceID)) {
            return true;
        }
        return resourceID.isCollection() && this.resourceExists(path, false);
    }

    @Override
    public boolean resourceExists(String path, boolean isCollection) throws RegistryException {
        ResourceIDImpl resourceID = this.getResourceID(path, isCollection);
        return resourceID != null && this.resourceExists(resourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getVersion(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        long version = -1L;
        try {
            String sql;
            if (resourceID.isCollection()) {
                sql = "SELECT REG_VERSION FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
                result = ps.executeQuery();
                if (result.next()) {
                    version = result.getLong("REG_VERSION");
                }
            } else {
                sql = "SELECT REG_VERSION FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setString(2, resourceID.getName());
                ps.setInt(3, CurrentSession.getTenantId());
                result = ps.executeQuery();
                if (result.next()) {
                    version = result.getLong("REG_VERSION");
                }
            }
        }
        catch (SQLException e) {
            String msg = "Failed to check the existence of the resource " + resourceID.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return version;
    }

    @Override
    public ResourceImpl get(String path) throws RegistryException {
        ResourceIDImpl resourceID = this.getResourceID(path);
        if (resourceID == null) {
            return null;
        }
        return this.get(resourceID);
    }

    @Override
    public ResourceImpl get(ResourceIDImpl resourceID) throws RegistryException {
        ResourceImpl resourceImpl = this.getResource(resourceID);
        if (resourceImpl == null) {
            return null;
        }
        this.fillResourceProperties(resourceImpl);
        return resourceImpl;
    }

    @Override
    public CollectionImpl get(String path, int start, int pageLen) throws RegistryException {
        ResourceIDImpl resourceID = this.getResourceID(path);
        if (resourceID == null) {
            return null;
        }
        return this.get(resourceID, start, pageLen);
    }

    @Override
    public CollectionImpl get(ResourceIDImpl resourceID, int start, int pageLen) throws RegistryException {
        CollectionImpl collection = (CollectionImpl)this.getResource(resourceID);
        if (collection == null) {
            return null;
        }
        this.fillChildren(collection, start, pageLen);
        this.fillResourceProperties(collection);
        return collection;
    }

    @Override
    public void fillResource(ResourceImpl resourceImpl) throws RegistryException {
        int tempTenantId;
        if (resourceImpl == null) {
            throw new RegistryException("Unable to fill null resource");
        }
        if (!(resourceImpl instanceof CollectionImpl) && resourceImpl.getDbBasedContentID() > 0) {
            this.fillResourceContentWithNoUpdate(resourceImpl);
        } else if (resourceImpl instanceof CollectionImpl && (tempTenantId = CurrentSession.getTenantId()) != -1 && tempTenantId != -1234) {
            JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
            this.fillChildren((CollectionImpl)resourceImpl, 0, -1, conn);
        }
        this.fillResourcePropertiesWithNoUpdate(resourceImpl);
    }

    @Override
    public void fillResource(CollectionImpl collection, int start, int pageLen) throws RegistryException {
        this.fillChildren(collection, start, pageLen);
        this.fillResourcePropertiesWithNoUpdate(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillResourcePropertiesWithNoUpdate(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            ResourceIDImpl resourceID;
            String propSQL;
            if (StaticConfiguration.isVersioningProperties()) {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_VERSION=? AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                ps.setLong(1, resourceImpl.getVersionNumber());
                ps.setInt(2, CurrentSession.getTenantId());
                ps.setInt(3, CurrentSession.getTenantId());
                results = ps.executeQuery();
            } else if (resourceImpl instanceof CollectionImpl) {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_PATH_ID=? AND RP.REG_RESOURCE_NAME IS NULL AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                resourceID = resourceImpl.getResourceIDImpl();
                ps.setLong(1, resourceID.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
                ps.setInt(3, CurrentSession.getTenantId());
                results = ps.executeQuery();
            } else {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_PATH_ID=? AND RP.REG_RESOURCE_NAME=? AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                resourceID = resourceImpl.getResourceIDImpl();
                ps.setLong(1, resourceID.getPathID());
                ps.setString(2, resourceID.getName());
                ps.setInt(3, CurrentSession.getTenantId());
                ps.setInt(4, CurrentSession.getTenantId());
                results = ps.executeQuery();
            }
            while (results.next()) {
                String name = results.getString("REG_NAME");
                String value = results.getString("REG_VALUE");
                resourceImpl.addPropertyWithNoUpdate(name, value);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add properties to the resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillResourceProperties(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            ResourceIDImpl resourceID;
            String propSQL;
            if (StaticConfiguration.isVersioningProperties()) {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_VERSION=? AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                ps.setLong(1, resourceImpl.getVersionNumber());
                ps.setInt(2, CurrentSession.getTenantId());
                ps.setInt(3, CurrentSession.getTenantId());
                results = ps.executeQuery();
            } else if (resourceImpl instanceof CollectionImpl) {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_PATH_ID=? AND RP.REG_RESOURCE_NAME IS NULL AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                resourceID = resourceImpl.getResourceIDImpl();
                ps.setLong(1, resourceID.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
                ps.setInt(3, CurrentSession.getTenantId());
                results = ps.executeQuery();
            } else {
                propSQL = "SELECT REG_NAME, REG_VALUE FROM REG_PROPERTY P, REG_RESOURCE_PROPERTY RP WHERE P.REG_ID=RP.REG_PROPERTY_ID AND RP.REG_PATH_ID=? AND RP.REG_RESOURCE_NAME=? AND P.REG_TENANT_ID=? AND RP.REG_TENANT_ID=?";
                ps = conn.prepareStatement(propSQL);
                resourceID = resourceImpl.getResourceIDImpl();
                ps.setLong(1, resourceID.getPathID());
                ps.setString(2, resourceID.getName());
                ps.setInt(3, CurrentSession.getTenantId());
                ps.setInt(4, CurrentSession.getTenantId());
                results = ps.executeQuery();
            }
            while (results.next()) {
                String name = results.getString("REG_NAME");
                String value = results.getString("REG_VALUE");
                resourceImpl.addProperty(name, value);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add properties to the resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        resourceImpl.setPropertiesModified(false);
    }

    @Override
    public void addRoot(ResourceImpl resourceImpl) throws RegistryException {
        String path = "/";
        this.createAndApplyResourceID(path, null, resourceImpl);
        this.addResourceWithoutContentId(resourceImpl, false);
        this.addProperties(resourceImpl);
    }

    @Override
    public void add(String path, ResourceIDImpl parentID, ResourceImpl resourceImpl) throws RegistryException {
        this.createAndApplyResourceID(path, parentID, resourceImpl);
        this.addResourceWithoutContentId(resourceImpl, false);
        if (!(resourceImpl instanceof Collection)) {
            this.addContent(resourceImpl);
            if (resourceImpl.getDbBasedContentID() > 0) {
                this.updateContentId(resourceImpl);
            }
        }
        this.addProperties(resourceImpl);
    }

    @Override
    public void createAndApplyResourceID(String path, ResourceIDImpl parentID, ResourceImpl resourceImpl) throws RegistryException {
        ResourceIDImpl resourceID = this.createResourceID(path, parentID, resourceImpl instanceof CollectionImpl);
        resourceImpl.setName(resourceID.getName());
        resourceImpl.setPath(resourceID.getPath());
        resourceImpl.setPathID(resourceID.getPathID());
    }

    @Override
    public ResourceIDImpl createResourceID(String path, ResourceIDImpl parentID, boolean isCollection) throws RegistryException {
        ResourceIDImpl resourceID = new ResourceIDImpl();
        try {
            int parentPathID = -1;
            if (parentID != null) {
                parentPathID = parentID.getPathID();
            }
            if (isCollection) {
                resourceID.setName(null);
                resourceID.setPath(path);
                JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
                JDBCPathCache pathCache = JDBCPathCache.getPathCache();
                int pathID = pathCache.getPathID(conn, path);
                if (pathID == -1) {
                    pathID = pathCache.addEntry(path, parentPathID);
                }
                resourceID.setPathID(pathID);
            } else {
                String resourceName = RegistryUtils.getResourceName(path);
                resourceID.setName(resourceName);
                resourceID.setPath(path);
                resourceID.setPathID(parentPathID);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to create the resource id for the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return resourceID;
    }

    @Override
    public void deleteContentStream(int contentID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String resourceContentSQL = "DELETE FROM REG_CONTENT WHERE REG_CONTENT_ID = ? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(resourceContentSQL);
            ps.setLong(1, contentID);
            ps.setInt(2, CurrentSession.getTenantId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getContentStream(int contentID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            InputStream rawInputStream;
            String resourceContentSQL = "SELECT REG_CONTENT_DATA  FROM  REG_CONTENT WHERE REG_CONTENT_ID = ? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(resourceContentSQL);
            ps.setLong(1, contentID);
            ps.setInt(2, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next() && (rawInputStream = result.getBinaryStream("REG_CONTENT_DATA")) != null) {
                InputStream inputStream = RegistryUtils.getMemoryStream(rawInputStream);
                return inputStream;
            }
        }
        catch (SQLException ex) {
            String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
            log.error((Object)msg, (Throwable)ex);
            throw new RegistryException(msg, ex);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void update(ResourceImpl resourceImpl) throws RegistryException {
        this.addResourceWithoutContentId(resourceImpl, true);
        if (!(resourceImpl instanceof CollectionImpl)) {
            this.addContent(resourceImpl);
            if (resourceImpl.getDbBasedContentID() > 0) {
                this.updateContentId(resourceImpl);
            }
        }
        this.addProperties(resourceImpl);
    }

    @Override
    public int getChildCount(CollectionImpl collection, DataAccessManager dataAccessManager) throws RegistryException {
        int childCount = -1;
        if (Transaction.isStarted()) {
            childCount = this.getChildCount(collection, JDBCDatabaseTransaction.getConnection());
        } else {
            Connection conn = null;
            boolean transactionSucceeded = false;
            try {
                if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                    String msg = "Failed to get child count. Invalid data access manager.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                conn = ((JDBCDataAccessManager)dataAccessManager).getDataSource().getConnection();
                JDBCDatabaseTransaction.ManagedRegistryConnection temp = JDBCDatabaseTransaction.getManagedRegistryConnection(conn);
                if (temp != null) {
                    conn.close();
                    conn = temp;
                }
                if (conn.getTransactionIsolation() != 2) {
                    conn.setTransactionIsolation(2);
                }
                conn.setAutoCommit(false);
                childCount = this.getChildCount(collection, conn);
                transactionSucceeded = true;
            }
            catch (SQLException e) {
                String msg = "Failed to get the child count of resource " + collection.getPath() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                if (transactionSucceeded) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to commit the database connection used in getting child count of the collection " + collection.getPath()));
                    }
                } else if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to rollback the database connection used in getting child count of the collection " + collection.getPath()));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to close the database connection used in getting child count of collection " + collection.getPath()));
                    }
                }
            }
        }
        return childCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(CollectionImpl collection, Connection conn) throws RegistryException {
        ResourceIDImpl resourceID = collection.getResourceIDImpl();
        ResultSet results1 = null;
        PreparedStatement ps1 = null;
        ResultSet results2 = null;
        Statement ps2 = null;
        int childCount = 0;
        try {
            String sql = "SELECT COUNT(R.REG_NAME) AS REG_RES_COUNT FROM REG_RESOURCE R WHERE R.REG_PATH_ID=? AND R.REG_TENANT_ID=?";
            ps1 = conn.prepareStatement(sql);
            ps1.setInt(1, resourceID.getPathID());
            ps1.setInt(2, CurrentSession.getTenantId());
            results1 = ps1.executeQuery();
            if (results1.next()) {
                childCount += results1.getInt("REG_RES_COUNT");
            }
            sql = "SELECT COUNT(P.REG_PATH_ID) AS REG_RES_COUNT FROM REG_PATH P, REG_RESOURCE R WHERE P.REG_PATH_PARENT_ID=? AND P.REG_TENANT_ID=? AND R.REG_PATH_ID=P.REG_PATH_ID AND R.REG_TENANT_ID=?";
            ps2 = conn.prepareStatement(sql);
            ps2.setInt(1, resourceID.getPathID());
            ps2.setInt(2, CurrentSession.getTenantId());
            ps2.setInt(3, CurrentSession.getTenantId());
            results2 = ps2.executeQuery();
            if (results2.next()) {
                childCount += results2.getInt("REG_RES_COUNT");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get child paths of resource " + collection.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results1 != null) {
                        results1.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        try {
                            if (results2 != null) {
                                results2.close();
                            }
                        }
                        finally {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return childCount;
    }

    @Override
    public void fillChildren(CollectionImpl collection, int start, int pageLen) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        this.fillChildren(collection, start, pageLen, conn);
    }

    @Override
    public void fillChildren(CollectionImpl collection, DataAccessManager dataAccessManager) throws RegistryException {
        if (Transaction.isStarted()) {
            this.fillChildren(collection, 0, -1, JDBCDatabaseTransaction.getConnection());
        } else {
            Connection conn = null;
            boolean transactionSucceeded = false;
            try {
                if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                    String msg = "Failed to fill children. Invalid data access manager.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                conn = ((JDBCDataAccessManager)dataAccessManager).getDataSource().getConnection();
                JDBCDatabaseTransaction.ManagedRegistryConnection temp = JDBCDatabaseTransaction.getManagedRegistryConnection(conn);
                if (temp != null) {
                    conn.close();
                    conn = temp;
                }
                if (conn.getTransactionIsolation() != 2) {
                    conn.setTransactionIsolation(2);
                }
                conn.setAutoCommit(false);
                this.fillChildren(collection, 0, -1, conn);
                transactionSucceeded = true;
            }
            catch (SQLException e) {
                String msg = "Failed to get child paths of " + collection.getPath() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                if (transactionSucceeded) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to commit the database connection used in getting child paths of the collection " + collection.getPath()));
                    }
                } else if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to rollback the database connection used in getting child paths of the collection " + collection.getPath()));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to close the database connection opened in getting the child paths of " + collection.getPath()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void fillChildren(CollectionImpl collection, int start, int pageLen, Connection conn) throws RegistryException {
        String[] childPaths = this.getChildren(collection, start, pageLen, conn);
        collection.setContent(childPaths);
        if (childPaths != null) {
            collection.setChildCount(childPaths.length);
        }
    }

    @Override
    public String[] getChildren(CollectionImpl collection, int start, int pageLen, DataAccessManager dataAccessManager) throws RegistryException {
        String[] childPaths = null;
        if (Transaction.isStarted()) {
            childPaths = this.getChildren(collection, start, pageLen, JDBCDatabaseTransaction.getConnection());
        } else {
            Connection conn = null;
            boolean transactionSucceeded = false;
            try {
                if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                    String msg = "Failed to get children. Invalid data access manager.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                conn = ((JDBCDataAccessManager)dataAccessManager).getDataSource().getConnection();
                JDBCDatabaseTransaction.ManagedRegistryConnection temp = JDBCDatabaseTransaction.getManagedRegistryConnection(conn);
                if (temp != null) {
                    conn.close();
                    conn = temp;
                }
                if (conn.getTransactionIsolation() != 2) {
                    conn.setTransactionIsolation(2);
                }
                conn.setAutoCommit(false);
                childPaths = this.getChildren(collection, start, pageLen, conn);
                transactionSucceeded = true;
            }
            catch (SQLException e) {
                String msg = "Failed to get the child paths " + pageLen + " child paths from " + start + " of resource " + collection.getPath() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                if (transactionSucceeded) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to commit the database connection used in getting child paths of the collection " + collection.getPath()));
                    }
                } else if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to rollback the database connection used in getting child paths of the collection " + collection.getPath()));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to close the database connection used in getting child paths of the collection " + collection.getPath()));
                    }
                }
            }
        }
        return childPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChildren(CollectionImpl collection, int start, int pageLen, Connection conn) throws RegistryException {
        ResourceIDImpl resourceID = collection.getResourceIDImpl();
        ResultSet results1 = null;
        PreparedStatement ps1 = null;
        ResultSet results2 = null;
        Statement ps2 = null;
        ResourcePath parentResourcePath = new ResourcePath(resourceID.getPath());
        String parentPath = parentResourcePath.getPath();
        try {
            int i;
            int totalSize;
            String childPath;
            String sql = "SELECT R.REG_NAME FROM REG_RESOURCE R WHERE R.REG_PATH_ID=? AND R.REG_TENANT_ID=?";
            ps1 = conn.prepareStatement(sql);
            ps1.setInt(1, resourceID.getPathID());
            ps1.setInt(2, CurrentSession.getTenantId());
            results1 = ps1.executeQuery();
            ArrayList<String> childResourcesList = new ArrayList<String>();
            ArrayList<String> childCollectionsList = new ArrayList<String>();
            while (results1.next()) {
                String childName = results1.getString("REG_NAME");
                if (childName == null) continue;
                childPath = parentPath + (parentPath.equals("/") ? "" : "/") + childName;
                ResourceIDImpl childResourceID = new ResourceIDImpl();
                childResourceID.setPath(childPath);
                childResourceID.setCollection(false);
                childResourceID.setName(childName);
                childResourceID.setPathID(resourceID.getPathID());
                if (!AuthorizationUtils.authorize(childPath, "http://www.wso2.org/projects/registry/actions/get")) continue;
                childResourcesList.add(childPath);
            }
            int end = start + pageLen;
            if (childResourcesList.size() < end || pageLen == -1) {
                sql = "SELECT P.REG_PATH_ID, P.REG_PATH_VALUE FROM REG_PATH P, REG_RESOURCE R WHERE P.REG_PATH_PARENT_ID=? AND P.REG_TENANT_ID=? AND R.REG_PATH_ID=P.REG_PATH_ID AND R.REG_NAME IS NULL AND R.REG_TENANT_ID=?";
                ps2 = conn.prepareStatement(sql);
                ps2.setInt(1, resourceID.getPathID());
                ps2.setInt(2, CurrentSession.getTenantId());
                ps2.setInt(3, CurrentSession.getTenantId());
                results2 = ps2.executeQuery();
                while (results2.next()) {
                    childPath = results2.getString("REG_PATH_VALUE");
                    int childPathId = results2.getInt("REG_PATH_ID");
                    ResourceIDImpl childResourceID = new ResourceIDImpl();
                    childResourceID.setPath(childPath);
                    childResourceID.setCollection(true);
                    childResourceID.setName(null);
                    childResourceID.setPathID(childPathId);
                    if (!AuthorizationUtils.authorize(childPath, "http://www.wso2.org/projects/registry/actions/get")) continue;
                    childCollectionsList.add(childPath);
                }
            }
            if ((totalSize = childResourcesList.size() + childCollectionsList.size()) < start) {
                throw new RegistryException("Didn't have enough results to start at #" + start);
            }
            Collections.sort(childResourcesList);
            Collections.sort(childCollectionsList);
            int currentPageLen = pageLen;
            if (currentPageLen == -1) {
                currentPageLen = totalSize - start;
                end = totalSize - 1;
            }
            int resultMaxSize = currentPageLen < totalSize - start ? currentPageLen : totalSize - start;
            String[] childPaths = new String[resultMaxSize];
            int current = 0;
            for (i = 0; i < childResourcesList.size() && current < resultMaxSize; ++i) {
                if (i < start || i > end) continue;
                childPaths[current] = (String)childResourcesList.get(i);
                ++current;
            }
            int j = 0;
            while (j < childCollectionsList.size() && current < resultMaxSize) {
                if (i >= start && i <= end) {
                    childPaths[current] = (String)childCollectionsList.get(j);
                    ++current;
                }
                ++j;
                ++i;
            }
            String[] stringArray = childPaths;
            return stringArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get child paths of resource " + collection.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results1 != null) {
                        results1.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        try {
                            if (results2 != null) {
                                results2.close();
                            }
                        }
                        finally {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public String[] getChildren(CollectionImpl collection, int start, int pageLen) throws RegistryException {
        return this.getChildren(collection, start, pageLen, JDBCDatabaseTransaction.getConnection());
    }

    @Override
    public ResourceImpl getResourceMetaData(String path) throws RegistryException {
        ResourceIDImpl resourceIDImpl = this.getResourceID(path);
        ResourceImpl resourceImpl = null;
        if (resourceIDImpl != null && (resourceImpl = this.getResourceMetaData(resourceIDImpl)) == null && resourceIDImpl.isCollection() && (resourceIDImpl = this.getResourceID(path, false)) != null) {
            resourceImpl = this.getResourceMetaData(resourceIDImpl);
        }
        return resourceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceImpl getResourceMetaData(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResourceImpl resourceImpl = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            String sql;
            boolean isCollection = resourceID.isCollection();
            int pathID = resourceID.getPathID();
            String resourceName = resourceID.getName();
            if (isCollection) {
                sql = "SELECT REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_VERSION, REG_DESCRIPTION, REG_CONTENT_ID, REG_UUID FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, pathID);
                ps.setInt(2, CurrentSession.getTenantId());
            } else {
                sql = "SELECT REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_VERSION, REG_DESCRIPTION, REG_CONTENT_ID, REG_UUID FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME = ? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, pathID);
                ps.setString(2, resourceName);
                ps.setInt(3, CurrentSession.getTenantId());
            }
            result = ps.executeQuery();
            if (result.next()) {
                resourceImpl = isCollection ? new CollectionImpl() : new ResourceImpl();
                resourceImpl.setPathID(resourceID.getPathID());
                resourceImpl.setPath(resourceID.getPath());
                resourceImpl.setName(resourceID.getName());
                resourceImpl.setMediaType(result.getString("REG_MEDIA_TYPE"));
                resourceImpl.setAuthorUserName(result.getString("REG_CREATOR"));
                resourceImpl.setCreatedTime(result.getTimestamp("REG_CREATED_TIME"));
                resourceImpl.setLastUpdaterUserName(result.getString("REG_LAST_UPDATOR"));
                resourceImpl.setLastModified(result.getTimestamp("REG_LAST_UPDATED_TIME"));
                resourceImpl.setVersionNumber(result.getInt("REG_VERSION"));
                resourceImpl.setDescription(result.getString("REG_DESCRIPTION"));
                resourceImpl.setDbBasedContentID(result.getInt("REG_CONTENT_ID"));
                resourceImpl.setUUID(result.getString("REG_UUID"));
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the resource at path " + resourceID.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return resourceImpl;
    }

    private ResourceImpl getResource(ResourceIDImpl resourceID) throws RegistryException {
        ResourceImpl resourceImpl = this.getResourceMetaData(resourceID);
        if (resourceImpl != null && !(resourceImpl instanceof CollectionImpl) && resourceImpl.getDbBasedContentID() > 0) {
            this.fillResourceContent(resourceImpl);
        }
        return resourceImpl;
    }

    @Override
    public ResourceImpl getResourceWithNoUpdate(ResourceIDImpl resourceID) throws RegistryException {
        ResourceImpl resourceImpl = this.getResourceMetaData(resourceID);
        if (resourceImpl != null && !(resourceImpl instanceof CollectionImpl) && resourceImpl.getDbBasedContentID() > 0) {
            this.fillResourceContentWithNoUpdate(resourceImpl);
        }
        return resourceImpl;
    }

    @Override
    public void fillResourceContent(ResourceImpl resourceImpl) throws RegistryException {
        int contentId = resourceImpl.getDbBasedContentID();
        InputStream contentStream = this.getContentStream(contentId);
        if (contentStream == null) {
            resourceImpl.setContent(null);
        } else {
            resourceImpl.setContentStream(contentStream);
        }
    }

    @Override
    public void fillResourceContentWithNoUpdate(ResourceImpl resourceImpl) throws RegistryException {
        int contentId = resourceImpl.getDbBasedContentID();
        InputStream contentStream = this.getContentStream(contentId);
        if (contentStream == null) {
            resourceImpl.setContentWithNoUpdate(null);
        } else {
            resourceImpl.setContentStreamWithNoUpdate(contentStream);
        }
    }

    @Override
    public void updateCollectionLastUpdatedTime(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        try {
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            String sql = dbProductName.contains("Microsoft") ? "UPDATE REG_RESOURCE WITH (NOWAIT) SET REG_LAST_UPDATED_TIME=? WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?" : "UPDATE REG_RESOURCE SET REG_LAST_UPDATED_TIME=? WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            long now = System.currentTimeMillis();
            ps.setTimestamp(1, new Timestamp(now));
            ps.setLong(2, resourceID.getPathID());
            ps.setInt(3, CurrentSession.getTenantId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Failed to update the last updated time for the collection. path: " + resourceID.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            if (msg.toLowerCase().contains("lock")) {
                throw new ConcurrentModificationException(msg, e);
            }
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void updateContentId(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE REG_RESOURCE SET REG_CONTENT_ID=? WHERE REG_VERSION=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, resourceImpl.getDbBasedContentID());
            ps.setLong(2, resourceImpl.getVersionNumber());
            ps.setInt(3, CurrentSession.getTenantId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Failed to update the content id: " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceWithoutContentId(ResourceImpl resourceImpl, boolean isUpdatingExisting) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        Statement ps1 = null;
        ResultSet result = null;
        ResourceIDImpl resourceID = resourceImpl.getResourceIDImpl();
        try {
            Object authorName;
            String sql = "INSERT INTO REG_RESOURCE (REG_PATH_ID, REG_NAME, REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_DESCRIPTION, REG_TENANT_ID, REG_UUID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String sql1 = "SELECT MAX(REG_VERSION) FROM REG_RESOURCE";
            long now = System.currentTimeMillis();
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps = returnsGeneratedKeys ? conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_VERSION")}) : conn.prepareStatement(sql);
            ps.setInt(1, resourceID.getPathID());
            ps.setString(2, resourceID.getName());
            ps.setString(3, resourceImpl.getMediaType());
            if (isUpdatingExisting) {
                authorName = resourceImpl.getAuthorUserName();
                if (authorName == null) {
                    authorName = CurrentSession.getUser();
                    resourceImpl.setAuthorUserName((String)authorName);
                }
                ps.setString(4, (String)authorName);
                Date createdTime = resourceImpl.getCreatedTime();
                Timestamp createdTimestamp = createdTime == null ? new Timestamp(now) : new Timestamp(createdTime.getTime());
                ps.setTimestamp(5, createdTimestamp);
            } else {
                ps.setString(4, CurrentSession.getUser());
                resourceImpl.setAuthorUserName(CurrentSession.getUser());
                ps.setTimestamp(5, new Timestamp(now));
            }
            ps.setString(6, CurrentSession.getUser());
            ps.setTimestamp(7, new Timestamp(now));
            ps.setString(8, resourceImpl.getDescription());
            ps.setInt(9, CurrentSession.getTenantId());
            ps.setString(10, resourceImpl.getUUID());
            if (returnsGeneratedKeys) {
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
            } else {
                authorName = ADD_RESOURCE_LOCK;
                synchronized (authorName) {
                    ps.executeUpdate();
                    ps1 = conn.prepareStatement(sql1);
                    result = ps1.executeQuery();
                }
            }
            if (result.next()) {
                long version = result.getLong(1);
                resourceImpl.setVersionNumber(version);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add resource to path " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void addResourceWithNoUpdate(ResourceImpl resourceImpl) throws RegistryException {
        ResourceDO resourceDO = resourceImpl.getResourceDO();
        this.addResourceDO(resourceDO);
        resourceImpl.setVersionNumber(resourceDO.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceDO(ResourceDO resourceDO) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        Statement ps1 = null;
        ResultSet result = null;
        try {
            String sql = "INSERT INTO REG_RESOURCE (REG_PATH_ID, REG_NAME, REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_DESCRIPTION, REG_CONTENT_ID, REG_TENANT_ID, REG_UUID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String sql1 = "SELECT MAX(REG_VERSION) FROM REG_RESOURCE";
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps = returnsGeneratedKeys ? conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_VERSION")}) : conn.prepareStatement(sql);
            ps.setInt(1, resourceDO.getPathID());
            ps.setString(2, resourceDO.getName());
            ps.setString(3, resourceDO.getMediaType());
            ps.setString(4, resourceDO.getAuthor());
            ps.setTimestamp(5, new Timestamp(resourceDO.getCreatedOn()));
            ps.setString(6, resourceDO.getLastUpdater());
            ps.setTimestamp(7, new Timestamp(resourceDO.getLastUpdatedOn()));
            ps.setString(8, resourceDO.getDescription());
            if (resourceDO.getContentID() > 0) {
                ps.setInt(9, resourceDO.getContentID());
            } else {
                ps.setNull(9, 4);
            }
            ps.setInt(10, CurrentSession.getTenantId());
            ps.setString(11, resourceDO.getUUID());
            if (returnsGeneratedKeys) {
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
            } else {
                Object object = ADD_RESOURCE_LOCK;
                synchronized (object) {
                    ps.executeUpdate();
                    ps1 = conn.prepareStatement(sql1);
                    result = ps1.executeQuery();
                }
            }
            if (result.next()) {
                long version = result.getLong(1);
                resourceDO.setVersion(version);
            }
            ps.close();
        }
        catch (SQLException e) {
            String msg = "Failed to add resource to version " + resourceDO.getVersion() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void deleteResource(ResourceDO resourceDO) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        try {
            String sql;
            if (resourceDO.getName() == null) {
                sql = "DELETE FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceDO.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
                ps.executeUpdate();
            } else {
                sql = "DELETE FROM REG_RESOURCE WHERE REG_PATH_ID=? AND REG_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceDO.getPathID());
                ps.setString(2, resourceDO.getName());
                ps.setInt(3, CurrentSession.getTenantId());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to delete the resource with id " + resourceDO.getVersion() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperties(ResourceImpl resource) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        boolean isVersioningProperties = StaticConfiguration.isVersioningProperties();
        String sql1 = "INSERT INTO REG_PROPERTY (REG_NAME, REG_VALUE, REG_TENANT_ID) VALUES (?, ?, ?)";
        String sql2 = "SELECT MAX(REG_ID) FROM REG_PROPERTY";
        String sql3 = isVersioningProperties ? "INSERT INTO REG_RESOURCE_PROPERTY (REG_PROPERTY_ID, REG_VERSION, REG_TENANT_ID) VALUES (?, ?, ?)" : "INSERT INTO REG_RESOURCE_PROPERTY (REG_PROPERTY_ID, REG_PATH_ID, REG_RESOURCE_NAME, REG_TENANT_ID) VALUES (?, ?, ?, ?)";
        ResourceIDImpl resourceID = resource.getResourceIDImpl();
        Properties props = resource.getProperties();
        if (props != null) {
            for (Object nameObj : props.keySet()) {
                String name = (String)nameObj;
                List propValues = (List)props.get(name);
                if (propValues == null) continue;
                for (Object valueObj : propValues) {
                    Statement ps1 = null;
                    Statement ps2 = null;
                    Statement ps3 = null;
                    ResultSet resultSet1 = null;
                    try {
                        String value = (String)valueObj;
                        String dbProductName = conn.getMetaData().getDatabaseProductName();
                        boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
                        ps1 = returnsGeneratedKeys ? conn.prepareStatement(sql1, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")}) : conn.prepareStatement(sql1);
                        ps3 = conn.prepareStatement(sql3);
                        ps1.setString(1, name);
                        ps1.setString(2, value);
                        ps1.setInt(3, CurrentSession.getTenantId());
                        if (returnsGeneratedKeys) {
                            ps1.executeUpdate();
                            resultSet1 = ps1.getGeneratedKeys();
                        } else {
                            Object object = ADD_PROPERTY_LOCK;
                            synchronized (object) {
                                ps1.executeUpdate();
                                ps2 = conn.prepareStatement(sql2);
                                resultSet1 = ps2.executeQuery();
                            }
                        }
                        if (!resultSet1.next()) continue;
                        int propertyId = resultSet1.getInt(1);
                        ps3.setInt(1, propertyId);
                        if (isVersioningProperties) {
                            ps3.setLong(2, resource.getVersionNumber());
                            ps3.setInt(3, CurrentSession.getTenantId());
                        } else {
                            ps3.setLong(2, resourceID.getPathID());
                            if (resourceID.getName() == null) {
                                ps3.setNull(3, 12);
                            } else {
                                ps3.setString(3, resourceID.getName());
                            }
                            ps3.setInt(4, CurrentSession.getTenantId());
                        }
                        ps3.executeUpdate();
                    }
                    catch (SQLException e) {
                        String msg = "Failed to add properties to the resource " + resource.getPath() + ". " + e.getMessage();
                        log.error((Object)msg, (Throwable)e);
                        throw new RegistryException(msg, e);
                    }
                    finally {
                        try {
                            try {
                                try {
                                    if (resultSet1 == null) continue;
                                    resultSet1.close();
                                }
                                finally {
                                    if (ps1 == null) continue;
                                    ps1.close();
                                }
                            }
                            finally {
                                try {
                                    if (ps2 == null) continue;
                                    ps2.close();
                                }
                                finally {
                                    if (ps3 == null) continue;
                                    ps3.close();
                                }
                            }
                        }
                        catch (SQLException ex) {
                            String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                            log.error((Object)msg, (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] getPropertyIds(ResourceDO resourceDO) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ArrayList<Integer> propertyIds = new ArrayList<Integer>();
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            String sql;
            if (StaticConfiguration.isVersioningProperties()) {
                sql = "SELECT REG_PROPERTY_ID FROM REG_RESOURCE_PROPERTY WHERE REG_VERSION=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setLong(1, resourceDO.getVersion());
                ps.setInt(2, CurrentSession.getTenantId());
            } else if (resourceDO.getName() == null) {
                sql = "SELECT REG_PROPERTY_ID FROM REG_RESOURCE_PROPERTY WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceDO.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
            } else {
                sql = "SELECT REG_PROPERTY_ID FROM REG_RESOURCE_PROPERTY WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceDO.getPathID());
                ps.setString(2, resourceDO.getName());
                ps.setInt(3, CurrentSession.getTenantId());
            }
            results = ps.executeQuery();
            while (results.next()) {
                int propertyId = results.getInt("REG_PROPERTY_ID");
                propertyIds.add(propertyId);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get properties on resource version" + resourceDO.getVersion() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return propertyIds.toArray(new Integer[propertyIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperties(ResourceDO resourceDO) throws RegistryException {
        block20: {
            JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
            PreparedStatement ps1 = null;
            Statement ps2 = null;
            Integer[] propertyIds = this.getPropertyIds(resourceDO);
            if (propertyIds == null) {
                return;
            }
            try {
                String sql = "DELETE FROM REG_RESOURCE_PROPERTY WHERE REG_PROPERTY_ID= ? AND REG_TENANT_ID=?";
                ps1 = conn.prepareStatement(sql);
                sql = "DELETE FROM REG_PROPERTY WHERE REG_ID= ? AND REG_TENANT_ID=?";
                ps2 = conn.prepareStatement(sql);
                for (Integer propertyId : propertyIds) {
                    ps1.setInt(1, propertyId);
                    ps1.setInt(2, CurrentSession.getTenantId());
                    ps2.setInt(1, propertyId);
                    ps2.setInt(2, CurrentSession.getTenantId());
                    ps1.addBatch();
                    ps2.addBatch();
                }
                if (propertyIds.length <= 0) break block20;
                try {
                    ps1.executeBatch();
                    ps2.executeBatch();
                }
                catch (SQLException e) {
                    ps1.clearBatch();
                    ps2.clearBatch();
                    throw e;
                }
            }
            catch (SQLException e) {
                String msg = "Failed to remove properties from resource version " + resourceDO.getVersion() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                try {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        if (ps2 != null) {
                            ps2.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void addContent(ResourceImpl resourceImpl) throws RegistryException {
        if (!(resourceImpl.getContent() instanceof byte[])) {
            if (log.isDebugEnabled()) {
                String msg = "Content of the resource " + resourceImpl.getPath() + " is null or " + "not a byte array. Content will not be persisted to the database.";
                log.debug((Object)msg);
            }
            resourceImpl.setDbBasedContentID(0);
            return;
        }
        InputStream contentStream = resourceImpl.getContentStream();
        int contentID = this.addContentBytes(contentStream);
        resourceImpl.setDbBasedContentID(contentID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addContentBytes(InputStream contentStream) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        int contentID = -1;
        try {
            String sql = "INSERT INTO REG_CONTENT (REG_CONTENT_DATA, REG_TENANT_ID) VALUES (?, ?)";
            String sql1 = "SELECT MAX(REG_CONTENT_ID) FROM REG_CONTENT";
            int size = contentStream.available();
            Statement ps1 = null;
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            PreparedStatement ps = returnsGeneratedKeys ? conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_CONTENT_ID")}) : conn.prepareStatement(sql);
            try {
                ResultSet result;
                ps.setBinaryStream(1, contentStream, size);
                ps.setInt(2, CurrentSession.getTenantId());
                if (returnsGeneratedKeys) {
                    ps.executeUpdate();
                    result = ps.getGeneratedKeys();
                } else {
                    Object object = ADD_CONTENT_LOCK;
                    synchronized (object) {
                        ps.executeUpdate();
                        if (dbProductName.equals("OpenEdge RDBMS")) {
                            String sql2 = "UPDATE REG_CONTENT SET REG_CONTENT_ID = PUB.REG_CONTENT_SEQUENCE.NEXTVAL WHERE REG_CONTENT_ID = 0";
                            PreparedStatement ps2 = null;
                            try {
                                ps2 = conn.prepareStatement(sql2);
                                ps2.executeUpdate();
                            }
                            finally {
                                if (ps2 != null) {
                                    ps2.close();
                                }
                            }
                        }
                        ps1 = conn.prepareStatement(sql1);
                        result = ps1.executeQuery();
                    }
                }
                try {
                    if (result.next()) {
                        contentID = result.getInt(1);
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            finally {
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
        catch (IOException e) {
            String msg = "An error occurred while processing content stream.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        catch (SQLException e) {
            String msg = "Failed to write resource content to the database.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return contentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceDO getResourceDO(long version) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            String sql = "SELECT REG_PATH_ID, REG_NAME, REG_MEDIA_TYPE, REG_CREATOR, REG_CREATED_TIME, REG_LAST_UPDATOR, REG_LAST_UPDATED_TIME, REG_DESCRIPTION, REG_CONTENT_ID, REG_UUID FROM REG_RESOURCE WHERE REG_VERSION = ? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, version);
            ps.setInt(2, CurrentSession.getTenantId());
            ResourceDO resourceDO = null;
            result = ps.executeQuery();
            if (result.next()) {
                resourceDO = new ResourceDO();
                resourceDO.setPathID(result.getInt("REG_PATH_ID"));
                resourceDO.setName(result.getString("REG_NAME"));
                resourceDO.setVersion(version);
                resourceDO.setMediaType(result.getString("REG_MEDIA_TYPE"));
                resourceDO.setAuthor(result.getString("REG_CREATOR"));
                resourceDO.setCreatedOn(result.getTimestamp("REG_CREATED_TIME").getTime());
                resourceDO.setLastUpdater(result.getString("REG_LAST_UPDATOR"));
                resourceDO.setLastUpdatedOn(result.getTimestamp("REG_LAST_UPDATED_TIME").getTime());
                resourceDO.setDescription(result.getString("REG_DESCRIPTION"));
                resourceDO.setContentID(result.getInt("REG_CONTENT_ID"));
                resourceDO.setUUID(result.getString("REG_UUID"));
            }
            ResourceDO resourceDO2 = resourceDO;
            return resourceDO2;
        }
        catch (SQLException e) {
            String msg = "Failed to read resource version data for resource version:" + version + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public ResourceDO getResourceDO(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            if (resourceID.isCollection()) {
                String sql = "SELECT  R.REG_PATH_ID, R.REG_NAME, R.REG_VERSION, R.REG_MEDIA_TYPE, R.REG_CREATOR, R.REG_CREATED_TIME, R.REG_LAST_UPDATOR, R.REG_LAST_UPDATED_TIME, R.REG_DESCRIPTION, R.REG_CONTENT_ID, R.REG_UUID FROM REG_RESOURCE R WHERE R.REG_PATH_ID=? AND R.REG_NAME IS NULL AND R.REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setInt(2, CurrentSession.getTenantId());
            } else {
                String sql = "SELECT  R.REG_PATH_ID, R.REG_NAME, R.REG_VERSION, R.REG_MEDIA_TYPE, R.REG_CREATOR, R.REG_CREATED_TIME, R.REG_LAST_UPDATOR, R.REG_LAST_UPDATED_TIME, R.REG_DESCRIPTION, R.REG_CONTENT_ID, R.REG_UUID FROM REG_RESOURCE R WHERE R.REG_PATH_ID=? AND R.REG_NAME=? AND R.REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, resourceID.getPathID());
                ps.setString(2, resourceID.getName());
                ps.setInt(3, CurrentSession.getTenantId());
            }
            ResourceDO resourceDO = null;
            result = ps.executeQuery();
            if (result.next()) {
                resourceDO = new ResourceDO();
                resourceDO.setPathID(result.getInt("REG_PATH_ID"));
                resourceDO.setName(result.getString("REG_NAME"));
                resourceDO.setVersion(result.getInt("REG_VERSION"));
                resourceDO.setMediaType(result.getString("REG_MEDIA_TYPE"));
                resourceDO.setAuthor(result.getString("REG_CREATOR"));
                resourceDO.setCreatedOn(result.getTimestamp("REG_CREATED_TIME").getTime());
                resourceDO.setLastUpdater(result.getString("REG_LAST_UPDATOR"));
                resourceDO.setLastUpdatedOn(result.getTimestamp("REG_LAST_UPDATED_TIME").getTime());
                resourceDO.setDescription(result.getString("REG_DESCRIPTION"));
                resourceDO.setContentID(result.getInt("REG_CONTENT_ID"));
                resourceDO.setUUID(result.getString("REG_UUID"));
            }
            ResourceDO resourceDO2 = resourceDO;
            return resourceDO2;
        }
        catch (SQLException e) {
            String msg = "Failed to read resource version data for resource " + resourceID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    log.error((Object)"A SQLException error has occurred when trying to close result set or prepared statement", (Throwable)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error((Object)"A SQLException error has occurred when trying to close result set or prepared statement", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<ResourceIDImpl> getChildPathIds(ResourceIDImpl resourceID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ArrayList<ResourceIDImpl> childPathList = new ArrayList<ResourceIDImpl>();
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            String sql = "SELECT R.REG_NAME FROM REG_RESOURCE R WHERE R.REG_PATH_ID=? AND R.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, resourceID.getPathID());
            ps.setInt(2, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                String childName = results.getString("REG_NAME");
                if (childName == null) continue;
                String parentPath = resourceID.getPath();
                String childPath = parentPath + (parentPath.equals("/") ? "" : "/") + childName;
                ResourceIDImpl childResourceID = new ResourceIDImpl();
                childResourceID.setPath(childPath);
                childResourceID.setCollection(false);
                childResourceID.setName(childName);
                childResourceID.setPathID(resourceID.getPathID());
                childPathList.add(childResourceID);
            }
            results.close();
            results = null;
            ps.close();
            ps = null;
            sql = "SELECT P.REG_PATH_ID, P.REG_PATH_VALUE FROM REG_PATH P, REG_RESOURCE R WHERE P.REG_PATH_PARENT_ID=? AND P.REG_TENANT_ID=? AND R.REG_PATH_ID=P.REG_PATH_ID AND R.REG_NAME IS NULL AND R.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, resourceID.getPathID());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                String childPath = results.getString("REG_PATH_VALUE");
                int childPathId = results.getInt("REG_PATH_ID");
                ResourceIDImpl childResourceID = new ResourceIDImpl();
                childResourceID.setPath(childPath);
                childResourceID.setCollection(true);
                childResourceID.setName(null);
                childResourceID.setPathID(childPathId);
                childPathList.add(childResourceID);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get child paths of resource " + resourceID.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    log.error((Object)"A SQLException error has occurred when trying to close result set or prepared statement", (Throwable)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error((Object)"A SQLException error has occurred when trying to close result set or prepared statement", (Throwable)e);
                }
            }
        }
        return childPathList;
    }

    @Override
    public String getPathFromId(int pathId) throws RegistryException {
        try {
            return JDBCPathCache.getPathCache().getPath(JDBCDatabaseTransaction.getConnection(), pathId);
        }
        catch (SQLException e) {
            String msg = "Failed to get the path for the path id " + pathId + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    @Override
    public String getPath(long version) throws RegistryException {
        ResourceDO resourceDO = this.getResourceDO(version);
        if (resourceDO == null) {
            return null;
        }
        return this.getPath(resourceDO.getPathID(), resourceDO.getName(), false);
    }

    @Override
    public String getPath(int pathId, String resourceName, boolean checkExistence) throws RegistryException {
        String pathCollection = this.getPathFromId(pathId);
        if (pathCollection == null) {
            return null;
        }
        String correctPath = resourceName == null ? pathCollection : (pathCollection.equals("/") ? pathCollection + resourceName : pathCollection + "/" + resourceName);
        if (checkExistence) {
            ResourceIDImpl resourceID = new ResourceIDImpl();
            resourceID.setCollection(resourceName == null);
            resourceID.setName(resourceName);
            resourceID.setPath(correctPath);
            resourceID.setPathID(pathId);
            ResourceDO resourceDO = this.getResourceDO(resourceID);
            if (resourceDO == null) {
                return null;
            }
        }
        return correctPath;
    }

    @Override
    public void moveResources(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        try {
            String sql;
            if (source.isCollection()) {
                sql = "UPDATE REG_RESOURCE SET REG_PATH_ID=? WHERE REG_PATH_ID=? AND REG_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, target.getPathID());
                ps.setInt(2, source.getPathID());
                ps.setInt(3, CurrentSession.getTenantId());
                ps.executeUpdate();
            } else {
                sql = "UPDATE REG_RESOURCE SET REG_PATH_ID=?, REG_NAME =? WHERE REG_PATH_ID=? AND REG_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, target.getPathID());
                ps.setString(2, target.getName());
                ps.setInt(3, source.getPathID());
                ps.setString(4, source.getName());
                ps.setInt(5, CurrentSession.getTenantId());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to move resource from  " + source.getPath() + " to " + target.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void moveResourcePaths(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE REG_RESOURCE SET REG_PATH_ID=? WHERE REG_PATH_ID=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, target.getPathID());
            ps.setInt(2, source.getPathID());
            ps.setInt(3, CurrentSession.getTenantId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Failed to move resource paths from  " + source.getPath() + " to " + target.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void moveProperties(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
        if (StaticConfiguration.isVersioningProperties()) {
            return;
        }
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps = null;
        try {
            String sql;
            if (source.isCollection()) {
                sql = "UPDATE REG_RESOURCE_PROPERTY SET REG_PATH_ID=? WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME IS NULL AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, target.getPathID());
                ps.setInt(2, source.getPathID());
                ps.setInt(3, CurrentSession.getTenantId());
                ps.executeUpdate();
            } else {
                sql = "UPDATE REG_RESOURCE_PROPERTY SET REG_PATH_ID=?, REG_RESOURCE_NAME=? WHERE REG_PATH_ID=? AND REG_RESOURCE_NAME=? AND REG_TENANT_ID=?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, target.getPathID());
                ps.setString(2, target.getName());
                ps.setInt(3, source.getPathID());
                ps.setString(4, source.getName());
                ps.setInt(5, CurrentSession.getTenantId());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to move properties from  " + source.getPath() + " to " + target.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void movePropertyPaths(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
        if (StaticConfiguration.isVersioningProperties()) {
            return;
        }
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        try {
            String sql = "UPDATE REG_RESOURCE_PROPERTY SET REG_PATH_ID=? WHERE REG_PATH_ID=? AND REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, target.getPathID());
            ps.setInt(2, source.getPathID());
            ps.setInt(3, CurrentSession.getTenantId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Failed to move property paths from  " + source.getPath() + " to " + target.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }
}

