/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.runners.model.RunnerScheduler;

public class ParallelScheduler
implements RunnerScheduler {
    private Queue<Future<String>> tasks = new LinkedList<Future<String>>();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private CompletionService<String> completionService = new ExecutorCompletionService<String>(this.executorService);

    public void schedule(final Runnable childStatement) {
        Future<String> future = this.completionService.submit(new Callable<String>(){

            @Override
            public String call() {
                childStatement.run();
                return this.toString();
            }

            public String toString() {
                return childStatement.toString();
            }
        });
        this.tasks.add(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        try {
            while (!this.tasks.isEmpty()) {
                Future<String> task = this.completionService.take();
                this.tasks.remove(task);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            while (!this.tasks.isEmpty()) {
                this.tasks.poll().cancel(true);
            }
            this.executorService.shutdownNow();
        }
    }
}

