/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.RFC3280CertPathUtilitiesHelper;
import eu.emi.security.authn.x509.helpers.revocation.RevocationChecker;
import eu.emi.security.authn.x509.helpers.revocation.RevocationStatus;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class CRLRevocationChecker
implements RevocationChecker {
    private ExtPKIXParameters paramsPKIX;
    private Date validDate;
    private PublicKey workingPublicKey;
    private List<?> certificates;
    private CrlCheckingMode checkingMode;

    public CRLRevocationChecker(ExtPKIXParameters paramsPKIX, Date validDate, PublicKey workingPublicKey, List<?> certificates, CrlCheckingMode checkingMode) {
        this.paramsPKIX = paramsPKIX;
        this.validDate = validDate;
        this.workingPublicKey = workingPublicKey;
        this.certificates = certificates;
        this.checkingMode = checkingMode;
    }

    @Override
    public RevocationStatus checkRevocation(X509Certificate certitifcate, X509Certificate issuer) throws SimpleValidationErrorException {
        if (this.checkingMode == CrlCheckingMode.IGNORE) {
            return RevocationStatus.unknown;
        }
        try {
            RFC3280CertPathUtilitiesHelper.checkCRLs2(this.paramsPKIX, certitifcate, this.validDate, issuer, this.workingPublicKey, this.certificates);
        }
        catch (SimpleValidationErrorException e) {
            if (e.getCode() == ValidationErrorCode.noValidCrlFound && this.checkingMode == CrlCheckingMode.IF_VALID) {
                return RevocationStatus.unknown;
            }
            throw e;
        }
        return RevocationStatus.verified;
    }
}

