/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValue<T>
extends AbstractItem {
    private T value;

    public ObjectValue(T object) {
        if (object == null) {
            throw new NullPointerException("External object cannot wrap a Java null");
        }
        this.value = object;
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.value.toString();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return new ExternalObjectType(this.value.getClass());
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return true;
    }

    public T getObject() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectValue) {
            T o = ((ObjectValue)other).value;
            return this.value.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

