/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.DefaultKeyStorePasswordCallback;
import org.apache.airavata.common.utils.KeyStorePasswordCallback;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.CredentialWriter;
import org.apache.airavata.credential.store.store.impl.db.CredentialsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHCredentialWriter
implements CredentialWriter {
    private CredentialsDAO credentialsDAO;
    private DBUtil dbUtil;
    protected static Logger logger = LoggerFactory.getLogger(SSHCredentialWriter.class);

    public SSHCredentialWriter(DBUtil dbUtil) throws ApplicationSettingsException {
        this.dbUtil = dbUtil;
        this.credentialsDAO = new CredentialsDAO(ApplicationSettings.getCredentialStoreKeyStorePath(), ApplicationSettings.getCredentialStoreKeyAlias(), (KeyStorePasswordCallback)new DefaultKeyStorePasswordCallback());
    }

    @Override
    public void writeCredentials(Credential credential) throws CredentialStoreException {
        SSHCredential sshCredential = (SSHCredential)credential;
        Connection connection = null;
        try {
            connection = this.dbUtil.getConnection();
            this.credentialsDAO.deleteCredentials(sshCredential.getGateway(), sshCredential.getToken(), connection);
            this.credentialsDAO.addCredentials(sshCredential.getGateway(), credential, connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    logger.error("Unable to rollback transaction", (Throwable)e1);
                }
            }
            throw new CredentialStoreException("Unable to retrieve database connection.", e);
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }
}

