/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionProxyType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class CollectionProxyId
implements IdentifiedDataSerializable {
    String name;
    String keyName;
    CollectionProxyType type;

    public CollectionProxyId() {
    }

    public CollectionProxyId(String name, String keyName, CollectionProxyType type) {
        this.name = name;
        this.keyName = keyName;
        this.type = type;
    }

    @Override
    public int getFactoryId() {
        return CollectionDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 38;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.type.getType());
        out.writeUTF(this.keyName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.type = CollectionProxyType.getByType(in.readInt());
        this.keyName = in.readUTF();
    }

    public String getName() {
        return this.name;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public CollectionProxyType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionProxyId)) {
            return false;
        }
        CollectionProxyId proxyId = (CollectionProxyId)o;
        if (this.keyName != null ? !this.keyName.equals(proxyId.keyName) : proxyId.keyName != null) {
            return false;
        }
        if (!this.name.equals(proxyId.name)) {
            return false;
        }
        return this.type == proxyId.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CollectionProxyId");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", keyName='").append(this.keyName).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }
}

