/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentStatistics;
import org.apache.airavata.model.experiment.ExperimentSummaryModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.QueueStatusModel;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentStatisticsResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentSummaryResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.GatewayResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResourceScheduleResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.QueueStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserConfigurationDataResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.WorkerResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRegistry {
    private GatewayResource gatewayResource;
    private WorkerResource workerResource;
    private static final Logger logger = LoggerFactory.getLogger(ExperimentRegistry.class);

    public ExperimentRegistry(GatewayResource gateway, UserResource user) throws RegistryException {
        this.gatewayResource = gateway;
        this.workerResource = !this.gatewayResource.isExists(ResourceType.GATEWAY_WORKER, user.getUserName()) ? ExpCatResourceUtils.addGatewayWorker(gateway, user) : (WorkerResource)ExpCatResourceUtils.getWorker(gateway.getGatewayId(), user.getUserName());
    }

    public String addExperiment(ExperimentModel experiment) throws RegistryException {
        String experimentId;
        try {
            if (!ExpCatResourceUtils.isUserExist(experiment.getUserName(), experiment.getGatewayId())) {
                ExpCatResourceUtils.addUser(experiment.getUserName(), null, experiment.getGatewayId());
            }
            if (!this.workerResource.isProjectExists(experiment.getProjectId())) {
                logger.error("Project does not exist in the system..");
                throw new Exception("Project does not exist in the system, Please create the project first...");
            }
            experimentId = AiravataUtils.getId((String)experiment.getExperimentName());
            experiment.setExperimentId(experimentId);
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setExperimentId(experimentId);
            experimentResource.setProjectId(experiment.getProjectId());
            experimentResource.setGatewayId(experiment.getGatewayId());
            experimentResource.setExperimentType(experiment.getExperimentType().toString());
            experimentResource.setUserName(experiment.getUserName());
            experimentResource.setExperimentName(experiment.getExperimentName());
            experimentResource.setCreationTime(AiravataUtils.getTime((long)experiment.getCreationTime()));
            experimentResource.setDescription(experiment.getDescription());
            experimentResource.setExecutionId(experiment.getExecutionId());
            experimentResource.setGatewayExecutionId(experiment.getGatewayExecutionId());
            experimentResource.setGatewayInstanceId(experiment.getGatewayInstanceId());
            if (experiment.isEnableEmailNotification()) {
                experimentResource.setEnableEmailNotification(true);
                if (experiment.getEmailAddresses() != null) {
                    experimentResource.setEmailAddresses(StringUtils.join((Collection)experiment.getEmailAddresses(), (String)","));
                }
            } else {
                experimentResource.setEnableEmailNotification(false);
            }
            experimentResource.save();
            if (experiment.getUserConfigurationData() != null) {
                this.addUserConfigData(experiment.getUserConfigurationData(), experimentId);
            }
            if (experiment.getExperimentInputs() != null && experiment.getExperimentInputs().size() > 0) {
                this.addExpInputs(experiment.getExperimentInputs(), experimentId);
            }
            if (experiment.getExperimentOutputs() != null && experiment.getExperimentOutputs().size() > 0) {
                this.addExpOutputs(experiment.getExperimentOutputs(), experimentId);
            }
            ExperimentStatus experimentStatus = new ExperimentStatus();
            experimentStatus.setState(ExperimentState.CREATED);
            experimentStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            this.addExperimentStatus(experimentStatus, experimentId);
            List errors = experiment.getErrors();
            if (errors != null && !errors.isEmpty()) {
                for (ErrorModel errror : errors) {
                    this.addExperimentError(errror, experimentId);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while saving experiment to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentId;
    }

    public String addUserConfigData(UserConfigurationDataModel configurationData, String experimentId) throws RegistryException {
        try {
            UserConfigurationDataResource configDataResource = new UserConfigurationDataResource();
            configDataResource.setExperimentId(experimentId);
            configDataResource.setAiravataAutoSchedule(configurationData.isAiravataAutoSchedule());
            configDataResource.setOverrideManualScheduledParams(configurationData.isOverrideManualScheduledParams());
            configDataResource.setShareExperimentPublically(configurationData.isShareExperimentPublicly());
            configDataResource.setThrottleResources(configurationData.isThrottleResources());
            configDataResource.setUserDn(configurationData.getUserDN());
            configDataResource.setGenerateCert(configurationData.isGenerateCert());
            configDataResource.setResourceHostId(configurationData.getComputationalResourceScheduling().getResourceHostId());
            configDataResource.setTotalCpuCount(configurationData.getComputationalResourceScheduling().getTotalCPUCount());
            configDataResource.setNodeCount(configurationData.getComputationalResourceScheduling().getNodeCount());
            configDataResource.setNumberOfThreads(configurationData.getComputationalResourceScheduling().getNumberOfThreads());
            configDataResource.setQueueName(configurationData.getComputationalResourceScheduling().getQueueName());
            configDataResource.setWallTimeLimit(configurationData.getComputationalResourceScheduling().getWallTimeLimit());
            configDataResource.setTotalPhysicalMemory(configurationData.getComputationalResourceScheduling().getTotalPhysicalMemory());
            configDataResource.setStaticWorkingDir(configurationData.getComputationalResourceScheduling().getStaticWorkingDir());
            configDataResource.setStorageId(configurationData.getStorageId());
            configDataResource.setExperimentDataDir(configurationData.getExperimentDataDir());
            configDataResource.setUseUserCRPref(configurationData.isUseUserCRPref());
            configDataResource.setOverrideLoginUserName(configurationData.getComputationalResourceScheduling().getOverrideLoginUserName());
            configDataResource.setOverrideScratchLocation(configurationData.getComputationalResourceScheduling().getOverrideScratchLocation());
            configDataResource.setOverrideAllocationProjectNumber(configurationData.getComputationalResourceScheduling().getOverrideAllocationProjectNumber());
            configDataResource.save();
        }
        catch (Exception e) {
            logger.error("Unable to save user config data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentId;
    }

    public String addExpInputs(List<InputDataObjectType> exInputs, String experimentId) throws RegistryException {
        try {
            for (InputDataObjectType input : exInputs) {
                ExperimentInputResource resource = new ExperimentInputResource();
                resource.setExperimentId(experimentId);
                resource.setInputName(input.getName());
                resource.setInputValue(input.getValue());
                if (input.getType() != null) {
                    resource.setDataType(input.getType().toString());
                }
                resource.setMetadata(input.getMetaData());
                resource.setApplicationArgument(input.getApplicationArgument());
                resource.setInputOrder(input.getInputOrder());
                resource.setIsRequired(input.isIsRequired());
                resource.setRequiredToAddedToCmd(input.isRequiredToAddedToCommandLine());
                resource.setStorageResourceId(input.getStorageResourceId());
                resource.setIsReadOnly(input.isIsReadOnly());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Unable to save experiment inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentId;
    }

    public String addExpOutputs(List<OutputDataObjectType> exOutput, String expId) throws RegistryException {
        try {
            for (OutputDataObjectType output : exOutput) {
                ExperimentOutputResource resource = new ExperimentOutputResource();
                resource.setExperimentId(expId);
                resource.setOutputName(output.getName());
                resource.setOutputValue(output.getValue());
                if (output.getType() != null) {
                    resource.setDataType(output.getType().toString());
                }
                resource.setApplicationArgument(output.getApplicationArgument());
                resource.setIsRequired(output.isIsRequired());
                resource.setRequiredToAddedToCmd(output.isRequiredToAddedToCommandLine());
                resource.setDataMovement(output.isDataMovement());
                resource.setLocation(output.getLocation());
                resource.setSearchQuery(output.getSearchQuery());
                resource.setOutputStreaming(output.isOutputStreaming());
                resource.setStorageResourceId(output.getStorageResourceId());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding experiment outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return expId;
    }

    public String addExperimentStatus(ExperimentStatus experimentStatus, String expId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            experiment.setExperimentId(expId);
            ExperimentStatusResource status = experiment.getExperimentStatus();
            ExperimentState newState = experimentStatus.getState();
            if (status == null) {
                status = (ExperimentStatusResource)experiment.create(ResourceType.EXPERIMENT_STATUS);
                status.setStatusId(this.getStatusID("EXPERIMENT_STATE"));
            } else {
                String state = status.getState();
                if (newState != null && !state.equals(newState.toString())) {
                    status.setStatusId(this.getStatusID("EXPERIMENT_STATE"));
                }
            }
            status.setExperimentId(expId);
            status.setTimeOfStateChange(AiravataUtils.getTime((long)experimentStatus.getTimeOfStateChange()));
            if (newState != null) {
                status.setState(newState.toString());
            }
            status.setReason(experimentStatus.getReason());
            status.save();
            logger.debug(expId, new Object[]{"Added experiment {} status to {}.", expId, experimentStatus.toString()});
        }
        catch (Exception e) {
            logger.error(expId, (Object)"Error while adding experiment status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return expId;
    }

    public String addExperimentError(ErrorModel experimentError, String expId) throws RegistryException {
        try {
            ExperimentErrorResource error = new ExperimentErrorResource();
            if (experimentError.getErrorId() == null) {
                error.setErrorId(AiravataUtils.getId((String)"EXP_ERROR"));
            } else {
                error.setErrorId(experimentError.getErrorId());
            }
            error.setExperimentId(expId);
            error.setCreationTime(AiravataUtils.getTime((long)experimentError.getCreationTime()));
            error.setActualErrorMessage(experimentError.getActualErrorMessage());
            error.setUserFriendlyMessage(experimentError.getUserFriendlyMessage());
            error.setTransientOrPersistent(experimentError.isTransientOrPersistent());
            if (experimentError.getRootCauseErrorIdList() != null) {
                error.setRootCauseErrorIdList(StringUtils.join((Collection)experimentError.getRootCauseErrorIdList(), (String)","));
            }
            error.save();
        }
        catch (Exception e) {
            logger.error(expId, (Object)"Error while updating experiment status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return expId;
    }

    public String addProcess(ProcessModel process, String expId) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            String processId = AiravataUtils.getId((String)"PROCESS");
            process.setProcessId(processId);
            processResource.setProcessId(processId);
            processResource.setExperimentId(expId);
            processResource.setCreationTime(AiravataUtils.getTime((long)process.getCreationTime()));
            processResource.setLastUpdateTime(AiravataUtils.getTime((long)process.getLastUpdateTime()));
            processResource.setProcessDetail(process.getProcessDetail());
            processResource.setApplicationInterfaceId(process.getApplicationInterfaceId());
            processResource.setTaskDag(process.getTaskDag());
            processResource.setGatewayExecutionId(process.getGatewayExecutionId());
            processResource.setComputeResourceId(process.getComputeResourceId());
            processResource.setApplicationInterfaceId(process.getApplicationInterfaceId());
            processResource.setStorageResourceId(process.getStorageResourceId());
            processResource.setUserDn(process.getUserDn());
            processResource.setGenerateCert(process.isGenerateCert());
            processResource.setExperimentDataDir(process.getExperimentDataDir());
            processResource.setUserName(process.getUserName());
            processResource.setUseUserCRPref(process.isUseUserCRPref());
            if (process.isEnableEmailNotification()) {
                processResource.setEnableEmailNotification(true);
                if (process.getEmailAddresses() != null) {
                    processResource.setEmailAddresses(StringUtils.join((Collection)process.getEmailAddresses(), (String)","));
                }
            } else {
                processResource.setEnableEmailNotification(false);
            }
            processResource.save();
            if (process.getProcessResourceSchedule() != null) {
                this.addProcessResourceSchedule(process.getProcessResourceSchedule(), process.getProcessId());
            }
            if (process.getProcessInputs() != null && process.getProcessInputs().size() > 0) {
                this.addProcessInputs(process.getProcessInputs(), process.getProcessId());
            }
            if (process.getProcessOutputs() != null && process.getProcessOutputs().size() > 0) {
                this.addProcessOutputs(process.getProcessOutputs(), process.getProcessId());
            }
            ProcessStatus processStatus = new ProcessStatus();
            processStatus.setState(ProcessState.CREATED);
            ArrayList<ProcessStatus> processStatuses = new ArrayList<ProcessStatus>();
            processStatuses.add(processStatus);
            this.addProcessStatus((ProcessStatus)processStatuses.get(0), process.getProcessId());
            if (process.getProcessErrors() != null) {
                this.addProcessError((ErrorModel)process.getProcessErrors().get(0), process.getProcessId());
            }
        }
        catch (Exception e) {
            logger.error(expId, (Object)"Error while adding process...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return process.getProcessId();
    }

    public String addProcessResourceSchedule(ComputationalResourceSchedulingModel resourceSchedule, String processID) throws RegistryException {
        try {
            ProcessResourceScheduleResource processResourceSchedule = new ProcessResourceScheduleResource();
            processResourceSchedule.setProcessId(processID);
            processResourceSchedule.setResourceHostId(resourceSchedule.getResourceHostId());
            processResourceSchedule.setTotalCpuCount(resourceSchedule.getTotalCPUCount());
            processResourceSchedule.setNodeCount(resourceSchedule.getNodeCount());
            processResourceSchedule.setNumberOfThreads(resourceSchedule.getNumberOfThreads());
            processResourceSchedule.setQueueName(resourceSchedule.getQueueName());
            processResourceSchedule.setWallTimeLimit(resourceSchedule.getWallTimeLimit());
            processResourceSchedule.setTotalPhysicalMemory(resourceSchedule.getTotalPhysicalMemory());
            processResourceSchedule.setOverrideAllocationProjectNumber(resourceSchedule.getOverrideAllocationProjectNumber());
            processResourceSchedule.setOverrideLoginUserName(resourceSchedule.getOverrideLoginUserName());
            processResourceSchedule.setOverrideScratchLocation(resourceSchedule.getOverrideScratchLocation());
            processResourceSchedule.setStaticWorkingDir(resourceSchedule.getStaticWorkingDir());
            processResourceSchedule.save();
        }
        catch (Exception e) {
            logger.error("Unable to save user config data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return processID;
    }

    public String addProcessInputs(List<InputDataObjectType> processInputs, String processID) throws RegistryException {
        try {
            for (InputDataObjectType input : processInputs) {
                ProcessInputResource resource = new ProcessInputResource();
                resource.setProcessId(processID);
                resource.setInputName(input.getName());
                resource.setInputValue(input.getValue());
                if (input.getType() != null) {
                    resource.setDataType(input.getType().toString());
                }
                resource.setMetadata(input.getMetaData());
                resource.setApplicationArgument(input.getApplicationArgument());
                resource.setInputOrder(input.getInputOrder());
                resource.setIsRequired(input.isIsRequired());
                resource.setRequiredToAddedToCmd(input.isRequiredToAddedToCommandLine());
                resource.setStorageResourceId(input.getStorageResourceId());
                resource.setIsReadOnly(input.isIsReadOnly());
                resource.save();
            }
            return processID;
        }
        catch (Exception e) {
            logger.error("Unable to save process inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addProcessOutputs(List<OutputDataObjectType> processOutput, String processID) throws RegistryException {
        try {
            for (OutputDataObjectType output : processOutput) {
                ProcessOutputResource resource = new ProcessOutputResource();
                resource.setProcessId(processID);
                resource.setOutputName(output.getName());
                resource.setOutputValue(output.getValue());
                if (output.getType() != null) {
                    resource.setDataType(output.getType().toString());
                }
                resource.setApplicationArgument(output.getApplicationArgument());
                resource.setIsRequired(output.isIsRequired());
                resource.setRequiredToAddedToCmd(output.isRequiredToAddedToCommandLine());
                resource.setDataMovement(output.isDataMovement());
                resource.setLocation(output.getLocation());
                resource.setSearchQuery(output.getSearchQuery());
                resource.setOutputStreaming(output.isOutputStreaming());
                resource.setStorageResourceId(output.getStorageResourceId());
                resource.save();
            }
            return processID;
        }
        catch (Exception e) {
            logger.error("Error while adding process outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addProcessStatus(ProcessStatus processStatus, String processID) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            processResource.setProcessId(processID);
            ProcessStatusResource status = processResource.getProcessStatus();
            ProcessState newState = processStatus.getState();
            if (status == null) {
                status = (ProcessStatusResource)processResource.create(ResourceType.PROCESS_STATUS);
                status.setStatusId(this.getStatusID("PROCESS_STATE"));
            } else {
                String state = status.getState();
                if (newState != null && !state.equals(newState.toString())) {
                    status.setStatusId(this.getStatusID("PROCESS_STATE"));
                }
            }
            status.setProcessId(processID);
            status.setTimeOfStateChange(AiravataUtils.getTime((long)processStatus.getTimeOfStateChange()));
            if (newState != null) {
                status.setState(newState.toString());
            }
            status.setReason(processStatus.getReason());
            status.save();
            logger.debug(processID, new Object[]{"Added process {} status to {}.", processID, processStatus.toString()});
        }
        catch (Exception e) {
            logger.error(processID, (Object)"Error while adding process status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return processID;
    }

    public String addProcessError(ErrorModel processError, String processID) throws RegistryException {
        try {
            ProcessErrorResource error = new ProcessErrorResource();
            error.setProcessId(processID);
            if (processError.getErrorId() == null) {
                error.setErrorId(AiravataUtils.getId((String)"PROCESS_ERROR"));
            } else {
                error.setErrorId(processError.getErrorId());
            }
            error.setCreationTime(AiravataUtils.getTime((long)processError.getCreationTime()));
            error.setActualErrorMessage(processError.getActualErrorMessage());
            error.setUserFriendlyMessage(processError.getUserFriendlyMessage());
            error.setTransientOrPersistent(processError.isTransientOrPersistent());
            if (processError.getRootCauseErrorIdList() != null) {
                error.setRootCauseErrorIdList(StringUtils.join((Collection)processError.getRootCauseErrorIdList(), (String)","));
            }
            error.save();
        }
        catch (Exception e) {
            logger.error(processID, (Object)"Error while adding process status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return processID;
    }

    public String addTask(TaskModel task, String processID) throws RegistryException {
        try {
            TaskResource taskResource = new TaskResource();
            task.setTaskId(AiravataUtils.getId((String)"TASK"));
            taskResource.setTaskId(task.getTaskId());
            taskResource.setParentProcessId(task.getParentProcessId());
            taskResource.setTaskType(task.getTaskType().toString());
            taskResource.setCreationTime(AiravataUtils.getTime((long)task.getCreationTime()));
            taskResource.setLastUpdateTime(AiravataUtils.getTime((long)task.getLastUpdateTime()));
            taskResource.setTaskDetail(task.getTaskDetail());
            taskResource.setSubTaskModel(task.getSubTaskModel());
            taskResource.save();
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setState(TaskState.CREATED);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            this.addTaskStatus(taskStatus, task.getTaskId());
            if (task.getTaskErrors() != null) {
                this.addTaskError((ErrorModel)task.getTaskErrors().get(0), task.getTaskId());
            }
        }
        catch (Exception e) {
            logger.error(processID, (Object)"Error while adding task...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return task.getTaskId();
    }

    public String addTaskStatus(TaskStatus taskStatus, String taskID) throws RegistryException {
        try {
            TaskResource taskResource = new TaskResource();
            taskResource.setTaskId(taskID);
            TaskStatusResource status = taskResource.getTaskStatus();
            TaskState newState = taskStatus.getState();
            if (status == null) {
                status = (TaskStatusResource)taskResource.create(ResourceType.TASK_STATUS);
                status.setStatusId(this.getStatusID("TASK_STATE"));
            } else {
                String state = status.getState();
                if (newState != null && !state.equals(newState.toString())) {
                    status.setStatusId(this.getStatusID("TASK_STATE"));
                }
            }
            status.setTaskId(taskID);
            status.setTimeOfStateChange(AiravataUtils.getTime((long)taskStatus.getTimeOfStateChange()));
            if (newState != null) {
                status.setState(newState.toString());
            }
            status.setReason(taskStatus.getReason());
            status.save();
            logger.debug(taskID, new Object[]{"Added task {} status to {}.", taskID, taskStatus.toString()});
        }
        catch (Exception e) {
            logger.error(taskID, (Object)"Error while adding task status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return taskID;
    }

    public String addTaskError(ErrorModel taskError, String taskId) throws RegistryException {
        try {
            TaskErrorResource error = new TaskErrorResource();
            error.setTaskId(taskId);
            if (taskError.getErrorId() == null) {
                error.setErrorId(AiravataUtils.getId((String)"TASK_ERROR"));
            } else {
                error.setErrorId(taskError.getErrorId());
            }
            error.setCreationTime(AiravataUtils.getTime((long)taskError.getCreationTime()));
            error.setActualErrorMessage(taskError.getActualErrorMessage());
            error.setUserFriendlyMessage(taskError.getUserFriendlyMessage());
            error.setTransientOrPersistent(taskError.isTransientOrPersistent());
            if (taskError.getRootCauseErrorIdList() != null) {
                error.setRootCauseErrorIdList(StringUtils.join((Collection)taskError.getRootCauseErrorIdList(), (String)","));
            }
            error.save();
        }
        catch (Exception e) {
            logger.error(taskId, (Object)"Error while adding task status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return taskId;
    }

    public String addJob(JobModel job, String processId) throws RegistryException {
        try {
            JobResource jobResource = new JobResource();
            jobResource.setJobId(job.getJobId());
            jobResource.setProcessId(processId);
            jobResource.setTaskId(job.getTaskId());
            jobResource.setJobDescription(job.getJobDescription());
            jobResource.setCreationTime(AiravataUtils.getTime((long)job.getCreationTime()));
            jobResource.setComputeResourceConsumed(job.getComputeResourceConsumed());
            jobResource.setJobName(job.getJobName());
            jobResource.setWorkingDir(job.getWorkingDir());
            jobResource.setExitCode(job.getExitCode());
            jobResource.setStdOut(job.getStdOut());
            jobResource.setStdErr(job.getStdErr());
            jobResource.save();
        }
        catch (Exception e) {
            logger.error(processId, (Object)"Error while adding task...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return processId;
    }

    public String addJobStatus(JobStatus jobStatus, CompositeIdentifier cis) throws RegistryException {
        String taskId = (String)cis.getTopLevelIdentifier();
        String jobID = (String)cis.getSecondLevelIdentifier();
        try {
            JobResource jobResource = new JobResource();
            jobResource.setJobId(jobID);
            JobStatusResource status = jobResource.getJobStatus();
            if (status == null) {
                status = new JobStatusResource();
            }
            status.setStatusId(this.getStatusID(jobID));
            status.setJobId(jobID);
            status.setTaskId(taskId);
            status.setTimeOfStateChange(AiravataUtils.getTime((long)jobStatus.getTimeOfStateChange()));
            status.setState(jobStatus.getJobState().toString());
            status.setReason(jobStatus.getReason());
            status.save();
            logger.debug(jobID, new Object[]{"Added job {} status to {}.", jobID, jobStatus.toString()});
        }
        catch (Exception e) {
            logger.error(jobID, (Object)"Error while adding job status...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return jobID;
    }

    public void updateExperiment(ExperimentModel experiment, String expId) throws RegistryException {
        try {
            List errors;
            List experimentStatuses;
            List experimentOutputs;
            List experimentInputs;
            if (!this.workerResource.isProjectExists(experiment.getProjectId())) {
                logger.error("Project does not exist in the system..");
                throw new Exception("Project does not exist in the system, Please create the project first...");
            }
            ExperimentResource existingExperiment = this.gatewayResource.getExperiment(expId);
            existingExperiment.setExperimentName(experiment.getExperimentName());
            existingExperiment.setUserName(experiment.getUserName());
            existingExperiment.setGatewayId(experiment.getGatewayId());
            existingExperiment.setGatewayExecutionId(experiment.getGatewayExecutionId());
            existingExperiment.setGatewayInstanceId(experiment.getGatewayInstanceId());
            existingExperiment.setProjectId(experiment.getProjectId());
            existingExperiment.setCreationTime(AiravataUtils.getTime((long)experiment.getCreationTime()));
            existingExperiment.setDescription(experiment.getDescription());
            existingExperiment.setExecutionId(experiment.getExecutionId());
            if (experiment.isEnableEmailNotification()) {
                existingExperiment.setEnableEmailNotification(true);
                if (experiment.getEmailAddresses() != null) {
                    existingExperiment.setEmailAddresses(StringUtils.join((Collection)experiment.getEmailAddresses(), (String)","));
                }
            } else {
                existingExperiment.setEnableEmailNotification(false);
            }
            existingExperiment.save();
            UserConfigurationDataModel userConfigurationData = experiment.getUserConfigurationData();
            if (userConfigurationData != null) {
                this.updateUserConfigData(userConfigurationData, expId);
            }
            if ((experimentInputs = experiment.getExperimentInputs()) != null && !experimentInputs.isEmpty()) {
                this.updateExpInputs(experimentInputs, expId);
            }
            if ((experimentOutputs = experiment.getExperimentOutputs()) != null && !experimentOutputs.isEmpty()) {
                this.updateExpOutputs(experimentOutputs, expId);
            }
            if ((experimentStatuses = experiment.getExperimentStatus()) != null && experimentStatuses.size() > 0 && experimentStatuses.get(0) != null) {
                this.updateExperimentStatus((ExperimentStatus)experimentStatuses.get(0), expId);
            }
            if ((errors = experiment.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorModel errror : errors) {
                    this.updateExperimentError(errror, expId);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateExpInputs(List<InputDataObjectType> exInputs, String expID) throws RegistryException {
        try {
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setExperimentId(expID);
            List<ExperimentInputResource> experimentInputs = experimentResource.getExperimentInputs();
            for (InputDataObjectType input : exInputs) {
                for (ExperimentInputResource exinput : experimentInputs) {
                    if (!exinput.getInputName().equals(input.getName())) continue;
                    exinput.setInputValue(input.getValue());
                    exinput.setExperimentId(expID);
                    if (input.getType() != null) {
                        exinput.setDataType(input.getType().toString());
                    }
                    exinput.setMetadata(input.getMetaData());
                    exinput.setApplicationArgument(input.getApplicationArgument());
                    exinput.setInputOrder(input.getInputOrder());
                    exinput.setIsRequired(input.isIsRequired());
                    exinput.setRequiredToAddedToCmd(input.isRequiredToAddedToCommandLine());
                    exinput.setStorageResourceId(input.getStorageResourceId());
                    exinput.setIsReadOnly(input.isIsReadOnly());
                    exinput.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to update experiment inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateExpOutputs(List<OutputDataObjectType> exOutput, String expId) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            List<ExperimentOutputResource> existingExpOutputs = experiment.getExperimentOutputs();
            for (OutputDataObjectType output : exOutput) {
                for (ExperimentOutputResource resource : existingExpOutputs) {
                    if (!resource.getOutputName().equals(output.getName())) continue;
                    resource.setExperimentId(expId);
                    resource.setOutputName(output.getName());
                    resource.setOutputValue(output.getValue());
                    if (output.getType() != null) {
                        resource.setDataType(output.getType().toString());
                    }
                    resource.setIsRequired(output.isIsRequired());
                    resource.setRequiredToAddedToCmd(output.isRequiredToAddedToCommandLine());
                    resource.setDataMovement(output.isDataMovement());
                    resource.setLocation(output.getLocation());
                    resource.setApplicationArgument(output.getApplicationArgument());
                    resource.setSearchQuery(output.getSearchQuery());
                    resource.setOutputStreaming(output.isOutputStreaming());
                    resource.setStorageResourceId(output.getStorageResourceId());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating experiment outputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateExperimentStatus(ExperimentStatus experimentStatus, String expId) throws RegistryException {
        return this.addExperimentStatus(experimentStatus, expId);
    }

    public String updateExperimentError(ErrorModel experimentError, String expId) throws RegistryException {
        return this.addExperimentError(experimentError, expId);
    }

    public String updateUserConfigData(UserConfigurationDataModel configurationData, String experimentId) throws RegistryException {
        try {
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setExperimentId(experimentId);
            UserConfigurationDataResource configDataResource = experimentResource.getUserConfigurationDataResource();
            configDataResource.setExperimentId(experimentId);
            configDataResource.setAiravataAutoSchedule(configurationData.isAiravataAutoSchedule());
            configDataResource.setOverrideManualScheduledParams(configurationData.isOverrideManualScheduledParams());
            configDataResource.setShareExperimentPublically(configurationData.isShareExperimentPublicly());
            configDataResource.setThrottleResources(configurationData.isThrottleResources());
            configDataResource.setUserDn(configurationData.getUserDN());
            configDataResource.setGenerateCert(configurationData.isGenerateCert());
            configDataResource.setStorageId(configurationData.getStorageId());
            configDataResource.setResourceHostId(configurationData.getComputationalResourceScheduling().getResourceHostId());
            configDataResource.setTotalCpuCount(configurationData.getComputationalResourceScheduling().getTotalCPUCount());
            configDataResource.setNodeCount(configurationData.getComputationalResourceScheduling().getNodeCount());
            configDataResource.setNumberOfThreads(configurationData.getComputationalResourceScheduling().getNumberOfThreads());
            configDataResource.setQueueName(configurationData.getComputationalResourceScheduling().getQueueName());
            configDataResource.setWallTimeLimit(configurationData.getComputationalResourceScheduling().getWallTimeLimit());
            configDataResource.setTotalPhysicalMemory(configurationData.getComputationalResourceScheduling().getTotalPhysicalMemory());
            configDataResource.setStaticWorkingDir(configurationData.getComputationalResourceScheduling().getStaticWorkingDir());
            configDataResource.setExperimentDataDir(configurationData.getExperimentDataDir());
            configDataResource.setUseUserCRPref(configurationData.isUseUserCRPref());
            configDataResource.setOverrideLoginUserName(configurationData.getComputationalResourceScheduling().getOverrideLoginUserName());
            configDataResource.setOverrideScratchLocation(configurationData.getComputationalResourceScheduling().getOverrideScratchLocation());
            configDataResource.setOverrideAllocationProjectNumber(configurationData.getComputationalResourceScheduling().getOverrideAllocationProjectNumber());
            configDataResource.save();
        }
        catch (Exception e) {
            logger.error("Unable to save user config data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentId;
    }

    public void updateProcess(ProcessModel process, String processId) throws RegistryException {
        try {
            ExperimentResource experimentResource = new ExperimentResource();
            ProcessResource processResource = experimentResource.getProcess(processId);
            processResource.setProcessId(process.getProcessId());
            processResource.setExperimentId(process.getExperimentId());
            processResource.setCreationTime(AiravataUtils.getTime((long)process.getCreationTime()));
            processResource.setLastUpdateTime(AiravataUtils.getTime((long)process.getLastUpdateTime()));
            processResource.setProcessDetail(process.getProcessDetail());
            processResource.setApplicationInterfaceId(process.getApplicationInterfaceId());
            processResource.setTaskDag(process.getTaskDag());
            processResource.setGatewayExecutionId(process.getGatewayExecutionId());
            processResource.setComputeResourceId(process.getComputeResourceId());
            processResource.setApplicationDeploymentId(process.getApplicationDeploymentId());
            processResource.setStorageResourceId(process.getStorageResourceId());
            processResource.setUserDn(process.getUserDn());
            processResource.setGenerateCert(process.isGenerateCert());
            processResource.setExperimentDataDir(process.getExperimentDataDir());
            processResource.setUserName(process.getUserName());
            processResource.setUseUserCRPref(process.isUseUserCRPref());
            if (process.isEnableEmailNotification()) {
                processResource.setEnableEmailNotification(true);
                if (process.getEmailAddresses() != null) {
                    processResource.setEmailAddresses(StringUtils.join((Collection)process.getEmailAddresses(), (String)","));
                }
            } else {
                processResource.setEnableEmailNotification(false);
            }
            processResource.save();
            if (process.getProcessResourceSchedule() != null) {
                this.updateProcessResourceSchedule(process.getProcessResourceSchedule(), process.getProcessId());
            }
            if (process.getProcessInputs() != null && process.getProcessInputs().size() > 0) {
                this.updateProcessInputs(process.getProcessInputs(), process.getProcessId());
            }
            if (process.getProcessOutputs() != null && process.getProcessOutputs().size() > 0) {
                this.updateProcessOutputs(process.getProcessOutputs(), process.getProcessId());
            }
            if (process.getProcessStatuses() != null) {
                this.updateProcessStatus((ProcessStatus)process.getProcessStatuses().get(0), process.getProcessId());
            }
            if (process.getProcessErrors() != null) {
                this.updateProcessError((ErrorModel)process.getProcessErrors().get(0), process.getProcessId());
            }
            if (process.getTasks() != null && process.getTasks().size() > 0) {
                for (TaskModel task : process.getTasks()) {
                    this.updateTask(task, task.getTaskId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating process...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateProcessResourceSchedule(ComputationalResourceSchedulingModel resourceSchedule, String processID) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            processResource.setProcessId(processID);
            ProcessResourceScheduleResource processResourceSchedule = processResource.getProcessResourceSchedule();
            processResourceSchedule.setProcessId(processID);
            processResourceSchedule.setResourceHostId(resourceSchedule.getResourceHostId());
            processResourceSchedule.setTotalCpuCount(resourceSchedule.getTotalCPUCount());
            processResourceSchedule.setNodeCount(resourceSchedule.getNodeCount());
            processResourceSchedule.setNumberOfThreads(resourceSchedule.getNumberOfThreads());
            processResourceSchedule.setQueueName(resourceSchedule.getQueueName());
            processResourceSchedule.setWallTimeLimit(resourceSchedule.getWallTimeLimit());
            processResourceSchedule.setTotalPhysicalMemory(resourceSchedule.getTotalPhysicalMemory());
            processResourceSchedule.setOverrideAllocationProjectNumber(resourceSchedule.getOverrideAllocationProjectNumber());
            processResourceSchedule.setOverrideLoginUserName(resourceSchedule.getOverrideLoginUserName());
            processResourceSchedule.setOverrideScratchLocation(resourceSchedule.getOverrideScratchLocation());
            processResourceSchedule.setStaticWorkingDir(resourceSchedule.getStaticWorkingDir());
            processResourceSchedule.save();
        }
        catch (Exception e) {
            logger.error("Unable to save process resource schedule data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return processID;
    }

    public void updateProcessInputs(List<InputDataObjectType> processInputs, String processID) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            processResource.setProcessId(processID);
            List<ProcessInputResource> existingProcessInputs = processResource.getProcessInputs();
            for (InputDataObjectType input : processInputs) {
                for (ProcessInputResource exinput : existingProcessInputs) {
                    if (!exinput.getInputName().equals(input.getName())) continue;
                    exinput.setProcessId(processID);
                    exinput.setInputValue(input.getValue());
                    if (input.getType() != null) {
                        exinput.setDataType(input.getType().toString());
                    }
                    exinput.setMetadata(input.getMetaData());
                    exinput.setApplicationArgument(input.getApplicationArgument());
                    exinput.setInputOrder(input.getInputOrder());
                    exinput.setIsRequired(input.isIsRequired());
                    exinput.setRequiredToAddedToCmd(input.isRequiredToAddedToCommandLine());
                    exinput.setStorageResourceId(input.getStorageResourceId());
                    exinput.setIsReadOnly(input.isIsReadOnly());
                    exinput.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to update experiment inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateProcessOutputs(List<OutputDataObjectType> processOutput, String processID) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            processResource.setProcessId(processID);
            List<ProcessOutputResource> existingProcessOutputs = processResource.getProcessOutputs();
            for (OutputDataObjectType output : processOutput) {
                for (ProcessOutputResource resource : existingProcessOutputs) {
                    if (!resource.getOutputName().equals(output.getName())) continue;
                    resource.setProcessId(processID);
                    resource.setOutputName(output.getName());
                    resource.setOutputValue(output.getValue());
                    if (output.getType() != null) {
                        resource.setDataType(output.getType().toString());
                    }
                    resource.setIsRequired(output.isIsRequired());
                    resource.setRequiredToAddedToCmd(output.isRequiredToAddedToCommandLine());
                    resource.setDataMovement(output.isDataMovement());
                    resource.setLocation(output.getLocation());
                    resource.setApplicationArgument(output.getApplicationArgument());
                    resource.setSearchQuery(output.getSearchQuery());
                    resource.setOutputStreaming(output.isOutputStreaming());
                    resource.setStorageResourceId(output.getStorageResourceId());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating process outputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateProcessStatus(ProcessStatus processStatus, String processID) throws RegistryException {
        return this.addProcessStatus(processStatus, processID);
    }

    public String updateProcessError(ErrorModel processErrors, String processID) throws RegistryException {
        return this.addProcessError(processErrors, processID);
    }

    public String updateTask(TaskModel task, String taskID) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            TaskResource taskResource = processResource.getTask(taskID);
            taskResource.setTaskId(task.getTaskId());
            taskResource.setParentProcessId(task.getParentProcessId());
            taskResource.setTaskType(task.getTaskType().toString());
            taskResource.setCreationTime(AiravataUtils.getTime((long)task.getCreationTime()));
            taskResource.setLastUpdateTime(AiravataUtils.getTime((long)task.getLastUpdateTime()));
            taskResource.setTaskDetail(task.getTaskDetail());
            taskResource.setSubTaskModel(task.getSubTaskModel());
            taskResource.save();
            if (task.getTaskErrors() != null) {
                this.updateTaskError((ErrorModel)task.getTaskErrors().get(0), task.getTaskId());
            }
            if (task.getTaskErrors() != null) {
                this.updateTaskError((ErrorModel)task.getTaskErrors().get(0), task.getTaskId());
            }
        }
        catch (Exception e) {
            logger.error(taskID, (Object)"Error while adding task...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return taskID;
    }

    public String updateTaskStatus(TaskStatus taskStatus, String taskID) throws RegistryException {
        return this.addTaskStatus(taskStatus, taskID);
    }

    public String updateTaskError(ErrorModel taskError, String taskID) throws RegistryException {
        return this.addTaskError(taskError, taskID);
    }

    public String updateJob(JobModel job, CompositeIdentifier cis) throws RegistryException {
        String taskId = (String)cis.getTopLevelIdentifier();
        String jobId = (String)cis.getSecondLevelIdentifier();
        try {
            TaskResource taskResource = new TaskResource();
            taskResource.setTaskId(taskId);
            JobResource jobResource = taskResource.getJob(jobId);
            jobResource.setJobId(jobId);
            jobResource.setTaskId(job.getTaskId());
            jobResource.setProcessId(job.getProcessId());
            jobResource.setJobDescription(job.getJobDescription());
            jobResource.setCreationTime(AiravataUtils.getTime((long)job.getCreationTime()));
            jobResource.setComputeResourceConsumed(job.getComputeResourceConsumed());
            jobResource.setJobName(job.getJobName());
            jobResource.setWorkingDir(job.getWorkingDir());
            jobResource.setStdOut(job.getStdOut());
            jobResource.setStdErr(job.getStdErr());
            jobResource.setExitCode(job.getExitCode());
            jobResource.save();
        }
        catch (Exception e) {
            logger.error(jobId, (Object)"Error while adding job...", (Object)e);
            throw new RegistryException((Throwable)e);
        }
        return jobId;
    }

    public String updateJobStatus(JobStatus jobStatus, CompositeIdentifier cis) throws RegistryException {
        return this.addJobStatus(jobStatus, cis);
    }

    public void updateExperimentField(String expID, String fieldName, Object value) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expID);
            if (fieldName.equals("experimentName")) {
                experiment.setExperimentName((String)value);
                experiment.save();
            } else if (fieldName.equals("userName")) {
                experiment.setUserName((String)value);
                experiment.save();
            } else if (fieldName.equals("description")) {
                experiment.setDescription((String)value);
                experiment.save();
            } else {
                logger.error("Unsupported field type for Experiment");
            }
        }
        catch (Exception e) {
            logger.error("Error while updating fields in experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateUserConfigDataField(String expID, String fieldName, Object value) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            experiment.setExperimentId(expID);
            UserConfigurationDataResource exConfigData = (UserConfigurationDataResource)experiment.get(ResourceType.USER_CONFIGURATION_DATA, expID);
            if (fieldName.equals("airavataAutoSchedule")) {
                exConfigData.setAiravataAutoSchedule((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("overrideManualScheduledParams")) {
                exConfigData.setOverrideManualScheduledParams((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("shareExperimentPublicly")) {
                exConfigData.setShareExperimentPublically((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("computationalResourceScheduling")) {
                this.updateComputeResourceScheduling((ComputationalResourceSchedulingModel)value, expID);
            } else {
                logger.error("Unsupported field type for Experiment config data");
            }
        }
        catch (Exception e) {
            logger.error("Error while updating fields in experiment config...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateComputeResourceScheduling(ComputationalResourceSchedulingModel value, String expID) throws RegistryException {
        ExperimentResource experiment = new ExperimentResource();
        experiment.setExperimentId(expID);
        UserConfigurationDataResource configDataResource = experiment.getUserConfigurationDataResource();
        configDataResource.setResourceHostId(value.getResourceHostId());
        configDataResource.setTotalCpuCount(value.getTotalCPUCount());
        configDataResource.setNodeCount(value.getNodeCount());
        configDataResource.setNumberOfThreads(value.getNumberOfThreads());
        configDataResource.setQueueName(value.getQueueName());
        configDataResource.setWallTimeLimit(value.getWallTimeLimit());
        configDataResource.setTotalPhysicalMemory(value.getTotalPhysicalMemory());
        configDataResource.setStaticWorkingDir(value.getStaticWorkingDir());
        configDataResource.setOverrideLoginUserName(value.getOverrideLoginUserName());
        configDataResource.setOverrideScratchLocation(value.getOverrideScratchLocation());
        configDataResource.setOverrideAllocationProjectNumber(value.getOverrideAllocationProjectNumber());
        configDataResource.save();
    }

    public Object getExperiment(String expId, String fieldName) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getExperiment(resource);
            }
            if (fieldName.equals("experimentInputs")) {
                return ThriftDataModelConversion.getExpInputs(resource.getExperimentInputs());
            }
            if (fieldName.equals("experimentOutputs")) {
                return ThriftDataModelConversion.getExpOutputs(resource.getExperimentOutputs());
            }
            if (fieldName.equals("experimentStatus")) {
                return ThriftDataModelConversion.getExperimentStatus(resource.getExperimentStatus());
            }
            if (fieldName.equals("experimentErrors")) {
                return ThriftDataModelConversion.getExperimentErrorList(resource.getExperimentErrors());
            }
            if (fieldName.equals("userConfigurationData")) {
                return ThriftDataModelConversion.getUserConfigData(resource.getUserConfigurationDataResource());
            }
            logger.error("Unsupported field name for experiment data..");
        }
        catch (Exception e) {
            logger.error("Error while getting experiment info...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getExperimentInputs(String expID) throws RegistryException {
        return this.getExperiment(expID, "experimentInputs");
    }

    public Object getExperimentOutputs(String expID) throws RegistryException {
        return this.getExperiment(expID, "experimentOutputs");
    }

    public Object getExperimentErrors(String expID) throws RegistryException {
        return this.getExperiment(expID, "experimentErrors");
    }

    public Object getExperimentStatus(String expID) throws RegistryException {
        return this.getExperiment(expID, "experimentStatus");
    }

    public Object getUserConfigData(String expId, String fieldName) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            UserConfigurationDataResource userConfigData = resource.getUserConfigurationDataResource();
            if (fieldName == null) {
                return ThriftDataModelConversion.getUserConfigData(userConfigData);
            }
            if (fieldName.equals("computationalResourceScheduling")) {
                return ThriftDataModelConversion.getComputationalResourceScheduling(userConfigData);
            }
            logger.error("Unsupported field name for experiment configuration data..");
        }
        catch (Exception e) {
            logger.error("Error while getting config data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getProcess(String processId, String fieldName) throws RegistryException {
        try {
            ExperimentResource experimentResource = new ExperimentResource();
            ProcessResource resource = experimentResource.getProcess(processId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getProcessModel(resource);
            }
            if (fieldName.equals("processError")) {
                return ThriftDataModelConversion.getErrorModel(resource.getProcessError());
            }
            if (fieldName.equals("processStatus")) {
                return ThriftDataModelConversion.getProcessStatus(resource.getProcessStatus());
            }
            if (fieldName.equals("processInputs")) {
                return ThriftDataModelConversion.getProcessInputs(resource.getProcessInputs());
            }
            if (fieldName.equals("processOutputs")) {
                return ThriftDataModelConversion.getProcessOutputs(resource.getProcessOutputs());
            }
            if (fieldName.equals("processResourceSchedule")) {
                return ThriftDataModelConversion.getProcessResourceSchedule(resource.getProcessResourceSchedule());
            }
            logger.error("Unsupported field name for process data..");
        }
        catch (Exception e) {
            logger.error("Error while getting process data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getProcessError(String processId) throws RegistryException {
        return this.getProcess(processId, "processError");
    }

    public Object getProcessStatus(String processId) throws RegistryException {
        return this.getProcess(processId, "processStatus");
    }

    public Object getProcessInputs(String processId) throws RegistryException {
        return this.getProcess(processId, "processInputs");
    }

    public Object getProcessOutputs(String processId) throws RegistryException {
        return this.getProcess(processId, "processOutputs");
    }

    public Object getProcessResourceSchedule(String processId) throws RegistryException {
        return this.getProcess(processId, "processResourceSchedule");
    }

    public Object getTask(String taskId, String fieldName) throws RegistryException {
        try {
            ProcessResource processResource = new ProcessResource();
            TaskResource resource = processResource.getTask(taskId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getTaskModel(resource);
            }
            if (fieldName.equals("taskError")) {
                return ThriftDataModelConversion.getErrorModel(resource.getTaskError());
            }
            if (fieldName.equals("taskStatus")) {
                return ThriftDataModelConversion.getTaskStatus(resource.getTaskStatus());
            }
            logger.error("Unsupported field name for task data..");
        }
        catch (Exception e) {
            logger.error("Error while getting task data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getTaskError(String taskId) throws RegistryException {
        return this.getTask(taskId, "taskError");
    }

    public Object getTaskStatus(String taskId) throws RegistryException {
        return this.getTask(taskId, "taskStatus");
    }

    public Object getJob(CompositeIdentifier cis, String fieldName) throws RegistryException {
        String taskId = (String)cis.getTopLevelIdentifier();
        String jobId = (String)cis.getSecondLevelIdentifier();
        try {
            TaskResource taskResource = new TaskResource();
            taskResource.setTaskId(taskId);
            JobResource resource = taskResource.getJob(jobId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getJobModel(resource);
            }
            if (fieldName.equals("taskStatus")) {
                return ThriftDataModelConversion.getJobStatus(resource.getJobStatus());
            }
            logger.error("Unsupported field name for job basic data..");
        }
        catch (Exception e) {
            logger.error("Error while getting job data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getJobStatus(CompositeIdentifier cis) throws RegistryException {
        return this.getJob(cis, "taskStatus");
    }

    public List<ExperimentModel> getExperimentList(String fieldName, Object value) throws RegistryException {
        ArrayList<ExperimentModel> experiments = new ArrayList<ExperimentModel>();
        try {
            if (fieldName.equals("userName")) {
                WorkerResource resource = (WorkerResource)this.gatewayResource.create(ResourceType.GATEWAY_WORKER);
                resource.setUser((String)value);
                List<ExperimentResource> resources = resource.getExperiments();
                for (ExperimentResource experimentResource : resources) {
                    ExperimentModel experiment = ThriftDataModelConversion.getExperiment(experimentResource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            if (fieldName.equals("projectId")) {
                ProjectResource project = this.workerResource.getProject((String)value);
                List<ExperimentResource> resources = project.getExperiments();
                for (ExperimentResource resource : resources) {
                    ExperimentModel experiment = ThriftDataModelConversion.getExperiment(resource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            if (fieldName.equals("gatewayId")) {
                List<ExperimentResource> resources = this.gatewayResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    ExperimentModel experiment = ThriftDataModelConversion.getExperiment(resource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            logger.error("Unsupported field name to retrieve experiment list...");
        }
        catch (Exception e) {
            logger.error("Error while getting experiment list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experiments;
    }

    public List<ProcessModel> getProcessList(String fieldName, Object value) throws RegistryException {
        ArrayList<ProcessModel> processes = new ArrayList<ProcessModel>();
        try {
            if (fieldName.equals("experimentId")) {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setExperimentId((String)value);
                List<ProcessResource> resources = experimentResource.getProcessList();
                for (ProcessResource processResource : resources) {
                    ProcessModel processModel = ThriftDataModelConversion.getProcessModel(processResource);
                    processes.add(processModel);
                }
                return processes;
            }
            logger.error("Unsupported field name to retrieve process list...");
        }
        catch (Exception e) {
            logger.error("Error while getting process list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return processes;
    }

    public List<TaskModel> getTaskList(String fieldName, Object value) throws RegistryException {
        ArrayList<TaskModel> tasks = new ArrayList<TaskModel>();
        try {
            if (fieldName.equals("parentProcessId")) {
                ProcessResource processResource = new ProcessResource();
                processResource.setProcessId((String)value);
                List<TaskResource> resources = processResource.getTaskList();
                for (TaskResource taskResource : resources) {
                    TaskModel taskModel = ThriftDataModelConversion.getTaskModel(taskResource);
                    tasks.add(taskModel);
                }
                return tasks;
            }
            logger.error("Unsupported field name to retrieve task list...");
        }
        catch (Exception e) {
            logger.error("Error while getting task list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return tasks;
    }

    public List<JobModel> getJobList(String fieldName, Object value) throws RegistryException {
        ArrayList<JobModel> jobs = new ArrayList<JobModel>();
        try {
            if (fieldName.equals("processId")) {
                ProcessResource processResource = new ProcessResource();
                processResource.setProcessId((String)value);
                List<JobResource> resources = processResource.getJobList();
                for (JobResource jobResource : resources) {
                    JobModel jobModel = ThriftDataModelConversion.getJobModel(jobResource);
                    JobStatusResource latestSR = jobResource.getJobStatus();
                    if (latestSR != null) {
                        JobStatus jobStatus = new JobStatus(JobState.valueOf((String)latestSR.getState()));
                        jobStatus.setReason(latestSR.getReason());
                        ArrayList<JobStatus> statuses = new ArrayList<JobStatus>();
                        statuses.add(jobStatus);
                        jobModel.setJobStatuses(statuses);
                    }
                    jobs.add(jobModel);
                }
                return jobs;
            }
            if (fieldName.equals("taskId")) {
                TaskResource taskResource = new TaskResource();
                taskResource.setTaskId((String)value);
                List<JobResource> resources = taskResource.getJobList();
                for (JobResource jobResource : resources) {
                    JobModel jobModel = ThriftDataModelConversion.getJobModel(jobResource);
                    JobStatusResource latestSR = jobResource.getJobStatus();
                    if (latestSR != null) {
                        JobStatus jobStatus = new JobStatus(JobState.valueOf((String)latestSR.getState()));
                        jobStatus.setReason(latestSR.getReason());
                        ArrayList<JobStatus> statuses = new ArrayList<JobStatus>();
                        statuses.add(jobStatus);
                        jobModel.setJobStatuses(statuses);
                    }
                    jobs.add(jobModel);
                }
                return jobs;
            }
            logger.error("Unsupported field name to retrieve job list...");
        }
        catch (Exception e) {
            logger.error("Error while getting job list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return jobs;
    }

    public List<ExperimentModel> getExperimentList(String fieldName, Object value, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ExperimentModel> experiments = new ArrayList<ExperimentModel>();
        try {
            if (fieldName.equals("userName")) {
                WorkerResource resource = (WorkerResource)this.gatewayResource.create(ResourceType.GATEWAY_WORKER);
                resource.setUser((String)value);
                List<ExperimentResource> resources = resource.getExperiments(limit, offset, orderByIdentifier, resultOrderType);
                for (ExperimentResource experimentResource : resources) {
                    ExperimentModel experiment = ThriftDataModelConversion.getExperiment(experimentResource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            if (fieldName.equals("projectId")) {
                ProjectResource project = this.workerResource.getProject((String)value);
                List<ExperimentResource> resources = project.getExperiments(limit, offset, "creationTime", ResultOrderType.DESC);
                for (ExperimentResource resource : resources) {
                    ExperimentModel experiment = ThriftDataModelConversion.getExperiment(resource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            logger.error("Unsupported field name to retrieve experiment list...");
        }
        catch (Exception e) {
            logger.error("Error while getting experiment list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experiments;
    }

    public List<ExperimentSummaryModel> searchExperiments(Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<ExperimentSummaryModel> experimentSummaries = new ArrayList<ExperimentSummaryModel>();
            long fromTime = 0L;
            long toTime = 0L;
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("experimentName")) {
                        fil.put("experimentName", filters.get(field));
                        continue;
                    }
                    if (field.equals("userName")) {
                        fil.put("userName", filters.get(field));
                        continue;
                    }
                    if (field.equals("projectId")) {
                        fil.put("projectId", filters.get(field));
                        continue;
                    }
                    if (field.equals("gatewayId")) {
                        fil.put("gatewayId", filters.get(field));
                        continue;
                    }
                    if (field.equals("description")) {
                        fil.put("description", filters.get(field));
                        continue;
                    }
                    if (field.equals("executionId")) {
                        fil.put("executionId", filters.get(field));
                        continue;
                    }
                    if (field.equals("experimentStatus")) {
                        fil.put("state", filters.get(field));
                        continue;
                    }
                    if (field.equals("fromDate")) {
                        fromTime = Long.parseLong(filters.get(field));
                        continue;
                    }
                    if (!field.equals("toDate")) continue;
                    toTime = Long.parseLong(filters.get(field));
                }
                List<ExperimentSummaryResource> experimentSummaryResources = fromTime != 0L && toTime != 0L ? this.workerResource.searchExperiments(null, new Timestamp(fromTime), new Timestamp(toTime), fil, limit, offset, orderByIdentifier, resultOrderType) : this.workerResource.searchExperiments(null, null, null, fil, limit, offset, orderByIdentifier, resultOrderType);
                if (experimentSummaryResources != null && !experimentSummaryResources.isEmpty()) {
                    for (ExperimentSummaryResource ex : experimentSummaryResources) {
                        experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
                    }
                }
                return experimentSummaries;
            }
            catch (Exception e) {
                logger.error("Error while retrieving experiment summary from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }

    public List<ExperimentSummaryModel> searchAllAccessibleExperiments(List<String> accessibleIds, Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<ExperimentSummaryModel> experimentSummaries = new ArrayList<ExperimentSummaryModel>();
            long fromTime = 0L;
            long toTime = 0L;
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("experimentName")) {
                        fil.put("experimentName", filters.get(field));
                        continue;
                    }
                    if (field.equals("userName")) {
                        fil.put("userName", filters.get(field));
                        continue;
                    }
                    if (field.equals("projectId")) {
                        fil.put("projectId", filters.get(field));
                        continue;
                    }
                    if (field.equals("gatewayId")) {
                        fil.put("gatewayId", filters.get(field));
                        continue;
                    }
                    if (field.equals("description")) {
                        fil.put("description", filters.get(field));
                        continue;
                    }
                    if (field.equals("executionId")) {
                        fil.put("executionId", filters.get(field));
                        continue;
                    }
                    if (field.equals("experimentStatus")) {
                        fil.put("state", filters.get(field));
                        continue;
                    }
                    if (field.equals("fromDate")) {
                        fromTime = Long.parseLong(filters.get(field));
                        continue;
                    }
                    if (!field.equals("toDate")) continue;
                    toTime = Long.parseLong(filters.get(field));
                }
                List<ExperimentSummaryResource> experimentSummaryResources = fromTime != 0L && toTime != 0L ? this.workerResource.searchExperiments(accessibleIds, new Timestamp(fromTime), new Timestamp(toTime), fil, limit, offset, orderByIdentifier, resultOrderType) : this.workerResource.searchExperiments(accessibleIds, null, null, fil, limit, offset, orderByIdentifier, resultOrderType);
                if (experimentSummaryResources != null && !experimentSummaryResources.isEmpty()) {
                    for (ExperimentSummaryResource ex : experimentSummaryResources) {
                        experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
                    }
                }
                return experimentSummaries;
            }
            catch (Exception e) {
                logger.error("Error while retrieving experiment summary from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }

    public ExperimentStatistics getExperimentStatistics(Map<String, String> filters) throws RegistryException {
        try {
            ExperimentStatistics experimentStatistics = new ExperimentStatistics();
            ExperimentStatisticsResource experimentStatisticsResource = this.workerResource.getExperimentStatistics(filters.get("gatewayId"), new Timestamp(Long.parseLong(filters.get("fromDate"))), new Timestamp(Long.parseLong(filters.get("toDate"))), filters.get("userName"), filters.get("executionId"), filters.get("resourceHostId"));
            experimentStatistics.setAllExperimentCount(experimentStatisticsResource.getAllExperimentCount());
            experimentStatistics.setCreatedExperimentCount(experimentStatisticsResource.getCreatedExperimentCount());
            experimentStatistics.setRunningExperimentCount(experimentStatisticsResource.getRunningExperimentCount());
            experimentStatistics.setCompletedExperimentCount(experimentStatisticsResource.getCompletedExperimentCount());
            experimentStatistics.setFailedExperimentCount(experimentStatisticsResource.getFailedExperimentCount());
            experimentStatistics.setCancelledExperimentCount(experimentStatisticsResource.getCancelledExperimentCount());
            ArrayList<ExperimentSummaryModel> experimentSummaries = new ArrayList<ExperimentSummaryModel>();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getAllExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setAllExperiments(experimentSummaries);
            experimentSummaries = new ArrayList();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getCreatedExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setCreatedExperiments(experimentSummaries);
            experimentSummaries = new ArrayList();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getRunningExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setRunningExperiments(experimentSummaries);
            experimentSummaries = new ArrayList();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getCompletedExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setCompletedExperiments(experimentSummaries);
            experimentSummaries = new ArrayList();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getFailedExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setFailedExperiments(experimentSummaries);
            experimentSummaries = new ArrayList();
            for (ExperimentSummaryResource ex : experimentStatisticsResource.getCancelledExperiments()) {
                experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
            }
            experimentStatistics.setCancelledExperiments(experimentSummaries);
            return experimentStatistics;
        }
        catch (RegistryException e) {
            logger.error("Error while retrieving experiment statistics from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<String> getExperimentIDs(String fieldName, Object value) throws RegistryException {
        ArrayList<String> expIDs = new ArrayList<String>();
        try {
            if (fieldName.equals("gatewayId")) {
                if (this.gatewayResource == null) {
                    logger.error("You should use an existing gateway in order to retrieve experiments..");
                    return null;
                }
                List<ExperimentResource> resources = this.gatewayResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    String expID = resource.getExperimentId();
                    expIDs.add(expID);
                }
            } else if (fieldName.equals("userName")) {
                List<ExperimentResource> resources = this.workerResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    expIDs.add(resource.getExperimentId());
                }
            } else if (fieldName.equals("projectId")) {
                List<ExperimentResource> resources = this.workerResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    expIDs.add(resource.getExperimentId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment ids..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return expIDs;
    }

    public List<String> getProcessIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> processIds = new ArrayList<String>();
        List<ProcessModel> processes = this.getProcessList(fieldName, value);
        for (ProcessModel td : processes) {
            processIds.add(td.getProcessId());
        }
        return processIds;
    }

    public List<String> getTaskIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> taskIds = new ArrayList<String>();
        List<TaskModel> tasks = this.getTaskList(fieldName, value);
        for (TaskModel task : tasks) {
            taskIds.add(task.getTaskId());
        }
        return taskIds;
    }

    public List<String> getJobIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> jobIds = new ArrayList<String>();
        List<JobModel> jobs = this.getJobList(fieldName, value);
        for (JobModel job : jobs) {
            jobIds.add(job.getJobId());
        }
        return jobIds;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        try {
            this.gatewayResource.remove(ResourceType.EXPERIMENT, experimentId);
        }
        catch (Exception e) {
            logger.error("Error while removing experiment..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeUserConfigData(String experimentId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            experiment.setExperimentId(experimentId);
            experiment.remove(ResourceType.USER_CONFIGURATION_DATA, experimentId);
        }
        catch (Exception e) {
            logger.error("Error while removing experiment config..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeProcess(String processId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            experiment.remove(ResourceType.PROCESS, processId);
        }
        catch (Exception e) {
            logger.error("Error while removing workflow node..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeProcessResourceSchedule(String processId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            experiment.remove(ResourceType.PROCESS_RESOURCE_SCHEDULE, processId);
        }
        catch (Exception e) {
            logger.error("Error while removing workflow node..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeTask(String taskId) throws RegistryException {
        try {
            ProcessResource process = new ProcessResource();
            process.remove(ResourceType.TASK, taskId);
        }
        catch (Exception e) {
            logger.error("Error while removing task details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeJob(CompositeIdentifier cis) throws RegistryException {
        try {
            String processId = (String)cis.getTopLevelIdentifier();
            String jobId = (String)cis.getSecondLevelIdentifier();
            ProcessResource process = new ProcessResource();
            process.setProcessId(processId);
            process.remove(ResourceType.JOB, jobId);
        }
        catch (Exception e) {
            logger.error("Error while removing task details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isExperimentExist(String expID) throws RegistryException {
        try {
            return this.gatewayResource.isExists(ResourceType.EXPERIMENT, expID);
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isUserConfigDataExist(String expID) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expID);
            experiment.isExists(ResourceType.USER_CONFIGURATION_DATA, expID);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isProcessExist(String processId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            return experiment.isExists(ResourceType.PROCESS, processId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving process...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isProcessResourceScheduleExist(String processId) throws RegistryException {
        try {
            ExperimentResource experiment = new ExperimentResource();
            return experiment.isExists(ResourceType.PROCESS_RESOURCE_SCHEDULE, processId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving process...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isTaskExist(String taskId) throws RegistryException {
        try {
            ProcessResource process = new ProcessResource();
            return process.isExists(ResourceType.TASK, taskId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving task.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isJobExist(CompositeIdentifier cis) throws RegistryException {
        String taskId = (String)cis.getTopLevelIdentifier();
        String jobId = (String)cis.getSecondLevelIdentifier();
        try {
            TaskResource taskResource = new TaskResource();
            taskResource.setTaskId(taskId);
            return taskResource.isExists(ResourceType.JOB, jobId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving job.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean createQueueStatuses(List<QueueStatusModel> queueStatusModels) throws RegistryException {
        for (QueueStatusModel qModel : queueStatusModels) {
            QueueStatusResource queueStatusResource = new QueueStatusResource();
            queueStatusResource.setHostName(qModel.getHostName());
            queueStatusResource.setQueueName(qModel.getQueueName());
            queueStatusResource.setTime(qModel.getTime());
            queueStatusResource.setQueueUp(qModel.isQueueUp());
            queueStatusResource.setRunningJobs(qModel.getRunningJobs());
            queueStatusResource.setQueuedJobs(qModel.getQueuedJobs());
            queueStatusResource.save();
        }
        return true;
    }

    public List<QueueStatusModel> getLatestQueueStatuses() throws RegistryException {
        ArrayList<QueueStatusModel> queueStatusModels = new ArrayList<QueueStatusModel>();
        List<ExperimentCatResource> queueStatusResources = new QueueStatusResource().get(ResourceType.QUEUE_STATUS);
        for (ExperimentCatResource r : queueStatusResources) {
            QueueStatusResource qResource = (QueueStatusResource)r;
            QueueStatusModel queueStatusModel = new QueueStatusModel();
            queueStatusModel.setHostName(qResource.getHostName());
            queueStatusModel.setQueueName(qResource.getQueueName());
            queueStatusModel.setTime(qResource.getTime().longValue());
            queueStatusModel.setQueueUp(qResource.getQueueUp().booleanValue());
            queueStatusModel.setRunningJobs(qResource.getRunningJobs().intValue());
            queueStatusModel.setQueuedJobs(qResource.getQueuedJobs().intValue());
            queueStatusModels.add(queueStatusModel);
        }
        return queueStatusModels;
    }

    public String getStatusID(String parentId) {
        String status = parentId.replaceAll("\\s", "");
        return status + "_" + UUID.randomUUID();
    }

    public String getErrorID(String parentId) {
        String error = parentId.replaceAll("\\s", "");
        return error + "_" + UUID.randomUUID();
    }

    public boolean isValidStatusTransition(Object object1, Object object2) {
        if (object1 instanceof ExperimentState && object2 instanceof ExperimentState) {
            ExperimentState oldState = (ExperimentState)object1;
            ExperimentState nextState = (ExperimentState)object2;
            if (nextState == null) {
                return false;
            }
            switch (oldState) {
                case CREATED: {
                    return true;
                }
                case VALIDATED: {
                    return nextState != ExperimentState.CREATED;
                }
                case SCHEDULED: {
                    return nextState != ExperimentState.CREATED || nextState != ExperimentState.VALIDATED;
                }
                case LAUNCHED: {
                    return nextState != ExperimentState.CREATED || nextState != ExperimentState.VALIDATED || nextState != ExperimentState.SCHEDULED;
                }
                case EXECUTING: {
                    return nextState != ExperimentState.CREATED || nextState != ExperimentState.VALIDATED || nextState != ExperimentState.SCHEDULED || nextState != ExperimentState.LAUNCHED;
                }
                case CANCELING: {
                    return nextState == ExperimentState.CANCELING || nextState == ExperimentState.CANCELED || nextState == ExperimentState.COMPLETED || nextState == ExperimentState.FAILED;
                }
                case CANCELED: {
                    return nextState == ExperimentState.CANCELED;
                }
                case COMPLETED: {
                    return nextState == ExperimentState.COMPLETED;
                }
                case FAILED: {
                    return nextState == ExperimentState.FAILED;
                }
            }
            return false;
        }
        if (object1 instanceof ProcessState && object2 instanceof ProcessState) {
            ProcessState oldState = (ProcessState)object1;
            ProcessState nextState = (ProcessState)object2;
            return nextState != null;
        }
        if (object1 instanceof TaskState && object2 instanceof TaskState) {
            TaskState oldState = (TaskState)object1;
            TaskState nextState = (TaskState)object2;
            return nextState != null;
        }
        if (object1 instanceof JobState && object2 instanceof JobState) {
            JobState oldState = (JobState)object1;
            JobState nextState = (JobState)object2;
            return nextState != null;
        }
        return false;
    }
}

