/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.UnicoreDataMovement;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicoreDataMovementResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UnicoreDataMovementResource.class);
    private String dataMovementId;
    private String securityProtocol;
    private String unicoreEndpointUrl;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreDataMovement", new Object[0][]);
            generator.setParameter("dataMovementId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreDataMovement", new Object[0][]);
            generator.setParameter("dataMovementId", identifier);
            Query q = generator.selectQuery(em);
            UnicoreDataMovement unicoreDataMovement = (UnicoreDataMovement)q.getSingleResult();
            UnicoreDataMovementResource dataMovementResource = (UnicoreDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_DATA_MOVEMENT, unicoreDataMovement);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            UnicoreDataMovementResource unicoreDataMovementResource = dataMovementResource;
            return unicoreDataMovementResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> unicoreDMResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreDataMovement", new Object[0][]);
            if (fieldName.equals("unicoreEndpointUrl")) {
                generator.setParameter("unicoreEndpointUrl", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UnicoreDataMovement dataMovement = (UnicoreDataMovement)result;
                        UnicoreDataMovementResource unicoreJobSubmissionResource = (UnicoreDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_DATA_MOVEMENT, dataMovement);
                        unicoreDMResourceList.add(unicoreJobSubmissionResource);
                    }
                }
            } else if (fieldName.equals("securityProtocol")) {
                generator.setParameter("securityProtocol", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UnicoreDataMovement dataMovement = (UnicoreDataMovement)result;
                        UnicoreDataMovementResource dataMovementResource = (UnicoreDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_DATA_MOVEMENT, dataMovement);
                        unicoreDMResourceList.add(dataMovementResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Unicore data movement resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Unicore data movement resource.");
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return unicoreDMResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        return null;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UnicoreDataMovement existingDataMovement = (UnicoreDataMovement)em.find(UnicoreDataMovement.class, (Object)this.dataMovementId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingDataMovement != null) {
                existingDataMovement.setDataMovementId(this.dataMovementId);
                existingDataMovement.setUnicoreEndpointUrl(this.unicoreEndpointUrl);
                existingDataMovement.setSecurityProtocol(this.securityProtocol);
                em.merge((Object)existingDataMovement);
            } else {
                UnicoreDataMovement unicoreJobSubmission = new UnicoreDataMovement();
                unicoreJobSubmission.setDataMovementId(this.dataMovementId);
                unicoreJobSubmission.setUnicoreEndpointUrl(this.unicoreEndpointUrl);
                unicoreJobSubmission.setSecurityProtocol(this.securityProtocol);
                em.persist((Object)unicoreJobSubmission);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UnicoreDataMovement dataMovement = (UnicoreDataMovement)em.find(UnicoreDataMovement.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = dataMovement != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getDataMovementId() {
        return this.dataMovementId;
    }

    public void setDataMovementId(String dataMovementId) {
        this.dataMovementId = dataMovementId;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getUnicoreEndpointUrl() {
        return this.unicoreEndpointUrl;
    }

    public void setUnicoreEndpointUrl(String unicoreEndpointUrl) {
        this.unicoreEndpointUrl = unicoreEndpointUrl;
    }
}

