/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogUtils;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.StorageResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageResourceImpl
implements StorageResource {
    private static final Logger logger = LoggerFactory.getLogger(StorageResourceImpl.class);

    protected String saveStorageResourceDescriptorData(StorageResourceDescription description) throws AppCatalogException {
        StorageResourceResource storageResourceResource = this.saveStorageResource(description);
        return storageResourceResource.getStorageResourceId();
    }

    protected StorageResourceResource saveStorageResource(StorageResourceDescription description) throws AppCatalogException {
        StorageResourceResource storageResourceResource = AppCatalogThriftConversion.getStorageResource(description);
        storageResourceResource.save();
        this.saveDataMovementInterfaces(description, storageResourceResource);
        return storageResourceResource;
    }

    protected void saveDataMovementInterfaces(StorageResourceDescription description, StorageResourceResource storageResourceResource) throws AppCatalogException {
        List dataMovemenetInterfaces = description.getDataMovementInterfaces();
        if (dataMovemenetInterfaces != null && !dataMovemenetInterfaces.isEmpty()) {
            for (DataMovementInterface dataMovementInterface : dataMovemenetInterfaces) {
                StorageInterfaceResource storageInterface = AppCatalogThriftConversion.getStorageInterface(dataMovementInterface);
                storageInterface.setStorageResourceResource(storageResourceResource);
                storageInterface.setStorageResourceId(storageResourceResource.getStorageResourceId());
                storageInterface.save();
            }
        }
    }

    public String addStorageResource(StorageResourceDescription description) throws AppCatalogException {
        try {
            if (description.getStorageResourceDescription().equals("") || description.getStorageResourceId().equals("DO_NOT_SET_AT_CLIENTS")) {
                description.setStorageResourceId(AppCatalogUtils.getID(description.getHostName()));
            }
            return this.saveStorageResourceDescriptorData(description);
        }
        catch (Exception e) {
            logger.error("Error while saving storage resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void updateStorageResource(String storageResourceId, StorageResourceDescription updatedStorageResource) throws AppCatalogException {
        try {
            this.saveStorageResourceDescriptorData(updatedStorageResource);
        }
        catch (Exception e) {
            logger.error("Error while updating storage resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public StorageResourceDescription getStorageResource(String resourceId) throws AppCatalogException {
        try {
            StorageResourceResource resource = new StorageResourceResource();
            StorageResourceResource storageResource = (StorageResourceResource)resource.get(resourceId);
            return AppCatalogThriftConversion.getStorageDescription(storageResource);
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<StorageResourceDescription> getStorageResourceList(Map<String, String> filters) throws AppCatalogException {
        List<StorageResourceDescription> storageResourceDescriptions = new ArrayList<StorageResourceDescription>();
        try {
            StorageResourceResource resource = new StorageResourceResource();
            for (String fieldName : filters.keySet()) {
                if (fieldName.equals("hostName")) {
                    List<AppCatalogResource> resources = resource.get("hostName", filters.get(fieldName));
                    if (resources == null || resources.isEmpty()) continue;
                    storageResourceDescriptions = AppCatalogThriftConversion.getStorageDescriptionList(resources);
                    continue;
                }
                logger.error("Unsupported field name for storage resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for storage resource.");
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return storageResourceDescriptions;
    }

    public List<StorageResourceDescription> getAllStorageResourceList() throws AppCatalogException {
        List<StorageResourceDescription> storageResourceDescriptions = new ArrayList<StorageResourceDescription>();
        try {
            StorageResourceResource resource = new StorageResourceResource();
            List<AppCatalogResource> resources = resource.getAll();
            if (resources != null && !resources.isEmpty()) {
                storageResourceDescriptions = AppCatalogThriftConversion.getStorageDescriptionList(resources);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return storageResourceDescriptions;
    }

    public Map<String, String> getAllStorageResourceIdList() throws AppCatalogException {
        try {
            HashMap<String, String> storageResourceMap = new HashMap<String, String>();
            StorageResourceResource resource = new StorageResourceResource();
            List<AppCatalogResource> allStorageResources = resource.getAll();
            if (allStorageResources != null && !allStorageResources.isEmpty()) {
                for (AppCatalogResource sr : allStorageResources) {
                    StorageResourceResource srr = (StorageResourceResource)sr;
                    storageResourceMap.put(srr.getStorageResourceId(), srr.getHostName());
                }
            }
            return storageResourceMap;
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public Map<String, String> getAvailableStorageResourceIdList() throws AppCatalogException {
        try {
            HashMap<String, String> storageResourceMap = new HashMap<String, String>();
            StorageResourceResource resource = new StorageResourceResource();
            List<AppCatalogResource> allStorageResources = resource.getAll();
            if (allStorageResources != null && !allStorageResources.isEmpty()) {
                for (AppCatalogResource sr : allStorageResources) {
                    StorageResourceResource srr = (StorageResourceResource)sr;
                    if (!srr.isEnabled()) continue;
                    storageResourceMap.put(srr.getStorageResourceId(), srr.getHostName());
                }
            }
            return storageResourceMap;
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isStorageResourceExists(String resourceId) throws AppCatalogException {
        try {
            StorageResourceResource resource = new StorageResourceResource();
            return resource.isExists(resourceId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeStorageResource(String resourceId) throws AppCatalogException {
        try {
            StorageResourceResource resource = new StorageResourceResource();
            resource.remove(resourceId);
        }
        catch (Exception e) {
            logger.error("Error while removing storage resource...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void removeDataMovementInterface(String storageResourceId, String dataMovementInterfaceId) throws AppCatalogException {
        try {
            StorageInterfaceResource resource = new StorageInterfaceResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("storageResourceId", storageResourceId);
            ids.put("dataMovementInterfaceId", dataMovementInterfaceId);
            resource.remove(ids);
        }
        catch (Exception e) {
            logger.error("Error while removing data movement interface..", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }
}

