/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.xacml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceException;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class DefaultXACMLPEP {
    private static final Logger logger = LoggerFactory.getLogger(DefaultXACMLPEP.class);
    private EntitlementServiceStub entitlementServiceStub;

    public DefaultXACMLPEP(String auhorizationServerURL, String username, String password, ConfigurationContext configCtx) throws AiravataSecurityException {
        try {
            String PDPURL = auhorizationServerURL + "EntitlementService";
            this.entitlementServiceStub = new EntitlementServiceStub(configCtx, PDPURL);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (boolean)true, (ServiceClient)this.entitlementServiceStub._getServiceClient());
        }
        catch (AxisFault e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error initializing XACML PEP client.");
        }
    }

    public boolean getAuthorizationDecision(AuthzToken authzToken, Map<String, String> metaData) throws AiravataSecurityException {
        try {
            String action;
            String decisionString;
            String decision;
            String subject = (String)authzToken.getClaimsMap().get("userName");
            if (subject.startsWith("http://")) {
                subject = subject.substring(6);
            }
            if ("Permit".equals(decision = this.parseDecisionString(decisionString = this.entitlementServiceStub.getDecisionByAttributes(subject, null, action = "/airavata/" + metaData.get("api.method.name"), null)))) {
                return true;
            }
            logger.error("Authorization decision is: " + decision);
            return false;
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in authorizing the user.");
        }
        catch (EntitlementServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in authorizing the user.");
        }
    }

    private String parseDecisionString(String decisionString) throws AiravataSecurityException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decisionString.getBytes("UTF-8"));
            Document doc = docBuilderFactory.newDocumentBuilder().parse(inputStream);
            Node resultNode = doc.getDocumentElement().getFirstChild();
            Node decisionNode = resultNode.getFirstChild();
            String decision = decisionNode.getTextContent();
            return decision;
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in parsing XACML authorization response.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in parsing XACML authorization response.");
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in parsing XACML authorization response.");
        }
        catch (IOException e) {
            logger.error("Error in parsing XACML authorization response.");
            throw new AiravataSecurityException("Error in parsing XACML authorization response.");
        }
    }
}

