/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.error.AuthorizationException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.AiravataSecurityManager;
import org.apache.airavata.service.security.IdentityContext;
import org.apache.airavata.service.security.SecurityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SecurityInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        AuthzToken authzToken = (AuthzToken)invocation.getArguments()[0];
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        metaDataMap.put("api.method.name", invocation.getMethod().getName());
        this.authorize(authzToken, metaDataMap);
        IdentityContext.set(authzToken);
        Object returnObj = invocation.proceed();
        IdentityContext.unset();
        return returnObj;
    }

    private void authorize(AuthzToken authzToken, Map<String, String> metaData) throws AuthorizationException {
        try {
            AiravataSecurityManager securityManager;
            boolean isAuthz;
            boolean isAPISecured = ServerSettings.isAPISecured();
            if (isAPISecured && !(isAuthz = (securityManager = SecurityManagerFactory.getSecurityManager()).isUserAuthorized(authzToken, metaData))) {
                throw new AuthorizationException("User is not authenticated or authorized.");
            }
        }
        catch (AiravataSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AuthorizationException("Error in authenticating or authorizing user.");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AuthorizationException("Internal error in authenticating or authorizing user.");
        }
    }
}

