/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset.impl;

import java.util.LinkedList;
import java.util.List;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlElementView;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.impl.XmlElementImpl;
import org.xmlpull.infoset.impl.XmlViewIterableAdapter;

public class XmlElementWithViewsImpl
extends XmlElementImpl
implements XmlElement {
    private List<XmlElementView> views = null;

    @Override
    public XmlElementWithViewsImpl clone() throws CloneNotSupportedException {
        XmlElementWithViewsImpl cloned = (XmlElementWithViewsImpl)super.clone();
        cloned.views = null;
        return cloned;
    }

    public XmlElementWithViewsImpl(XmlNamespace namespace, String name) {
        super(namespace, name);
    }

    public XmlElementWithViewsImpl(String namespaceName, String name) {
        super(namespaceName, name);
    }

    @Override
    public XmlElement newElement(String namespace, String name) {
        return new XmlElementWithViewsImpl(namespace, name);
    }

    @Override
    public XmlElement newElement(XmlNamespace namespace, String name) {
        return new XmlElementWithViewsImpl(namespace, name);
    }

    @Override
    public <T extends XmlElementView> T viewAs(Class<T> someViewClass) throws XmlBuilderException {
        if (this.views != null) {
            for (int i = 0; i < this.views.size(); ++i) {
                XmlElementView view = this.views.get(i);
                Class<?> viewClass = view.getClass();
                if (!someViewClass.isAssignableFrom(viewClass)) continue;
                return (T)view;
            }
        }
        try {
            XmlElementView view = (XmlElementView)someViewClass.getConstructor(XmlElement.class).newInstance(this);
            this.addView(view);
            return (T)view;
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not create view to " + someViewClass, e);
        }
    }

    @Override
    public void addView(XmlElementView newView) throws XmlBuilderException {
        Class<?> newViewClass = newView.getClass();
        if (this.views != null) {
            for (int i = 0; i < this.views.size(); ++i) {
                XmlElementView view = this.views.get(i);
                Class<?> viewClass = view.getClass();
                if (!newViewClass.isAssignableFrom(viewClass)) continue;
                if (newView == view) {
                    return;
                }
                throw new XmlBuilderException("there is already view that is assignable to " + newViewClass + "(old: " + view + " new: " + newView + ")");
            }
        }
        if (this.views == null) {
            this.views = new LinkedList<XmlElementView>();
        }
        this.views.add(newView);
    }

    @Override
    public <T extends XmlElementView> Iterable<T> elements(XmlNamespace n, String name, Class<T> someViewClass) {
        Iterable<XmlElement> iterable = this.elements(n, name);
        return new XmlViewIterableAdapter<T>(iterable, someViewClass);
    }
}

