/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.sdk.Constraint;
import org.apache.airavata.cloud.aurora.client.sdk.Container;
import org.apache.airavata.cloud.aurora.client.sdk.ExecutorConfig;
import org.apache.airavata.cloud.aurora.client.sdk.Identity;
import org.apache.airavata.cloud.aurora.client.sdk.JobKey;
import org.apache.airavata.cloud.aurora.client.sdk.MesosContainer;
import org.apache.airavata.cloud.aurora.client.sdk.MesosFetcherURI;
import org.apache.airavata.cloud.aurora.client.sdk.Metadata;
import org.apache.airavata.cloud.aurora.client.sdk.Resource;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TaskConfig
implements TBase<TaskConfig, _Fields>,
Serializable,
Cloneable,
Comparable<TaskConfig> {
    private static final TStruct STRUCT_DESC = new TStruct("TaskConfig");
    private static final TField JOB_FIELD_DESC = new TField("job", 12, 28);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 12, 17);
    private static final TField IS_SERVICE_FIELD_DESC = new TField("isService", 2, 7);
    private static final TField NUM_CPUS_FIELD_DESC = new TField("numCpus", 4, 8);
    private static final TField RAM_MB_FIELD_DESC = new TField("ramMb", 10, 9);
    private static final TField DISK_MB_FIELD_DESC = new TField("diskMb", 10, 10);
    private static final TField PRIORITY_FIELD_DESC = new TField("priority", 8, 11);
    private static final TField MAX_TASK_FAILURES_FIELD_DESC = new TField("maxTaskFailures", 8, 13);
    private static final TField PRODUCTION_FIELD_DESC = new TField("production", 2, 18);
    private static final TField TIER_FIELD_DESC = new TField("tier", 11, 30);
    private static final TField RESOURCES_FIELD_DESC = new TField("resources", 14, 32);
    private static final TField CONSTRAINTS_FIELD_DESC = new TField("constraints", 14, 20);
    private static final TField REQUESTED_PORTS_FIELD_DESC = new TField("requestedPorts", 14, 21);
    private static final TField MESOS_FETCHER_URIS_FIELD_DESC = new TField("mesosFetcherUris", 14, 33);
    private static final TField TASK_LINKS_FIELD_DESC = new TField("taskLinks", 13, 22);
    private static final TField CONTACT_EMAIL_FIELD_DESC = new TField("contactEmail", 11, 23);
    private static final TField EXECUTOR_CONFIG_FIELD_DESC = new TField("executorConfig", 12, 25);
    private static final TField METADATA_FIELD_DESC = new TField("metadata", 14, 27);
    private static final TField CONTAINER_FIELD_DESC = new TField("container", 12, 29);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public JobKey job;
    public Identity owner;
    public boolean isService;
    public double numCpus;
    public long ramMb;
    public long diskMb;
    public int priority;
    public int maxTaskFailures;
    public boolean production;
    public String tier;
    public Set<Resource> resources;
    public Set<Constraint> constraints;
    public Set<String> requestedPorts;
    public Set<MesosFetcherURI> mesosFetcherUris;
    public Map<String, String> taskLinks;
    public String contactEmail;
    public ExecutorConfig executorConfig;
    public Set<Metadata> metadata;
    public Container container;
    private static final int __ISSERVICE_ISSET_ID = 0;
    private static final int __NUMCPUS_ISSET_ID = 1;
    private static final int __RAMMB_ISSET_ID = 2;
    private static final int __DISKMB_ISSET_ID = 3;
    private static final int __PRIORITY_ISSET_ID = 4;
    private static final int __MAXTASKFAILURES_ISSET_ID = 5;
    private static final int __PRODUCTION_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TaskConfig() {
        this.container = new Container();
        MesosContainer tmp32 = new MesosContainer();
        this.container.setMesos(tmp32);
    }

    public TaskConfig(JobKey job, Identity owner, boolean isService, double numCpus, long ramMb, long diskMb, int priority, int maxTaskFailures, Set<Resource> resources, Set<Constraint> constraints, Set<String> requestedPorts, Container container) {
        this();
        this.job = job;
        this.owner = owner;
        this.isService = isService;
        this.setIsServiceIsSet(true);
        this.numCpus = numCpus;
        this.setNumCpusIsSet(true);
        this.ramMb = ramMb;
        this.setRamMbIsSet(true);
        this.diskMb = diskMb;
        this.setDiskMbIsSet(true);
        this.priority = priority;
        this.setPriorityIsSet(true);
        this.maxTaskFailures = maxTaskFailures;
        this.setMaxTaskFailuresIsSet(true);
        this.resources = resources;
        this.constraints = constraints;
        this.requestedPorts = requestedPorts;
        this.container = container;
    }

    public TaskConfig(TaskConfig other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetJob()) {
            this.job = new JobKey(other.job);
        }
        if (other.isSetOwner()) {
            this.owner = new Identity(other.owner);
        }
        this.isService = other.isService;
        this.numCpus = other.numCpus;
        this.ramMb = other.ramMb;
        this.diskMb = other.diskMb;
        this.priority = other.priority;
        this.maxTaskFailures = other.maxTaskFailures;
        this.production = other.production;
        if (other.isSetTier()) {
            this.tier = other.tier;
        }
        if (other.isSetResources()) {
            HashSet<Resource> __this__resources = new HashSet<Resource>(other.resources.size());
            for (Resource resource : other.resources) {
                __this__resources.add(new Resource(resource));
            }
            this.resources = __this__resources;
        }
        if (other.isSetConstraints()) {
            HashSet<Constraint> __this__constraints = new HashSet<Constraint>(other.constraints.size());
            for (Constraint constraint : other.constraints) {
                __this__constraints.add(new Constraint(constraint));
            }
            this.constraints = __this__constraints;
        }
        if (other.isSetRequestedPorts()) {
            HashSet<String> __this__requestedPorts = new HashSet<String>(other.requestedPorts);
            this.requestedPorts = __this__requestedPorts;
        }
        if (other.isSetMesosFetcherUris()) {
            HashSet<MesosFetcherURI> __this__mesosFetcherUris = new HashSet<MesosFetcherURI>(other.mesosFetcherUris.size());
            for (MesosFetcherURI mesosFetcherURI : other.mesosFetcherUris) {
                __this__mesosFetcherUris.add(new MesosFetcherURI(mesosFetcherURI));
            }
            this.mesosFetcherUris = __this__mesosFetcherUris;
        }
        if (other.isSetTaskLinks()) {
            HashMap<String, String> __this__taskLinks = new HashMap<String, String>(other.taskLinks);
            this.taskLinks = __this__taskLinks;
        }
        if (other.isSetContactEmail()) {
            this.contactEmail = other.contactEmail;
        }
        if (other.isSetExecutorConfig()) {
            this.executorConfig = new ExecutorConfig(other.executorConfig);
        }
        if (other.isSetMetadata()) {
            HashSet<Metadata> __this__metadata = new HashSet<Metadata>(other.metadata.size());
            for (Metadata metadata : other.metadata) {
                __this__metadata.add(new Metadata(metadata));
            }
            this.metadata = __this__metadata;
        }
        if (other.isSetContainer()) {
            this.container = new Container(other.container);
        }
    }

    public TaskConfig deepCopy() {
        return new TaskConfig(this);
    }

    public void clear() {
        this.job = null;
        this.owner = null;
        this.setIsServiceIsSet(false);
        this.isService = false;
        this.setNumCpusIsSet(false);
        this.numCpus = 0.0;
        this.setRamMbIsSet(false);
        this.ramMb = 0L;
        this.setDiskMbIsSet(false);
        this.diskMb = 0L;
        this.setPriorityIsSet(false);
        this.priority = 0;
        this.setMaxTaskFailuresIsSet(false);
        this.maxTaskFailures = 0;
        this.setProductionIsSet(false);
        this.production = false;
        this.tier = null;
        this.resources = null;
        this.constraints = null;
        this.requestedPorts = null;
        this.mesosFetcherUris = null;
        this.taskLinks = null;
        this.contactEmail = null;
        this.executorConfig = null;
        this.metadata = null;
        this.container = new Container();
        MesosContainer tmp33 = new MesosContainer();
        this.container.setMesos(tmp33);
    }

    public JobKey getJob() {
        return this.job;
    }

    public TaskConfig setJob(JobKey job) {
        this.job = job;
        return this;
    }

    public void unsetJob() {
        this.job = null;
    }

    public boolean isSetJob() {
        return this.job != null;
    }

    public void setJobIsSet(boolean value) {
        if (!value) {
            this.job = null;
        }
    }

    public Identity getOwner() {
        return this.owner;
    }

    public TaskConfig setOwner(Identity owner) {
        this.owner = owner;
        return this;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    public boolean isIsService() {
        return this.isService;
    }

    public TaskConfig setIsService(boolean isService) {
        this.isService = isService;
        this.setIsServiceIsSet(true);
        return this;
    }

    public void unsetIsService() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetIsService() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIsServiceIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public double getNumCpus() {
        return this.numCpus;
    }

    public TaskConfig setNumCpus(double numCpus) {
        this.numCpus = numCpus;
        this.setNumCpusIsSet(true);
        return this;
    }

    public void unsetNumCpus() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetNumCpus() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setNumCpusIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getRamMb() {
        return this.ramMb;
    }

    public TaskConfig setRamMb(long ramMb) {
        this.ramMb = ramMb;
        this.setRamMbIsSet(true);
        return this;
    }

    public void unsetRamMb() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetRamMb() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setRamMbIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getDiskMb() {
        return this.diskMb;
    }

    public TaskConfig setDiskMb(long diskMb) {
        this.diskMb = diskMb;
        this.setDiskMbIsSet(true);
        return this;
    }

    public void unsetDiskMb() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetDiskMb() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setDiskMbIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getPriority() {
        return this.priority;
    }

    public TaskConfig setPriority(int priority) {
        this.priority = priority;
        this.setPriorityIsSet(true);
        return this;
    }

    public void unsetPriority() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetPriority() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setPriorityIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getMaxTaskFailures() {
        return this.maxTaskFailures;
    }

    public TaskConfig setMaxTaskFailures(int maxTaskFailures) {
        this.maxTaskFailures = maxTaskFailures;
        this.setMaxTaskFailuresIsSet(true);
        return this;
    }

    public void unsetMaxTaskFailures() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetMaxTaskFailures() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setMaxTaskFailuresIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public boolean isProduction() {
        return this.production;
    }

    public TaskConfig setProduction(boolean production) {
        this.production = production;
        this.setProductionIsSet(true);
        return this;
    }

    public void unsetProduction() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetProduction() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setProductionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public String getTier() {
        return this.tier;
    }

    public TaskConfig setTier(String tier) {
        this.tier = tier;
        return this;
    }

    public void unsetTier() {
        this.tier = null;
    }

    public boolean isSetTier() {
        return this.tier != null;
    }

    public void setTierIsSet(boolean value) {
        if (!value) {
            this.tier = null;
        }
    }

    public int getResourcesSize() {
        return this.resources == null ? 0 : this.resources.size();
    }

    public Iterator<Resource> getResourcesIterator() {
        return this.resources == null ? null : this.resources.iterator();
    }

    public void addToResources(Resource elem) {
        if (this.resources == null) {
            this.resources = new HashSet<Resource>();
        }
        this.resources.add(elem);
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public TaskConfig setResources(Set<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public void unsetResources() {
        this.resources = null;
    }

    public boolean isSetResources() {
        return this.resources != null;
    }

    public void setResourcesIsSet(boolean value) {
        if (!value) {
            this.resources = null;
        }
    }

    public int getConstraintsSize() {
        return this.constraints == null ? 0 : this.constraints.size();
    }

    public Iterator<Constraint> getConstraintsIterator() {
        return this.constraints == null ? null : this.constraints.iterator();
    }

    public void addToConstraints(Constraint elem) {
        if (this.constraints == null) {
            this.constraints = new HashSet<Constraint>();
        }
        this.constraints.add(elem);
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public TaskConfig setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public void unsetConstraints() {
        this.constraints = null;
    }

    public boolean isSetConstraints() {
        return this.constraints != null;
    }

    public void setConstraintsIsSet(boolean value) {
        if (!value) {
            this.constraints = null;
        }
    }

    public int getRequestedPortsSize() {
        return this.requestedPorts == null ? 0 : this.requestedPorts.size();
    }

    public Iterator<String> getRequestedPortsIterator() {
        return this.requestedPorts == null ? null : this.requestedPorts.iterator();
    }

    public void addToRequestedPorts(String elem) {
        if (this.requestedPorts == null) {
            this.requestedPorts = new HashSet<String>();
        }
        this.requestedPorts.add(elem);
    }

    public Set<String> getRequestedPorts() {
        return this.requestedPorts;
    }

    public TaskConfig setRequestedPorts(Set<String> requestedPorts) {
        this.requestedPorts = requestedPorts;
        return this;
    }

    public void unsetRequestedPorts() {
        this.requestedPorts = null;
    }

    public boolean isSetRequestedPorts() {
        return this.requestedPorts != null;
    }

    public void setRequestedPortsIsSet(boolean value) {
        if (!value) {
            this.requestedPorts = null;
        }
    }

    public int getMesosFetcherUrisSize() {
        return this.mesosFetcherUris == null ? 0 : this.mesosFetcherUris.size();
    }

    public Iterator<MesosFetcherURI> getMesosFetcherUrisIterator() {
        return this.mesosFetcherUris == null ? null : this.mesosFetcherUris.iterator();
    }

    public void addToMesosFetcherUris(MesosFetcherURI elem) {
        if (this.mesosFetcherUris == null) {
            this.mesosFetcherUris = new HashSet<MesosFetcherURI>();
        }
        this.mesosFetcherUris.add(elem);
    }

    public Set<MesosFetcherURI> getMesosFetcherUris() {
        return this.mesosFetcherUris;
    }

    public TaskConfig setMesosFetcherUris(Set<MesosFetcherURI> mesosFetcherUris) {
        this.mesosFetcherUris = mesosFetcherUris;
        return this;
    }

    public void unsetMesosFetcherUris() {
        this.mesosFetcherUris = null;
    }

    public boolean isSetMesosFetcherUris() {
        return this.mesosFetcherUris != null;
    }

    public void setMesosFetcherUrisIsSet(boolean value) {
        if (!value) {
            this.mesosFetcherUris = null;
        }
    }

    public int getTaskLinksSize() {
        return this.taskLinks == null ? 0 : this.taskLinks.size();
    }

    public void putToTaskLinks(String key, String val) {
        if (this.taskLinks == null) {
            this.taskLinks = new HashMap<String, String>();
        }
        this.taskLinks.put(key, val);
    }

    public Map<String, String> getTaskLinks() {
        return this.taskLinks;
    }

    public TaskConfig setTaskLinks(Map<String, String> taskLinks) {
        this.taskLinks = taskLinks;
        return this;
    }

    public void unsetTaskLinks() {
        this.taskLinks = null;
    }

    public boolean isSetTaskLinks() {
        return this.taskLinks != null;
    }

    public void setTaskLinksIsSet(boolean value) {
        if (!value) {
            this.taskLinks = null;
        }
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public TaskConfig setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public void unsetContactEmail() {
        this.contactEmail = null;
    }

    public boolean isSetContactEmail() {
        return this.contactEmail != null;
    }

    public void setContactEmailIsSet(boolean value) {
        if (!value) {
            this.contactEmail = null;
        }
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }

    public TaskConfig setExecutorConfig(ExecutorConfig executorConfig) {
        this.executorConfig = executorConfig;
        return this;
    }

    public void unsetExecutorConfig() {
        this.executorConfig = null;
    }

    public boolean isSetExecutorConfig() {
        return this.executorConfig != null;
    }

    public void setExecutorConfigIsSet(boolean value) {
        if (!value) {
            this.executorConfig = null;
        }
    }

    public int getMetadataSize() {
        return this.metadata == null ? 0 : this.metadata.size();
    }

    public Iterator<Metadata> getMetadataIterator() {
        return this.metadata == null ? null : this.metadata.iterator();
    }

    public void addToMetadata(Metadata elem) {
        if (this.metadata == null) {
            this.metadata = new HashSet<Metadata>();
        }
        this.metadata.add(elem);
    }

    public Set<Metadata> getMetadata() {
        return this.metadata;
    }

    public TaskConfig setMetadata(Set<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void unsetMetadata() {
        this.metadata = null;
    }

    public boolean isSetMetadata() {
        return this.metadata != null;
    }

    public void setMetadataIsSet(boolean value) {
        if (!value) {
            this.metadata = null;
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public TaskConfig setContainer(Container container) {
        this.container = container;
        return this;
    }

    public void unsetContainer() {
        this.container = null;
    }

    public boolean isSetContainer() {
        return this.container != null;
    }

    public void setContainerIsSet(boolean value) {
        if (!value) {
            this.container = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case JOB: {
                if (value == null) {
                    this.unsetJob();
                    break;
                }
                this.setJob((JobKey)value);
                break;
            }
            case OWNER: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((Identity)value);
                break;
            }
            case IS_SERVICE: {
                if (value == null) {
                    this.unsetIsService();
                    break;
                }
                this.setIsService((Boolean)value);
                break;
            }
            case NUM_CPUS: {
                if (value == null) {
                    this.unsetNumCpus();
                    break;
                }
                this.setNumCpus((Double)value);
                break;
            }
            case RAM_MB: {
                if (value == null) {
                    this.unsetRamMb();
                    break;
                }
                this.setRamMb((Long)value);
                break;
            }
            case DISK_MB: {
                if (value == null) {
                    this.unsetDiskMb();
                    break;
                }
                this.setDiskMb((Long)value);
                break;
            }
            case PRIORITY: {
                if (value == null) {
                    this.unsetPriority();
                    break;
                }
                this.setPriority((Integer)value);
                break;
            }
            case MAX_TASK_FAILURES: {
                if (value == null) {
                    this.unsetMaxTaskFailures();
                    break;
                }
                this.setMaxTaskFailures((Integer)value);
                break;
            }
            case PRODUCTION: {
                if (value == null) {
                    this.unsetProduction();
                    break;
                }
                this.setProduction((Boolean)value);
                break;
            }
            case TIER: {
                if (value == null) {
                    this.unsetTier();
                    break;
                }
                this.setTier((String)value);
                break;
            }
            case RESOURCES: {
                if (value == null) {
                    this.unsetResources();
                    break;
                }
                this.setResources((Set)value);
                break;
            }
            case CONSTRAINTS: {
                if (value == null) {
                    this.unsetConstraints();
                    break;
                }
                this.setConstraints((Set)value);
                break;
            }
            case REQUESTED_PORTS: {
                if (value == null) {
                    this.unsetRequestedPorts();
                    break;
                }
                this.setRequestedPorts((Set)value);
                break;
            }
            case MESOS_FETCHER_URIS: {
                if (value == null) {
                    this.unsetMesosFetcherUris();
                    break;
                }
                this.setMesosFetcherUris((Set)value);
                break;
            }
            case TASK_LINKS: {
                if (value == null) {
                    this.unsetTaskLinks();
                    break;
                }
                this.setTaskLinks((Map)value);
                break;
            }
            case CONTACT_EMAIL: {
                if (value == null) {
                    this.unsetContactEmail();
                    break;
                }
                this.setContactEmail((String)value);
                break;
            }
            case EXECUTOR_CONFIG: {
                if (value == null) {
                    this.unsetExecutorConfig();
                    break;
                }
                this.setExecutorConfig((ExecutorConfig)value);
                break;
            }
            case METADATA: {
                if (value == null) {
                    this.unsetMetadata();
                    break;
                }
                this.setMetadata((Set)value);
                break;
            }
            case CONTAINER: {
                if (value == null) {
                    this.unsetContainer();
                    break;
                }
                this.setContainer((Container)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case JOB: {
                return this.getJob();
            }
            case OWNER: {
                return this.getOwner();
            }
            case IS_SERVICE: {
                return this.isIsService();
            }
            case NUM_CPUS: {
                return this.getNumCpus();
            }
            case RAM_MB: {
                return this.getRamMb();
            }
            case DISK_MB: {
                return this.getDiskMb();
            }
            case PRIORITY: {
                return this.getPriority();
            }
            case MAX_TASK_FAILURES: {
                return this.getMaxTaskFailures();
            }
            case PRODUCTION: {
                return this.isProduction();
            }
            case TIER: {
                return this.getTier();
            }
            case RESOURCES: {
                return this.getResources();
            }
            case CONSTRAINTS: {
                return this.getConstraints();
            }
            case REQUESTED_PORTS: {
                return this.getRequestedPorts();
            }
            case MESOS_FETCHER_URIS: {
                return this.getMesosFetcherUris();
            }
            case TASK_LINKS: {
                return this.getTaskLinks();
            }
            case CONTACT_EMAIL: {
                return this.getContactEmail();
            }
            case EXECUTOR_CONFIG: {
                return this.getExecutorConfig();
            }
            case METADATA: {
                return this.getMetadata();
            }
            case CONTAINER: {
                return this.getContainer();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case JOB: {
                return this.isSetJob();
            }
            case OWNER: {
                return this.isSetOwner();
            }
            case IS_SERVICE: {
                return this.isSetIsService();
            }
            case NUM_CPUS: {
                return this.isSetNumCpus();
            }
            case RAM_MB: {
                return this.isSetRamMb();
            }
            case DISK_MB: {
                return this.isSetDiskMb();
            }
            case PRIORITY: {
                return this.isSetPriority();
            }
            case MAX_TASK_FAILURES: {
                return this.isSetMaxTaskFailures();
            }
            case PRODUCTION: {
                return this.isSetProduction();
            }
            case TIER: {
                return this.isSetTier();
            }
            case RESOURCES: {
                return this.isSetResources();
            }
            case CONSTRAINTS: {
                return this.isSetConstraints();
            }
            case REQUESTED_PORTS: {
                return this.isSetRequestedPorts();
            }
            case MESOS_FETCHER_URIS: {
                return this.isSetMesosFetcherUris();
            }
            case TASK_LINKS: {
                return this.isSetTaskLinks();
            }
            case CONTACT_EMAIL: {
                return this.isSetContactEmail();
            }
            case EXECUTOR_CONFIG: {
                return this.isSetExecutorConfig();
            }
            case METADATA: {
                return this.isSetMetadata();
            }
            case CONTAINER: {
                return this.isSetContainer();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TaskConfig) {
            return this.equals((TaskConfig)that);
        }
        return false;
    }

    public boolean equals(TaskConfig that) {
        if (that == null) {
            return false;
        }
        boolean this_present_job = this.isSetJob();
        boolean that_present_job = that.isSetJob();
        if (this_present_job || that_present_job) {
            if (!this_present_job || !that_present_job) {
                return false;
            }
            if (!this.job.equals(that.job)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_isService = true;
        boolean that_present_isService = true;
        if (this_present_isService || that_present_isService) {
            if (!this_present_isService || !that_present_isService) {
                return false;
            }
            if (this.isService != that.isService) {
                return false;
            }
        }
        boolean this_present_numCpus = true;
        boolean that_present_numCpus = true;
        if (this_present_numCpus || that_present_numCpus) {
            if (!this_present_numCpus || !that_present_numCpus) {
                return false;
            }
            if (this.numCpus != that.numCpus) {
                return false;
            }
        }
        boolean this_present_ramMb = true;
        boolean that_present_ramMb = true;
        if (this_present_ramMb || that_present_ramMb) {
            if (!this_present_ramMb || !that_present_ramMb) {
                return false;
            }
            if (this.ramMb != that.ramMb) {
                return false;
            }
        }
        boolean this_present_diskMb = true;
        boolean that_present_diskMb = true;
        if (this_present_diskMb || that_present_diskMb) {
            if (!this_present_diskMb || !that_present_diskMb) {
                return false;
            }
            if (this.diskMb != that.diskMb) {
                return false;
            }
        }
        boolean this_present_priority = true;
        boolean that_present_priority = true;
        if (this_present_priority || that_present_priority) {
            if (!this_present_priority || !that_present_priority) {
                return false;
            }
            if (this.priority != that.priority) {
                return false;
            }
        }
        boolean this_present_maxTaskFailures = true;
        boolean that_present_maxTaskFailures = true;
        if (this_present_maxTaskFailures || that_present_maxTaskFailures) {
            if (!this_present_maxTaskFailures || !that_present_maxTaskFailures) {
                return false;
            }
            if (this.maxTaskFailures != that.maxTaskFailures) {
                return false;
            }
        }
        boolean this_present_production = this.isSetProduction();
        boolean that_present_production = that.isSetProduction();
        if (this_present_production || that_present_production) {
            if (!this_present_production || !that_present_production) {
                return false;
            }
            if (this.production != that.production) {
                return false;
            }
        }
        boolean this_present_tier = this.isSetTier();
        boolean that_present_tier = that.isSetTier();
        if (this_present_tier || that_present_tier) {
            if (!this_present_tier || !that_present_tier) {
                return false;
            }
            if (!this.tier.equals(that.tier)) {
                return false;
            }
        }
        boolean this_present_resources = this.isSetResources();
        boolean that_present_resources = that.isSetResources();
        if (this_present_resources || that_present_resources) {
            if (!this_present_resources || !that_present_resources) {
                return false;
            }
            if (!this.resources.equals(that.resources)) {
                return false;
            }
        }
        boolean this_present_constraints = this.isSetConstraints();
        boolean that_present_constraints = that.isSetConstraints();
        if (this_present_constraints || that_present_constraints) {
            if (!this_present_constraints || !that_present_constraints) {
                return false;
            }
            if (!this.constraints.equals(that.constraints)) {
                return false;
            }
        }
        boolean this_present_requestedPorts = this.isSetRequestedPorts();
        boolean that_present_requestedPorts = that.isSetRequestedPorts();
        if (this_present_requestedPorts || that_present_requestedPorts) {
            if (!this_present_requestedPorts || !that_present_requestedPorts) {
                return false;
            }
            if (!this.requestedPorts.equals(that.requestedPorts)) {
                return false;
            }
        }
        boolean this_present_mesosFetcherUris = this.isSetMesosFetcherUris();
        boolean that_present_mesosFetcherUris = that.isSetMesosFetcherUris();
        if (this_present_mesosFetcherUris || that_present_mesosFetcherUris) {
            if (!this_present_mesosFetcherUris || !that_present_mesosFetcherUris) {
                return false;
            }
            if (!this.mesosFetcherUris.equals(that.mesosFetcherUris)) {
                return false;
            }
        }
        boolean this_present_taskLinks = this.isSetTaskLinks();
        boolean that_present_taskLinks = that.isSetTaskLinks();
        if (this_present_taskLinks || that_present_taskLinks) {
            if (!this_present_taskLinks || !that_present_taskLinks) {
                return false;
            }
            if (!this.taskLinks.equals(that.taskLinks)) {
                return false;
            }
        }
        boolean this_present_contactEmail = this.isSetContactEmail();
        boolean that_present_contactEmail = that.isSetContactEmail();
        if (this_present_contactEmail || that_present_contactEmail) {
            if (!this_present_contactEmail || !that_present_contactEmail) {
                return false;
            }
            if (!this.contactEmail.equals(that.contactEmail)) {
                return false;
            }
        }
        boolean this_present_executorConfig = this.isSetExecutorConfig();
        boolean that_present_executorConfig = that.isSetExecutorConfig();
        if (this_present_executorConfig || that_present_executorConfig) {
            if (!this_present_executorConfig || !that_present_executorConfig) {
                return false;
            }
            if (!this.executorConfig.equals(that.executorConfig)) {
                return false;
            }
        }
        boolean this_present_metadata = this.isSetMetadata();
        boolean that_present_metadata = that.isSetMetadata();
        if (this_present_metadata || that_present_metadata) {
            if (!this_present_metadata || !that_present_metadata) {
                return false;
            }
            if (!this.metadata.equals(that.metadata)) {
                return false;
            }
        }
        boolean this_present_container = this.isSetContainer();
        boolean that_present_container = that.isSetContainer();
        if (this_present_container || that_present_container) {
            if (!this_present_container || !that_present_container) {
                return false;
            }
            if (!this.container.equals(that.container)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_job = this.isSetJob();
        list.add(present_job);
        if (present_job) {
            list.add(this.job);
        }
        boolean present_owner = this.isSetOwner();
        list.add(present_owner);
        if (present_owner) {
            list.add(this.owner);
        }
        boolean present_isService = true;
        list.add(present_isService);
        if (present_isService) {
            list.add(this.isService);
        }
        boolean present_numCpus = true;
        list.add(present_numCpus);
        if (present_numCpus) {
            list.add(this.numCpus);
        }
        boolean present_ramMb = true;
        list.add(present_ramMb);
        if (present_ramMb) {
            list.add(this.ramMb);
        }
        boolean present_diskMb = true;
        list.add(present_diskMb);
        if (present_diskMb) {
            list.add(this.diskMb);
        }
        boolean present_priority = true;
        list.add(present_priority);
        if (present_priority) {
            list.add(this.priority);
        }
        boolean present_maxTaskFailures = true;
        list.add(present_maxTaskFailures);
        if (present_maxTaskFailures) {
            list.add(this.maxTaskFailures);
        }
        boolean present_production = this.isSetProduction();
        list.add(present_production);
        if (present_production) {
            list.add(this.production);
        }
        boolean present_tier = this.isSetTier();
        list.add(present_tier);
        if (present_tier) {
            list.add(this.tier);
        }
        boolean present_resources = this.isSetResources();
        list.add(present_resources);
        if (present_resources) {
            list.add(this.resources);
        }
        boolean present_constraints = this.isSetConstraints();
        list.add(present_constraints);
        if (present_constraints) {
            list.add(this.constraints);
        }
        boolean present_requestedPorts = this.isSetRequestedPorts();
        list.add(present_requestedPorts);
        if (present_requestedPorts) {
            list.add(this.requestedPorts);
        }
        boolean present_mesosFetcherUris = this.isSetMesosFetcherUris();
        list.add(present_mesosFetcherUris);
        if (present_mesosFetcherUris) {
            list.add(this.mesosFetcherUris);
        }
        boolean present_taskLinks = this.isSetTaskLinks();
        list.add(present_taskLinks);
        if (present_taskLinks) {
            list.add(this.taskLinks);
        }
        boolean present_contactEmail = this.isSetContactEmail();
        list.add(present_contactEmail);
        if (present_contactEmail) {
            list.add(this.contactEmail);
        }
        boolean present_executorConfig = this.isSetExecutorConfig();
        list.add(present_executorConfig);
        if (present_executorConfig) {
            list.add(this.executorConfig);
        }
        boolean present_metadata = this.isSetMetadata();
        list.add(present_metadata);
        if (present_metadata) {
            list.add(this.metadata);
        }
        boolean present_container = this.isSetContainer();
        list.add(present_container);
        if (present_container) {
            list.add((Object)this.container);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TaskConfig other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetJob()).compareTo(other.isSetJob());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJob() && (lastComparison = TBaseHelper.compareTo((Comparable)this.job, (Comparable)other.job)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwner()).compareTo(other.isSetOwner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwner() && (lastComparison = TBaseHelper.compareTo((Comparable)this.owner, (Comparable)other.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsService()).compareTo(other.isSetIsService());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsService() && (lastComparison = TBaseHelper.compareTo((boolean)this.isService, (boolean)other.isService)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumCpus()).compareTo(other.isSetNumCpus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumCpus() && (lastComparison = TBaseHelper.compareTo((double)this.numCpus, (double)other.numCpus)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRamMb()).compareTo(other.isSetRamMb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRamMb() && (lastComparison = TBaseHelper.compareTo((long)this.ramMb, (long)other.ramMb)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDiskMb()).compareTo(other.isSetDiskMb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDiskMb() && (lastComparison = TBaseHelper.compareTo((long)this.diskMb, (long)other.diskMb)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPriority()).compareTo(other.isSetPriority());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPriority() && (lastComparison = TBaseHelper.compareTo((int)this.priority, (int)other.priority)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxTaskFailures()).compareTo(other.isSetMaxTaskFailures());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxTaskFailures() && (lastComparison = TBaseHelper.compareTo((int)this.maxTaskFailures, (int)other.maxTaskFailures)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProduction()).compareTo(other.isSetProduction());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProduction() && (lastComparison = TBaseHelper.compareTo((boolean)this.production, (boolean)other.production)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTier()).compareTo(other.isSetTier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTier() && (lastComparison = TBaseHelper.compareTo((String)this.tier, (String)other.tier)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetResources()).compareTo(other.isSetResources());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetResources() && (lastComparison = TBaseHelper.compareTo(this.resources, other.resources)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetConstraints()).compareTo(other.isSetConstraints());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConstraints() && (lastComparison = TBaseHelper.compareTo(this.constraints, other.constraints)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRequestedPorts()).compareTo(other.isSetRequestedPorts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequestedPorts() && (lastComparison = TBaseHelper.compareTo(this.requestedPorts, other.requestedPorts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMesosFetcherUris()).compareTo(other.isSetMesosFetcherUris());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMesosFetcherUris() && (lastComparison = TBaseHelper.compareTo(this.mesosFetcherUris, other.mesosFetcherUris)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskLinks()).compareTo(other.isSetTaskLinks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskLinks() && (lastComparison = TBaseHelper.compareTo(this.taskLinks, other.taskLinks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetContactEmail()).compareTo(other.isSetContactEmail());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetContactEmail() && (lastComparison = TBaseHelper.compareTo((String)this.contactEmail, (String)other.contactEmail)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExecutorConfig()).compareTo(other.isSetExecutorConfig());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExecutorConfig() && (lastComparison = TBaseHelper.compareTo((Comparable)this.executorConfig, (Comparable)other.executorConfig)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMetadata()).compareTo(other.isSetMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMetadata() && (lastComparison = TBaseHelper.compareTo(this.metadata, other.metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetContainer()).compareTo(other.isSetContainer());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetContainer() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.container), (Comparable)((Object)other.container))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaskConfig(");
        boolean first = true;
        sb.append("job:");
        if (this.job == null) {
            sb.append("null");
        } else {
            sb.append(this.job);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("isService:");
        sb.append(this.isService);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numCpus:");
        sb.append(this.numCpus);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ramMb:");
        sb.append(this.ramMb);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("diskMb:");
        sb.append(this.diskMb);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("priority:");
        sb.append(this.priority);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxTaskFailures:");
        sb.append(this.maxTaskFailures);
        first = false;
        if (this.isSetProduction()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("production:");
            sb.append(this.production);
            first = false;
        }
        if (this.isSetTier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tier:");
            if (this.tier == null) {
                sb.append("null");
            } else {
                sb.append(this.tier);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("resources:");
        if (this.resources == null) {
            sb.append("null");
        } else {
            sb.append(this.resources);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("constraints:");
        if (this.constraints == null) {
            sb.append("null");
        } else {
            sb.append(this.constraints);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("requestedPorts:");
        if (this.requestedPorts == null) {
            sb.append("null");
        } else {
            sb.append(this.requestedPorts);
        }
        first = false;
        if (this.isSetMesosFetcherUris()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("mesosFetcherUris:");
            if (this.mesosFetcherUris == null) {
                sb.append("null");
            } else {
                sb.append(this.mesosFetcherUris);
            }
            first = false;
        }
        if (this.isSetTaskLinks()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("taskLinks:");
            if (this.taskLinks == null) {
                sb.append("null");
            } else {
                sb.append(this.taskLinks);
            }
            first = false;
        }
        if (this.isSetContactEmail()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("contactEmail:");
            if (this.contactEmail == null) {
                sb.append("null");
            } else {
                sb.append(this.contactEmail);
            }
            first = false;
        }
        if (this.isSetExecutorConfig()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("executorConfig:");
            if (this.executorConfig == null) {
                sb.append("null");
            } else {
                sb.append(this.executorConfig);
            }
            first = false;
        }
        if (this.isSetMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("metadata:");
            if (this.metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.metadata);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("container:");
        if (this.container == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.container);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.job != null) {
            this.job.validate();
        }
        if (this.owner != null) {
            this.owner.validate();
        }
        if (this.executorConfig != null) {
            this.executorConfig.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TaskConfigStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TaskConfigTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.PRODUCTION, _Fields.TIER, _Fields.MESOS_FETCHER_URIS, _Fields.TASK_LINKS, _Fields.CONTACT_EMAIL, _Fields.EXECUTOR_CONFIG, _Fields.METADATA};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.JOB, new FieldMetaData("job", 3, (FieldValueMetaData)new StructMetaData(12, JobKey.class)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 3, (FieldValueMetaData)new StructMetaData(12, Identity.class)));
        tmpMap.put(_Fields.IS_SERVICE, new FieldMetaData("isService", 3, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.NUM_CPUS, new FieldMetaData("numCpus", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.RAM_MB, new FieldMetaData("ramMb", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DISK_MB, new FieldMetaData("diskMb", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PRIORITY, new FieldMetaData("priority", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_TASK_FAILURES, new FieldMetaData("maxTaskFailures", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PRODUCTION, new FieldMetaData("production", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.TIER, new FieldMetaData("tier", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.RESOURCES, new FieldMetaData("resources", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, Resource.class))));
        tmpMap.put(_Fields.CONSTRAINTS, new FieldMetaData("constraints", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, Constraint.class))));
        tmpMap.put(_Fields.REQUESTED_PORTS, new FieldMetaData("requestedPorts", 3, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.MESOS_FETCHER_URIS, new FieldMetaData("mesosFetcherUris", 2, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, MesosFetcherURI.class))));
        tmpMap.put(_Fields.TASK_LINKS, new FieldMetaData("taskLinks", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.CONTACT_EMAIL, new FieldMetaData("contactEmail", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXECUTOR_CONFIG, new FieldMetaData("executorConfig", 2, (FieldValueMetaData)new StructMetaData(12, ExecutorConfig.class)));
        tmpMap.put(_Fields.METADATA, new FieldMetaData("metadata", 2, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, Metadata.class))));
        tmpMap.put(_Fields.CONTAINER, new FieldMetaData("container", 3, (FieldValueMetaData)new StructMetaData(12, Container.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TaskConfig.class, metaDataMap);
    }

    private static class TaskConfigTupleScheme
    extends TupleScheme<TaskConfig> {
        private TaskConfigTupleScheme() {
        }

        public void write(TProtocol prot, TaskConfig struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetJob()) {
                optionals.set(0);
            }
            if (struct.isSetOwner()) {
                optionals.set(1);
            }
            if (struct.isSetIsService()) {
                optionals.set(2);
            }
            if (struct.isSetNumCpus()) {
                optionals.set(3);
            }
            if (struct.isSetRamMb()) {
                optionals.set(4);
            }
            if (struct.isSetDiskMb()) {
                optionals.set(5);
            }
            if (struct.isSetPriority()) {
                optionals.set(6);
            }
            if (struct.isSetMaxTaskFailures()) {
                optionals.set(7);
            }
            if (struct.isSetProduction()) {
                optionals.set(8);
            }
            if (struct.isSetTier()) {
                optionals.set(9);
            }
            if (struct.isSetResources()) {
                optionals.set(10);
            }
            if (struct.isSetConstraints()) {
                optionals.set(11);
            }
            if (struct.isSetRequestedPorts()) {
                optionals.set(12);
            }
            if (struct.isSetMesosFetcherUris()) {
                optionals.set(13);
            }
            if (struct.isSetTaskLinks()) {
                optionals.set(14);
            }
            if (struct.isSetContactEmail()) {
                optionals.set(15);
            }
            if (struct.isSetExecutorConfig()) {
                optionals.set(16);
            }
            if (struct.isSetMetadata()) {
                optionals.set(17);
            }
            if (struct.isSetContainer()) {
                optionals.set(18);
            }
            oprot.writeBitSet(optionals, 19);
            if (struct.isSetJob()) {
                struct.job.write((TProtocol)oprot);
            }
            if (struct.isSetOwner()) {
                struct.owner.write((TProtocol)oprot);
            }
            if (struct.isSetIsService()) {
                oprot.writeBool(struct.isService);
            }
            if (struct.isSetNumCpus()) {
                oprot.writeDouble(struct.numCpus);
            }
            if (struct.isSetRamMb()) {
                oprot.writeI64(struct.ramMb);
            }
            if (struct.isSetDiskMb()) {
                oprot.writeI64(struct.diskMb);
            }
            if (struct.isSetPriority()) {
                oprot.writeI32(struct.priority);
            }
            if (struct.isSetMaxTaskFailures()) {
                oprot.writeI32(struct.maxTaskFailures);
            }
            if (struct.isSetProduction()) {
                oprot.writeBool(struct.production);
            }
            if (struct.isSetTier()) {
                oprot.writeString(struct.tier);
            }
            if (struct.isSetResources()) {
                oprot.writeI32(struct.resources.size());
                for (Resource resource : struct.resources) {
                    resource.write((TProtocol)oprot);
                }
            }
            if (struct.isSetConstraints()) {
                oprot.writeI32(struct.constraints.size());
                for (Constraint constraint : struct.constraints) {
                    constraint.write((TProtocol)oprot);
                }
            }
            if (struct.isSetRequestedPorts()) {
                oprot.writeI32(struct.requestedPorts.size());
                for (String string : struct.requestedPorts) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetMesosFetcherUris()) {
                oprot.writeI32(struct.mesosFetcherUris.size());
                for (MesosFetcherURI mesosFetcherURI : struct.mesosFetcherUris) {
                    mesosFetcherURI.write((TProtocol)oprot);
                }
            }
            if (struct.isSetTaskLinks()) {
                oprot.writeI32(struct.taskLinks.size());
                for (Map.Entry entry : struct.taskLinks.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetContactEmail()) {
                oprot.writeString(struct.contactEmail);
            }
            if (struct.isSetExecutorConfig()) {
                struct.executorConfig.write((TProtocol)oprot);
            }
            if (struct.isSetMetadata()) {
                oprot.writeI32(struct.metadata.size());
                for (Metadata metadata : struct.metadata) {
                    metadata.write((TProtocol)oprot);
                }
            }
            if (struct.isSetContainer()) {
                struct.container.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, TaskConfig struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(19);
            if (incoming.get(0)) {
                struct.job = new JobKey();
                struct.job.read((TProtocol)iprot);
                struct.setJobIsSet(true);
            }
            if (incoming.get(1)) {
                struct.owner = new Identity();
                struct.owner.read((TProtocol)iprot);
                struct.setOwnerIsSet(true);
            }
            if (incoming.get(2)) {
                struct.isService = iprot.readBool();
                struct.setIsServiceIsSet(true);
            }
            if (incoming.get(3)) {
                struct.numCpus = iprot.readDouble();
                struct.setNumCpusIsSet(true);
            }
            if (incoming.get(4)) {
                struct.ramMb = iprot.readI64();
                struct.setRamMbIsSet(true);
            }
            if (incoming.get(5)) {
                struct.diskMb = iprot.readI64();
                struct.setDiskMbIsSet(true);
            }
            if (incoming.get(6)) {
                struct.priority = iprot.readI32();
                struct.setPriorityIsSet(true);
            }
            if (incoming.get(7)) {
                struct.maxTaskFailures = iprot.readI32();
                struct.setMaxTaskFailuresIsSet(true);
            }
            if (incoming.get(8)) {
                struct.production = iprot.readBool();
                struct.setProductionIsSet(true);
            }
            if (incoming.get(9)) {
                struct.tier = iprot.readString();
                struct.setTierIsSet(true);
            }
            if (incoming.get(10)) {
                TSet _set65 = new TSet(12, iprot.readI32());
                struct.resources = new HashSet<Resource>(2 * _set65.size);
                for (int _i67 = 0; _i67 < _set65.size; ++_i67) {
                    Resource _elem66 = new Resource();
                    _elem66.read((TProtocol)iprot);
                    struct.resources.add(_elem66);
                }
                struct.setResourcesIsSet(true);
            }
            if (incoming.get(11)) {
                TSet _set68 = new TSet(12, iprot.readI32());
                struct.constraints = new HashSet<Constraint>(2 * _set68.size);
                for (int _i70 = 0; _i70 < _set68.size; ++_i70) {
                    Constraint _elem69 = new Constraint();
                    _elem69.read((TProtocol)iprot);
                    struct.constraints.add(_elem69);
                }
                struct.setConstraintsIsSet(true);
            }
            if (incoming.get(12)) {
                TSet _set71 = new TSet(11, iprot.readI32());
                struct.requestedPorts = new HashSet<String>(2 * _set71.size);
                for (int _i73 = 0; _i73 < _set71.size; ++_i73) {
                    String _elem72 = iprot.readString();
                    struct.requestedPorts.add(_elem72);
                }
                struct.setRequestedPortsIsSet(true);
            }
            if (incoming.get(13)) {
                TSet _set74 = new TSet(12, iprot.readI32());
                struct.mesosFetcherUris = new HashSet<MesosFetcherURI>(2 * _set74.size);
                for (int _i76 = 0; _i76 < _set74.size; ++_i76) {
                    MesosFetcherURI _elem75 = new MesosFetcherURI();
                    _elem75.read((TProtocol)iprot);
                    struct.mesosFetcherUris.add(_elem75);
                }
                struct.setMesosFetcherUrisIsSet(true);
            }
            if (incoming.get(14)) {
                TMap _map77 = new TMap(11, 11, iprot.readI32());
                struct.taskLinks = new HashMap<String, String>(2 * _map77.size);
                for (int _i80 = 0; _i80 < _map77.size; ++_i80) {
                    String _key78 = iprot.readString();
                    String _val79 = iprot.readString();
                    struct.taskLinks.put(_key78, _val79);
                }
                struct.setTaskLinksIsSet(true);
            }
            if (incoming.get(15)) {
                struct.contactEmail = iprot.readString();
                struct.setContactEmailIsSet(true);
            }
            if (incoming.get(16)) {
                struct.executorConfig = new ExecutorConfig();
                struct.executorConfig.read((TProtocol)iprot);
                struct.setExecutorConfigIsSet(true);
            }
            if (incoming.get(17)) {
                TSet _set81 = new TSet(12, iprot.readI32());
                struct.metadata = new HashSet<Metadata>(2 * _set81.size);
                for (int _i83 = 0; _i83 < _set81.size; ++_i83) {
                    Metadata _elem82 = new Metadata();
                    _elem82.read((TProtocol)iprot);
                    struct.metadata.add(_elem82);
                }
                struct.setMetadataIsSet(true);
            }
            if (incoming.get(18)) {
                struct.container = new Container();
                struct.container.read((TProtocol)iprot);
                struct.setContainerIsSet(true);
            }
        }
    }

    private static class TaskConfigTupleSchemeFactory
    implements SchemeFactory {
        private TaskConfigTupleSchemeFactory() {
        }

        public TaskConfigTupleScheme getScheme() {
            return new TaskConfigTupleScheme();
        }
    }

    private static class TaskConfigStandardScheme
    extends StandardScheme<TaskConfig> {
        private TaskConfigStandardScheme() {
        }

        public void read(TProtocol iprot, TaskConfig struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 28: {
                        if (schemeField.type == 12) {
                            struct.job = new JobKey();
                            struct.job.read(iprot);
                            struct.setJobIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 12) {
                            struct.owner = new Identity();
                            struct.owner.read(iprot);
                            struct.setOwnerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 2) {
                            struct.isService = iprot.readBool();
                            struct.setIsServiceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 4) {
                            struct.numCpus = iprot.readDouble();
                            struct.setNumCpusIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.ramMb = iprot.readI64();
                            struct.setRamMbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.diskMb = iprot.readI64();
                            struct.setDiskMbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.priority = iprot.readI32();
                            struct.setPriorityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 8) {
                            struct.maxTaskFailures = iprot.readI32();
                            struct.setMaxTaskFailuresIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 2) {
                            struct.production = iprot.readBool();
                            struct.setProductionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 30: {
                        if (schemeField.type == 11) {
                            struct.tier = iprot.readString();
                            struct.setTierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 32: {
                        if (schemeField.type == 14) {
                            TSet _set34 = iprot.readSetBegin();
                            struct.resources = new HashSet<Resource>(2 * _set34.size);
                            for (int _i36 = 0; _i36 < _set34.size; ++_i36) {
                                Resource _elem35 = new Resource();
                                _elem35.read(iprot);
                                struct.resources.add(_elem35);
                            }
                            iprot.readSetEnd();
                            struct.setResourcesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 20: {
                        if (schemeField.type == 14) {
                            TSet _set37 = iprot.readSetBegin();
                            struct.constraints = new HashSet<Constraint>(2 * _set37.size);
                            for (int _i39 = 0; _i39 < _set37.size; ++_i39) {
                                Constraint _elem38 = new Constraint();
                                _elem38.read(iprot);
                                struct.constraints.add(_elem38);
                            }
                            iprot.readSetEnd();
                            struct.setConstraintsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 21: {
                        if (schemeField.type == 14) {
                            TSet _set40 = iprot.readSetBegin();
                            struct.requestedPorts = new HashSet<String>(2 * _set40.size);
                            for (int _i42 = 0; _i42 < _set40.size; ++_i42) {
                                String _elem41 = iprot.readString();
                                struct.requestedPorts.add(_elem41);
                            }
                            iprot.readSetEnd();
                            struct.setRequestedPortsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 33: {
                        if (schemeField.type == 14) {
                            TSet _set43 = iprot.readSetBegin();
                            struct.mesosFetcherUris = new HashSet<MesosFetcherURI>(2 * _set43.size);
                            for (int _i45 = 0; _i45 < _set43.size; ++_i45) {
                                MesosFetcherURI _elem44 = new MesosFetcherURI();
                                _elem44.read(iprot);
                                struct.mesosFetcherUris.add(_elem44);
                            }
                            iprot.readSetEnd();
                            struct.setMesosFetcherUrisIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 22: {
                        if (schemeField.type == 13) {
                            TMap _map46 = iprot.readMapBegin();
                            struct.taskLinks = new HashMap<String, String>(2 * _map46.size);
                            for (int _i49 = 0; _i49 < _map46.size; ++_i49) {
                                String _key47 = iprot.readString();
                                String _val48 = iprot.readString();
                                struct.taskLinks.put(_key47, _val48);
                            }
                            iprot.readMapEnd();
                            struct.setTaskLinksIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 23: {
                        if (schemeField.type == 11) {
                            struct.contactEmail = iprot.readString();
                            struct.setContactEmailIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 25: {
                        if (schemeField.type == 12) {
                            struct.executorConfig = new ExecutorConfig();
                            struct.executorConfig.read(iprot);
                            struct.setExecutorConfigIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 27: {
                        if (schemeField.type == 14) {
                            TSet _set50 = iprot.readSetBegin();
                            struct.metadata = new HashSet<Metadata>(2 * _set50.size);
                            for (int _i52 = 0; _i52 < _set50.size; ++_i52) {
                                Metadata _elem51 = new Metadata();
                                _elem51.read(iprot);
                                struct.metadata.add(_elem51);
                            }
                            iprot.readSetEnd();
                            struct.setMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 29: {
                        if (schemeField.type == 12) {
                            struct.container = new Container();
                            struct.container.read(iprot);
                            struct.setContainerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TaskConfig struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(IS_SERVICE_FIELD_DESC);
            oprot.writeBool(struct.isService);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_CPUS_FIELD_DESC);
            oprot.writeDouble(struct.numCpus);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(RAM_MB_FIELD_DESC);
            oprot.writeI64(struct.ramMb);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DISK_MB_FIELD_DESC);
            oprot.writeI64(struct.diskMb);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(PRIORITY_FIELD_DESC);
            oprot.writeI32(struct.priority);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_TASK_FAILURES_FIELD_DESC);
            oprot.writeI32(struct.maxTaskFailures);
            oprot.writeFieldEnd();
            if (struct.owner != null) {
                oprot.writeFieldBegin(OWNER_FIELD_DESC);
                struct.owner.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetProduction()) {
                oprot.writeFieldBegin(PRODUCTION_FIELD_DESC);
                oprot.writeBool(struct.production);
                oprot.writeFieldEnd();
            }
            if (struct.constraints != null) {
                oprot.writeFieldBegin(CONSTRAINTS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.constraints.size()));
                for (Constraint constraint : struct.constraints) {
                    constraint.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.requestedPorts != null) {
                oprot.writeFieldBegin(REQUESTED_PORTS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.requestedPorts.size()));
                for (String string : struct.requestedPorts) {
                    oprot.writeString(string);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.taskLinks != null && struct.isSetTaskLinks()) {
                oprot.writeFieldBegin(TASK_LINKS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.taskLinks.size()));
                for (Map.Entry entry : struct.taskLinks.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.contactEmail != null && struct.isSetContactEmail()) {
                oprot.writeFieldBegin(CONTACT_EMAIL_FIELD_DESC);
                oprot.writeString(struct.contactEmail);
                oprot.writeFieldEnd();
            }
            if (struct.executorConfig != null && struct.isSetExecutorConfig()) {
                oprot.writeFieldBegin(EXECUTOR_CONFIG_FIELD_DESC);
                struct.executorConfig.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.metadata != null && struct.isSetMetadata()) {
                oprot.writeFieldBegin(METADATA_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.metadata.size()));
                for (Metadata metadata : struct.metadata) {
                    metadata.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.job != null) {
                oprot.writeFieldBegin(JOB_FIELD_DESC);
                struct.job.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.container != null) {
                oprot.writeFieldBegin(CONTAINER_FIELD_DESC);
                struct.container.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.tier != null && struct.isSetTier()) {
                oprot.writeFieldBegin(TIER_FIELD_DESC);
                oprot.writeString(struct.tier);
                oprot.writeFieldEnd();
            }
            if (struct.resources != null) {
                oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.resources.size()));
                for (Resource resource : struct.resources) {
                    resource.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.mesosFetcherUris != null && struct.isSetMesosFetcherUris()) {
                oprot.writeFieldBegin(MESOS_FETCHER_URIS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.mesosFetcherUris.size()));
                for (MesosFetcherURI mesosFetcherURI : struct.mesosFetcherUris) {
                    mesosFetcherURI.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TaskConfigStandardSchemeFactory
    implements SchemeFactory {
        private TaskConfigStandardSchemeFactory() {
        }

        public TaskConfigStandardScheme getScheme() {
            return new TaskConfigStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        JOB(28, "job"),
        OWNER(17, "owner"),
        IS_SERVICE(7, "isService"),
        NUM_CPUS(8, "numCpus"),
        RAM_MB(9, "ramMb"),
        DISK_MB(10, "diskMb"),
        PRIORITY(11, "priority"),
        MAX_TASK_FAILURES(13, "maxTaskFailures"),
        PRODUCTION(18, "production"),
        TIER(30, "tier"),
        RESOURCES(32, "resources"),
        CONSTRAINTS(20, "constraints"),
        REQUESTED_PORTS(21, "requestedPorts"),
        MESOS_FETCHER_URIS(33, "mesosFetcherUris"),
        TASK_LINKS(22, "taskLinks"),
        CONTACT_EMAIL(23, "contactEmail"),
        EXECUTOR_CONFIG(25, "executorConfig"),
        METADATA(27, "metadata"),
        CONTAINER(29, "container");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 28: {
                    return JOB;
                }
                case 17: {
                    return OWNER;
                }
                case 7: {
                    return IS_SERVICE;
                }
                case 8: {
                    return NUM_CPUS;
                }
                case 9: {
                    return RAM_MB;
                }
                case 10: {
                    return DISK_MB;
                }
                case 11: {
                    return PRIORITY;
                }
                case 13: {
                    return MAX_TASK_FAILURES;
                }
                case 18: {
                    return PRODUCTION;
                }
                case 30: {
                    return TIER;
                }
                case 32: {
                    return RESOURCES;
                }
                case 20: {
                    return CONSTRAINTS;
                }
                case 21: {
                    return REQUESTED_PORTS;
                }
                case 33: {
                    return MESOS_FETCHER_URIS;
                }
                case 22: {
                    return TASK_LINKS;
                }
                case 23: {
                    return CONTACT_EMAIL;
                }
                case 25: {
                    return EXECUTOR_CONFIG;
                }
                case 27: {
                    return METADATA;
                }
                case 29: {
                    return CONTAINER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

