/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control;

import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringUtils;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetConfigurationResponseCommand
extends ControlCommand {
    private static final Log log = LogFactory.getLog(GetConfigurationResponseCommand.class);
    private String[] serviceGroups;

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        if (configContext.getPropertyNonReplicable("local_recd.config.init.method") == null) {
            log.info((Object)"Received configuration initialization message");
            configContext.setNonReplicableProperty("local_recd.config.init.method", "true");
            if (this.serviceGroups != null) {
                Object serviceGroup;
                for (int i = 0; i < this.serviceGroups.length; ++i) {
                    serviceGroup = this.serviceGroups[i];
                    if (axisConfig.getServiceGroup((String)serviceGroup) != null) continue;
                    try {
                        ClusteringUtils.loadServiceGroup((String)serviceGroup, configContext, System.getProperty("axis2.work.dir"));
                        continue;
                    }
                    catch (FileNotFoundException ignored) {
                        continue;
                    }
                    catch (Exception e) {
                        throw new ClusteringFault(e);
                    }
                }
                Iterator<AxisServiceGroup> iter = axisConfig.getServiceGroups();
                while (iter.hasNext()) {
                    serviceGroup = iter.next();
                    boolean foundServiceGroup = false;
                    for (int i = 0; i < this.serviceGroups.length; ++i) {
                        String serviceGroupName = this.serviceGroups[i];
                        if (!((AxisServiceGroup)serviceGroup).getServiceGroupName().equals(serviceGroupName)) continue;
                        foundServiceGroup = true;
                        break;
                    }
                    if (foundServiceGroup) continue;
                    boolean mustUnloadServiceGroup = true;
                    Iterator<AxisService> serviceIter = ((AxisServiceGroup)serviceGroup).getServices();
                    while (serviceIter.hasNext()) {
                        AxisService service = serviceIter.next();
                        if (!service.isClientSide() && service.getParameter("moduleService") == null) continue;
                        mustUnloadServiceGroup = false;
                        break;
                    }
                    if (!mustUnloadServiceGroup) continue;
                    try {
                        axisConfig.removeServiceGroup(((AxisServiceGroup)serviceGroup).getServiceGroupName());
                    }
                    catch (Exception e) {
                        throw new ClusteringFault(e);
                    }
                }
            }
        }
    }

    public void setServiceGroups(String[] serviceGroups) {
        this.serviceGroups = serviceGroups;
    }

    public String toString() {
        return "GetConfigurationResponseCommand";
    }
}

