/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.jetty;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.ConfigurableGzipFilter;
import eu.unicore.util.jetty.CustomSslSocketConnector;
import eu.unicore.util.jetty.HttpServerProperties;
import eu.unicore.util.jetty.JettyLogger;
import eu.unicore.util.jetty.NIOSSLSocketConnector;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Random;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class JettyServerBase {
    private static final Logger logger = Log.getLogger("unicore.httpserver", JettyServerBase.class);
    protected final Class<? extends JettyLogger> jettyLogger;
    protected final URL[] listenUrls;
    protected final IAuthnAndTrustConfiguration securityConfiguration;
    protected final HttpServerProperties extraSettings;
    private Server theServer;

    public JettyServerBase(URL listenUrl, IAuthnAndTrustConfiguration secConfiguration, HttpServerProperties extraSettings) throws ConfigurationException {
        this(new URL[]{listenUrl}, secConfiguration, extraSettings, JettyLogger.class);
    }

    public JettyServerBase(URL[] listenUrls, IAuthnAndTrustConfiguration secConfiguration, HttpServerProperties extraSettings, Class<? extends JettyLogger> jettyLogger) throws ConfigurationException {
        this.securityConfiguration = secConfiguration;
        this.jettyLogger = jettyLogger;
        this.listenUrls = listenUrls;
        this.extraSettings = extraSettings;
    }

    public void start() throws Exception {
        logger.debug("Starting Jetty HTTP server");
        this.theServer.start();
        this.updatePortsIfNeeded();
        logger.info("Jetty HTTP server was started");
    }

    public void stop() throws Exception {
        logger.debug("Stopping Jetty HTTP server");
        this.theServer.stop();
        logger.info("Jetty HTTP server was stopped");
    }

    protected void initServer() throws ConfigurationException {
        if (this.jettyLogger != null) {
            logger.debug("Setting a custom class for handling Jetty logging: " + this.jettyLogger.getName());
            System.setProperty("org.eclipse.jetty.util.log.class", this.jettyLogger.getName());
        }
        if (this.listenUrls.length == 1 && "0.0.0.0".equals(this.listenUrls[0].getHost())) {
            logger.info("Creating Jetty HTTP server, will listen on all network interfaces");
        } else {
            StringBuilder allAddresses = new StringBuilder();
            for (URL uRL : this.listenUrls) {
                allAddresses.append(uRL).append(" ");
            }
            logger.info("Creating Jetty HTTP server, will listen on: " + allAddresses);
        }
        this.theServer = new Server();
        this.configureSessionIdManager(this.extraSettings.getBooleanValue("fastRandom"));
        Connector[] connectors = this.createConnectors();
        for (URL uRL : connectors) {
            this.theServer.addConnector((Connector)uRL);
        }
        this.configureServer();
        this.theServer.setHandler(this.createRootHandler());
        this.configureGzip();
    }

    protected void configureSessionIdManager(boolean useFastRandom) {
        if (useFastRandom) {
            logger.info("Using fast (but less secure) session ID generator");
            HashSessionIdManager sm = new HashSessionIdManager(new Random());
            this.theServer.setSessionIdManager((SessionIdManager)sm);
        }
    }

    protected Connector[] createConnectors() throws ConfigurationException {
        AbstractConnector[] ret = new AbstractConnector[this.listenUrls.length];
        for (int i = 0; i < this.listenUrls.length; ++i) {
            ret[i] = this.createConnector(this.listenUrls[i]);
            this.configureConnector(ret[i], this.listenUrls[i]);
        }
        return ret;
    }

    protected AbstractConnector createConnector(URL url) throws ConfigurationException {
        AbstractConnector connector = url.getProtocol().startsWith("https") ? this.createSecureConnector(url) : this.createPlainConnector(url);
        return connector;
    }

    protected SslSelectChannelConnector getNioSecuredConnectorInstance() {
        NIOSSLSocketConnector ssl;
        try {
            ssl = new NIOSSLSocketConnector((X509CertChainValidator)this.securityConfiguration.getValidator(), this.securityConfiguration.getCredential());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create Jetty NIO SSL connector, shouldn't happen.", e);
        }
        ssl.setLowResourcesConnections(this.extraSettings.getIntValue("highLoadConnections"));
        return ssl;
    }

    protected SslSocketConnector getClassicSecuredConnectorInstance() {
        try {
            return new CustomSslSocketConnector((X509CertChainValidator)this.securityConfiguration.getValidator(), this.securityConfiguration.getCredential());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create Jetty SSL connector, shouldn't happen.", e);
        }
    }

    protected AbstractConnector createSecureConnector(URL url) throws ConfigurationException {
        SslSelectChannelConnector ssl;
        boolean useNio = this.extraSettings.getBooleanValue("useNIO");
        if (useNio) {
            logger.debug("Creating SSL NIO connector on: " + url);
            ssl = this.getNioSecuredConnectorInstance();
        } else {
            logger.debug("Creating SSL connector on: " + url);
            ssl = this.getClassicSecuredConnectorInstance();
        }
        SslContextFactory factory = ssl.getSslContextFactory();
        factory.setNeedClientAuth(this.extraSettings.getBooleanValue("requireClientAuthn").booleanValue());
        factory.setWantClientAuth(this.extraSettings.getBooleanValue("wantClientAuthn").booleanValue());
        String disabledCiphers = this.extraSettings.getValue("disabledCipherSuites");
        if (disabledCiphers != null && (disabledCiphers = disabledCiphers.trim()).length() > 1) {
            factory.setExcludeCipherSuites(disabledCiphers.split("[ ]+"));
        }
        logger.debug("SSL protocol was set to: '" + factory.getProtocol() + "'");
        return (AbstractConnector)ssl;
    }

    protected SelectChannelConnector getNioPlainConnectorInstance() {
        return new SelectChannelConnector();
    }

    protected SocketConnector getClassicPlainConnectorInstance() {
        return new SocketConnector();
    }

    protected AbstractConnector createPlainConnector(URL url) {
        boolean useNio = this.extraSettings.getBooleanValue("useNIO");
        if (useNio) {
            logger.debug("Creating plain NIO HTTP connector on: " + url);
            SelectChannelConnector ret = this.getNioPlainConnectorInstance();
            ret.setLowResourcesConnections(this.extraSettings.getIntValue("highLoadConnections").intValue());
            return ret;
        }
        logger.debug("Creating plain HTTP connector on: " + url);
        return this.getClassicPlainConnectorInstance();
    }

    protected void configureConnector(AbstractConnector connector, URL url) throws ConfigurationException {
        connector.setHost(url.getHost());
        connector.setPort(url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
        connector.setSoLingerTime(this.extraSettings.getIntValue("soLingerTime").intValue());
        connector.setLowResourcesMaxIdleTime(this.extraSettings.getIntValue("lowResourceMaxIdleTime").intValue());
        connector.setMaxIdleTime(this.extraSettings.getIntValue("maxIdleTime").intValue());
    }

    protected void configureServer() throws ConfigurationException {
        QueuedThreadPool btPool = new QueuedThreadPool();
        int connectorsNum = this.getUrls().length;
        boolean useNio = this.extraSettings.getBooleanValue("useNIO");
        if (useNio) {
            connectorsNum *= 2;
        }
        btPool.setMaxThreads(this.extraSettings.getIntValue("maxThreads") + connectorsNum);
        btPool.setMinThreads(this.extraSettings.getIntValue("minThreads") + connectorsNum);
        this.theServer.setThreadPool((ThreadPool)btPool);
    }

    protected void configureGzip() throws ConfigurationException {
        boolean enableGzip = this.extraSettings.getBooleanValue("gzip.enable");
        if (enableGzip) {
            FilterHolder gzipHolder = new FilterHolder((Filter)new ConfigurableGzipFilter(this.extraSettings));
            logger.info("Enabling GZIP compression filter");
            this.tryToAddGzipFilter(gzipHolder, this.getRootHandler());
        }
    }

    protected void tryToAddGzipFilter(FilterHolder gzipHolder, Handler h) {
        if (h instanceof ServletContextHandler) {
            ((ServletContextHandler)h).addFilter(gzipHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        } else if (h instanceof HandlerContainer) {
            Handler[] handlers;
            for (Handler handler : handlers = ((HandlerContainer)h).getChildHandlers()) {
                this.tryToAddGzipFilter(gzipHolder, handler);
            }
        }
    }

    protected void updatePortsIfNeeded() {
        Connector[] conns = this.theServer.getConnectors();
        for (int i = 0; i < this.listenUrls.length; ++i) {
            URL url = this.listenUrls[i];
            if (url.getPort() != 0) continue;
            int port = conns[i].getLocalPort();
            try {
                this.listenUrls[i] = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Ups, URL can not be reconstructed, while it should", e);
            }
        }
    }

    protected abstract Handler createRootHandler() throws ConfigurationException;

    public Handler getRootHandler() {
        return this.theServer.getHandler();
    }

    public Server getServer() {
        return this.theServer;
    }

    public URL[] getUrls() {
        return this.listenUrls;
    }
}

