/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.rsync;

import eu.unicore.uftp.rsync.ChecksumHolder;
import eu.unicore.uftp.rsync.MasterChannel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;

public class SocketMasterChannel
implements MasterChannel {
    private final Socket socket;

    public SocketMasterChannel(Socket socket) {
        this.socket = socket;
    }

    @Override
    public ChecksumHolder receiveChecksums() throws IOException {
        DataInputStream dis = new DataInputStream(this.socket.getInputStream());
        ChecksumHolder res = new ChecksumHolder();
        res.blocksize = dis.readInt();
        int numBlocks = dis.readInt();
        res.weakChecksums = new ArrayList<Long>();
        res.strongChecksums = new ArrayList<byte[]>();
        for (int i = 0; i < numBlocks; ++i) {
            res.weakChecksums.add(dis.readLong());
            byte[] cs = new byte[16];
            dis.readFully(cs);
            res.strongChecksums.add(cs);
        }
        return res;
    }

    @Override
    public void sendData(long bytes, ByteChannel source, int index) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
        dos.writeInt(index);
        dos.writeLong(bytes);
        dos.flush();
        if (source == null) {
            return;
        }
        long remaining = bytes;
        ByteBuffer buf = ByteBuffer.allocate(2048);
        int len = 0;
        while (len > -1 && remaining > 0L) {
            if (remaining < (long)buf.limit()) {
                buf.limit((int)remaining);
            }
            if ((len = source.read(buf)) <= 0) continue;
            buf.flip();
            this.socket.getOutputStream().write(buf.array(), 0, len);
            buf.clear();
            remaining -= (long)len;
        }
        this.socket.getOutputStream().flush();
    }

    @Override
    public void shutdown() throws IOException {
        this.sendData(-1L, null, -1);
    }
}

