/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.addressing.Names;

public class CheckUnderstoodHeadersHandler
extends AbstractSoapInterceptor {
    private final Set<QName> understoodHeaders = new HashSet<QName>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public static final QName[] defaultHeaders = new QName[]{Names.WSA_ACTION_QNAME, Names.WSA_ADDRESS_QNAME, Names.WSA_FROM_QNAME, Names.WSA_TO_QNAME, Names.WSA_FAULTTO_QNAME, Names.WSA_REPLYTO_QNAME, Names.WSA_MESSAGEID_QNAME, Names.WSA_RELATESTO_QNAME};

    public CheckUnderstoodHeadersHandler() {
        super("pre-protocol");
        this.addUnderstoodHeaders(defaultHeaders);
    }

    public void addUnderstoodHeaders(QName[] qn) {
        this.rwLock.writeLock().lock();
        for (int l = 0; l < qn.length; ++l) {
            this.understoodHeaders.add(qn[l]);
        }
        this.rwLock.writeLock().unlock();
    }

    public Set<QName> getUnderstoodHeaders() {
        this.rwLock.readLock().lock();
        HashSet<QName> ret = new HashSet<QName>();
        ret.addAll(this.understoodHeaders);
        this.rwLock.readLock().unlock();
        return ret;
    }

    public void handleMessage(SoapMessage message) throws Fault {
    }
}

