/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.ErrorReasons;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.AudienceRestrictionType;
import xmlbeans.org.oasis.saml2.assertion.ConditionsType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;

public class AssertionValidator {
    public static final long DEFAULT_VALIDITY_GRACE_PERIOD = 180000L;
    private static final DateFormat DATE_FORMATTER = DateFormat.getDateTimeInstance(2, 2);
    protected Set<String> consumerSamlNames = new HashSet<String>();
    protected String consumerEndpointUri;
    protected String requestId;
    protected long samlValidityGraceTime;
    protected SamlTrustChecker trustChecker;

    public AssertionValidator(String consumerSamlName, String consumerEndpointUri, String requestId, long samlValidityGraceTime, SamlTrustChecker trustChecker) {
        if (consumerSamlName != null) {
            this.consumerSamlNames.add(consumerSamlName);
        }
        this.consumerEndpointUri = consumerEndpointUri;
        this.requestId = requestId;
        this.samlValidityGraceTime = samlValidityGraceTime;
        this.trustChecker = trustChecker;
    }

    public void addConsumerSamlNameAlias(String alias) {
        this.consumerSamlNames.add(alias);
    }

    public void validate(AssertionDocument assertionDoc) throws SAMLValidationException {
        AssertionType assertionXml = assertionDoc.getAssertion();
        this.checkMandatoryElements(assertionXml);
        this.trustChecker.checkTrust(assertionDoc);
        this.checkConditions(assertionXml);
        this.checkSubject(assertionXml);
    }

    protected void checkMandatoryElements(AssertionType assertion) throws SAMLValidationException {
        if (assertion.getID() == null || assertion.getID().equals("")) {
            throw new SAMLValidationException("Assertion must posses an ID");
        }
        if (assertion.getVersion() == null || !assertion.getVersion().equals("2.0")) {
            throw new SAMLValidationException("Assertion must posses 2.0 version");
        }
        if (assertion.getIssueInstant() == null) {
            throw new SAMLValidationException("Assertion must posses an IssueInstant");
        }
        if (assertion.getIssuer() == null || assertion.getIssuer().isNil()) {
            throw new SAMLValidationException("Assertion must have its Issuer set");
        }
        if (assertion.getIssuer().getStringValue() == null) {
            throw new SAMLValidationException("Assertion must have its Issuer value set");
        }
        if (assertion.getSubject() == null || assertion.getSubject().isNil()) {
            throw new SAMLValidationException("Assertion must have its Subject set");
        }
    }

    protected void checkSubject(AssertionType assertion) throws SAMLValidationException {
        SubjectType subject = assertion.getSubject();
        SubjectConfirmationType[] confirmations = subject.getSubjectConfirmationArray();
        if (confirmations == null || confirmations.length == 0) {
            return;
        }
        ErrorReasons errors = new ErrorReasons();
        boolean foundValid = false;
        int i = 1;
        for (SubjectConfirmationType confirmation : confirmations) {
            SubjectConfirmationDataType confData = confirmation.getSubjectConfirmationData();
            if (confData.getRecipient() != null && this.consumerEndpointUri != null && !confData.getRecipient().equals(this.consumerEndpointUri)) {
                errors.addConfirmationError(i, "subject confirmation receipent URL " + confData.getRecipient() + " is different from the expected one: " + this.consumerEndpointUri);
                continue;
            }
            try {
                this.checkTimeBounds("Audience restriction", confData.getNotBefore(), confData.getNotOnOrAfter());
            }
            catch (SAMLValidationException e) {
                errors.addConfirmationError(i, e.getMessage());
                continue;
            }
            if (this.requestId != null) {
                if (!confData.isSetInResponseTo() && "urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod())) {
                    errors.addConfirmationError(i, "InResponseTo is not set for an assertion with a bearer confirmation, and an expected requestId is " + this.requestId);
                    continue;
                }
                if (confData.isSetInResponseTo() && !this.requestId.equals(confData.getInResponseTo())) {
                    errors.addConfirmationError(i, "InResponseTo (" + confData.getInResponseTo() + ") is not equal to expected request id which was " + this.requestId);
                    continue;
                }
            }
            foundValid = true;
            ++i;
        }
        if (!foundValid) {
            throw new SAMLValidationException("None of subject confirmations is valid: " + errors.toString());
        }
    }

    protected void checkConditions(AssertionType assertion) throws SAMLValidationException {
        ConditionsType conditions = assertion.getConditions();
        if (conditions == null || conditions.isNil()) {
            return;
        }
        if (conditions.getOneTimeUseArray() != null && conditions.getOneTimeUseArray().length > 1) {
            throw new SAMLValidationException("Assertion may possess 0 or 1 OneTimeUse condition");
        }
        if (conditions.getProxyRestrictionArray() != null && conditions.getProxyRestrictionArray().length > 1) {
            throw new SAMLValidationException("Assertion may possess 0 or 1 ProxyRestriction condition");
        }
        this.checkTimeBounds("Assertion", conditions.getNotBefore(), conditions.getNotOnOrAfter());
        this.checkAudienceRestriction(conditions.getAudienceRestrictionArray());
        this.checkGenericConditions(conditions);
    }

    protected void checkStatements(AssertionType assertion) throws SAMLValidationException {
        int types = 0;
        if (assertion.getAttributeStatementArray() != null && assertion.getAttributeStatementArray().length > 0) {
            ++types;
        }
        if (assertion.getAuthzDecisionStatementArray() != null && assertion.getAuthzDecisionStatementArray().length > 0) {
            ++types;
        }
        if (assertion.getAuthnStatementArray() != null && assertion.getAuthnStatementArray().length > 0) {
            ++types;
        }
        if (types > 1) {
            throw new SAMLValidationException("Assertions with different statement types are unsupported");
        }
        if (types == 0) {
            throw new SAMLValidationException("Assertions without any statement are unsupported");
        }
    }

    protected void checkGenericConditions(ConditionsType conditions) throws SAMLValidationException {
        if (conditions.getConditionArray() != null && conditions.getConditionArray().length > 0) {
            throw new SAMLValidationException("Got unsupported conditions in the assertion: " + conditions.xmlText());
        }
    }

    protected void checkAudienceRestriction(AudienceRestrictionType[] audienceRest) throws SAMLValidationException {
        if (audienceRest == null || audienceRest.length == 0 || this.consumerSamlNames.isEmpty()) {
            return;
        }
        for (AudienceRestrictionType restriction : audienceRest) {
            String[] audiences = restriction.getAudienceArray();
            if (audiences == null) {
                throw new SAMLValidationException("Assertion has wrong audience restriction: no audiences defined inside");
            }
            boolean found = false;
            for (String tested : audiences) {
                for (String allowed : this.consumerSamlNames) {
                    if (!this.audienceMatching(allowed, tested)) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            throw new SAMLValidationException("Assertion audience restriction doesn't include any of this service identifiers: " + this.consumerSamlNames.toString() + " Audience is restricted to: " + restriction.xmlText());
        }
    }

    protected boolean audienceMatching(String audience, String tested) {
        if (audience.equals(tested)) {
            return true;
        }
        try {
            if (X500NameUtils.equal((String)audience, (String)tested)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void checkTimeBounds(String msg, Calendar notBefore, Calendar notOnOrAfter) throws SAMLValidationException {
        long now = System.currentTimeMillis();
        if (notBefore != null && now < notBefore.getTimeInMillis() - this.samlValidityGraceTime) {
            throw new SAMLValidationException(msg + " is not yet valid, will be from " + DATE_FORMATTER.format(notBefore.getTime()) + " and current time is " + DATE_FORMATTER.format(new Date()));
        }
        if (notOnOrAfter != null && now >= notOnOrAfter.getTimeInMillis() + this.samlValidityGraceTime) {
            throw new SAMLValidationException(msg + " expired at " + DATE_FORMATTER.format(notOnOrAfter.getTime()) + " and current time is " + DATE_FORMATTER.format(new Date()));
        }
    }
}

