/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.rns;

import de.fzj.unicore.uas.rns.RNSFault;
import de.fzj.unicore.uas.rns.RNSInvalidResultNumberException;
import de.fzj.unicore.uas.rns.RNSPath;
import de.fzj.unicore.uas.rns.RNSPortType;
import eu.unicore.security.wsutil.client.UnicoreWSClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import org.ggf.rns.LookupRequestDocument;
import org.ggf.rns.LookupRequestType;
import org.ggf.rns.LookupResponseDocument;
import org.ggf.rns.RNSEntryResponseType;
import org.ggf.rns.RemoveRequestDocument;
import org.ggf.rns.RemoveRequestType;
import org.ggf.rns.RemoveResponseDocument;
import org.ggf.rns.RemoveResponseType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RNSClient {
    private RNSPath path;
    private IClientConfiguration sec;

    public RNSClient(RNSPath path, IClientConfiguration sec) {
        this.path = path;
        this.sec = sec;
    }

    public RNSPath[] lookup(String ... names) throws RNSFault {
        LookupRequestDocument doc = LookupRequestDocument.Factory.newInstance();
        LookupRequestType request = doc.addNewLookupRequest();
        if (names != null && names.length > 0) {
            request.setEntryNameArray(names);
        }
        try {
            LookupResponseDocument response = this.makeProxy().lookup(doc);
            RNSEntryResponseType[] entries = response.getLookupResponse().getEntryResponseArray();
            ArrayList<RNSPath> result = new ArrayList<RNSPath>();
            for (RNSEntryResponseType entry : entries) {
                result.add(new RNSPath(this.path, entry.getEntryName(), entry.getEndpoint()));
            }
            return result.toArray(new RNSPath[result.size()]);
        }
        catch (Exception e) {
            throw new RNSFault("Unable to perform lookup operation", e);
        }
    }

    public boolean[] remove(String ... names) throws RNSFault, RNSInvalidResultNumberException {
        if (names == null || names.length == 0) {
            return new boolean[0];
        }
        RemoveRequestDocument doc = RemoveRequestDocument.Factory.newInstance();
        RemoveRequestType request = doc.addNewRemoveRequest();
        request.setEntryNameArray(names);
        try {
            RemoveResponseDocument responseDoc = this.makeProxy().remove(doc);
            RemoveResponseType response = responseDoc.getRemoveResponse();
            RNSEntryResponseType[] results = response.getEntryResponseArray();
            if (results.length != names.length) {
                throw new RNSInvalidResultNumberException();
            }
            boolean[] result = new boolean[results.length];
            for (int i = 0; i < results.length; ++i) {
                boolean success;
                result[i] = success = results[i].getFault() == null;
            }
            return result;
        }
        catch (RNSFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new RNSFault("Unable to perform remove operation.", e);
        }
    }

    protected RNSPortType makeProxy() throws Exception {
        EndpointReferenceType epr = this.path.getEndpointReference();
        RNSPortType proxy = new UnicoreWSClientFactory(this.sec).createPlainWSProxy(RNSPortType.class, epr.getAddress().getStringValue());
        this.configureRetry(proxy);
        return proxy;
    }

    private void configureRetry(Object proxy) {
    }
}

