/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.io.IOException;

public class AddItemListenerRequest
extends CallableClientRequest
implements Portable {
    CollectionProxyId proxyId;
    Data key;
    boolean includeValue;

    public AddItemListenerRequest() {
    }

    public AddItemListenerRequest(CollectionProxyId proxyId, Data key, boolean includeValue) {
        this.proxyId = proxyId;
        this.key = key;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        CollectionService service = (CollectionService)this.getService();
        ItemListener listener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.live()) {
                    Data item = clientEngine.toData(event.getItem());
                    PortableItemEvent portableItemEvent = new PortableItemEvent(item, event.getEventType(), event.getMember().getUuid());
                    clientEngine.sendResponse(endpoint, portableItemEvent);
                }
            }
        };
        String registrationId = service.addListener(this.proxyId.getName(), listener, this.key, this.includeValue, false);
        endpoint.setListenerRegistration("hz:impl:mapService", this.proxyId.getName(), registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:collectionService";
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeBoolean("i", this.includeValue);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.proxyId.writeData(out);
        IOUtil.writeNullableData(out, this.key);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.includeValue = reader.readBoolean("i");
        ObjectDataInput in = reader.getRawDataInput();
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
        this.key = IOUtil.readNullableData(in);
    }
}

