/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.TimeZone;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.util.DateUtil;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class CalendarExtractor
implements Extractor {
    protected SimpleDateFormat dateFormat;
    protected boolean useUnixTimestamp = false;
    protected boolean useUnixMillis = false;
    protected boolean useUnixNanos = false;

    public CalendarExtractor(String dateFormat, TimeZone timeZone) {
        if ("time".equals(dateFormat) || "long".equals(dateFormat) || "millis".equals(dateFormat)) {
            this.useUnixMillis = true;
        } else if ("unix".equals(dateFormat)) {
            this.useUnixTimestamp = true;
        } else if ("nanos".equals(dateFormat)) {
            this.useUnixNanos = true;
        } else {
            try {
                this.dateFormat = new SimpleDateFormat(dateFormat);
                this.dateFormat.setTimeZone(timeZone);
            }
            catch (IllegalArgumentException e) {
                this.dateFormat = new SimpleDateFormat(ConfigKey.DATE_FORMAT.getDefaultValue());
                this.dateFormat.setTimeZone(TimeZone.getTimeZone(ConfigKey.DATE_FORMAT_ZONE.getDefaultValue()));
            }
        }
    }

    @Override
    public Class<?> getType() {
        return Calendar.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        if (!jsonify || pValue == null) {
            return pValue;
        }
        Calendar cal = (Calendar)pValue;
        if (this.useUnixTimestamp) {
            return cal.getTimeInMillis() / 1000L;
        }
        if (this.useUnixMillis) {
            return cal.getTimeInMillis();
        }
        if (this.useUnixNanos) {
            return cal.getTimeInMillis() * 1000000L;
        }
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            if (!"time".equals(pathPart)) {
                return pConverter.getValueFaultHandler().handleException((Throwable)new AttributeNotFoundException("A calendar accepts only a single inner path element of value 'time' (and not '" + pathPart + "')"));
            }
            return cal.getTime().getTime();
        }
        return this.dateFormat.format(cal.getTime());
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        Calendar cal = (Calendar)pInner;
        if ("time".equals(pAttribute)) {
            long oldValue = cal.getTime().getTime();
            long time = pValue instanceof String ? Long.parseLong((String)pValue) : (Long)pValue;
            cal.setTime(new Date(time));
            return oldValue;
        }
        if ("iso8601".equals(pAttribute)) {
            Date newDate = DateUtil.fromISO8601((String)pValue.toString());
            String oldValue = DateUtil.toISO8601((Date)cal.getTime());
            cal.setTime(newDate);
            return oldValue;
        }
        if ("format".equals(pAttribute)) {
            try {
                Date newDate = this.dateFormat.parse(pValue.toString());
                String oldValue = this.dateFormat.format(cal);
                cal.setTime(newDate);
                return oldValue;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("Setting of calendar values is not yet supported directly. Use a path/attribute 'time', 'iso8601' or 'format' to set the epoch seconds on a date of the calendar");
    }

    @Override
    public boolean canSetValue() {
        return true;
    }
}

