/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.resources.rg.GssResourceGenerator;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassNamesCollector
extends DefaultTreeVisitor {
    private Set<String> classNames;
    private SortedSet<String> excludedPrefixes;

    public Set<String> getClassNames(CssTree tree) {
        return this.getClassNames(tree, new HashSet<JClassType>());
    }

    public Set<String> getClassNames(CssTree tree, Set<JClassType> imports) {
        Preconditions.checkNotNull(tree, "tree cannot be null");
        Preconditions.checkNotNull(imports, "imports set cannot be null");
        this.classNames = new HashSet<String>();
        this.excludedPrefixes = new TreeSet<String>();
        for (JClassType importedType : imports) {
            this.excludedPrefixes.add(GssResourceGenerator.getImportPrefix(importedType));
        }
        tree.getVisitController().startVisit((CssTreeVisitor)this);
        return this.classNames;
    }

    public boolean enterClassSelector(CssClassSelectorNode classSelector) {
        String className = classSelector.getRefinerName();
        if (!this.isImportedClass(className)) {
            this.classNames.add(className);
        }
        return false;
    }

    private boolean isImportedClass(String className) {
        SortedSet<String> lowerPrefixes = this.excludedPrefixes.headSet(className);
        return !lowerPrefixes.isEmpty() && className.startsWith(lowerPrefixes.last());
    }
}

