/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kea" locale.
 */
public class LocalizedNamesImpl_kea extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "HT",
        "AL",
        "DE",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BD",
        "BH",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EG",
        "EC",
        "SV",
        "AE",
        "ET",
        "EZ",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GG",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "YE",
        "BV",
        "AC",
        "IM",
        "CX",
        "CP",
        "AX",
        "IO",
        "QO",
        "FO",
        "HM",
        "GS",
        "KY",
        "CC",
        "CK",
        "FK",
        "MP",
        "MH",
        "UM",
        "NF",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IQ",
        "IR",
        "ER",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "GI",
        "GE",
        "JO",
        "CV",
        "CM",
        "KH",
        "KM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "XK",
        "HR",
        "CU",
        "KW",
        "CW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MG",
        "YT",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "MU",
        "MR",
        "MX",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "NL",
        "OM",
        "HN",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PR",
        "PL",
        "PT",
        "GB",
        "HK",
        "MO",
        "DO",
        "CF",
        "RW",
        "RO",
        "RE",
        "RU",
        "WS",
        "AS",
        "SM",
        "PM",
        "SH",
        "LC",
        "EH",
        "BL",
        "VC",
        "KN",
        "MF",
        "SX",
        "ST",
        "SC",
        "SN",
        "SL",
        "RS",
        "EA",
        "SG",
        "SY",
        "SK",
        "SI",
        "ES",
        "LK",
        "US",
        "EE",
        "SZ",
        "SD",
        "SS",
        "SE",
        "CH",
        "SO",
        "SR",
        "SJ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "TD",
        "CZ",
        "WF",
        "UG",
        "UA",
        "UN",
        "HU",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VN",
        "VE",
        "XA",
        "XB",
        "CL",
        "CN",
        "CY",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundu");
    namesMap.put("002", "Áfrika");
    namesMap.put("003", "Merka di Norti");
    namesMap.put("005", "Merka di Sul");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Áfrika Osidental");
    namesMap.put("013", "Merka Sentral");
    namesMap.put("014", "Áfrika Oriental");
    namesMap.put("015", "Norti di Áfrika");
    namesMap.put("017", "Áfrika Sentral");
    namesMap.put("018", "Sul di Áfrika");
    namesMap.put("019", "Merkas");
    namesMap.put("021", "Norti di Merka");
    namesMap.put("029", "Karaibas");
    namesMap.put("030", "Ázia Oriental");
    namesMap.put("034", "Sul di Ázia");
    namesMap.put("035", "Sudesti Aziátiku");
    namesMap.put("039", "Europa di Sul");
    namesMap.put("053", "Australázia");
    namesMap.put("054", "Melanézia");
    namesMap.put("057", "Rejiãu di Mikronézia");
    namesMap.put("061", "Polinézia");
    namesMap.put("142", "Ázia");
    namesMap.put("143", "Ázia Sentral");
    namesMap.put("145", "Ázia Osidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa di Norti");
    namesMap.put("155", "Europa Osidental");
    namesMap.put("419", "Merka Latinu");
    namesMap.put("AC", "Ilha di Asensãu");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Emiradus Árabi Unidu");
    namesMap.put("AF", "Afeganistãu");
    namesMap.put("AG", "Antigua i Barbuda");
    namesMap.put("AI", "Angila");
    namesMap.put("AL", "Albánia");
    namesMap.put("AM", "Arménia");
    namesMap.put("AQ", "Antártika");
    namesMap.put("AR", "Arjentina");
    namesMap.put("AS", "Samoa Merkanu");
    namesMap.put("AT", "Áustria");
    namesMap.put("AU", "Austrália");
    namesMap.put("AX", "Ilhas Åland");
    namesMap.put("AZ", "Azerbaijãu");
    namesMap.put("BA", "Bósnia i Erzegovina");
    namesMap.put("BB", "Barbadus");
    namesMap.put("BD", "Bangladexi");
    namesMap.put("BE", "Béljika");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BH", "Barain");
    namesMap.put("BL", "Sãu Bartolomeu");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BQ", "Karaibas Olandezas");
    namesMap.put("BS", "Baamas");
    namesMap.put("BT", "Butãu");
    namesMap.put("BV", "Ilha Buve");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BZ", "Belizi");
    namesMap.put("CA", "Kanadá");
    namesMap.put("CC", "Ilhas Kokus (Keeling)");
    namesMap.put("CD", "Kongu - Kinxasa");
    namesMap.put("CF", "Republika Sentru-Afrikanu");
    namesMap.put("CG", "Kongu - Brazavili");
    namesMap.put("CH", "Suisa");
    namesMap.put("CI", "Kosta di Marfin");
    namesMap.put("CK", "Ilhas Kuk");
    namesMap.put("CL", "Xili");
    namesMap.put("CM", "Kamarõis");
    namesMap.put("CN", "Xina");
    namesMap.put("CO", "Kolômbia");
    namesMap.put("CP", "Ilha Kliperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kabu Verdi");
    namesMap.put("CW", "Kurasau");
    namesMap.put("CX", "Ilha di Natal");
    namesMap.put("CY", "Xipri");
    namesMap.put("CZ", "Txékia");
    namesMap.put("DE", "Alimanha");
    namesMap.put("DG", "Diegu Garsia");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Repúblika Dominikana");
    namesMap.put("DZ", "Arjélia");
    namesMap.put("EA", "Seuta i Melilha");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EE", "Stónia");
    namesMap.put("EG", "Ejitu");
    namesMap.put("EH", "Sara Osidental");
    namesMap.put("ER", "Iritreia");
    namesMap.put("ES", "Spanha");
    namesMap.put("ET", "Etiópia");
    namesMap.put("EU", "Uniãu Europeia");
    namesMap.put("FI", "Finlándia");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Ilhas Malvinas");
    namesMap.put("FM", "Mikronézia");
    namesMap.put("FO", "Ilhas Faroe");
    namesMap.put("FR", "Fransa");
    namesMap.put("GA", "Gabãu");
    namesMap.put("GB", "Reinu Unidu");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Jiórjia");
    namesMap.put("GF", "Giana Franseza");
    namesMap.put("GG", "Gernzi");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Jibraltar");
    namesMap.put("GL", "Gronelándia");
    namesMap.put("GM", "Gámbia");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Guadalupi");
    namesMap.put("GQ", "Gine Ekuatorial");
    namesMap.put("GR", "Grésia");
    namesMap.put("GS", "Ilhas Jeórjia di Sul i Sanduixi di Sul");
    namesMap.put("GT", "Guatimala");
    namesMap.put("GW", "Gine-Bisau");
    namesMap.put("GY", "Giana");
    namesMap.put("HK", "Rejiãu Administrativu Spesial di Hong Kong");
    namesMap.put("HM", "Ilhas Heard i McDonald");
    namesMap.put("HN", "Onduras");
    namesMap.put("HR", "Kroásia");
    namesMap.put("HT", "Aití");
    namesMap.put("HU", "Ungria");
    namesMap.put("IC", "Kanárias");
    namesMap.put("ID", "Indonézia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Ilha di Man");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Ilhas Británikas di Índiku");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Irãu");
    namesMap.put("IS", "Islándia");
    namesMap.put("IT", "Itália");
    namesMap.put("JE", "Jersi");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordánia");
    namesMap.put("JP", "Japãu");
    namesMap.put("KE", "Kénia");
    namesMap.put("KG", "Kirgistãu");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Kamoris");
    namesMap.put("KN", "Sãu Kristovãu i Nevis");
    namesMap.put("KP", "Koreia di Norti");
    namesMap.put("KR", "Koreia di Sul");
    namesMap.put("KW", "Kueiti");
    namesMap.put("KY", "Ilhas Kaimãu");
    namesMap.put("KZ", "Kazakistãu");
    namesMap.put("LA", "Laus");
    namesMap.put("LB", "Líbanu");
    namesMap.put("LC", "Santa Lúsia");
    namesMap.put("LI", "Lixenstain");
    namesMap.put("LR", "Libéria");
    namesMap.put("LS", "Lezotu");
    namesMap.put("LT", "Lituánia");
    namesMap.put("LU", "Luxemburgu");
    namesMap.put("LV", "Letónia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marokus");
    namesMap.put("MC", "Mónaku");
    namesMap.put("MD", "Moldávia");
    namesMap.put("ME", "Montenegru");
    namesMap.put("MF", "Sãu Martinhu di Fransa");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Ilhas Marxal");
    namesMap.put("MK", "Masidónia");
    namesMap.put("MM", "Mianmar (Birmánia)");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MO", "Rejiãu Administrativu Spesial di Makau");
    namesMap.put("MP", "Ilhas Marianas di Norti");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Mauritánia");
    namesMap.put("MS", "Monserat");
    namesMap.put("MU", "Maurísia");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "Méxiku");
    namesMap.put("MY", "Malázia");
    namesMap.put("MZ", "Musambiki");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nova Kalidónia");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Ilhas Norfolk");
    namesMap.put("NG", "Nijéria");
    namesMap.put("NI", "Nikarágua");
    namesMap.put("NL", "Olanda");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zilándia");
    namesMap.put("PA", "Panamá");
    namesMap.put("PF", "Polinézia Franseza");
    namesMap.put("PG", "Papua-Nova Gine");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Pakistãu");
    namesMap.put("PL", "Pulónia");
    namesMap.put("PM", "San Piere i Mikelon");
    namesMap.put("PN", "Pirkairn");
    namesMap.put("PR", "Portu Riku");
    namesMap.put("PS", "Palistina");
    namesMap.put("PT", "Purtugal");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Ilhas di Oseania");
    namesMap.put("RE", "Runiãu");
    namesMap.put("RO", "Ruménia");
    namesMap.put("RS", "Sérvia");
    namesMap.put("RU", "Rúsia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arábia Saudita");
    namesMap.put("SB", "Ilhas Salumãu");
    namesMap.put("SC", "Seixelis");
    namesMap.put("SD", "Sudãu");
    namesMap.put("SE", "Suésia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SH", "Santa Ilena");
    namesMap.put("SI", "Slovénia");
    namesMap.put("SJ", "Svalbard i Jan Maien");
    namesMap.put("SK", "Slovákia");
    namesMap.put("SL", "Sera Lioa");
    namesMap.put("SM", "San Marinu");
    namesMap.put("SO", "Sumália");
    namesMap.put("SR", "Surinami");
    namesMap.put("SS", "Sudãu di Sul");
    namesMap.put("ST", "Sãu Tume i Prínsipi");
    namesMap.put("SX", "Sãu Martinhu di Olanda");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Suazilándia");
    namesMap.put("TA", "Tristan da Kunha");
    namesMap.put("TC", "Ilhas Turkas i Kaikus");
    namesMap.put("TD", "Txadi");
    namesMap.put("TF", "Terras Franses di Sul");
    namesMap.put("TG", "Togu");
    namesMap.put("TH", "Tailándia");
    namesMap.put("TJ", "Tadjikistãu");
    namesMap.put("TL", "Timor Lesti");
    namesMap.put("TM", "Turkumenistãu");
    namesMap.put("TN", "Tunízia");
    namesMap.put("TR", "Turkia");
    namesMap.put("TT", "Trinidad i Tobagu");
    namesMap.put("TW", "Taiuan");
    namesMap.put("TZ", "Tanzánia");
    namesMap.put("UA", "Ukránia");
    namesMap.put("UM", "Ilhas Minoris Distantis de Stadus Unidus");
    namesMap.put("US", "Stadus Unidos di Merka");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbekistãu");
    namesMap.put("VA", "Vatikanu");
    namesMap.put("VC", "Sãu Bisenti i Granadinas");
    namesMap.put("VE", "Vinizuela");
    namesMap.put("VG", "Ilhas Virjens Británikas");
    namesMap.put("VI", "Ilhas Virjens Merkanas");
    namesMap.put("WF", "Ualis i Futuna");
    namesMap.put("XK", "Kozovu");
    namesMap.put("YE", "Iémen");
    namesMap.put("YT", "Maiote");
    namesMap.put("ZA", "Áfrika di Sul");
    namesMap.put("ZM", "Zámbia");
    namesMap.put("ZW", "Zimbábui");
    namesMap.put("ZZ", "Rejiãu Diskonxedu");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundu",
        "002": "Áfrika",
        "003": "Merka di Norti",
        "005": "Merka di Sul",
        "009": "Oseania",
        "011": "Áfrika Osidental",
        "013": "Merka Sentral",
        "014": "Áfrika Oriental",
        "015": "Norti di Áfrika",
        "017": "Áfrika Sentral",
        "018": "Sul di Áfrika",
        "019": "Merkas",
        "021": "Norti di Merka",
        "029": "Karaibas",
        "030": "Ázia Oriental",
        "034": "Sul di Ázia",
        "035": "Sudesti Aziátiku",
        "039": "Europa di Sul",
        "053": "Australázia",
        "054": "Melanézia",
        "057": "Rejiãu di Mikronézia",
        "061": "Polinézia",
        "142": "Ázia",
        "143": "Ázia Sentral",
        "145": "Ázia Osidental",
        "150": "Europa",
        "151": "Europa Oriental",
        "154": "Europa di Norti",
        "155": "Europa Osidental",
        "419": "Merka Latinu",
        "AC": "Ilha di Asensãu",
        "AD": "Andora",
        "AE": "Emiradus Árabi Unidu",
        "AF": "Afeganistãu",
        "AG": "Antigua i Barbuda",
        "AI": "Angila",
        "AL": "Albánia",
        "AM": "Arménia",
        "AQ": "Antártika",
        "AR": "Arjentina",
        "AS": "Samoa Merkanu",
        "AT": "Áustria",
        "AU": "Austrália",
        "AX": "Ilhas Åland",
        "AZ": "Azerbaijãu",
        "BA": "Bósnia i Erzegovina",
        "BB": "Barbadus",
        "BD": "Bangladexi",
        "BE": "Béljika",
        "BF": "Burkina Fasu",
        "BG": "Bulgária",
        "BH": "Barain",
        "BL": "Sãu Bartolomeu",
        "BM": "Bermudas",
        "BO": "Bolívia",
        "BQ": "Karaibas Olandezas",
        "BS": "Baamas",
        "BT": "Butãu",
        "BV": "Ilha Buve",
        "BW": "Botsuana",
        "BZ": "Belizi",
        "CA": "Kanadá",
        "CC": "Ilhas Kokus (Keeling)",
        "CD": "Kongu - Kinxasa",
        "CF": "Republika Sentru-Afrikanu",
        "CG": "Kongu - Brazavili",
        "CH": "Suisa",
        "CI": "Kosta di Marfin",
        "CK": "Ilhas Kuk",
        "CL": "Xili",
        "CM": "Kamarõis",
        "CN": "Xina",
        "CO": "Kolômbia",
        "CP": "Ilha Kliperton",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Kabu Verdi",
        "CW": "Kurasau",
        "CX": "Ilha di Natal",
        "CY": "Xipri",
        "CZ": "Txékia",
        "DE": "Alimanha",
        "DG": "Diegu Garsia",
        "DJ": "Djibuti",
        "DK": "Dinamarka",
        "DM": "Dominika",
        "DO": "Repúblika Dominikana",
        "DZ": "Arjélia",
        "EA": "Seuta i Melilha",
        "EC": "Ekuador",
        "EE": "Stónia",
        "EG": "Ejitu",
        "EH": "Sara Osidental",
        "ER": "Iritreia",
        "ES": "Spanha",
        "ET": "Etiópia",
        "EU": "Uniãu Europeia",
        "FI": "Finlándia",
        "FJ": "Fidji",
        "FK": "Ilhas Malvinas",
        "FM": "Mikronézia",
        "FO": "Ilhas Faroe",
        "FR": "Fransa",
        "GA": "Gabãu",
        "GB": "Reinu Unidu",
        "GD": "Granada",
        "GE": "Jiórjia",
        "GF": "Giana Franseza",
        "GG": "Gernzi",
        "GH": "Gana",
        "GI": "Jibraltar",
        "GL": "Gronelándia",
        "GM": "Gámbia",
        "GN": "Gine",
        "GP": "Guadalupi",
        "GQ": "Gine Ekuatorial",
        "GR": "Grésia",
        "GS": "Ilhas Jeórjia di Sul i Sanduixi di Sul",
        "GT": "Guatimala",
        "GW": "Gine-Bisau",
        "GY": "Giana",
        "HK": "Rejiãu Administrativu Spesial di Hong Kong",
        "HM": "Ilhas Heard i McDonald",
        "HN": "Onduras",
        "HR": "Kroásia",
        "HT": "Aití",
        "HU": "Ungria",
        "IC": "Kanárias",
        "ID": "Indonézia",
        "IE": "Irlanda",
        "IM": "Ilha di Man",
        "IN": "Índia",
        "IO": "Ilhas Británikas di Índiku",
        "IQ": "Iraki",
        "IR": "Irãu",
        "IS": "Islándia",
        "IT": "Itália",
        "JE": "Jersi",
        "JM": "Jamaika",
        "JO": "Jordánia",
        "JP": "Japãu",
        "KE": "Kénia",
        "KG": "Kirgistãu",
        "KH": "Kambodja",
        "KM": "Kamoris",
        "KN": "Sãu Kristovãu i Nevis",
        "KP": "Koreia di Norti",
        "KR": "Koreia di Sul",
        "KW": "Kueiti",
        "KY": "Ilhas Kaimãu",
        "KZ": "Kazakistãu",
        "LA": "Laus",
        "LB": "Líbanu",
        "LC": "Santa Lúsia",
        "LI": "Lixenstain",
        "LR": "Libéria",
        "LS": "Lezotu",
        "LT": "Lituánia",
        "LU": "Luxemburgu",
        "LV": "Letónia",
        "LY": "Líbia",
        "MA": "Marokus",
        "MC": "Mónaku",
        "MD": "Moldávia",
        "ME": "Montenegru",
        "MF": "Sãu Martinhu di Fransa",
        "MG": "Madagaskar",
        "MH": "Ilhas Marxal",
        "MK": "Masidónia",
        "MM": "Mianmar (Birmánia)",
        "MN": "Mongólia",
        "MO": "Rejiãu Administrativu Spesial di Makau",
        "MP": "Ilhas Marianas di Norti",
        "MQ": "Martinika",
        "MR": "Mauritánia",
        "MS": "Monserat",
        "MU": "Maurísia",
        "MV": "Maldivas",
        "MW": "Malaui",
        "MX": "Méxiku",
        "MY": "Malázia",
        "MZ": "Musambiki",
        "NA": "Namíbia",
        "NC": "Nova Kalidónia",
        "NE": "Nijer",
        "NF": "Ilhas Norfolk",
        "NG": "Nijéria",
        "NI": "Nikarágua",
        "NL": "Olanda",
        "NO": "Noruega",
        "NZ": "Nova Zilándia",
        "PA": "Panamá",
        "PF": "Polinézia Franseza",
        "PG": "Papua-Nova Gine",
        "PH": "Filipinas",
        "PK": "Pakistãu",
        "PL": "Pulónia",
        "PM": "San Piere i Mikelon",
        "PN": "Pirkairn",
        "PR": "Portu Riku",
        "PS": "Palistina",
        "PT": "Purtugal",
        "PY": "Paraguai",
        "QA": "Katar",
        "QO": "Ilhas di Oseania",
        "RE": "Runiãu",
        "RO": "Ruménia",
        "RS": "Sérvia",
        "RU": "Rúsia",
        "RW": "Ruanda",
        "SA": "Arábia Saudita",
        "SB": "Ilhas Salumãu",
        "SC": "Seixelis",
        "SD": "Sudãu",
        "SE": "Suésia",
        "SG": "Singapura",
        "SH": "Santa Ilena",
        "SI": "Slovénia",
        "SJ": "Svalbard i Jan Maien",
        "SK": "Slovákia",
        "SL": "Sera Lioa",
        "SM": "San Marinu",
        "SO": "Sumália",
        "SR": "Surinami",
        "SS": "Sudãu di Sul",
        "ST": "Sãu Tume i Prínsipi",
        "SX": "Sãu Martinhu di Olanda",
        "SY": "Síria",
        "SZ": "Suazilándia",
        "TA": "Tristan da Kunha",
        "TC": "Ilhas Turkas i Kaikus",
        "TD": "Txadi",
        "TF": "Terras Franses di Sul",
        "TG": "Togu",
        "TH": "Tailándia",
        "TJ": "Tadjikistãu",
        "TL": "Timor Lesti",
        "TM": "Turkumenistãu",
        "TN": "Tunízia",
        "TR": "Turkia",
        "TT": "Trinidad i Tobagu",
        "TW": "Taiuan",
        "TZ": "Tanzánia",
        "UA": "Ukránia",
        "UM": "Ilhas Minoris Distantis de Stadus Unidus",
        "US": "Stadus Unidos di Merka",
        "UY": "Uruguai",
        "UZ": "Uzbekistãu",
        "VA": "Vatikanu",
        "VC": "Sãu Bisenti i Granadinas",
        "VE": "Vinizuela",
        "VG": "Ilhas Virjens Británikas",
        "VI": "Ilhas Virjens Merkanas",
        "WF": "Ualis i Futuna",
        "XK": "Kozovu",
        "YE": "Iémen",
        "YT": "Maiote",
        "ZA": "Áfrika di Sul",
        "ZM": "Zámbia",
        "ZW": "Zimbábui",
        "ZZ": "Rejiãu Diskonxedu"
    };
  }-*/;
}
