/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert.converter;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import net.sourceforge.unicodeconvert.converter.LegacyCharSet;
import net.sourceforge.unicodeconvert.converter.VietEncodings;

public class LegacyXLS {
    private VietEncodings sourceEncoding;
    private ActiveXComponent excelApp;
    private Dispatch workbooks;
    private final Variant True = new Variant(true);
    private final Variant False = new Variant(false);
    private Variant MatchCase = this.True;
    private final int XlLookAt_xlPart = 2;
    private Variant LookAt = new Variant(2);
    private final int XlSearchOrder_xlByRows = 1;
    private Variant SearchOrder = new Variant(1);
    private String[] Whats;
    private String[] Replacements;

    public LegacyXLS(String string) throws Exception {
        this(VietEncodings.valueOf(VietEncodings.class, string));
    }

    public LegacyXLS(VietEncodings vietEncodings) throws Exception {
        this.sourceEncoding = vietEncodings;
        ComThread.InitSTA();
        this.excelApp = new ActiveXComponent("Excel.Application");
        this.excelApp.setProperty("DisplayAlerts", this.False);
        this.workbooks = this.excelApp.getProperty("Workbooks").toDispatch();
        this.initComponents();
    }

    private void initComponents() {
        if (this.sourceEncoding == VietEncodings.VIQR) {
            String string = "Conversion of Excel workbooks in VIQR format is not possible.\nMicrosoft Knowledge Base Article - 124739\nCan't Use Find/Replace on Text with Leading Apostrophe\nhttp://support.microsoft.com/default.aspx?scid=kb;en-us;124739";
            throw new RuntimeException(string);
        }
        LegacyCharSet legacyCharSet = new LegacyCharSet(this.sourceEncoding);
        this.Whats = legacyCharSet.getLegacyChars();
        this.Replacements = legacyCharSet.getUnicodeChars();
    }

    public void convert(File file, File file2) throws Exception {
        Dispatch dispatch = null;
        try {
            dispatch = Dispatch.call(this.workbooks, "Open", (Object)file2.getPath()).toDispatch();
            Dispatch dispatch2 = Dispatch.get(dispatch, "Worksheets").toDispatch();
            int n = Dispatch.get(dispatch2, "Count").getInt();
            for (int i = 1; i <= n; ++i) {
                Dispatch dispatch3 = Dispatch.invoke(dispatch2, "Item", 2, new Object[]{new Integer(i)}, new int[1]).toDispatch();
                String string = Dispatch.get(dispatch3, "Name").getString();
                Dispatch dispatch4 = Dispatch.get(dispatch3, "Cells").toDispatch();
                for (int j = 0; j < this.Whats.length; ++j) {
                    string = string.replaceAll("\\Q" + this.Whats[j], this.Replacements[j]);
                    Variant variant = new Variant(this.Whats[j]);
                    Variant variant2 = new Variant(this.Replacements[j]);
                    Dispatch.callN(dispatch4, "Replace", (Object[])new Variant[]{variant, variant2, this.LookAt, this.SearchOrder, this.MatchCase});
                }
                Dispatch.put(dispatch3, "Name", (Object)string);
                Dispatch dispatch5 = Dispatch.call(dispatch4, "Font").toDispatch();
                Dispatch.put(dispatch5, "Name", (Object)"Arial");
            }
            Dispatch.call(dispatch, "SaveCopyAs", (Object)new File(file.getAbsolutePath(), file2.getName()).getAbsolutePath());
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                Dispatch.call(dispatch, "Close", (Object)this.False);
                dispatch = null;
                throw throwable;
            }
        }
        Dispatch.call(dispatch, "Close", (Object)this.False);
        dispatch = null;
    }

    public void quitExcel() {
        if (this.excelApp != null) {
            this.excelApp.invoke("Quit", new Variant[0]);
            this.excelApp = null;
            ComThread.Release();
        }
    }
}

