/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.cache.ManualEvictionInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.session.BuildSessionLifecycleListener;

@ThreadSafe
public class DefaultCrossBuildInMemoryCacheFactory
implements CrossBuildInMemoryCacheFactory {
    private final ListenerManager listenerManager;

    public DefaultCrossBuildInMemoryCacheFactory(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public <K, V> CrossBuildInMemoryCache<K, V> newCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new HashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <K, V> CrossBuildInMemoryCache<K, V> newCacheRetainingDataFromPreviousBuild(Predicate<V> retentionFilter) {
        CrossBuildCacheRetainingDataFromPreviousBuild cache = new CrossBuildCacheRetainingDataFromPreviousBuild(retentionFilter);
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new WeakHashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassMap() {
        DefaultClassMap map = new DefaultClassMap();
        this.listenerManager.addListener(map);
        return map;
    }

    private static class CrossBuildCacheRetainingDataFromPreviousBuild<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    BuildSessionLifecycleListener {
        private final ManualEvictionInMemoryCache<K, V> delegate = new ManualEvictionInMemoryCache();
        private final ConcurrentMap<K, Boolean> keysFromPreviousBuild = new ConcurrentHashMap<K, Boolean>();
        private final ConcurrentMap<K, Boolean> keysFromCurrentBuild = new ConcurrentHashMap<K, Boolean>();
        private final Predicate<V> retentionFilter;

        public CrossBuildCacheRetainingDataFromPreviousBuild(Predicate<V> retentionFilter) {
            this.retentionFilter = retentionFilter;
        }

        public V get(K key, Function<? super K, ? extends V> factory) {
            Object value = this.delegate.get(key, factory);
            this.markAccessedInCurrentBuild(key, value);
            return (V)value;
        }

        public V getIfPresent(K key) {
            Object value = this.delegate.getIfPresent(key);
            this.markAccessedInCurrentBuild(key, value);
            return (V)value;
        }

        public void put(K key, V value) {
            this.markAccessedInCurrentBuild(key, value);
            this.delegate.put(key, value);
        }

        private void markAccessedInCurrentBuild(K key, @Nullable V value) {
            if (value != null && this.retentionFilter.test(value)) {
                this.keysFromCurrentBuild.put(key, Boolean.TRUE);
            }
        }

        public void clear() {
            this.delegate.clear();
            this.keysFromCurrentBuild.clear();
            this.keysFromPreviousBuild.clear();
        }

        @Override
        public void beforeComplete() {
            HashSet keysToRetain = new HashSet();
            keysToRetain.addAll(this.keysFromPreviousBuild.keySet());
            keysToRetain.addAll(this.keysFromCurrentBuild.keySet());
            this.delegate.retainAll(keysToRetain);
            this.keysFromPreviousBuild.clear();
            this.keysFromPreviousBuild.putAll(this.keysFromCurrentBuild);
            this.keysFromCurrentBuild.clear();
        }
    }

    private static class DefaultClassMap<V>
    extends AbstractCrossBuildInMemoryCache<Class<?>, V> {
        private final Map<Class<?>, V> leakyValues = new HashMap();

        private DefaultClassMap() {
        }

        @Override
        protected void retainValuesFromCurrentSession(Collection<V> values) {
        }

        @Override
        protected void discardRetainedValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void retainValue(Class<?> key, V v) {
            this.getCacheScope(key).put(key, v);
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(Class<?> key) {
            return this.getCacheScope(key).get(key);
        }

        private Map<Class<?>, V> getCacheScope(Class<?> type) {
            ClassLoader classLoader = type.getClassLoader();
            if (classLoader instanceof VisitableURLClassLoader) {
                return (Map)((VisitableURLClassLoader)classLoader).getUserData((Object)this, HashMap::new);
            }
            return this.leakyValues;
        }
    }

    private static class DefaultCrossBuildInMemoryCache<K, V>
    extends AbstractCrossBuildInMemoryCache<K, V> {
        private final Set<V> valuesForPreviousSession = new HashSet<V>();
        private final Map<K, SoftReference<V>> allValues;

        public DefaultCrossBuildInMemoryCache(Map<K, SoftReference<V>> allValues) {
            this.allValues = allValues;
        }

        @Override
        protected void retainValuesFromCurrentSession(Collection<V> values) {
            this.valuesForPreviousSession.clear();
            this.valuesForPreviousSession.addAll(values);
        }

        @Override
        protected void discardRetainedValues() {
            this.valuesForPreviousSession.clear();
            this.allValues.clear();
        }

        @Override
        protected void retainValue(K key, V v) {
            this.allValues.put(key, new SoftReference<V>(v));
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(K key) {
            SoftReference<V> reference = this.allValues.get(key);
            if (reference != null) {
                return reference.get();
            }
            return null;
        }
    }

    private static abstract class AbstractCrossBuildInMemoryCache<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    BuildSessionLifecycleListener {
        private final Object lock = new Object();
        private final Map<K, V> valuesForThisSession = new HashMap();

        private AbstractCrossBuildInMemoryCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeComplete() {
            Object object = this.lock;
            synchronized (object) {
                this.retainValuesFromCurrentSession(this.valuesForThisSession.values());
                this.valuesForThisSession.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.valuesForThisSession.clear();
                this.discardRetainedValues();
            }
        }

        protected abstract void retainValuesFromCurrentSession(Collection<V> var1);

        protected abstract void discardRetainedValues();

        protected abstract void retainValue(K var1, V var2);

        @Nullable
        protected abstract V maybeGetRetainedValue(K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public V getIfPresent(K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.getIfPresentWithoutLock(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key, Function<? super K, ? extends V> factory) {
            Object object = this.lock;
            synchronized (object) {
                V v = this.getIfPresentWithoutLock(key);
                if (v != null) {
                    return v;
                }
                v = factory.apply(key);
                this.retainValue(key, v);
                this.valuesForThisSession.put(key, v);
                return v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                this.retainValue(key, value);
                this.valuesForThisSession.put(key, value);
            }
        }

        private V getIfPresentWithoutLock(K key) {
            V v = this.valuesForThisSession.get(key);
            if (v != null) {
                return v;
            }
            v = this.maybeGetRetainedValue(key);
            if (v != null) {
                this.valuesForThisSession.put(key, v);
                return v;
            }
            return null;
        }
    }
}

