/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.diagnostics.ProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.PropertyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class PropertyReportTask
extends ProjectBasedReportTask {
    private PropertyReportRenderer renderer = new PropertyReportRenderer();
    private final Property<String> property = this.getProject().getObjects().property(String.class);

    @Incubating
    @Input
    @Optional
    @Option(option="property", description="A specific property to output")
    public Property<String> getProperty() {
        return this.property;
    }

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(PropertyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void generate(Project project) {
        TreeMap entries = new TreeMap(project.getProperties());
        if (this.property.isPresent()) {
            String propertyValue = (String)this.property.get();
            if (propertyValue.equals("properties")) {
                this.renderer.addProperty(propertyValue, "{...}");
            } else {
                this.renderer.addProperty(propertyValue, entries.get(propertyValue));
            }
        } else {
            for (Map.Entry entry : entries.entrySet()) {
                if (((String)entry.getKey()).equals("properties")) {
                    this.renderer.addProperty((String)entry.getKey(), "{...}");
                    continue;
                }
                this.renderer.addProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

