/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.IntervalTree;
import edu.stanford.nlp.util.Iterables;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.regex.MatchResult;

public class MultiPatternMatcher<T> {
    Collection<SequencePattern<T>> patterns;
    private SequencePatternTrigger<T> patternTrigger;
    private boolean matchWithResult = false;

    public MultiPatternMatcher(SequencePatternTrigger<T> patternTrigger, Collection<? extends SequencePattern<T>> patterns) {
        this.patterns = new ArrayList<SequencePattern<T>>();
        this.patterns.addAll(patterns);
        this.patternTrigger = patternTrigger;
    }

    @SafeVarargs
    public MultiPatternMatcher(SequencePatternTrigger<T> patternTrigger, SequencePattern<T> ... patterns) {
        this(patterns);
        this.patternTrigger = patternTrigger;
    }

    public MultiPatternMatcher(Collection<SequencePattern<T>> patterns) {
        this.patterns = patterns;
    }

    @SafeVarargs
    public MultiPatternMatcher(SequencePattern<T> ... patterns) {
        this.patterns = new ArrayList<SequencePattern<T>>(patterns.length);
        Collections.addAll(this.patterns, patterns);
    }

    public List<SequenceMatchResult<T>> findNonOverlapping(List<? extends T> elements) {
        return this.findNonOverlapping(elements, SequenceMatchResult.DEFAULT_COMPARATOR);
    }

    public List<SequenceMatchResult<T>> findNonOverlapping(List<? extends T> elements, Comparator<? super SequenceMatchResult> cmp) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<BasicSequenceMatchResult<? extends T>> all = new ArrayList<BasicSequenceMatchResult<? extends T>>();
        int i = 0;
        for (SequencePattern<? extends T> sequencePattern : triggered) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            SequenceMatcher<T> m = sequencePattern.getMatcher(elements);
            m.setMatchWithResult(this.matchWithResult);
            m.setOrder(i);
            while (m.find()) {
                all.add(m.toBasicSequenceMatchResult());
            }
            ++i;
        }
        List<SequenceMatchResult<T>> res = IntervalTree.getNonOverlapping(all, SequenceMatchResult.TO_INTERVAL, cmp);
        res.sort(SequenceMatchResult.OFFSET_COMPARATOR);
        return res;
    }

    public List<SequenceMatchResult<T>> find(List<? extends T> elements, SequenceMatcher.FindType findType) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<BasicSequenceMatchResult<? extends T>> all = new ArrayList<BasicSequenceMatchResult<? extends T>>();
        int i = 0;
        for (SequencePattern<? extends T> sequencePattern : triggered) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            SequenceMatcher<T> m = sequencePattern.getMatcher(elements);
            m.setMatchWithResult(this.matchWithResult);
            m.setFindType(findType);
            m.setOrder(i);
            while (m.find()) {
                all.add(m.toBasicSequenceMatchResult());
            }
            ++i;
        }
        List<? super MatchResult> res = IntervalTree.getNonOverlapping(all, SequenceMatchResult.TO_INTERVAL, SequenceMatchResult.DEFAULT_COMPARATOR);
        res.sort(SequenceMatchResult.OFFSET_COMPARATOR);
        return res;
    }

    public List<SequenceMatchResult<T>> findNonOverlappingMaxScore(List<? extends T> elements) {
        return this.findNonOverlappingMaxScore(elements, SequenceMatchResult.SCORER);
    }

    public List<SequenceMatchResult<T>> findNonOverlappingMaxScore(List<? extends T> elements, ToDoubleFunction<? super SequenceMatchResult> scorer) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<BasicSequenceMatchResult<? extends T>> all = new ArrayList<BasicSequenceMatchResult<? extends T>>();
        int i = 0;
        for (SequencePattern<? extends T> sequencePattern : triggered) {
            SequenceMatcher<T> m = sequencePattern.getMatcher(elements);
            m.setMatchWithResult(this.matchWithResult);
            m.setOrder(i);
            while (m.find()) {
                all.add(m.toBasicSequenceMatchResult());
            }
            ++i;
        }
        List<SequenceMatchResult<T>> res = IntervalTree.getNonOverlappingMaxScore(all, SequenceMatchResult.TO_INTERVAL, scorer);
        res.sort(SequenceMatchResult.OFFSET_COMPARATOR);
        return res;
    }

    public Iterable<SequenceMatchResult<T>> findAllNonOverlappingMatchesPerPattern(List<? extends T> elements) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<Iterable<SequenceMatchResult<? extends T>>> allMatches = new ArrayList<Iterable<SequenceMatchResult<? extends T>>>(elements.size());
        for (SequencePattern<T> p : triggered) {
            SequenceMatcher<T> m = p.getMatcher(elements);
            m.setMatchWithResult(this.matchWithResult);
            Iterable<SequenceMatchResult<? extends T>> matches = m.findAllNonOverlapping();
            allMatches.add(matches);
        }
        return Iterables.chain(allMatches);
    }

    public Collection<SequencePattern<T>> getTriggeredPatterns(List<? extends T> elements) {
        if (this.patternTrigger != null) {
            return (Collection)this.patternTrigger.apply(elements);
        }
        return this.patterns;
    }

    public boolean isMatchWithResult() {
        return this.matchWithResult;
    }

    public void setMatchWithResult(boolean matchWithResult) {
        this.matchWithResult = matchWithResult;
    }

    public static class BasicSequencePatternTrigger<T>
    implements SequencePatternTrigger<T> {
        NodePatternTrigger<T> trigger;

        public BasicSequencePatternTrigger(NodePatternTrigger<T> trigger) {
            this.trigger = trigger;
        }

        @Override
        public Collection<SequencePattern<T>> apply(List<? extends T> elements) {
            LinkedHashSet<SequencePattern<T>> triggeredPatterns = new LinkedHashSet<SequencePattern<T>>();
            for (T node : elements) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                Collection triggered = (Collection)this.trigger.apply(node);
                triggeredPatterns.addAll(triggered);
            }
            return triggeredPatterns;
        }
    }

    public static interface SequencePatternTrigger<T>
    extends Function<List<? extends T>, Collection<SequencePattern<T>>> {
    }

    public static interface NodePatternTrigger<T>
    extends Function<T, Collection<SequencePattern<T>>> {
    }
}

