/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TwoDimensionalCollectionValuedMap<K1, K2, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K1, CollectionValuedMap<K2, V>> map = Generics.newHashMap();
    protected MapFactory<K2, Collection<V>> mf;
    protected CollectionFactory<V> cf;
    private final boolean treatCollectionsAsImmutable;

    public TwoDimensionalCollectionValuedMap() {
        this(false);
    }

    public TwoDimensionalCollectionValuedMap(boolean treatCollectionsAsImmutable) {
        this(MapFactory.hashMapFactory(), CollectionFactory.hashSetFactory(), treatCollectionsAsImmutable);
    }

    public TwoDimensionalCollectionValuedMap(CollectionFactory<V> cf) {
        this(MapFactory.hashMapFactory(), cf, false);
    }

    public TwoDimensionalCollectionValuedMap(MapFactory<K2, Collection<V>> mf, CollectionFactory<V> cf) {
        this(mf, cf, false);
    }

    public TwoDimensionalCollectionValuedMap(MapFactory<K2, Collection<V>> mf, CollectionFactory<V> cf, boolean treatCollectionsAsImmutable) {
        this.mf = mf;
        this.cf = cf;
        this.treatCollectionsAsImmutable = treatCollectionsAsImmutable;
    }

    public String toString() {
        return this.map.toString();
    }

    public void putAll(Map<K1, CollectionValuedMap<K2, V>> toAdd) {
        this.map.putAll(toAdd);
    }

    public CollectionValuedMap<K2, V> getCollectionValuedMap(K1 key1) {
        CollectionValuedMap<K2, V> cvm = this.map.get(key1);
        if (cvm == null) {
            cvm = new CollectionValuedMap<K2, V>(this.mf, this.cf, this.treatCollectionsAsImmutable);
            this.map.put(key1, cvm);
        }
        return cvm;
    }

    public Collection<V> get(K1 key1, K2 key2) {
        return this.getCollectionValuedMap(key1).get(key2);
    }

    public void add(K1 key1, K2 key2, V value) {
        CollectionValuedMap<K2, V> cvm = this.map.get(key1);
        if (cvm == null) {
            cvm = new CollectionValuedMap<K2, V>(this.mf, this.cf, this.treatCollectionsAsImmutable);
            this.map.put(key1, cvm);
        }
        cvm.add(key2, value);
    }

    public void add(K1 key1, K2 key2, Collection<V> value) {
        CollectionValuedMap<K2, V> cvm = this.map.get(key1);
        if (cvm == null) {
            cvm = new CollectionValuedMap<K2, V>(this.mf, this.cf, this.treatCollectionsAsImmutable);
            this.map.put(key1, cvm);
        }
        for (V v : value) {
            cvm.add(key2, v);
        }
    }

    public void addKey(K1 key1) {
        CollectionValuedMap<K2, V> cvm = this.map.get(key1);
        if (cvm == null) {
            cvm = new CollectionValuedMap<K2, V>(this.mf, this.cf, this.treatCollectionsAsImmutable);
            this.map.put(key1, cvm);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K1> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<K1, CollectionValuedMap<K2, V>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(K1 key) {
        return this.map.containsKey(key);
    }

    public void retainAll(Set<K1> keys) {
        for (Object key : new LinkedList<K1>(this.map.keySet())) {
            if (keys.contains(key)) continue;
            this.map.remove(key);
        }
    }

    public Set<K1> firstKeySet() {
        return this.keySet();
    }

    public Set<K2> secondKeySet() {
        Set<K2> keys = Generics.newHashSet();
        for (K1 k1 : this.map.keySet()) {
            keys.addAll(this.getCollectionValuedMap(k1).keySet());
        }
        return keys;
    }

    public Collection<V> values() {
        Set<V> allValues = Generics.newHashSet();
        for (K1 k1 : this.map.keySet()) {
            Collection<Collection<V>> collectionOfValues = this.getCollectionValuedMap(k1).values();
            for (Collection<V> values : collectionOfValues) {
                allValues.addAll(values);
            }
        }
        return allValues;
    }
}

