/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

public class History {
    int start;
    int end;
    int current;
    final PairsHolder pairs;
    final Extractors extractors;

    History(PairsHolder pairs, Extractors extractors) {
        this.pairs = pairs;
        this.extractors = extractors;
    }

    History(int start, int end, int current, PairsHolder pairs, Extractors extractors) {
        this.pairs = pairs;
        this.extractors = extractors;
        this.init(start, end, current);
    }

    void init(int start, int end, int current) {
        this.start = start;
        this.end = end;
        this.current = current;
    }

    private String getX(int index) {
        return this.extractors.get(index).extract(this);
    }

    public String[] getX() {
        String[] x = new String[this.extractors.size()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.getX(i);
        }
        return x;
    }

    protected void setTag(int pos, String tag) {
        this.pairs.setTag(pos + this.start, tag);
    }

    protected void set(int start, int end, int current) {
        this.start = start;
        this.end = end;
        this.current = current;
    }

    public String toString() {
        String[] str;
        StringBuilder sb = new StringBuilder();
        for (String aStr : str = this.getX()) {
            sb.append(aStr).append('\t');
        }
        return sb.toString();
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        int sz = this.extractors.size();
        for (int i = 0; i < sz; ++i) {
            sb.append(this.getX(i));
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object h1) {
        return h1 instanceof History && this.extractors.equals(this, (History)h1);
    }
}

