/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.plugin;

import static org.junit.Assert.assertTrue;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.sql.DataSource;

import org.junit.Test;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.config.java.plugin.Plugin;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

import test.common.dataaccess.DummyDataSource;


/** TODO: JAVADOC */
public class PluginProofOfConceptTests {
    @Test
    public void proofOfConcept() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(DemoConfig.class);

        String[] expectedBeans =
            new String[] { "dataSource",
                           "txManager",
                           "foo"  // registered by FooPlugin
                         };

        for(String beanName : expectedBeans)
            assertTrue("did not contain bean named " + beanName,
                       ctx.containsBeanDefinition(beanName));
    }

    @Configuration
    @FooPlugin
    static class DemoConfig {
        @Bean
        public DataSource dataSource() {
            return new DummyDataSource();
        }

        @Bean
        public PlatformTransactionManager txManager() {
            return new DataSourceTransactionManager(dataSource());
        }
    }

}

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Plugin(handler=FooPluginHandler.class)
@interface FooPlugin { }

class Foo { }

class FooPluginHandler implements ConfigurationPlugin<FooPlugin> {
    public void handle(FooPlugin anno, BeanDefinitionRegistry registry) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClass(Foo.class);
        registry.registerBeanDefinition("foo", beanDef);
    }
}
