/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.scoping;

import static org.junit.Assert.*;

import org.junit.Test;

import org.springframework.config.java.context.JavaConfigApplicationContext;

import test.common.beans.ITestBean;

import test.common.config.BaseConfiguration;


/**
 * Integration tests proving that singleton semantics are respected
 * by {@link JavaConfigApplicationContext}.
 *
 * @author  Chris Beams
 */
public class SingletonTests {

    @Test
    public void testSingletonSemantics() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(BaseConfiguration.class);
        assertTrue(ctx.containsBean(BaseConfiguration.class.getName()));

        ITestBean tb = (ITestBean) ctx.getBean("tom");
        assertEquals("tom", tb.getName());
        assertEquals("becky", tb.getSpouse().getName());
        ITestBean tomsBecky = tb.getSpouse();
        ITestBean factorysBecky = (ITestBean) ctx.getBean("becky");

        // given that becky is a singleton-scoped bean, these objects should be same instance
        assertSame(tomsBecky, factorysBecky);
    }

}
