/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;

public class DirectReadQuery
extends DataReadQuery {
    protected Converter valueConverter;

    public DirectReadQuery() {
    }

    public DirectReadQuery(String sqlString) {
        super(sqlString);
    }

    public DirectReadQuery(Call call) {
        super(call);
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Object buildObject(AbstractRecord row) {
        Object value = row.get(row.getFields().firstElement());
        if (this.getValueConverter() != null) {
            value = this.getValueConverter().convertDataValueToObjectValue(value, this.session);
        }
        return value;
    }

    public Object executeNonCursor() throws DatabaseException, QueryException {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector rows = this.getQueryMechanism().executeSelect();
        Object result = cp.containerInstance(rows.size());
        DatabaseField resultDirectField = null;
        Enumeration stream = rows.elements();
        while (stream.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)stream.nextElement();
            if (resultDirectField == null) {
                resultDirectField = (DatabaseField)row.getFields().firstElement();
            }
            Object value = row.get(resultDirectField);
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertDataValueToObjectValue(value, this.session);
            }
            cp.addInto(value, result, this.getSession());
        }
        return result;
    }

    public boolean isDirectReadQuery() {
        return true;
    }
}

